/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.route.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteStageContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingRouteCacheValue {
    private final boolean cacheable;
    private final RouteContext cachedRouteContext;

    public ShardingRouteCacheValue(RouteContext routeContext) {
        this(null != routeContext, routeContext);
    }

    public Optional<RouteContext> getCachedRouteContext() {
        return this.cacheable ? Optional.of(this.deepCopyRouteContext()) : Optional.empty();
    }

    private RouteContext deepCopyRouteContext() {
        RouteContext result = new RouteContext();
        result.getOriginalDataNodes().addAll(this.deepCopyOriginalDataNodes());
        result.getRouteUnits().addAll(this.deepCopyRouteUnits());
        result.getRouteStageContexts().putAll(this.deepCopyRouteStageContext());
        return result;
    }

    private Collection<Collection<DataNode>> deepCopyOriginalDataNodes() {
        ArrayList<Collection<DataNode>> result = new ArrayList<Collection<DataNode>>(this.cachedRouteContext.getOriginalDataNodes().size());
        for (Collection eachDataNodes : this.cachedRouteContext.getOriginalDataNodes()) {
            ArrayList<DataNode> eachResult = new ArrayList<DataNode>(eachDataNodes.size());
            for (DataNode each : eachDataNodes) {
                DataNode copiedDataNode = new DataNode(each.getDataSourceName(), each.getTableName());
                copiedDataNode.setSchemaName(each.getSchemaName());
                eachResult.add(copiedDataNode);
            }
            result.add(eachResult);
        }
        return result;
    }

    private Collection<RouteUnit> deepCopyRouteUnits() {
        ArrayList<RouteUnit> result = new ArrayList<RouteUnit>(this.cachedRouteContext.getRouteUnits().size());
        for (RouteUnit each : this.cachedRouteContext.getRouteUnits()) {
            result.add(new RouteUnit(each.getDataSourceMapper(), new ArrayList(each.getTableMappers())));
        }
        return result;
    }

    private Map<Class<? extends ShardingSphereRule>, ? extends RouteStageContext> deepCopyRouteStageContext() {
        return this.cachedRouteContext.getRouteStageContexts();
    }

    @Generated
    private ShardingRouteCacheValue(boolean cacheable, RouteContext cachedRouteContext) {
        this.cacheable = cacheable;
        this.cachedRouteContext = cachedRouteContext;
    }
}

