/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data.dialect.type;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.sharding.metadata.data.dialect.DialectShardingStatisticsTableCollector;

public final class PostgreSQLShardingStatisticsTableCollector
implements DialectShardingStatisticsTableCollector {
    private static final String FETCH_TABLE_ROWS_LENGTH_SQL = "SELECT RELTUPLES FROM PG_CLASS WHERE RELNAMESPACE = (SELECT OID FROM PG_NAMESPACE WHERE NSPNAME= ?) AND RELNAME = ?";
    private static final String FETCH_TABLE_DATA_LENGTH_SQL = "SELECT PG_RELATION_SIZE(RELID) as DATA_LENGTH FROM PG_STAT_ALL_TABLES T WHERE SCHEMANAME= ? AND RELNAME = ?";

    @Override
    public boolean appendRow(Connection connection, DataNode dataNode, List<Object> row) throws SQLException {
        row.add(this.getRowValue(connection, dataNode, FETCH_TABLE_ROWS_LENGTH_SQL, "TABLE_ROWS").orElse(BigDecimal.ZERO));
        row.add(this.getRowValue(connection, dataNode, FETCH_TABLE_DATA_LENGTH_SQL, "DATA_LENGTH").orElse(BigDecimal.ZERO));
        return true;
    }

    private Optional<BigDecimal> getRowValue(Connection connection, DataNode dataNode, String sql, String columnName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            Optional<BigDecimal> optional;
            block12: {
                preparedStatement.setString(1, dataNode.getSchemaName());
                preparedStatement.setString(2, dataNode.getTableName());
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    Optional<BigDecimal> optional2 = optional = resultSet.next() ? Optional.of(resultSet.getBigDecimal(columnName)) : Optional.empty();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return optional;
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

