/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.prometheus.client.hotspot;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.shade.io.prometheus.client.Collector;
import org.apache.shardingsphere.shade.io.prometheus.client.CounterMetricFamily;
import org.apache.shardingsphere.shade.io.prometheus.client.GaugeMetricFamily;

public class ThreadExports
extends Collector {
    private final ThreadMXBean threadBean;

    public ThreadExports() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ThreadExports(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    void addThreadMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_current", "Current thread count of a JVM", this.threadBean.getThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_daemon", "Daemon thread count of a JVM", this.threadBean.getDaemonThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_peak", "Peak thread count of a JVM", this.threadBean.getPeakThreadCount()));
        sampleFamilies.add(new CounterMetricFamily("jvm_threads_started_total", "Started thread count of a JVM", this.threadBean.getTotalStartedThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_deadlocked", "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors or ownable synchronizers", ThreadExports.nullSafeArrayLength(this.threadBean.findDeadlockedThreads())));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_deadlocked_monitor", "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors", ThreadExports.nullSafeArrayLength(this.threadBean.findMonitorDeadlockedThreads())));
        GaugeMetricFamily threadStateFamily = new GaugeMetricFamily("jvm_threads_state", "Current count of threads by state", Collections.singletonList("state"));
        Map<Thread.State, Integer> threadStateCounts = this.getThreadStateCountMap();
        for (Map.Entry<Thread.State, Integer> entry : threadStateCounts.entrySet()) {
            threadStateFamily.addMetric(Collections.singletonList(entry.getKey().toString()), entry.getValue().intValue());
        }
        sampleFamilies.add(threadStateFamily);
    }

    private Map<Thread.State, Integer> getThreadStateCountMap() {
        ThreadInfo[] allThreads = this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), 0);
        HashMap<Thread.State, Integer> threadCounts = new HashMap<Thread.State, Integer>();
        for (Thread.State state : Thread.State.values()) {
            threadCounts.put(state, 0);
        }
        for (ThreadInfo threadInfo : allThreads) {
            if (threadInfo == null) continue;
            Thread.State threadState = threadInfo.getThreadState();
            threadCounts.put(threadState, threadCounts.get((Object)threadState) + 1);
        }
        return threadCounts;
    }

    private static double nullSafeArrayLength(long[] array) {
        return null == array ? 0.0 : (double)array.length;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addThreadMetrics(mfs);
        return mfs;
    }
}

