/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.dumper;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.PostgreSQLLogicalReplication;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALEventConverter;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.PostgreSQLLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.PostgreSQLTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.TestDecodingPlugin;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractWALEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.BeginTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.CommitTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLSlotNameGenerator;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.replication.PGReplicationStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLIncrementalDumper
extends AbstractPipelineLifecycleRunnable
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLIncrementalDumper.class);
    private final IncrementalDumperContext dumperContext;
    private final AtomicReference<WALPosition> walPosition;
    private final PipelineChannel channel;
    private final WALEventConverter walEventConverter;
    private final PostgreSQLLogicalReplication logicalReplication;
    private final boolean decodeWithTX;
    private List<AbstractRowEvent> rowEvents = new LinkedList<AbstractRowEvent>();

    public PostgreSQLIncrementalDumper(IncrementalDumperContext dumperContext, IngestPosition position, PipelineChannel channel, PipelineTableMetaDataLoader metaDataLoader) {
        this.dumperContext = dumperContext;
        this.walPosition = new AtomicReference<WALPosition>((WALPosition)position);
        this.channel = channel;
        this.walEventConverter = new WALEventConverter(dumperContext, metaDataLoader);
        this.logicalReplication = new PostgreSQLLogicalReplication();
        this.decodeWithTX = dumperContext.isDecodeWithTX();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runBlocking() {
        AtomicInteger reconnectTimes = new AtomicInteger();
        while (this.isRunning()) {
            try {
                this.dump();
                return;
            }
            catch (SQLException ex) {
                int times = reconnectTimes.incrementAndGet();
                log.error("Connect failed, reconnect times={}", (Object)times, (Object)ex);
                if (this.isRunning()) {
                    Thread.sleep(5000L);
                }
                if (times < 5) continue;
                throw new IngestException((Throwable)ex);
                return;
            }
        }
    }

    private void dump() throws SQLException {
        try (Connection connection = this.logicalReplication.createConnection((StandardPipelineDataSourceConfiguration)this.dumperContext.getCommonContext().getDataSourceConfig());
             PGReplicationStream stream = this.logicalReplication.createReplicationStream(connection, PostgreSQLSlotNameGenerator.getUniqueSlotName(connection, this.dumperContext.getJobId()), this.walPosition.get().getLogSequenceNumber());){
            PostgreSQLTimestampUtils utils = new PostgreSQLTimestampUtils(connection.unwrap(PgConnection.class).getTimestampUtils());
            TestDecodingPlugin decodingPlugin = new TestDecodingPlugin(utils);
            while (this.isRunning()) {
                ByteBuffer message = stream.readPending();
                if (null == message) {
                    Thread.sleep(10L);
                    continue;
                }
                AbstractWALEvent event = decodingPlugin.decode(message, new PostgreSQLLogSequenceNumber(stream.getLastReceiveLSN()));
                if (this.decodeWithTX) {
                    this.processEventWithTX(event);
                } else {
                    this.processEventIgnoreTX(event);
                }
                this.walPosition.set(new WALPosition(event.getLogSequenceNumber()));
            }
        }
    }

    private void processEventWithTX(AbstractWALEvent event) {
        if (event instanceof BeginTXEvent) {
            this.rowEvents = new ArrayList<AbstractRowEvent>();
            return;
        }
        if (event instanceof AbstractRowEvent) {
            this.rowEvents.add((AbstractRowEvent)event);
            return;
        }
        if (event instanceof CommitTXEvent) {
            LinkedList<Record> records = new LinkedList<Record>();
            for (AbstractWALEvent abstractWALEvent : this.rowEvents) {
                records.add(this.walEventConverter.convert(abstractWALEvent));
            }
            records.add(this.walEventConverter.convert(event));
            this.channel.push(records);
        }
    }

    private void processEventIgnoreTX(AbstractWALEvent event) {
        if (event instanceof BeginTXEvent) {
            return;
        }
        this.channel.push(Collections.singletonList(this.walEventConverter.convert(event)));
    }

    protected void doStop() {
    }
}

