/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal;

import java.util.List;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.NormalColumn;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.PlaceholderRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractWALEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.WriteRowEvent;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class WALEventConverter {
    private final IncrementalDumperContext dumperContext;
    private final PipelineTableMetaDataLoader metaDataLoader;

    public WALEventConverter(IncrementalDumperContext dumperContext, PipelineTableMetaDataLoader metaDataLoader) {
        this.dumperContext = dumperContext;
        this.metaDataLoader = metaDataLoader;
    }

    public Record convert(AbstractWALEvent event) {
        if (this.filter(event)) {
            return this.createPlaceholderRecord(event);
        }
        if (!(event instanceof AbstractRowEvent)) {
            return this.createPlaceholderRecord(event);
        }
        PipelineTableMetaData tableMetaData = this.getPipelineTableMetaData(((AbstractRowEvent)event).getTableName());
        if (event instanceof WriteRowEvent) {
            return this.handleWriteRowEvent((WriteRowEvent)event, tableMetaData);
        }
        if (event instanceof UpdateRowEvent) {
            return this.handleUpdateRowEvent((UpdateRowEvent)event, tableMetaData);
        }
        if (event instanceof DeleteRowEvent) {
            return this.handleDeleteRowEvent((DeleteRowEvent)event, tableMetaData);
        }
        throw new UnsupportedSQLOperationException("");
    }

    private boolean filter(AbstractWALEvent event) {
        if (event instanceof AbstractRowEvent) {
            AbstractRowEvent rowEvent = (AbstractRowEvent)event;
            return !this.dumperContext.getCommonContext().getTableNameMapper().containsTable(rowEvent.getTableName());
        }
        return false;
    }

    private PlaceholderRecord createPlaceholderRecord(AbstractWALEvent event) {
        return new PlaceholderRecord((IngestPosition)new WALPosition(event.getLogSequenceNumber()));
    }

    private PipelineTableMetaData getPipelineTableMetaData(String actualTableName) {
        ShardingSphereIdentifier logicTableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(actualTableName);
        return this.metaDataLoader.getTableMetaData(this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(logicTableName), actualTableName);
    }

    private DataRecord handleWriteRowEvent(WriteRowEvent writeRowEvent, PipelineTableMetaData tableMetaData) {
        DataRecord result = this.createDataRecord(PipelineSQLOperationType.INSERT, writeRowEvent, writeRowEvent.getAfterRow().size());
        this.putColumnsIntoDataRecord(result, tableMetaData, writeRowEvent.getAfterRow());
        return result;
    }

    private DataRecord handleUpdateRowEvent(UpdateRowEvent updateRowEvent, PipelineTableMetaData tableMetaData) {
        DataRecord result = this.createDataRecord(PipelineSQLOperationType.UPDATE, updateRowEvent, updateRowEvent.getAfterRow().size());
        this.putColumnsIntoDataRecord(result, tableMetaData, updateRowEvent.getAfterRow());
        return result;
    }

    private DataRecord handleDeleteRowEvent(DeleteRowEvent event, PipelineTableMetaData tableMetaData) {
        DataRecord result = this.createDataRecord(PipelineSQLOperationType.DELETE, event, event.getPrimaryKeys().size());
        List primaryKeyColumns = tableMetaData.getPrimaryKeyColumns();
        for (int i = 0; i < event.getPrimaryKeys().size(); ++i) {
            result.addColumn((Column)new NormalColumn((String)primaryKeyColumns.get(i), event.getPrimaryKeys().get(i), null, true, true));
        }
        return result;
    }

    private DataRecord createDataRecord(PipelineSQLOperationType type, AbstractRowEvent rowsEvent, int columnCount) {
        String tableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(rowsEvent.getTableName()).toString();
        DataRecord result = new DataRecord(type, rowsEvent.getSchemaName(), tableName, (IngestPosition)new WALPosition(rowsEvent.getLogSequenceNumber()), columnCount);
        result.setActualTableName(rowsEvent.getTableName());
        result.setCsn(rowsEvent.getCsn());
        return result;
    }

    private void putColumnsIntoDataRecord(DataRecord dataRecord, PipelineTableMetaData tableMetaData, List<Object> values) {
        int count = values.size();
        for (int i = 0; i < count; ++i) {
            PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(i + 1);
            boolean isUniqueKey = columnMetaData.isUniqueKey();
            Object uniqueKeyOldValue = isUniqueKey && PipelineSQLOperationType.UPDATE == dataRecord.getType() ? values.get(i) : null;
            NormalColumn column = new NormalColumn(columnMetaData.getName(), uniqueKeyOldValue, values.get(i), true, isUniqueKey);
            dataRecord.addColumn((Column)column);
        }
    }
}

