/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.beat;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.AesUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.SystemInfoUtils;
import org.apache.shenyu.register.client.beat.ShenyuBootstrapHeartBeatConfig;
import org.apache.shenyu.register.client.http.utils.RegisterUtils;
import org.apache.shenyu.register.common.dto.InstanceBeatInfoDTO;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

public class HeartbeatListener {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatListener.class);
    private static final int INITIAL_DELAY = 0;
    private static final int CHECK_PERIOD = 5;
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"scheduled-instance-task", (boolean)false));
    private final ShenyuConfig shenyuConfig;
    private String username;
    private String password;
    private List<String> serverList;
    private LoadingCache<String, String> accessToken;
    private ShenyuBootstrapHeartBeatConfig config;

    public HeartbeatListener(ShenyuBootstrapHeartBeatConfig config, ShenyuConfig shenyuConfig, ServerProperties serverProperties) {
        this.shenyuConfig = shenyuConfig;
        LOG.info("Web server initialized on port {}, starting heartbeat reporter", (Object)serverProperties.getPort());
        this.username = config.getProps().getProperty("username");
        this.password = config.getProps().getProperty("password");
        this.config = config;
        String secretKey = config.getProps().getProperty("aes-secret-key");
        String secretIv = config.getProps().getProperty("aes-secret-iv");
        if (StringUtils.isNotBlank((CharSequence)secretKey) && StringUtils.isNotBlank((CharSequence)secretIv)) {
            this.password = AesUtils.cbcEncrypt((String)secretKey, (String)secretIv, (String)this.password);
        }
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)config.getServerLists()));
        this.accessToken = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

            public @Nullable String load(@NonNull String server) {
                try {
                    Optional login = RegisterUtils.doLogin((String)HeartbeatListener.this.username, (String)HeartbeatListener.this.password, (String)server.concat("/platform/login"));
                    return login.map(String::valueOf).orElse(null);
                }
                catch (Exception e) {
                    LOG.error("Login admin url :{} is fail, will retry. cause: {} ", (Object)server, (Object)e.getMessage());
                    return null;
                }
            }
        });
        this.executor.scheduleAtFixedRate(() -> {
            InstanceBeatInfoDTO instanceBeatInfoDTO = new InstanceBeatInfoDTO();
            instanceBeatInfoDTO.setInstancePort(String.valueOf(serverProperties.getPort()));
            instanceBeatInfoDTO.setInstanceIp(IpUtils.getHost());
            instanceBeatInfoDTO.setNamespaceId(shenyuConfig.getNamespace());
            instanceBeatInfoDTO.setInstanceInfo(SystemInfoUtils.getSystemInfo());
            instanceBeatInfoDTO.setInstanceType("bootstrapInstanceInfo");
            this.sendHeartbeat(instanceBeatInfoDTO);
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    private void sendHeartbeat(InstanceBeatInfoDTO instanceBeatInfoDTO) {
        int i = 0;
        for (String server : this.serverList) {
            ++i;
            String concat = server.concat("/instance/beat");
            try {
                String accessToken = (String)this.accessToken.get((Object)server);
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    throw new NullPointerException("accessToken is null");
                }
                RegisterUtils.doHeartBeat((String)GsonUtils.getInstance().toJson((Object)instanceBeatInfoDTO), (String)concat, (String)"heartbeat", (String)accessToken);
            }
            catch (Exception e) {
                LOG.error("HeartBeat admin url :{} is fail, will retry.", (Object)server, (Object)e);
                if (i != this.serverList.size()) continue;
                throw new RuntimeException(e);
            }
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onShutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

