/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class DerbyURLParser
extends AbstractURLParser {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 1527;
    private static final String DB_TYPE = "Derby";
    private static final String DERBY_JDBC_URL_PREFIX = "jdbc:derby";
    private static final String DIRECTORY_MODE_FLAG = "derby:directory";
    private static final String MEMORY_MODE_FLAG = "derby:memory";
    private static final String CLASSPATH_MODE_FLAG = "derby:classpath";
    private static final String JAR_MODE_FLAG = "derby:jar";

    public DerbyURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag;
        int databaseEndTag = this.url.indexOf(";");
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        if ((databaseStartTag = this.url.lastIndexOf("\\")) == -1) {
            databaseStartTag = this.url.lastIndexOf("/");
        }
        if (this.url.indexOf(":", databaseStartTag) != -1) {
            databaseStartTag = this.url.indexOf(":", databaseStartTag);
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        int[] databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexForSubProtocol(DIRECTORY_MODE_FLAG);
        if (databaseNameRangeIndex != null) {
            return this.defaultConnection(databaseNameRangeIndex);
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexForSubProtocol(MEMORY_MODE_FLAG);
        if (databaseNameRangeIndex != null) {
            return this.defaultConnection(databaseNameRangeIndex);
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexForSubProtocol(CLASSPATH_MODE_FLAG);
        if (databaseNameRangeIndex != null) {
            return this.defaultConnection(databaseNameRangeIndex);
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexForSubProtocol(JAR_MODE_FLAG);
        if (databaseNameRangeIndex != null) {
            return this.defaultConnection(databaseNameRangeIndex);
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexWithoutHosts();
        if (databaseNameRangeIndex != null) {
            return this.defaultConnection(databaseNameRangeIndex);
        }
        String[] hostAndPort = this.fetchDatabaseHostsFromURL().split(":");
        if (hostAndPort.length == 1) {
            return new ConnectionInfo(ComponentsDefine.DERBY_JDBC_DRIVER, DB_TYPE, hostAndPort[0], 1527, this.fetchDatabaseNameFromURL());
        }
        return new ConnectionInfo(ComponentsDefine.DERBY_JDBC_DRIVER, DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL());
    }

    private int[] fetchDatabaseNameRangeIndexWithoutHosts() {
        if (this.url.contains("//")) {
            return null;
        }
        int fileLabelIndex = this.url.indexOf(DERBY_JDBC_URL_PREFIX);
        int parameterLabelIndex = this.url.indexOf(";");
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = this.url.length();
        }
        if (fileLabelIndex != -1) {
            int pathLabelIndexForLinux = this.url.lastIndexOf("/");
            if (pathLabelIndexForLinux != -1 && pathLabelIndexForLinux > fileLabelIndex) {
                return new int[]{pathLabelIndexForLinux + 1, parameterLabelIndex};
            }
            int pathLabelIndexForWin = this.url.lastIndexOf("\\");
            if (pathLabelIndexForWin != -1 && pathLabelIndexForWin > fileLabelIndex) {
                return new int[]{pathLabelIndexForWin + 1, parameterLabelIndex};
            }
            return new int[]{fileLabelIndex + DERBY_JDBC_URL_PREFIX.length() + 1, parameterLabelIndex};
        }
        return null;
    }

    private int[] fetchDatabaseNameRangeIndexForSubProtocol(String mode) {
        int fileLabelIndex = this.url.indexOf(mode);
        int parameterLabelIndex = this.url.indexOf(";", fileLabelIndex);
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = this.url.length();
        }
        if (fileLabelIndex != -1) {
            int pathLabelIndexForLinux = this.url.lastIndexOf("/");
            if (pathLabelIndexForLinux != -1 && pathLabelIndexForLinux > fileLabelIndex) {
                return new int[]{pathLabelIndexForLinux + 1, parameterLabelIndex};
            }
            int pathLabelIndexForWin = this.url.lastIndexOf("\\");
            if (pathLabelIndexForWin != -1 && pathLabelIndexForWin > fileLabelIndex) {
                return new int[]{pathLabelIndexForWin + 1, parameterLabelIndex};
            }
            return new int[]{fileLabelIndex + mode.length() + 1, parameterLabelIndex};
        }
        return null;
    }

    private ConnectionInfo defaultConnection(int[] databaseNameRangeIndex) {
        return new ConnectionInfo(ComponentsDefine.DERBY_JDBC_DRIVER, DB_TYPE, DEFAULT_HOST, -1, this.fetchDatabaseNameFromURL(databaseNameRangeIndex));
    }
}

