/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.impl.launcher.commands.VersionCommand;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;

class VertxContext {
    public static final double VERTX_VERSION;
    public static final String STOP_SPAN_NECESSARY = "VERTX_STOP_SPAN_NECESSARY";
    private static final Map<String, Deque<VertxContext>> CONTEXT_MAP;
    private final ContextSnapshot contextSnapshot;
    private final AbstractSpan span;

    static void pushContext(String identifier, VertxContext vertxContext) {
        if (!CONTEXT_MAP.containsKey(identifier)) {
            CONTEXT_MAP.put(identifier, new LinkedBlockingDeque());
        }
        CONTEXT_MAP.get(identifier).push(vertxContext);
    }

    static VertxContext popContext(String identifier) {
        Deque<VertxContext> stack = CONTEXT_MAP.get(identifier);
        VertxContext context = stack.pop();
        if (stack.isEmpty()) {
            CONTEXT_MAP.remove(identifier);
        }
        return context;
    }

    static VertxContext peekContext(String identifier) {
        return CONTEXT_MAP.get(identifier).peek();
    }

    static boolean hasContext(String identifier) {
        return identifier != null && CONTEXT_MAP.containsKey(identifier);
    }

    VertxContext(ContextSnapshot contextSnapshot, AbstractSpan span) {
        this.contextSnapshot = contextSnapshot;
        this.span = span;
    }

    ContextSnapshot getContextSnapshot() {
        return this.contextSnapshot;
    }

    AbstractSpan getSpan() {
        return this.span;
    }

    static {
        double version;
        try {
            version = Double.parseDouble(VersionCommand.getVersion().replaceFirst("\\.", ""));
        }
        catch (Throwable ignored) {
            version = 3.0;
        }
        VERTX_VERSION = version;
        CONTEXT_MAP = new ConcurrentHashMap<String, Deque<VertxContext>>();
    }
}

