/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Readable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Writable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteUtils;

public class BrokerHeartbeatRequestData
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    long currentMetadataOffset;
    boolean wantFence;
    boolean wantShutDown;
    List<Uuid> offlineLogDirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("current_metadata_offset", Type.INT64, "The highest metadata offset which the broker has reached."), new Field("want_fence", Type.BOOLEAN, "True if the broker wants to be fenced, false otherwise."), new Field("want_shut_down", Type.BOOLEAN, "True if the broker wants to be shut down, false otherwise."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("current_metadata_offset", Type.INT64, "The highest metadata offset which the broker has reached."), new Field("want_fence", Type.BOOLEAN, "True if the broker wants to be fenced, false otherwise."), new Field("want_shut_down", Type.BOOLEAN, "True if the broker wants to be shut down, false otherwise."), Field.TaggedFieldsSection.of(0, new Field("offline_log_dirs", new CompactArrayOf(Type.UUID), "Log directories that failed and went offline.")));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public BrokerHeartbeatRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BrokerHeartbeatRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
        this.currentMetadataOffset = 0L;
        this.wantFence = false;
        this.wantShutDown = false;
        this.offlineLogDirs = new ArrayList<Uuid>(0);
    }

    @Override
    public short apiKey() {
        return 63;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        this.currentMetadataOffset = _readable.readLong();
        this.wantFence = _readable.readByte() != 0;
        this.wantShutDown = _readable.readByte() != 0;
        this.offlineLogDirs = new ArrayList<Uuid>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    if (_version >= 1) {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field offlineLogDirs was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Uuid> newCollection = new ArrayList<Uuid>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readUuid());
                        }
                        this.offlineLogDirs = newCollection;
                        continue block3;
                    }
                    throw new RuntimeException("Tag 0 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeLong(this.currentMetadataOffset);
        _writable.writeByte(this.wantFence ? (byte)1 : 0);
        _writable.writeByte(this.wantShutDown ? (byte)1 : 0);
        if (_version >= 1) {
            if (!this.offlineLogDirs.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.offlineLogDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default offlineLogDirs at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (_version >= 1 && !this.offlineLogDirs.isEmpty()) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.offlineLogDirs));
            _writable.writeUnsignedVarint(this.offlineLogDirs.size() + 1);
            for (Uuid offlineLogDirsElement : this.offlineLogDirs) {
                _writable.writeUuid(offlineLogDirsElement);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(1);
        _size.addBytes(1);
        if (_version >= 1 && !this.offlineLogDirs.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.offlineLogDirs.size() + 1));
            _size.addBytes(this.offlineLogDirs.size() * 16);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.offlineLogDirs, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerHeartbeatRequestData)) {
            return false;
        }
        BrokerHeartbeatRequestData other = (BrokerHeartbeatRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.currentMetadataOffset != other.currentMetadataOffset) {
            return false;
        }
        if (this.wantFence != other.wantFence) {
            return false;
        }
        if (this.wantShutDown != other.wantShutDown) {
            return false;
        }
        if (this.offlineLogDirs == null ? other.offlineLogDirs != null : !this.offlineLogDirs.equals(other.offlineLogDirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + ((int)(this.currentMetadataOffset >> 32) ^ (int)this.currentMetadataOffset);
        hashCode = 31 * hashCode + (this.wantFence ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.wantShutDown ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.offlineLogDirs == null ? 0 : this.offlineLogDirs.hashCode());
        return hashCode;
    }

    @Override
    public BrokerHeartbeatRequestData duplicate() {
        BrokerHeartbeatRequestData _duplicate = new BrokerHeartbeatRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.currentMetadataOffset = this.currentMetadataOffset;
        _duplicate.wantFence = this.wantFence;
        _duplicate.wantShutDown = this.wantShutDown;
        ArrayList<Uuid> newOfflineLogDirs = new ArrayList<Uuid>(this.offlineLogDirs.size());
        for (Uuid _element : this.offlineLogDirs) {
            newOfflineLogDirs.add(_element);
        }
        _duplicate.offlineLogDirs = newOfflineLogDirs;
        return _duplicate;
    }

    public String toString() {
        return "BrokerHeartbeatRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", currentMetadataOffset=" + this.currentMetadataOffset + ", wantFence=" + (this.wantFence ? "true" : "false") + ", wantShutDown=" + (this.wantShutDown ? "true" : "false") + ", offlineLogDirs=" + MessageUtil.deepToString(this.offlineLogDirs.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public long currentMetadataOffset() {
        return this.currentMetadataOffset;
    }

    public boolean wantFence() {
        return this.wantFence;
    }

    public boolean wantShutDown() {
        return this.wantShutDown;
    }

    public List<Uuid> offlineLogDirs() {
        return this.offlineLogDirs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerHeartbeatRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public BrokerHeartbeatRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public BrokerHeartbeatRequestData setCurrentMetadataOffset(long v) {
        this.currentMetadataOffset = v;
        return this;
    }

    public BrokerHeartbeatRequestData setWantFence(boolean v) {
        this.wantFence = v;
        return this;
    }

    public BrokerHeartbeatRequestData setWantShutDown(boolean v) {
        this.wantShutDown = v;
        return this;
    }

    public BrokerHeartbeatRequestData setOfflineLogDirs(List<Uuid> v) {
        this.offlineLogDirs = v;
        return this;
    }
}

