/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Message;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Readable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Writable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteUtils;

public class DescribeProducersResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<TopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(TopicResponse.SCHEMA_0), "Each topic in the response."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeProducersResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeProducersResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<TopicResponse>(0);
    }

    @Override
    public short apiKey() {
        return 61;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicResponse> newCollection = new ArrayList<TopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicResponse(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicResponse topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeProducersResponseData)) {
            return false;
        }
        DescribeProducersResponseData other = (DescribeProducersResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public DescribeProducersResponseData duplicate() {
        DescribeProducersResponseData _duplicate = new DescribeProducersResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<TopicResponse> newTopics = new ArrayList<TopicResponse>(this.topics.size());
        for (TopicResponse _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "DescribeProducersResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<TopicResponse> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeProducersResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeProducersResponseData setTopics(List<TopicResponse> v) {
        this.topics = v;
        return this;
    }

    public static class ProducerState
    implements Message {
        long producerId;
        int producerEpoch;
        int lastSequence;
        long lastTimestamp;
        int coordinatorEpoch;
        long currentTxnStartOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("producer_id", Type.INT64, ""), new Field("producer_epoch", Type.INT32, ""), new Field("last_sequence", Type.INT32, ""), new Field("last_timestamp", Type.INT64, ""), new Field("coordinator_epoch", Type.INT32, ""), new Field("current_txn_start_offset", Type.INT64, ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ProducerState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ProducerState() {
            this.producerId = 0L;
            this.producerEpoch = 0;
            this.lastSequence = -1;
            this.lastTimestamp = -1L;
            this.coordinatorEpoch = 0;
            this.currentTxnStartOffset = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ProducerState");
            }
            this.producerId = _readable.readLong();
            this.producerEpoch = _readable.readInt();
            this.lastSequence = _readable.readInt();
            this.lastTimestamp = _readable.readLong();
            this.coordinatorEpoch = _readable.readInt();
            this.currentTxnStartOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeInt(this.producerEpoch);
            _writable.writeInt(this.lastSequence);
            _writable.writeLong(this.lastTimestamp);
            _writable.writeInt(this.coordinatorEpoch);
            _writable.writeLong(this.currentTxnStartOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ProducerState");
            }
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProducerState)) {
                return false;
            }
            ProducerState other = (ProducerState)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.producerEpoch != other.producerEpoch) {
                return false;
            }
            if (this.lastSequence != other.lastSequence) {
                return false;
            }
            if (this.lastTimestamp != other.lastTimestamp) {
                return false;
            }
            if (this.coordinatorEpoch != other.coordinatorEpoch) {
                return false;
            }
            if (this.currentTxnStartOffset != other.currentTxnStartOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + this.producerEpoch;
            hashCode = 31 * hashCode + this.lastSequence;
            hashCode = 31 * hashCode + ((int)(this.lastTimestamp >> 32) ^ (int)this.lastTimestamp);
            hashCode = 31 * hashCode + this.coordinatorEpoch;
            hashCode = 31 * hashCode + ((int)(this.currentTxnStartOffset >> 32) ^ (int)this.currentTxnStartOffset);
            return hashCode;
        }

        @Override
        public ProducerState duplicate() {
            ProducerState _duplicate = new ProducerState();
            _duplicate.producerId = this.producerId;
            _duplicate.producerEpoch = this.producerEpoch;
            _duplicate.lastSequence = this.lastSequence;
            _duplicate.lastTimestamp = this.lastTimestamp;
            _duplicate.coordinatorEpoch = this.coordinatorEpoch;
            _duplicate.currentTxnStartOffset = this.currentTxnStartOffset;
            return _duplicate;
        }

        public String toString() {
            return "ProducerState(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", lastSequence=" + this.lastSequence + ", lastTimestamp=" + this.lastTimestamp + ", coordinatorEpoch=" + this.coordinatorEpoch + ", currentTxnStartOffset=" + this.currentTxnStartOffset + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public int producerEpoch() {
            return this.producerEpoch;
        }

        public int lastSequence() {
            return this.lastSequence;
        }

        public long lastTimestamp() {
            return this.lastTimestamp;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        public long currentTxnStartOffset() {
            return this.currentTxnStartOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ProducerState setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public ProducerState setProducerEpoch(int v) {
            this.producerEpoch = v;
            return this;
        }

        public ProducerState setLastSequence(int v) {
            this.lastSequence = v;
            return this;
        }

        public ProducerState setLastTimestamp(long v) {
            this.lastTimestamp = v;
            return this;
        }

        public ProducerState setCoordinatorEpoch(int v) {
            this.coordinatorEpoch = v;
            return this;
        }

        public ProducerState setCurrentTxnStartOffset(long v) {
            this.currentTxnStartOffset = v;
            return this;
        }
    }

    public static class PartitionResponse
    implements Message {
        int partitionIndex;
        short errorCode;
        String errorMessage;
        List<ProducerState> activeProducers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The partition error message, which may be null if no additional details are available"), new Field("active_producers", new CompactArrayOf(ProducerState.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.errorMessage = null;
            this.activeProducers = new ArrayList<ProducerState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field activeProducers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ProducerState> newCollection = new ArrayList<ProducerState>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ProducerState(_readable, _version));
            }
            this.activeProducers = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeUnsignedVarint(this.activeProducers.size() + 1);
            _stringBytes = this.activeProducers.iterator();
            while (_stringBytes.hasNext()) {
                ProducerState activeProducersElement = (ProducerState)_stringBytes.next();
                activeProducersElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.activeProducers.size() + 1));
            for (ProducerState activeProducersElement : this.activeProducers) {
                activeProducersElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionResponse)) {
                return false;
            }
            PartitionResponse other = (PartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.activeProducers == null ? other.activeProducers != null : !this.activeProducers.equals(other.activeProducers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.activeProducers == null ? 0 : this.activeProducers.hashCode());
            return hashCode;
        }

        @Override
        public PartitionResponse duplicate() {
            PartitionResponse _duplicate = new PartitionResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            ArrayList<ProducerState> newActiveProducers = new ArrayList<ProducerState>(this.activeProducers.size());
            for (ProducerState _element : this.activeProducers) {
                newActiveProducers.add(_element.duplicate());
            }
            _duplicate.activeProducers = newActiveProducers;
            return _duplicate;
        }

        public String toString() {
            return "PartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", activeProducers=" + MessageUtil.deepToString(this.activeProducers.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<ProducerState> activeProducers() {
            return this.activeProducers;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public PartitionResponse setActiveProducers(List<ProducerState> v) {
            this.activeProducers = v;
            return this;
        }
    }

    public static class TopicResponse
    implements Message {
        String name;
        List<PartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("partitions", new CompactArrayOf(PartitionResponse.SCHEMA_0), "Each partition in the response."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<PartitionResponse>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicResponse");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionResponse> newCollection = new ArrayList<PartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionResponse(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionResponse partitionsElement = (PartitionResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicResponse");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionResponse partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicResponse)) {
                return false;
            }
            TopicResponse other = (TopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicResponse duplicate() {
            TopicResponse _duplicate = new TopicResponse();
            _duplicate.name = this.name;
            ArrayList<PartitionResponse> newPartitions = new ArrayList<PartitionResponse>(this.partitions.size());
            for (PartitionResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionResponse> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public TopicResponse setPartitions(List<PartitionResponse> v) {
            this.partitions = v;
            return this;
        }
    }
}

