/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.SerializationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.header.Headers;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.Deserializer;

public class DoubleDeserializer
implements Deserializer<Double> {
    @Override
    public Double deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new SerializationException("Size of data received by Deserializer is not 8");
        }
        long value = 0L;
        for (byte b : data) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return Double.longBitsToDouble(value);
    }

    @Override
    public Double deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.remaining() != 8) {
            throw new SerializationException("Size of data received by DoubleDeserializer is not 8");
        }
        return data.getDouble(data.position());
    }
}

