/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tmq!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%i!\u0012\u0005\u0007\u0019\u0006\u0001\u000bQ\u0002$\t\u000f5\u000b!\u0019!C\u0001\u000b\"1a*\u0001Q\u0001\n\u0019CQaT\u0001\u0005\u0002ACQaT\u0001\u0005\u0002mCQ!Y\u0001\u0005\u0002\tDQ!Y\u0001\u0005\u0002\u0011DqA]\u0001\u0002\u0002\u0013\u00055\u000fC\u0005\u0003\u0004\u0005\t\t\u0011\"!\u0003\u0006!I!\u0011C\u0001\u0002\u0002\u0013%!1\u0003\u0004\u0005e\r\u0002U\u000f\u0003\u0006\u0002\u00169\u0011)\u001a!C\u0001\u0003/A!\"a\b\u000f\u0005#\u0005\u000b\u0011BA\r\u0011\u0019\u0011e\u0002\"\u0001\u0002\"!9\u0011Q\u0005\b\u0005B\u0005\u001d\u0002bBA\u0018\u001d\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003\u0007rA\u0011IA#\u0011\u001d\tiE\u0004C!\u0003OAq!a\u0014\u000f\t#\n\t\u0006C\u0004\u0002\\9!\t&!\u0018\t\u000f\u0005ed\u0002\"\u0015\u0002|!I\u0011\u0011\u0011\b\u0002\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000fs\u0011\u0013!C\u0001\u0003\u0013C\u0011\"a(\u000f\u0003\u0003%\t%!)\t\u0013\u00055f\"!A\u0005\u0002\u0005=\u0006\"CA\\\u001d\u0005\u0005I\u0011AA]\u0011%\tyLDA\u0001\n\u0003\n\t\rC\u0005\u0002P:\t\t\u0011\"\u0001\u0002R\"I\u0011Q\u001b\b\u0002\u0002\u0013\u0005\u0013q\u001b\u0005\n\u00037t\u0011\u0011!C!\u0003;\f1\u0001S3y\u0015\t!S%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005\u0019#a\u0001%fqN\u0019\u0011\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0002j_*\tq(\u0001\u0003kCZ\f\u0017BA!=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t\u0001'A\u0005iKb$\u0015nZ5ugV\ta\tE\u00026\u000f&K!\u0001\u0013\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005UR\u0015BA&7\u0005\u0011\u0011\u0015\u0010^3\u0002\u0015!,\u0007\u0010R5hSR\u001c\b%A\u0006v]\",\u0007\u0010R5hSR\u001c\u0018\u0001D;oQ\u0016DH)[4jiN\u0004\u0013a\u00015fqR\u0011\u0011+\u0017\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bQ\u0001^=qKNT!AV\u0015\u0002\rUt7/\u00194f\u0013\tA6K\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eDQAW\u0004A\u0002\u0019\u000bQAY=uKN$\"!\u0015/\t\u000buC\u0001\u0019\u00010\u0002\u00079,X\u000e\u0005\u00026?&\u0011\u0001M\u000e\u0002\u0005\u0019>tw-A\u0003v]\",\u0007\u0010\u0006\u0002GG\")!,\u0003a\u0001\rR\u0011a)\u001a\u0005\u0006M*\u0001\raZ\u0001\u0004gR\u0014\bC\u00015p\u001d\tIW\u000e\u0005\u0002km5\t1N\u0003\u0002m_\u00051AH]8pizJ!A\u001c\u001c\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]Z\nQ!\u00199qYf$2\u0001\u001eB\u0001!\t\tdbE\u0004\u000fmfdx0!\u0002\u0011\u0005E:\u0018B\u0001=$\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u0019{\u0013\tY8E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\tT0\u0003\u0002\u007fG\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\r)\u0014\u0011A\u0005\u0004\u0003\u00071$a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u00055ab\u00016\u0002\f%\tq'C\u0002\u0002\u0010Y\nq\u0001]1dW\u0006<W-C\u0002B\u0003'Q1!a\u00047\u0003\u0015\u0019\u0007.\u001b7e+\t\tI\u0002E\u00022\u00037I1!!\b$\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0015\u0007Q\f\u0019\u0003C\u0004\u0002\u0016E\u0001\r!!\u0007\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\u0011\u0011\u0011\u0006\t\u0004k\u0005-\u0012bAA\u0017m\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\u0011\u00111\u0007\t\u0007\u0003\u000f\t)$!\u000f\n\t\u0005]\u00121\u0003\u0002\u0004'\u0016\f\b\u0003BA\u001e\u0003\u007fi!!!\u0010\u000b\u0005Q;\u0013\u0002BA!\u0003{\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0012\u0011\t\u0005m\u0012\u0011J\u0005\u0005\u0003\u0017\niD\u0001\u0005ECR\fG+\u001f9f\u0003i\u0019wN\u001c;fqRLe\u000eZ3qK:$WM\u001c;G_2$\u0017M\u00197f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\t\u0019&!\u0017\u0011\u0007U\n)&C\u0002\u0002XY\u00121!\u00118z\u0011\u0019if\u00031\u0001\u0002T\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003?\nY'!\u001e\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a$\u0003\u001d\u0019w\u000eZ3hK:LA!!\u001b\u0002d\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002n]\u0001\r!a\u001c\u0002\u0007\r$\b\u0010\u0005\u0003\u0002b\u0005E\u0014\u0002BA:\u0003G\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002x]\u0001\r!a\u0018\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002u\u0003{Bq!a \u0019\u0001\u0004\tI\"\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007Q\f)\tC\u0005\u0002\u0016e\u0001\n\u00111\u0001\u0002\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAFU\u0011\tI\"!$,\u0005\u0005=\u0005\u0003BAI\u00037k!!a%\u000b\t\u0005U\u0015qS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!'7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\u000b\u0019JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAR!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAU}\u0005!A.\u00198h\u0013\r\u0001\u0018qU\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00032!NAZ\u0013\r\t)L\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\nY\fC\u0005\u0002>v\t\t\u00111\u0001\u00022\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a1\u0011\r\u0005\u0015\u00171ZA*\u001b\t\t9MC\u0002\u0002JZ\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti-a2\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\t\u0019\u000eC\u0005\u0002>~\t\t\u00111\u0001\u0002T\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019+!7\t\u0013\u0005u\u0006%!AA\u0002\u0005E\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002*\u0005}\u0007\"CA_C\u0005\u0005\t\u0019AA*QMq\u00111]Au\u0003W\fy/!=\u0002v\u0006]\u00181`A\u007f!\r\t\u0014Q]\u0005\u0004\u0003O\u001c#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\faf\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I\"p]Z,'\u000f^:!A\u0016D\bO\u001d1!i>\u0004\u0003.\u001a=bI\u0016\u001c\u0017.\\1m]\u0005AQ\r_1na2,7/\t\u0002\u0002t\u0006!(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00198SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!kM:\u0004GN\u00198eY\u0012%\u0007M\u001b4kE\"4I\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI0A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002\u0000\u0006QQ.\u0019;i?\u001a,hnY:\t\u000f\u0005U1\u00021\u0001\u0002\u001a\u00059QO\\1qa2LH\u0003\u0002B\u0004\u0005\u001b\u0001R!\u000eB\u0005\u00033I1Aa\u00037\u0005\u0019y\u0005\u000f^5p]\"A!q\u0002\u0007\u0002\u0002\u0003\u0007A/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0006\u0011\t\u0005\u0015&qC\u0005\u0005\u00053\t9K\u0001\u0004PE*,7\r\u001e")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex x$0) {
        return Hex$.MODULE$.unapply(x$0);
    }

    public static byte[] unhex(String str) {
        return Hex$.MODULE$.unhex(str);
    }

    public static byte[] unhex(byte[] bytes) {
        return Hex$.MODULE$.unhex(bytes);
    }

    public static UTF8String hex(long num) {
        return Hex$.MODULE$.hex(num);
    }

    public static UTF8String hex(byte[] bytes) {
        return Hex$.MODULE$.hex(bytes);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType;
        }
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object num) {
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex((byte[])num);
        }
        if (dataType instanceof StringType) {
            return Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            DataType dataType;
            String hex = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName()), "$");
            return ev.value() + " = " + ((dataType = this.child().dataType()) instanceof StringType ? hex + ".hex(" + c + ".getBytes());" : hex + ".hex(" + c + ");");
        });
    }

    @Override
    public Hex withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

