/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.FinalizedSketch;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaSketchState;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.UnionAggregationBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.UpdatableSketchBuffer;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, lgNomEntries) - Returns the ThetaSketch compact binary representation.\n      `lgNomEntries` (optional) is the log-base-2 of nominal entries, with nominal entries deciding\n      the number buckets or slots for the ThetaSketch. ", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(col, 12)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005j\u0001\tE\t\u0015!\u0003M\u0011!Q\u0007A!f\u0001\n\u0003Z\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011A\u0004!Q3A\u0005B-D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\ts\u0002A)\u0019!C\u0001W\")!\u000f\u0001C\u0001u\")!\u000f\u0001C\u0001{\"1!\u000f\u0001C\u0001\u0003\u0003Aq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005]\u0001\u0001\"\u0015\u0002\u001a!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t9\u0006\u0001C!\u00033Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003C\u0003A\u0011IAR\u0011%\tI\u000bAA\u0001\n\u0003\tY\u000bC\u0005\u00026\u0002\t\n\u0011\"\u0001\u00028\"I\u0011Q\u001a\u0001\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003\u001f\u0004\u0011\u0013!C\u0001\u0003#D\u0011\"!6\u0001#\u0003%\t!!5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\u0002CAu\u0001\u0005\u0005I\u0011A6\t\u0013\u0005-\b!!A\u0005\u0002\u00055\b\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\n\u0001\t\t\u0011\"\u0011\u0003\f!I!q\u0002\u0001\u0002\u0002\u0013\u0005#\u0011C\u0004\n\u0005ky\u0013\u0011!E\u0001\u0005o1\u0001BL\u0018\u0002\u0002#\u0005!\u0011\b\u0005\u0007e\"\"\tA!\u0015\t\u0013\tM\u0003&!A\u0005F\tU\u0003\"\u0003B,Q\u0005\u0005I\u0011\u0011B-\u0011%\u0011\u0019\u0007KA\u0001\n\u0003\u0013)\u0007C\u0005\u0003x!\n\t\u0011\"\u0003\u0003z\tqA\u000b[3uCN[W\r^2i\u0003\u001e<'B\u0001\u00192\u0003%\twm\u001a:fO\u0006$XM\u0003\u00023g\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!T'\u0001\u0005dCR\fG._:u\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001'\u0019\u0001qH\u0012)T3B\u0019\u0001)Q\"\u000e\u0003=J!AQ\u0018\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002A\t&\u0011Qi\f\u0002\u0011)\",G/Y*lKR\u001c\u0007n\u0015;bi\u0016\u00042a\u0012&M\u001b\u0005A%BA%4\u0003\u0015!(/Z3t\u0013\tY\u0005J\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"!\u0014(\u000e\u0003EJ!aT\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002N#&\u0011!+\r\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&a\u0002)s_\u0012,8\r\u001e\t\u00035\nt!a\u00171\u000f\u0005q{V\"A/\u000b\u0005yk\u0014A\u0002\u001fs_>$h(C\u0001W\u0013\t\tW+A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'\u0001D*fe&\fG.\u001b>bE2,'BA1V\u0003\u0011aWM\u001a;\u0016\u00031\u000bQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u00031\u0004\"\u0001V7\n\u00059,&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"R\u0001^;wob\u0004\"\u0001\u0011\u0001\t\u000b\u0015L\u0001\u0019\u0001'\t\u000b!L\u0001\u0019\u0001'\t\u000b)L\u0001\u0019\u00017\t\u000bAL\u0001\u0019\u00017\u0002\u00191<gj\\7F]R\u0014\u0018.Z:\u0015\u0005Q\\\b\"\u0002?\f\u0001\u0004a\u0015!B2iS2$Gc\u0001;\u007f\u007f\")A\u0010\u0004a\u0001\u0019\")\u0011\u0010\u0004a\u0001\u0019R)A/a\u0001\u0002\u0006!)A0\u0004a\u0001\u0019\")\u00110\u0004a\u0001Y\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fF\u0002u\u0003\u0017Aa!!\u0004\u000f\u0001\u0004a\u0017!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001;\u0002\u0014!1\u0011QC\bA\u00021\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002;\u0002\u001c\u0005}\u0001BBA\u000f!\u0001\u0007A*A\u0004oK^dUM\u001a;\t\r\u0005\u0005\u0002\u00031\u0001M\u0003!qWm\u001e*jO\"$\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011q\u0005\t\u0005\u0003S\t\tD\u0004\u0003\u0002,\u00055\u0002C\u0001/V\u0013\r\ty#V\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=R+\u0001\u0006j]B,H\u000fV=qKN,\"!a\u000f\u0011\u000bi\u000bi$!\u0011\n\u0007\u0005}BMA\u0002TKF\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f*\u0014!\u0002;za\u0016\u001c\u0018\u0002BA&\u0003\u000b\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0015\u0011\t\u0005\r\u00131K\u0005\u0005\u0003+\n)E\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA.!\r!\u0016QL\u0005\u0004\u0003?*&a\u0002\"p_2,\u0017M\\\u0001\u0018GJ,\u0017\r^3BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012aQ\u0001\u0007kB$\u0017\r^3\u0015\u000b\r\u000bI'!\u001c\t\r\u0005-d\u00031\u0001D\u00031)\b\u000fZ1uK\n+hMZ3s\u0011\u001d\tyG\u0006a\u0001\u0003c\nQ!\u001b8qkR\u0004B!a\u001d\u0002v5\t1'C\u0002\u0002xM\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)Q.\u001a:hKR)1)! \u0002\u0000!1\u00111N\fA\u0002\rCa!a\u001c\u0018\u0001\u0004\u0019\u0015\u0001B3wC2$B!!\"\u0002\fB\u0019A+a\"\n\u0007\u0005%UKA\u0002B]fDa!!$\u0019\u0001\u0004\u0019\u0015aC:lKR\u001c\u0007n\u0015;bi\u0016\f\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005M\u0015q\u0014\t\u0006)\u0006U\u0015\u0011T\u0005\u0004\u0003/+&!B!se\u0006L\bc\u0001+\u0002\u001c&\u0019\u0011QT+\u0003\t\tKH/\u001a\u0005\u0007\u0003\u001bK\u0002\u0019A\"\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0007\u0006\u0015\u0006bBAT5\u0001\u0007\u00111S\u0001\u0007EV4g-\u001a:\u0002\t\r|\u0007/\u001f\u000b\ni\u00065\u0016qVAY\u0003gCq!Z\u000e\u0011\u0002\u0003\u0007A\nC\u0004i7A\u0005\t\u0019\u0001'\t\u000f)\\\u0002\u0013!a\u0001Y\"9\u0001o\u0007I\u0001\u0002\u0004a\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sS3\u0001TA^W\t\ti\f\u0005\u0003\u0002@\u0006%WBAAa\u0015\u0011\t\u0019-!2\u0002\u0013Ut7\r[3dW\u0016$'bAAd+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0017\u0011\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019NK\u0002m\u0003w\u000babY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0004B!!8\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/\u0001\u0003mC:<'BAAs\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012q\\\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t))a<\t\u0011\u0005E(%!AA\u00021\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA|!\u0019\tI0a@\u0002\u00066\u0011\u00111 \u0006\u0004\u0003{,\u0016AC2pY2,7\r^5p]&!!\u0011AA~\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m#q\u0001\u0005\n\u0003c$\u0013\u0011!a\u0001\u0003\u000b\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u001cB\u0007\u0011!\t\t0JA\u0001\u0002\u0004a\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\\\tM\u0001\"CAyM\u0005\u0005\t\u0019AACQM\u0001!q\u0003B\u000f\u0005?\u0011\u0019C!\n\u0003*\t-\"q\u0006B\u0019!\ri%\u0011D\u0005\u0004\u00057\t$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005C\t\u0011\u0011\u001e\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u0001bwMT8n\u000b:$(/[3tS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\"\u0006.\u001a;b'.,Go\u00195!G>l\u0007/Y2uA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]:R\u0001\u0005\t\u0011!A\u0001\u0002Gn\u001a(p[\u0016sGO]5fg\u0002\u0004\u0003f\u001c9uS>t\u0017\r\\\u0015!SN\u0004C\u000f[3!Y><WFY1tK6\u0012\u0004e\u001c4!]>l\u0017N\\1mA\u0015tGO]5fg2\u0002s/\u001b;iA9|W.\u001b8bY\u0002*g\u000e\u001e:jKN\u0004C-Z2jI&twM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5fA9,XNY3sA\t,8m[3ug\u0002z'\u000fI:m_R\u001c\bEZ8sAQDW\r\t+iKR\f7k[3uG\"t\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u00119#\u0001@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQDW\r^1`g.,Go\u00195`KN$\u0018.\\1uK\"zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!cIJ\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015-A!\n\u0014\u0006\f\u0011)e%b\u0003\u0005\u000b\u001a*Y\u0001B3'\u000b\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t5\u0012!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\u0019$A\u00035]Er\u0003'\u0001\bUQ\u0016$\u0018mU6fi\u000eD\u0017iZ4\u0011\u0005\u0001C3#\u0002\u0015\u0003<\t\u001d\u0003#\u0003B\u001f\u0005\u0007bE\n\u001c7u\u001b\t\u0011yDC\u0002\u0003BU\u000bqA];oi&lW-\u0003\u0003\u0003F\t}\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!\u0011\nB(\u001b\t\u0011YE\u0003\u0003\u0003N\u0005\r\u0018AA5p\u0013\r\u0019'1\n\u000b\u0003\u0005o\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\fQ!\u00199qYf$\u0012\u0002\u001eB.\u0005;\u0012yF!\u0019\t\u000b\u0015\\\u0003\u0019\u0001'\t\u000b!\\\u0003\u0019\u0001'\t\u000b)\\\u0003\u0019\u00017\t\u000bA\\\u0003\u0019\u00017\u0002\u000fUt\u0017\r\u001d9msR!!q\rB:!\u0015!&\u0011\u000eB7\u0013\r\u0011Y'\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fQ\u0013y\u0007\u0014'mY&\u0019!\u0011O+\u0003\rQ+\b\u000f\\35\u0011!\u0011)\bLA\u0001\u0002\u0004!\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0010\t\u0005\u0003;\u0014i(\u0003\u0003\u0003\u0000\u0005}'AB(cU\u0016\u001cG\u000f")
public class ThetaSketchAgg
extends TypedImperativeAggregate<ThetaSketchState>
implements BinaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private int lgNomEntries;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(ThetaSketchAgg x$0) {
        return ThetaSketchAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, ThetaSketchAgg> tupled() {
        return ThetaSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, ThetaSketchAgg>>>> curried() {
        return ThetaSketchAgg$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ThetaSketchAgg thetaSketchAgg = this;
        synchronized (thetaSketchAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    /*
     * WARNING - void declaration
     */
    private int lgNomEntries$lzycompute() {
        ThetaSketchAgg thetaSketchAgg = this;
        synchronized (thetaSketchAgg) {
            if (!this.bitmap$0) {
                void var2_2;
                int lgNomEntriesInput = BoxesRunTime.unboxToInt((Object)this.right().eval(this.right().eval$default$1()));
                ThetaSketchUtils$.MODULE$.checkLgNomLongs(lgNomEntriesInput, this.prettyName());
                this.lgNomEntries = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.lgNomEntries;
    }

    public int lgNomEntries() {
        if (!this.bitmap$0) {
            return this.lgNomEntries$lzycompute();
        }
        return this.lgNomEntries;
    }

    @Override
    public ThetaSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ThetaSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public ThetaSketchAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "theta_sketch_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$), BinaryType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public ThetaSketchState createAggregationBuffer() {
        UpdateSketchBuilder builder = new UpdateSketchBuilder();
        builder.setLogNominalEntries(this.lgNomEntries());
        return new UpdatableSketchBuffer(builder.build());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ThetaSketchState update(ThetaSketchState updateBuffer, InternalRow input) {
        DataType dataType;
        Object v = this.left().eval(input);
        if (v == null) {
            return updateBuffer;
        }
        ThetaSketchState thetaSketchState = updateBuffer;
        if (!(thetaSketchState instanceof UpdatableSketchBuffer)) throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
        UpdatableSketchBuffer updatableSketchBuffer = (UpdatableSketchBuffer)thetaSketchState;
        UpdateSketch s = updatableSketchBuffer.sketch();
        UpdateSketch sketch = s;
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType2 = this.left().dataType();
        if (dataType2 instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType2;
            DataType dataType3 = arrayType.elementType();
            if (IntegerType$.MODULE$.equals(dataType3)) {
                int[] arr = ((ArrayData)v).toIntArray();
                sketch.update(arr);
                return new UpdatableSketchBuffer(sketch);
            }
        }
        if (bl && LongType$.MODULE$.equals(dataType = arrayType.elementType())) {
            long[] arr = ((ArrayData)v).toLongArray();
            sketch.update(arr);
            return new UpdatableSketchBuffer(sketch);
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            byte[] bytes = (byte[])v;
            sketch.update(bytes);
            return new UpdatableSketchBuffer(sketch);
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            sketch.update(BoxesRunTime.unboxToDouble((Object)v));
            return new UpdatableSketchBuffer(sketch);
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            sketch.update((double)BoxesRunTime.unboxToFloat((Object)v));
            return new UpdatableSketchBuffer(sketch);
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            sketch.update((long)BoxesRunTime.unboxToInt((Object)v));
            return new UpdatableSketchBuffer(sketch);
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            sketch.update(BoxesRunTime.unboxToLong((Object)v));
            return new UpdatableSketchBuffer(sketch);
        }
        if (dataType2 instanceof StringType) {
            StringType stringType = (StringType)dataType2;
            CollationFactory.Collation collation = CollationFactory.fetchCollation((int)stringType.collationId());
            UTF8String str = (UTF8String)v;
            if (Predef$.MODULE$.Boolean2boolean((Boolean)collation.equalsFunction.apply(str, UTF8String.EMPTY_UTF8))) return new UpdatableSketchBuffer(sketch);
            sketch.update((byte[])collation.sortKeyFunction.apply(str));
            return new UpdatableSketchBuffer(sketch);
        }
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3121", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.left().dataType().toString())})));
    }

    @Override
    public ThetaSketchState merge(ThetaSketchState updateBuffer, ThetaSketchState input) {
        Tuple2 tuple2 = new Tuple2((Object)updateBuffer, (Object)input);
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState2 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UnionAggregationBuffer) {
                UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
                Union existingUnion = unionAggregationBuffer.union();
                if (thetaSketchState2 instanceof UpdatableSketchBuffer) {
                    UpdatableSketchBuffer updatableSketchBuffer = (UpdatableSketchBuffer)thetaSketchState2;
                    UpdateSketch sketch = updatableSketchBuffer.sketch();
                    existingUnion.union((Sketch)sketch.compact());
                    return new UnionAggregationBuffer(existingUnion);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState3 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UnionAggregationBuffer) {
                UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
                Union existingUnion = unionAggregationBuffer.union();
                if (thetaSketchState3 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState3;
                    CompactSketch sketch = finalizedSketch.sketch();
                    existingUnion.union((Sketch)sketch);
                    return new UnionAggregationBuffer(existingUnion);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState4 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UnionAggregationBuffer) {
                UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
                Union union1 = unionAggregationBuffer.union();
                if (thetaSketchState4 instanceof UnionAggregationBuffer) {
                    UnionAggregationBuffer unionAggregationBuffer2 = (UnionAggregationBuffer)thetaSketchState4;
                    Union union2 = unionAggregationBuffer2.union();
                    union1.union((Sketch)union2.getResult());
                    return new UnionAggregationBuffer(union1);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState5 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UpdatableSketchBuffer) {
                UpdatableSketchBuffer updatableSketchBuffer = (UpdatableSketchBuffer)thetaSketchState;
                UpdateSketch sketch1 = updatableSketchBuffer.sketch();
                if (thetaSketchState5 instanceof UpdatableSketchBuffer) {
                    UpdatableSketchBuffer updatableSketchBuffer2 = (UpdatableSketchBuffer)thetaSketchState5;
                    UpdateSketch sketch2 = updatableSketchBuffer2.sketch();
                    return this.createUnionWith$1((Sketch)sketch1.compact(), (Sketch)sketch2.compact());
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState6 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UpdatableSketchBuffer) {
                UpdatableSketchBuffer updatableSketchBuffer = (UpdatableSketchBuffer)thetaSketchState;
                UpdateSketch sketch1 = updatableSketchBuffer.sketch();
                if (thetaSketchState6 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState6;
                    CompactSketch sketch2 = finalizedSketch.sketch();
                    return this.createUnionWith$1((Sketch)sketch1.compact(), (Sketch)sketch2);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState7 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch1 = finalizedSketch.sketch();
                if (thetaSketchState7 instanceof UpdatableSketchBuffer) {
                    UpdatableSketchBuffer updatableSketchBuffer = (UpdatableSketchBuffer)thetaSketchState7;
                    UpdateSketch sketch2 = updatableSketchBuffer.sketch();
                    return this.createUnionWith$1((Sketch)sketch1, (Sketch)sketch2.compact());
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState8 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch1 = finalizedSketch.sketch();
                if (thetaSketchState8 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch2 = (FinalizedSketch)thetaSketchState8;
                    CompactSketch sketch2 = finalizedSketch2.sketch();
                    return this.createUnionWith$1((Sketch)sketch1, (Sketch)sketch2);
                }
            }
        }
        throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
    }

    @Override
    public Object eval(ThetaSketchState sketchState) {
        return sketchState.eval();
    }

    @Override
    public byte[] serialize(ThetaSketchState sketchState) {
        return sketchState.serialize();
    }

    @Override
    public ThetaSketchState deserialize(byte[] buffer) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer))) {
            return new FinalizedSketch(CompactSketch.heapify((Memory)Memory.wrap((byte[])buffer)));
        }
        return this.createAggregationBuffer();
    }

    public ThetaSketchAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ThetaSketchAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ThetaSketchAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaSketchAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaSketchAgg thetaSketchAgg = (ThetaSketchAgg)x$1;
        if (this.mutableAggBufferOffset() != thetaSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != thetaSketchAgg.inputAggBufferOffset()) return false;
        Expression expression = this.left();
        Expression expression2 = thetaSketchAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = thetaSketchAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!thetaSketchAgg.canEqual(this)) return false;
        return true;
    }

    private final UnionAggregationBuffer createUnionWith$1(Sketch sketch1, Sketch sketch2) {
        Union union = SetOperation.builder().setLogNominalEntries(this.lgNomEntries()).buildUnion();
        union.union(sketch1);
        union.union(sketch2);
        return new UnionAggregationBuffer(union);
    }

    public ThetaSketchAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ThetaSketchAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)), 0, 0);
    }

    public ThetaSketchAgg(Expression child, Expression lgNomEntries) {
        this(child, lgNomEntries, 0, 0);
    }

    public ThetaSketchAgg(Expression child, int lgNomEntries) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)lgNomEntries)), 0, 0);
    }
}

