/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm$SPHERICAL$;
import org.apache.spark.sql.types.GeographyType$;
import org.json4s.JString;
import org.json4s.JValue;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\u0016,\u0001YB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0017\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u001dy\u0006A1A\u0005\u0002\u0001Da!\u001a\u0001!\u0002\u0013\t\u0007\"\u00024\u0001\t\u0003\u0002\u0007\"B4\u0001\t\u0003A\u0007\"\u00027\u0001\t\u0003R\u0005\"B7\u0001\t\u0003r\u0007\"B8\u0001\t\u0003\u0002\bB\u0002@\u0001\t\u0003zs\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!A\u00111\u0003\u0001\u0005B5\n)\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u0011\u0005%\u0002\u0001\"\u0001.\u0003W9q!!\u0012,\u0011\u0003\t9E\u0002\u0004+W!\u0005\u0011\u0011\n\u0005\u00075R!\t!!\u001a\t\u0013\u0005\u001dDC1A\u0005\u0006\u0005%\u0004\u0002CA8)\u0001\u0006i!a\u001b\t\u0013\u0005EDC1A\u0005\u0006\u0005M\u0004\u0002CA>)\u0001\u0006i!!\u001e\t\u0013\u0005uDC1A\u0005\u0006\u0005}\u0004\u0002CAH)\u0001\u0006i!!!\t\u0013\u0005EEC1A\u0005\u0006\u0005M\u0005\u0002CAP)\u0001\u0006i!!&\t\u0011\u0005\u0005FC1A\u0005\u000e}Dq!a)\u0015A\u00035A\fC\u0004\u0002&R!\t!a*\t\u000f\u0005-F\u0003\"\u0001\u0002.\"9\u00111\u0016\u000b\u0005\u0002\u0005E\u0006bBAV)\u0011\u0005\u0011Q\u0017\u0005\b\u0003W#B\u0011AA^\u0011!\t\t\r\u0006C![\u0005\r\u0007\u0002CA\n)\u0011\u0005S&!2\t\u000f\u0005%G\u0003\"\u0011.\u0015\"A\u00111\u001a\u000b\u0005\u0002-\ni\rC\u0005\u0002RR\t\t\u0011\"\u0003\u0002T\niq)Z8he\u0006\u0004\b.\u001f+za\u0016T!\u0001L\u0017\u0002\u000bQL\b/Z:\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u000194\b\u0005\u00029s5\t1&\u0003\u0002;W\tQ\u0011\t^8nS\u000e$\u0016\u0010]3\u0011\u0005q2eBA\u001fD\u001d\tq\u0014)D\u0001@\u0015\t\u0001U'\u0001\u0004=e>|GOP\u0005\u0002\u0005\u0006)1oY1mC&\u0011A)R\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0011\u0015BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!U)A\u0002deN,\u0012a\u0013\t\u0003\u0019Bs!!\u0014(\u0011\u0005y*\u0015BA(F\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=+\u0015\u0001B2sg\u0002\n\u0011\"\u00197h_JLG\u000f[7\u0016\u0003Y\u0003\"\u0001O,\n\u0005a[#AG#eO\u0016Le\u000e^3sa>d\u0017\r^5p]\u0006cwm\u001c:ji\"l\u0017AC1mO>\u0014\u0018\u000e\u001e5nA\u00051A(\u001b8jiz\"2\u0001X/_!\tA\u0004\u0001C\u0003J\u000b\u0001\u00071\nC\u0003U\u000b\u0001\u0007a+\u0001\u0003te&$W#A1\u0011\u0005\t\u001cW\"A#\n\u0005\u0011,%aA%oi\u0006)1O]5eA\u0005YA-\u001a4bk2$8+\u001b>f\u0003-I7/T5yK\u0012\u001c&/\u001b3\u0016\u0003%\u0004\"A\u00196\n\u0005-,%a\u0002\"p_2,\u0017M\\\u0001\tif\u0004XMT1nK\u0006AAo\\*ue&tw\rF\u0001L\u0003%Q7o\u001c8WC2,X-F\u0001r!\t\u00118P\u0004\u0002tq:\u0011AO\u001e\b\u0003}UL\u0011\u0001N\u0005\u0003oN\naA[:p]R\u001a\u0018BA={\u0003\u001dQ5o\u001c8B'RS!a^\u001a\n\u0005ql(A\u0002&WC2,XM\u0003\u0002zu\u0006Q\u0011m\u001d(vY2\f'\r\\3\u0016\u0003q\u000ba!Z9vC2\u001cHcA5\u0002\u0006!9\u0011q\u0001\bA\u0002\u0005%\u0011aA8cUB\u0019!-a\u0003\n\u0007\u00055QIA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002C\u0006Y\u0011mY2faR\u001cH+\u001f9f)\rI\u0017q\u0003\u0005\b\u00033\u0001\u0002\u0019AA\u000e\u0003\u0015yG\u000f[3s!\rA\u0014QD\u0005\u0004\u0003?Y#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002)\u0005\u001c7-\u001a9ug\u001e+wn\u001a:ba\"LH+\u001f9f)\rI\u0017Q\u0005\u0005\u0007\u0003O\t\u0002\u0019\u0001/\u0002\u0005\u001d$\u0018\u0001G1tg\u0016\u0014Ho\u0015:jI\u0006cGn\\<fI\u001a{'\u000fV=qKR!\u0011QFA\u001a!\r\u0011\u0017qF\u0005\u0004\u0003c)%\u0001B+oSRDa!!\u000e\u0013\u0001\u0004\t\u0017!C8uQ\u0016\u00148K]5eQ\r\u0001\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005u\"\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0017!D$f_\u001e\u0014\u0018\r\u001d5z)f\u0004X\r\u0005\u00029)M9A#a\u0013\u0002R\u0005]\u0003c\u0001\u001d\u0002N%\u0019\u0011qJ\u0016\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007c\u0001\u001d\u0002T%\u0019\u0011QK\u0016\u0003\u0017M\u0003\u0018\r^5bYRK\b/\u001a\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\tIwN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\r9\u00151\f\u000b\u0003\u0003\u000f\nacR#P\u000fJ\u000b\u0005\u000bS-`\t\u00163\u0015)\u0016'U?N\u0013\u0016\nR\u000b\u0003\u0003Wz!!!\u001c\u001e\u0005A1\u001faF$F\u001f\u001e\u0013\u0016\t\u0015%Z?\u0012+e)Q+M)~\u001b&+\u0013#!\u0003U9UiT$S\u0003BC\u0015l\u0018#F\r\u0006+F\nV0D%N+\"!!\u001e\u0010\u0005\u0005]\u0014EAA=\u0003%yui\u0011\u001eD%NCD'\u0001\fH\u000b>;%+\u0011)I3~#UIR!V\u0019R{6IU*!\u0003m9UiT$S\u0003BC\u0015l\u0018#F\r\u0006+F\nV0B\u0019\u001e{%+\u0013+I\u001bV\u0011\u0011\u0011\u0011\b\u0005\u0003\u0007\u000bIID\u00029\u0003\u000bK1!a\",\u0003i)EmZ3J]R,'\u000f]8mCRLwN\\!mO>\u0014\u0018\u000e\u001e5n\u0013\u0011\tY)!$\u0002\u0013M\u0003\u0006*\u0012*J\u0007\u0006c%bAADW\u0005ar)R(H%\u0006\u0003\u0006*W0E\u000b\u001a\u000bU\u000b\u0014+`\u00032;uJU%U\u00116\u0003\u0013AG$F\u001f\u001e\u0013\u0016\t\u0015%Z?\u0012+e)Q+M)~+\u0005kU$`\u0007J\u001bVCAAK!\u0011\t9*!(\u000e\u0005\u0005e%\u0002BAN\u0003?\nA\u0001\\1oO&\u0019\u0011+!'\u00027\u001d+uj\u0012*B!\"Kv\fR#G\u0003VcEkX#Q'\u001e{6IU*!\u0003Q9UiT$S\u0003BC\u0015lX'J1\u0016#u\fV-Q\u000b\u0006)r)R(H%\u0006\u0003\u0006*W0N\u0013b+Ei\u0018+Z!\u0016\u0003\u0013aD5t'JLGmU;qa>\u0014H/\u001a3\u0015\u0007%\fI\u000bC\u0003`A\u0001\u0007\u0011-A\u0003baBd\u0017\u0010F\u0002]\u0003_CQaX\u0011A\u0002\u0005$2\u0001XAZ\u0011\u0015I%\u00051\u0001L)\u0015a\u0016qWA]\u0011\u0015I5\u00051\u0001L\u0011\u0015!6\u00051\u0001L)\u0015a\u0016QXA`\u0011\u0015IE\u00051\u0001L\u0011\u0015!F\u00051\u0001W\u0003M!WMZ1vYR\u001cuN\\2sKR,G+\u001f9f+\t\tY\u0002F\u0002j\u0003\u000fDq!!\u0007'\u0001\u0004\tY\"\u0001\u0007tS6\u0004H.Z*ue&tw-\u0001\u0004u_N\u0013\u0018\u000e\u001a\u000b\u0004C\u0006=\u0007\"B%)\u0001\u0004Y\u0015\u0001D<sSR,'+\u001a9mC\u000e,GCAAk!\u0011\t9*a6\n\t\u0005e\u0017\u0011\u0014\u0002\u0007\u001f\nTWm\u0019;)\u0007Q\tI\u0004K\u0002\u0014\u0003s\u0001")
public class GeographyType
extends AtomicType
implements Serializable {
    private final String crs;
    private final EdgeInterpolationAlgorithm algorithm;
    private final int srid;

    public static GeographyType apply(String crs, EdgeInterpolationAlgorithm algorithm) {
        return GeographyType$.MODULE$.apply(crs, algorithm);
    }

    public static GeographyType apply(String crs, String algorithm) {
        return GeographyType$.MODULE$.apply(crs, algorithm);
    }

    public static GeographyType apply(String crs) {
        return GeographyType$.MODULE$.apply(crs);
    }

    public static GeographyType apply(int srid) {
        return GeographyType$.MODULE$.apply(srid);
    }

    public static boolean isSridSupported(int srid) {
        return GeographyType$.MODULE$.isSridSupported(srid);
    }

    public static String GEOGRAPHY_DEFAULT_EPSG_CRS() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_EPSG_CRS();
    }

    public static EdgeInterpolationAlgorithm$SPHERICAL$ GEOGRAPHY_DEFAULT_ALGORITHM() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_ALGORITHM();
    }

    public static String GEOGRAPHY_DEFAULT_CRS() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_CRS();
    }

    public static int GEOGRAPHY_DEFAULT_SRID() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_SRID();
    }

    public static String MIXED_CRS() {
        return GeographyType$.MODULE$.MIXED_CRS();
    }

    public static int MIXED_SRID() {
        return GeographyType$.MODULE$.MIXED_SRID();
    }

    public String crs() {
        return this.crs;
    }

    public EdgeInterpolationAlgorithm algorithm() {
        return this.algorithm;
    }

    public int srid() {
        return this.srid;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    public boolean isMixedSrid() {
        return this.srid() == GeographyType$.MODULE$.MIXED_SRID();
    }

    @Override
    public String typeName() {
        if (this.isMixedSrid()) {
            return "geography(any)";
        }
        return "geography(" + this.srid() + ")";
    }

    public String toString() {
        if (this.isMixedSrid()) {
            return "GeographyType(ANY)";
        }
        return "GeographyType(" + this.srid() + ")";
    }

    @Override
    public JValue jsonValue() {
        return new JString("geography(" + this.crs() + ", " + this.algorithm() + ")");
    }

    @Override
    public GeographyType asNullable() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof GeographyType)) return false;
        GeographyType geographyType = (GeographyType)object;
        if (geographyType.srid() != this.srid()) return false;
        EdgeInterpolationAlgorithm edgeInterpolationAlgorithm = geographyType.algorithm();
        EdgeInterpolationAlgorithm edgeInterpolationAlgorithm2 = this.algorithm();
        if (edgeInterpolationAlgorithm != null) {
            if (!edgeInterpolationAlgorithm.equals(edgeInterpolationAlgorithm2)) return false;
            return true;
        }
        if (edgeInterpolationAlgorithm2 == null) return true;
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.srid());
    }

    @Override
    public boolean acceptsType(DataType other) {
        DataType dataType = other;
        if (dataType instanceof GeographyType) {
            GeographyType geographyType = (GeographyType)dataType;
            return this.acceptsGeographyType(geographyType);
        }
        return false;
    }

    public boolean acceptsGeographyType(GeographyType gt) {
        return this.isMixedSrid() || gt.srid() == this.srid();
    }

    public void assertSridAllowedForType(int otherSrid) {
        if (!this.isMixedSrid() && otherSrid != this.srid()) {
            throw new SparkRuntimeException("GEO_ENCODER_SRID_MISMATCH_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"GEOGRAPHY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueSrid"), (Object)Integer.toString(otherSrid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeSrid"), (Object)Integer.toString(this.srid()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isMixedSrid()) {
            if (!GeographyType$.MODULE$.isSridSupported(otherSrid)) {
                throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(otherSrid))})));
            }
            return;
        }
    }

    public GeographyType(String crs, EdgeInterpolationAlgorithm algorithm) {
        this.crs = crs;
        this.algorithm = algorithm;
        this.srid = GeographyType$.MODULE$.toSrid(crs);
    }
}

