/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    private static int poolNumber = 0;

    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.logging.Log", (String)"commons-logging.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.logicalcobwebs.proxool.ProxoolDriver", (String)"proxool.jar");
        String alias = "datanucleus" + poolNumber;
        String poolURL = null;
        try {
            Properties dbProps = ProxoolConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxConnections")) {
                int value = storeMgr.getIntProperty("datanucleus.connectionPool.maxConnections");
                if (value > 0) {
                    dbProps.put("proxool.maximum-connection-count", "" + value);
                } else {
                    dbProps.put("proxool.maximum-connection-count", "10");
                }
            } else {
                dbProps.put("proxool.maximum-connection-count", "10");
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                String value = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
                dbProps.put("proxool.house-keeping-test-sql", value);
            } else {
                dbProps.put("proxool.house-keeping-test-sql", "SELECT 1");
            }
            poolURL = "proxool." + alias + ":" + dbDriver + ":" + dbURL;
            ++poolNumber;
            ProxoolFacade.registerConnectionPool((String)poolURL, (Properties)dbProps);
        }
        catch (ProxoolException pe) {
            pe.printStackTrace();
            throw new DatastorePoolException("Proxool", dbDriver, dbURL, (Exception)((Object)pe));
        }
        ProxoolDataSource ds = new ProxoolDataSource(alias);
        return new ProxoolConnectionPool(ds, poolURL);
    }

    public class ProxoolConnectionPool
    implements ConnectionPool {
        final String poolURL;
        final ProxoolDataSource dataSource;

        public ProxoolConnectionPool(ProxoolDataSource ds, String poolURL) {
            this.dataSource = ds;
            this.poolURL = poolURL;
        }

        @Override
        public void close() {
            try {
                ProxoolFacade.removeConnectionPool((String)this.poolURL);
            }
            catch (ProxoolException proxoolException) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

