/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResultBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResultFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.StructuredResourceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StructuredResourceHandleFluent<A extends StructuredResourceHandleFluent<A>>
extends BaseFluent<A> {
    private String nodeName;
    private ArrayList<DriverAllocationResultBuilder> results = new ArrayList();
    private Object vendorClaimParameters;
    private Object vendorClassParameters;
    private Map<String, Object> additionalProperties;

    public StructuredResourceHandleFluent() {
    }

    public StructuredResourceHandleFluent(StructuredResourceHandle instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StructuredResourceHandle instance) {
        StructuredResourceHandle structuredResourceHandle = instance = instance != null ? instance : new StructuredResourceHandle();
        if (instance != null) {
            this.withNodeName(instance.getNodeName());
            this.withResults(instance.getResults());
            this.withVendorClaimParameters(instance.getVendorClaimParameters());
            this.withVendorClassParameters(instance.getVendorClassParameters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToResults(int index, DriverAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResults(int index, DriverAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(DriverAllocationResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (DriverAllocationResult item : items) {
            DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<DriverAllocationResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (DriverAllocationResult item : items) {
            DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(DriverAllocationResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (DriverAllocationResult item : items) {
            DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<DriverAllocationResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (DriverAllocationResult item : items) {
            DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<DriverAllocationResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<DriverAllocationResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            DriverAllocationResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DriverAllocationResult> buildResults() {
        return this.results != null ? StructuredResourceHandleFluent.build(this.results) : null;
    }

    public DriverAllocationResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public DriverAllocationResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public DriverAllocationResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public DriverAllocationResult buildMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
        for (DriverAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
        for (DriverAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResults(List<DriverAllocationResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (DriverAllocationResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(DriverAllocationResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (DriverAllocationResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(DriverAllocationResult item) {
        return new ResultsNested(-1, item);
    }

    public ResultsNested<A> setNewResultLike(int index, DriverAllocationResult item) {
        return new ResultsNested(index, item);
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public Object getVendorClaimParameters() {
        return this.vendorClaimParameters;
    }

    public A withVendorClaimParameters(Object vendorClaimParameters) {
        this.vendorClaimParameters = vendorClaimParameters;
        return (A)((Object)this);
    }

    public boolean hasVendorClaimParameters() {
        return this.vendorClaimParameters != null;
    }

    public Object getVendorClassParameters() {
        return this.vendorClassParameters;
    }

    public A withVendorClassParameters(Object vendorClassParameters) {
        this.vendorClassParameters = vendorClassParameters;
        return (A)((Object)this);
    }

    public boolean hasVendorClassParameters() {
        return this.vendorClassParameters != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructuredResourceHandleFluent that = (StructuredResourceHandleFluent)((Object)o);
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.vendorClaimParameters, that.vendorClaimParameters)) {
            return false;
        }
        if (!Objects.equals(this.vendorClassParameters, that.vendorClassParameters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.results, this.vendorClaimParameters, this.vendorClassParameters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(String.valueOf(this.results) + ",");
        }
        if (this.vendorClaimParameters != null) {
            sb.append("vendorClaimParameters:");
            sb.append(String.valueOf(this.vendorClaimParameters) + ",");
        }
        if (this.vendorClassParameters != null) {
            sb.append("vendorClassParameters:");
            sb.append(String.valueOf(this.vendorClassParameters) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResultsNested<N>
    extends DriverAllocationResultFluent<ResultsNested<N>>
    implements Nested<N> {
        DriverAllocationResultBuilder builder;
        int index;

        ResultsNested(int index, DriverAllocationResult item) {
            this.index = index;
            this.builder = new DriverAllocationResultBuilder(this, item);
        }

        public N and() {
            return (N)StructuredResourceHandleFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }
}

