/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.curator4.org.apache.curator.framework.imps;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.flink.shaded.curator4.org.apache.curator.RetryLoop;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.OperationType;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.TransactionCheckBuilder;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.transaction.TypeAndPath;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.imps.DeleteBuilderImpl;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.imps.SetDataBuilderImpl;
import org.apache.flink.shaded.curator4.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.curator4.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.Op;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.OpResult;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;

class CuratorTransactionImpl
implements CuratorTransaction,
CuratorTransactionBridge,
CuratorTransactionFinal {
    private final CuratorFrameworkImpl client;
    private final CuratorMultiTransactionRecord transaction;
    private boolean isCommitted = false;

    CuratorTransactionImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.transaction = new CuratorMultiTransactionRecord();
    }

    @Override
    public CuratorTransactionFinal and() {
        return this;
    }

    @Override
    public TransactionCreateBuilder<CuratorTransactionBridge> create() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        CuratorTransactionImpl asBridge = this;
        return new CreateBuilderImpl(this.client).asTransactionCreateBuilder(asBridge, this.transaction);
    }

    @Override
    public TransactionDeleteBuilder<CuratorTransactionBridge> delete() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        CuratorTransactionImpl asBridge = this;
        return new DeleteBuilderImpl(this.client).asTransactionDeleteBuilder(asBridge, this.transaction);
    }

    @Override
    public TransactionSetDataBuilder<CuratorTransactionBridge> setData() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        CuratorTransactionImpl asBridge = this;
        return new SetDataBuilderImpl(this.client).asTransactionSetDataBuilder(asBridge, this.transaction);
    }

    @Override
    public TransactionCheckBuilder<CuratorTransactionBridge> check() {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        CuratorTransactionImpl asBridge = this;
        return CuratorTransactionImpl.makeTransactionCheckBuilder(this.client, asBridge, this.transaction);
    }

    static <T> TransactionCheckBuilder<T> makeTransactionCheckBuilder(final CuratorFrameworkImpl client, final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionCheckBuilder<T>(){
            private int version = -1;

            @Override
            public T forPath(String path) throws Exception {
                String fixedPath = client.fixForNamespace(path);
                transaction.add(Op.check(fixedPath, this.version), OperationType.CHECK, path);
                return context;
            }

            @Override
            public Pathable<T> withVersion(int version) {
                this.version = version;
                return this;
            }
        };
    }

    @Override
    public Collection<CuratorTransactionResult> commit() throws Exception {
        Preconditions.checkState(!this.isCommitted, "transaction already committed");
        this.isCommitted = true;
        List<OpResult> resultList = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return CuratorTransactionImpl.this.doOperation();
            }
        });
        if (resultList.size() != this.transaction.metadataSize()) {
            throw new IllegalStateException(String.format("Result size (%d) doesn't match input size (%d)", resultList.size(), this.transaction.metadataSize()));
        }
        return CuratorTransactionImpl.wrapResults(this.client, resultList, this.transaction);
    }

    static List<CuratorTransactionResult> wrapResults(CuratorFrameworkImpl client, List<OpResult> resultList, CuratorMultiTransactionRecord transaction) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < resultList.size(); ++i) {
            OpResult opResult = resultList.get(i);
            TypeAndPath metadata = transaction.getMetadata(i);
            CuratorTransactionResult curatorResult = CuratorTransactionImpl.makeCuratorResult(client, opResult, metadata);
            builder.add(curatorResult);
        }
        return builder.build();
    }

    static CuratorTransactionResult makeCuratorResult(CuratorFrameworkImpl client, OpResult opResult, TypeAndPath metadata) {
        String resultPath = null;
        Stat resultStat = null;
        int error = 0;
        switch (opResult.getType()) {
            default: {
                break;
            }
            case 1: {
                OpResult.CreateResult createResult = (OpResult.CreateResult)opResult;
                resultPath = client.unfixForNamespace(createResult.getPath());
                break;
            }
            case 5: {
                OpResult.SetDataResult setDataResult = (OpResult.SetDataResult)opResult;
                resultStat = setDataResult.getStat();
                break;
            }
            case -1: {
                OpResult.ErrorResult errorResult = (OpResult.ErrorResult)opResult;
                error = errorResult.getErr();
                break;
            }
        }
        return new CuratorTransactionResult(metadata.getType(), metadata.getForPath(), resultPath, resultStat, error);
    }

    private List<OpResult> doOperation() throws Exception {
        OpResult firstResult;
        List<OpResult> opResults = this.client.getZooKeeper().multi(this.transaction);
        if (opResults.size() > 0 && (firstResult = opResults.get(0)).getType() == -1) {
            OpResult.ErrorResult error = (OpResult.ErrorResult)firstResult;
            KeeperException.Code code = KeeperException.Code.get(error.getErr());
            if (code == null) {
                code = KeeperException.Code.UNIMPLEMENTED;
            }
            throw KeeperException.create(code);
        }
        return opResults;
    }
}

