/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.IngressMeta;
import org.apache.streampark.flink.kubernetes.IngressMeta$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class IngressController$
implements org.apache.streampark.common.util.Logger {
    public static IngressController$ MODULE$;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new IngressController$();
    }

    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public void configureIngress(String domainName, String clusterId, String nameSpace) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DefaultKubernetesClient());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DefaultKubernetesClient client = (DefaultKubernetesClient)success.value();
            scala.collection.immutable.Map annotMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder(28).append("rewrite ^(/").append(clusterId).append(")$ $1/ permanent;").toString())}));
            scala.collection.immutable.Map labelsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
            io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressFluentImpl)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(clusterId).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)annotMap).asJava()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)labelsMap).asJava())).endMetadata()).withNewSpec().addNewRule().withHost(domainName).withNewHttp().addNewPath().withPath(new StringBuilder(3).append("/").append(nameSpace).append("/").append(clusterId).append("/").toString()).withNewBackend().withServiceName(new StringBuilder(5).append(clusterId).append("-rest").toString()).withServicePort(new IntOrString("rest"))).endBackend()).endPath()).addNewPath().withPath(new StringBuilder(11).append("/").append(nameSpace).append("/").append(clusterId).append("(/|$)(.*)").toString()).withNewBackend().withServiceName(new StringBuilder(5).append(clusterId).append("-rest").toString()).withServicePort(new IntOrString("rest"))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).build();
            ((InOutCreateable)client.network().ingress().inNamespace(nameSpace)).create((Object)ingress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureIngress(String ingressOutput) {
        void var3_2;
        DefaultKubernetesClient[] defaultKubernetesClientArray = new DefaultKubernetesClient[1];
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        ((Gettable)client.network().ingress().load(Files.newInputStream(Paths.get(ingressOutput, new String[0]), new OpenOption[0]))).get();
        defaultKubernetesClientArray[0] = var3_2;
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])defaultKubernetesClientArray));
        Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
        Utils$.MODULE$.close(x$1, x$2);
    }

    public void deleteIngress(String ingressName, String nameSpace) {
        block0: {
            if (!this.determineThePodSurvivalStatus(ingressName, nameSpace)) break block0;
            DefaultKubernetesClient[] defaultKubernetesClientArray = new DefaultKubernetesClient[1];
            DefaultKubernetesClient client = new DefaultKubernetesClient();
            ((Deletable)((Nameable)client.network().ingress().inNamespace(nameSpace)).withName(ingressName)).delete();
            defaultKubernetesClientArray[0] = client;
            Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])defaultKubernetesClientArray));
            Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
            Utils$.MODULE$.close(x$1, x$2);
        }
    }

    private boolean determineThePodSurvivalStatus(String name, String nameSpace) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToBoolean((boolean)IngressController$.$anonfun$determineThePodSurvivalStatus$1(nameSpace, name, client));
        Null$ x$3 = Utils$.MODULE$.tryWithResource$default$3((AutoCloseable)x$1, (Function1)x$2);
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((AutoCloseable)x$1, (Function1)x$2, null));
    }

    public String ingressUrlAddress(String nameSpace, String clusterId, ClusterClient<?> clusterClient) {
        String string;
        if (this.determineIfIngressExists(nameSpace, clusterId)) {
            DefaultKubernetesClient client = new DefaultKubernetesClient();
            io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress = (io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress)((Gettable)((Nameable)client.network().ingress().inNamespace(nameSpace)).withName(clusterId)).get();
            String publicEndpoints = (String)ingress.getMetadata().getAnnotations().get("field.cattle.io/publicEndpoints");
            Option<List<IngressMeta>> option = IngressMeta$.MODULE$.as(publicEndpoints);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException("[StreamPark] get ingressUrlAddress error.");
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            List metas = (List)some.value();
            IngressMeta ingressMeta = (IngressMeta)metas.head();
            String hostname = ingressMeta.hostname();
            String path = ingressMeta.path();
            this.logger().info(new StringBuilder(72).append("Retrieve flink cluster ").append(clusterId).append(" successfully, JobManager Web Interface: https://").append(hostname).append(path).toString());
            String string2 = new StringBuilder(8).append("https://").append(hostname).append(path).toString();
            string = string2;
        } else {
            string = clusterClient.getWebInterfaceURL();
        }
        return string;
    }

    public boolean determineIfIngressExists(String nameSpace, String clusterId) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToBoolean((boolean)IngressController$.$anonfun$determineIfIngressExists$1(nameSpace, clusterId, client));
        Null$ x$3 = Utils$.MODULE$.tryWithResource$default$3((AutoCloseable)x$1, (Function1)x$2);
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((AutoCloseable)x$1, (Function1)x$2, null));
    }

    public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) throws IOException {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = !workspaceDir.exists() ? BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir()) : BoxedUnit.UNIT;
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder(13).append(buildWorkspace).append("/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$determineThePodSurvivalStatus$1(String nameSpace$1, String name$1, KubernetesClient client) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ((Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace$1)).withName(name$1)).get()).getSpec().getSelector().getMatchLabels();
            return false;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public static final /* synthetic */ boolean $anonfun$determineIfIngressExists$1(String nameSpace$2, String clusterId$1, KubernetesClient client) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ((Ingress)((Gettable)((Nameable)client.extensions().ingresses().inNamespace(nameSpace$2)).withName(clusterId$1)).get()).getMetadata().getName();
            return true;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private IngressController$() {
        MODULE$ = this;
        org.apache.streampark.common.util.Logger.$init$((org.apache.streampark.common.util.Logger)this);
    }
}

