/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.DateUtils$;
import org.apache.streampark.common.util.FileUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.PropertiesUtils$;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HadoopUtils$
implements Logger {
    public static HadoopUtils$ MODULE$;
    private String HADOOP_HOME;
    private String HADOOP_CONF_DIR;
    private String CONF_SUFFIX;
    private String hadoopUserName;
    private String debugKerberos;
    private Map<String, Configuration> configurationCache;
    private scala.collection.immutable.Map<String, String> kerberosConf;
    private String hadoopConfDir;
    private long tgtRefreshTime;
    private YarnClient reusableYarnClient;
    private UserGroupInformation ugi;
    private Configuration reusableConf;
    private FileSystem reusableHdfs;
    private KerberosTicket tgt;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile int bitmap$0;

    static {
        new HadoopUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private String HADOOP_HOME$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.HADOOP_HOME = "HADOOP_HOME";
                this.bitmap$0 |= 1;
            }
        }
        return this.HADOOP_HOME;
    }

    private String HADOOP_HOME() {
        return (this.bitmap$0 & 1) == 0 ? this.HADOOP_HOME$lzycompute() : this.HADOOP_HOME;
    }

    private String HADOOP_CONF_DIR$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
                this.bitmap$0 |= 2;
            }
        }
        return this.HADOOP_CONF_DIR;
    }

    private String HADOOP_CONF_DIR() {
        return (this.bitmap$0 & 2) == 0 ? this.HADOOP_CONF_DIR$lzycompute() : this.HADOOP_CONF_DIR;
    }

    private String CONF_SUFFIX$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.CONF_SUFFIX = "/etc/hadoop";
                this.bitmap$0 |= 4;
            }
        }
        return this.CONF_SUFFIX;
    }

    private String CONF_SUFFIX() {
        return (this.bitmap$0 & 4) == 0 ? this.CONF_SUFFIX$lzycompute() : this.CONF_SUFFIX;
    }

    private String hadoopUserName$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.hadoopUserName = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_HADOOP_USER_NAME());
                this.bitmap$0 |= 8;
            }
        }
        return this.hadoopUserName;
    }

    private String hadoopUserName() {
        return (this.bitmap$0 & 8) == 0 ? this.hadoopUserName$lzycompute() : this.hadoopUserName;
    }

    private String debugKerberos$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.debugKerberos = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_DEBUG(), (Function0 & Serializable & scala.Serializable)() -> "false");
                this.bitmap$0 |= 0x10;
            }
        }
        return this.debugKerberos;
    }

    private String debugKerberos() {
        return (this.bitmap$0 & 0x10) == 0 ? this.debugKerberos$lzycompute() : this.debugKerberos;
    }

    private Map<String, Configuration> configurationCache$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.configurationCache = new ConcurrentHashMap<String, Configuration>();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.configurationCache;
    }

    private Map<String, Configuration> configurationCache() {
        return (this.bitmap$0 & 0x20) == 0 ? this.configurationCache$lzycompute() : this.configurationCache;
    }

    private scala.collection.immutable.Map<String, String> kerberosConf$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                scala.collection.immutable.Map<String, String> map;
                String string = SystemPropertyUtils$.MODULE$.get(ConfigConst$.MODULE$.KEY_APP_HOME(), null);
                if (string == null) {
                    InputStream inputStream = this.getClass().getResourceAsStream("/kerberos.yml");
                    scala.collection.immutable.Map<String, String> map2 = inputStream != null ? PropertiesUtils$.MODULE$.fromYamlFile(inputStream) : null;
                    map = map2;
                } else {
                    File file = new File(new StringBuilder(18).append(string).append("/conf/kerberos.yml").toString());
                    map = file.exists() && file.isFile() ? PropertiesUtils$.MODULE$.fromYamlFile(file.getAbsolutePath()) : null;
                }
                this.kerberosConf = map;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.kerberosConf;
    }

    private scala.collection.immutable.Map<String, String> kerberosConf() {
        return (this.bitmap$0 & 0x40) == 0 ? this.kerberosConf$lzycompute() : this.kerberosConf;
    }

    public UserGroupInformation getUgi() {
        block0: {
            if (this.ugi != null) break block0;
            String enableString = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_ENABLE(), (Function0 & Serializable & scala.Serializable)() -> "false");
            boolean kerberosEnable = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(enableString.trim())).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            this.ugi = kerberosEnable ? this.kerberosLogin() : UserGroupInformation.createRemoteUser((String)this.hadoopUserName());
        }
        return this.ugi;
    }

    private String hadoopConfDir$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                String string;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileUtils$.MODULE$.getPathFromEnv(MODULE$.HADOOP_CONF_DIR()));
                if (try_ instanceof Failure) {
                    string = FileUtils$.MODULE$.resolvePath(FileUtils$.MODULE$.getPathFromEnv(this.HADOOP_HOME()), this.CONF_SUFFIX());
                } else if (try_ instanceof Success) {
                    String value;
                    Success success = (Success)try_;
                    string = value = (String)success.value();
                } else {
                    throw new MatchError((Object)try_);
                }
                this.hadoopConfDir = string;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.hadoopConfDir;
    }

    private String hadoopConfDir() {
        return (this.bitmap$0 & 0x80) == 0 ? this.hadoopConfDir$lzycompute() : this.hadoopConfDir;
    }

    private long tgtRefreshTime$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                long l;
                UserGroupInformation user = UserGroupInformation.getLoginUser();
                Method method = UserGroupInformation.class.getDeclaredMethod("getTGT", new Class[0]);
                method.setAccessible(true);
                this.tgt = (KerberosTicket)method.invoke((Object)user, new Object[0]);
                Option option = Option$.MODULE$.apply((Object)this.tgt);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    KerberosTicket value = (KerberosTicket)some.value();
                    long start = value.getStartTime().getTime();
                    long end = value.getEndTime().getTime();
                    l = (long)((double)(end - start) * (double)0.9f);
                } else {
                    long l2;
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "get kerberos tgtRefreshTime failed, try get kerberos.ttl. ");
                    Tuple2<Object, TimeUnit> timeUnit = DateUtils$.MODULE$.getTimeUnit((String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.KERBEROS_TTL()), DateUtils$.MODULE$.getTimeUnit$default$2());
                    TimeUnit timeUnit2 = (TimeUnit)((Object)timeUnit._2());
                    if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 1000;
                    } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 60 * 1000;
                    } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 60 * 60 * 1000;
                    } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 60 * 60 * 24 * 1000;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(61).append("[StreamPark] parameter:").append(CommonConfig$.MODULE$.KERBEROS_TTL().key()).append(" invalided, unit options are [s|m|h|d]").toString());
                    }
                    l = l2;
                }
                this.tgtRefreshTime = l;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.tgtRefreshTime;
    }

    private long tgtRefreshTime() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tgtRefreshTime$lzycompute() : this.tgtRefreshTime;
    }

    public Configuration getConfigurationFromHadoopConfDir(String confDir) {
        BoxedUnit boxedUnit;
        if (!this.configurationCache().containsKey(confDir)) {
            FileUtils$.MODULE$.exists(confDir);
            File hadoopConfDir = new File(confDir);
            .colon.colon confName = new .colon.colon((Object)"hdfs-default.xml", (List)new .colon.colon((Object)"core-site.xml", (List)new .colon.colon((Object)"hdfs-site.xml", (List)new .colon.colon((Object)"yarn-site.xml", (List)Nil$.MODULE$))));
            List files = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopConfDir.listFiles())).filter(arg_0 -> HadoopUtils$.$anonfun$getConfigurationFromHadoopConfDir$1$adapted((List)confName, arg_0)))).toList();
            Configuration conf = new Configuration();
            if (CollectionUtils.isNotEmpty((Collection)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)files))) {
                files.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    conf.addResource(new Path(x.getAbsolutePath()));
                    return BoxedUnit.UNIT;
                });
                List rewriteNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dfs.blockreport.initialDelay", "dfs.datanode.directoryscan.interval", "dfs.heartbeat.interval", "dfs.namenode.decommission.interval", "dfs.namenode.replication.interval", "dfs.namenode.checkpoint.period", "dfs.namenode.checkpoint.check.period", "dfs.client.datanode-restart.timeout", "dfs.ha.log-roll.period", "dfs.ha.tail-edits.period", "dfs.datanode.bp-ready.timeout"}));
                rewriteNames.foreach((Function1 & Serializable & scala.Serializable)n -> {
                    HadoopUtils$.$anonfun$getConfigurationFromHadoopConfDir$3(conf, n);
                    return BoxedUnit.UNIT;
                });
            }
            boxedUnit = this.configurationCache().put(confDir, conf);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Configuration)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(this.configurationCache()).apply((Object)confDir);
    }

    public String getConfigurationFromHadoopConfDir$default$1() {
        return this.hadoopConfDir();
    }

    public Configuration hadoopConf() {
        return (Configuration)Option$.MODULE$.apply((Object)this.reusableConf).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            HadoopUtils$.MODULE$.reusableConf = MODULE$.getConfigurationFromHadoopConfDir(MODULE$.hadoopConfDir());
            ClassLoaderUtils$.MODULE$.loadResource(MODULE$.hadoopConfDir());
            if (StringUtils.isBlank((CharSequence)HadoopUtils$.MODULE$.reusableConf.get("hadoop.tmp.dir"))) {
                HadoopUtils$.MODULE$.reusableConf.set("hadoop.tmp.dir", "/tmp");
            }
            if (StringUtils.isBlank((CharSequence)HadoopUtils$.MODULE$.reusableConf.get("hbase.fs.tmp.dir"))) {
                HadoopUtils$.MODULE$.reusableConf.set("hbase.fs.tmp.dir", "/tmp");
            }
            HadoopUtils$.MODULE$.reusableConf.set("yarn.timeline-service.enabled", "false");
            HadoopUtils$.MODULE$.reusableConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            HadoopUtils$.MODULE$.reusableConf.set("fs.file.impl", LocalFileSystem.class.getName());
            HadoopUtils$.MODULE$.reusableConf.set("fs.hdfs.impl.disable.cache", "true");
            return HadoopUtils$.MODULE$.reusableConf;
        });
    }

    public void org$apache$streampark$common$util$HadoopUtils$$closeHadoop() {
        if (this.reusableHdfs != null) {
            this.reusableHdfs.close();
            this.reusableHdfs = null;
        }
        if (this.reusableYarnClient != null) {
            this.reusableYarnClient.close();
            this.reusableYarnClient = null;
        }
        if (this.tgt != null && !this.tgt.isDestroyed()) {
            this.tgt.destroy();
            this.tgt = null;
        }
        this.reusableConf = null;
        this.ugi = null;
    }

    private UserGroupInformation kerberosLogin() {
        UserGroupInformation ugi;
        Object object;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "kerberos login starting....");
        String principal = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_PRINCIPAL(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
        String keytab = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KEYTAB(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(keytab)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append(ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_PRINCIPAL()).append(" and ").append(ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KEYTAB()).append(" must not be empty").toString());
        String krb5 = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KRB5_CONF(), (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_JAVA_SECURITY_KRB5_CONF(), (Function0 & Serializable & scala.Serializable)() -> ""))).trim();
        if (new StringOps(Predef$.MODULE$.augmentString(krb5)).nonEmpty()) {
            System.setProperty("java.security.krb5.conf", krb5);
            object = System.setProperty("java.security.krb5.conf.path", krb5);
        } else {
            object = BoxedUnit.UNIT;
        }
        System.setProperty("sun.security.spnego.debug", this.debugKerberos());
        System.setProperty("sun.security.krb5.debug", this.debugKerberos());
        this.hadoopConf().set(ConfigConst$.MODULE$.KEY_HADOOP_SECURITY_AUTHENTICATION(), ConfigConst$.MODULE$.KEY_KERBEROS());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            UserGroupInformation.setConfiguration((Configuration)MODULE$.hadoopConf());
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
            UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "kerberos authentication successful");
            return var2_2;
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        UserGroupInformation userGroupInformation = ugi = (UserGroupInformation)success.value();
        return userGroupInformation;
    }

    public FileSystem hdfs() {
        return (FileSystem)Option$.MODULE$.apply((Object)this.reusableHdfs).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            FileSystem fs;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (FileSystem)MODULE$.getUgi().doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                public FileSystem run() {
                    return FileSystem.get((Configuration)HadoopUtils$.MODULE$.hadoopConf());
                }
            }));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                fs = (FileSystem)success.value();
                String enableString = (String)MODULE$.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_ENABLE(), (Function0 & Serializable & scala.Serializable)() -> "false");
                boolean kerberosEnable = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(enableString.trim())).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                if (kerberosEnable) {
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        public void run() {
                            HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$closeHadoop();
                            HadoopUtils$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Check Kerberos Tgt And reLogin From Keytab Finish:refresh time: ").append(DateUtils$.MODULE$.format(DateUtils$.MODULE$.format$default$1(), DateUtils$.MODULE$.format$default$2(), DateUtils$.MODULE$.format$default$3())).toString());
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
                        }
                    }, MODULE$.tgtRefreshTime(), MODULE$.tgtRefreshTime());
                }
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new IllegalArgumentException(new StringBuilder(32).append("[StreamPark] access hdfs error: ").append(e).toString());
                }
                throw new MatchError((Object)try_);
            }
            FileSystem fileSystem = fs;
            HadoopUtils$.MODULE$.reusableHdfs = fileSystem;
            return HadoopUtils$.MODULE$.reusableHdfs;
        });
    }

    public YarnClient yarnClient() {
        block0: {
            if (this.reusableYarnClient != null && this.reusableYarnClient.isInState(Service.STATE.STARTED)) break block0;
            this.reusableYarnClient = YarnClient.createYarnClient();
            YarnConfiguration yarnConf = new YarnConfiguration(this.hadoopConf());
            this.reusableYarnClient.init((Configuration)yarnConf);
            this.reusableYarnClient.start();
        }
        return this.reusableYarnClient;
    }

    public ApplicationId toApplicationId(String appId) {
        Predef$.MODULE$.require(appId != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] HadoopUtils.toApplicationId: applicationId muse not be null");
        String[] timestampAndId = appId.split("_");
        return ApplicationId.newInstance((long)new StringOps(Predef$.MODULE$.augmentString(timestampAndId[1])).toLong(), (int)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timestampAndId)).last())).toInt());
    }

    public String downloadJar(String jarOnHdfs) throws IOException {
        Path sourcePath;
        File tmpDir = FileUtils$.MODULE$.createTempDir();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        if (!fs.exists(sourcePath = fs.makeQualified(new Path(jarOnHdfs)))) {
            throw new IOException(new StringBuilder(25).append("jar file: ").append(jarOnHdfs).append(" doesn't exist.").toString());
        }
        Path destPath = new Path(new StringBuilder(1).append(tmpDir.getAbsolutePath()).append("/").append(sourcePath.getName()).toString());
        fs.copyToLocalFile(sourcePath, destPath);
        return new File(destPath.toString()).getAbsolutePath();
    }

    public static final /* synthetic */ boolean $anonfun$getConfigurationFromHadoopConfDir$1(List confName$1, File x) {
        return x.isFile() && confName$1.contains((Object)x.getName());
    }

    public static final /* synthetic */ void $anonfun$getConfigurationFromHadoopConfDir$3(Configuration conf$1, String n) {
        Some some;
        String v;
        Option option = Option$.MODULE$.apply((Object)conf$1.get(n));
        if (option instanceof Some && (v = (String)(some = (Some)option).value()).matches("\\d+s$")) {
            conf$1.set(n, (String)new StringOps(Predef$.MODULE$.augmentString(v)).dropRight(1));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private HadoopUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$getConfigurationFromHadoopConfDir$1$adapted(List confName$1, File x) {
        return BoxesRunTime.boxToBoolean((boolean)HadoopUtils$.$anonfun$getConfigurationFromHadoopConfDir$1(confName$1, x));
    }
}

