/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.console.core.service.SqlCompleteService;
import org.apache.streampark.console.core.service.VariableService;
import org.apache.streampark.flink.core.FlinkSqlValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"[flink sql] related operations"}, consumes="Content-Type=application/x-www-form-urlencoded")
@Validated
@RestController
@RequestMapping(value={"flink/sql"})
public class FlinkSqlController {
    private static final Logger log = LoggerFactory.getLogger(FlinkSqlController.class);
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private SqlCompleteService sqlComplete;

    @PostMapping(value={"verify"})
    public RestResponse verify(String sql, Long versionId, Long teamId) {
        FlinkSqlValidationResult flinkSqlValidationResult = this.flinkSqlService.verifySql(sql = this.variableService.replaceVariable(teamId, sql), versionId);
        if (!flinkSqlValidationResult.success().booleanValue()) {
            String exception = flinkSqlValidationResult.exception();
            RestResponse response = RestResponse.success().data(false).message(exception).put("type", (Object)flinkSqlValidationResult.failedType().getValue()).put("start", (Object)flinkSqlValidationResult.lineStart()).put("end", (Object)flinkSqlValidationResult.lineEnd());
            if (flinkSqlValidationResult.errorLine() > 0) {
                response.put("start", (Object)flinkSqlValidationResult.errorLine()).put("end", (Object)(flinkSqlValidationResult.errorLine() + 1));
            }
            return response;
        }
        return RestResponse.success(true);
    }

    @PostMapping(value={"get"})
    public RestResponse get(String id) throws InternalException {
        String[] array = id.split(",");
        FlinkSql flinkSql1 = (FlinkSql)this.flinkSqlService.getById((Serializable)((Object)array[0]));
        flinkSql1.base64Encode();
        if (array.length == 1) {
            return RestResponse.success(flinkSql1);
        }
        FlinkSql flinkSql2 = (FlinkSql)this.flinkSqlService.getById((Serializable)((Object)array[1]));
        flinkSql2.base64Encode();
        return RestResponse.success(new FlinkSql[]{flinkSql1, flinkSql2});
    }

    @PostMapping(value={"history"})
    public RestResponse sqlhistory(Application application) {
        List<FlinkSql> sqlList = this.flinkSqlService.history(application);
        return RestResponse.success(sqlList);
    }

    @PostMapping(value={"sqlComplete"})
    public RestResponse getSqlComplete(@NotNull(message="{required}") @NotNull(message="{required}") String sql) {
        return RestResponse.success().put("word", (Object)this.sqlComplete.getComplete(sql));
    }
}

