/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.HttpClientUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.enums.LaunchState;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.enums.StopFrom;
import org.apache.streampark.console.core.metrics.flink.CheckPoints;
import org.apache.streampark.console.core.metrics.flink.JobsOverview;
import org.apache.streampark.console.core.metrics.flink.Overview;
import org.apache.streampark.console.core.metrics.yarn.YarnAppInfo;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.SavePointService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.apache.streampark.console.core.task.CheckpointProcessor;
import org.apache.streampark.console.core.task.FlinkK8sWatcherWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FlinkRESTAPIWatcher {
    private static final Logger log = LoggerFactory.getLogger(FlinkRESTAPIWatcher.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private CheckpointProcessor checkpointProcessor;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private SavePointService savePointService;
    private static final long WATCHING_INTERVAL = 5000L;
    private static final long OPTION_INTERVAL = 10000L;
    private static final Cache<Long, Byte> SAVEPOINT_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Cache<Long, Byte> STARTING_CACHE = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Map<Long, Application> WATCHING_APPS = new ConcurrentHashMap<Long, Application>(0);
    private static final Map<Long, StopFrom> STOP_FROM_MAP = new ConcurrentHashMap<Long, StopFrom>(0);
    private static final Cache<Long, Byte> CANCELING_CACHE = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Map<Long, Long> CANCELLED_JOB_MAP = new ConcurrentHashMap<Long, Long>(0);
    private static final Map<Long, FlinkCluster> FLINK_CLUSTER_MAP = new ConcurrentHashMap<Long, FlinkCluster>(0);
    private static final Map<Long, OptionState> OPTIONING = new ConcurrentHashMap<Long, OptionState>(0);
    private Long lastWatchingTime = 0L;
    private Long lastOptionTime = 0L;
    private static final Byte DEFAULT_FLAG_BYTE = Byte.valueOf("0");
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 5, Runtime.getRuntime().availableProcessors() * 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), ThreadUtils.threadFactory((String)"flink-restapi-watching-executor"));

    @PostConstruct
    public void init() {
        WATCHING_APPS.clear();
        List applications = this.applicationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Application::getTracking, (Object)1)).notIn(Application::getExecutionMode, (Collection)ExecutionMode.getKubernetesMode()));
        applications.forEach(app -> WATCHING_APPS.put(app.getId(), (Application)app));
    }

    @PreDestroy
    public void doStop() {
        log.info("FlinkRESTAPIWatcher StreamPark Console will be shutdown,persistent application to database.");
        WATCHING_APPS.forEach((k, v) -> this.applicationService.persistMetrics((Application)v));
    }

    @Scheduled(fixedDelay=1000L)
    public void start() {
        if (this.lastWatchingTime == null || !OPTIONING.isEmpty()) {
            this.doWatch();
        } else if (System.currentTimeMillis() - this.lastOptionTime <= 10000L) {
            this.doWatch();
        } else if (System.currentTimeMillis() - this.lastWatchingTime >= 5000L) {
            this.doWatch();
        }
    }

    private void doWatch() {
        this.lastWatchingTime = System.currentTimeMillis();
        for (Map.Entry<Long, Application> entry : WATCHING_APPS.entrySet()) {
            EXECUTOR.execute(() -> {
                block9: {
                    long key = (Long)entry.getKey();
                    Application application = (Application)entry.getValue();
                    StopFrom stopFrom = STOP_FROM_MAP.getOrDefault(key, null) == null ? StopFrom.NONE : STOP_FROM_MAP.get(key);
                    OptionState optionState = OPTIONING.get(key);
                    try {
                        Utils.required((application.getId() != null ? 1 : 0) != 0);
                        this.getFromFlinkRestApi(application, stopFrom);
                    }
                    catch (Exception flinkException) {
                        try {
                            this.getFromYarnRestApi(application, stopFrom);
                        }
                        catch (Exception yarnException) {
                            if (optionState != null && optionState.equals(OptionState.STARTING)) break block9;
                            if (application.getState().intValue() != FlinkAppState.MAPPING.getValue()) {
                                log.error("FlinkRESTAPIWatcher getFromFlinkRestApi and getFromYarnRestApi error,job failed,savePoint expired!");
                                if (StopFrom.NONE.equals(stopFrom)) {
                                    this.savePointService.expire(application.getId());
                                    application.setState(FlinkAppState.LOST.getValue());
                                    this.alertService.alert(application, FlinkAppState.LOST);
                                } else {
                                    application.setState(FlinkAppState.CANCELED.getValue());
                                }
                            }
                            application.setEndTime(new Date());
                            this.cleanSavepoint(application);
                            this.cleanOptioning(optionState, key);
                            this.doPersistMetrics(application, true);
                            FlinkAppState appState = FlinkAppState.of(application.getState());
                            if (!appState.equals(FlinkAppState.FAILED) && !appState.equals(FlinkAppState.LOST)) break block9;
                            this.alertService.alert(application, FlinkAppState.of(application.getState()));
                            if (!appState.equals(FlinkAppState.FAILED)) break block9;
                            try {
                                this.applicationService.start(application, true);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    private void getFromFlinkRestApi(Application application, StopFrom stopFrom) throws Exception {
        JobsOverview.Job jobOverview;
        FlinkAppState currentState;
        FlinkCluster flinkCluster = this.getFlinkCluster(application);
        JobsOverview jobsOverview = this.httpJobsOverview(application, flinkCluster);
        ExecutionMode execMode = application.getExecutionModeEnum();
        Optional<Object> optional = ExecutionMode.YARN_APPLICATION.equals((Object)execMode) || ExecutionMode.YARN_PER_JOB.equals((Object)execMode) ? (jobsOverview.getJobs().size() > 1 ? jobsOverview.getJobs().stream().filter(a -> StringUtils.equals((CharSequence)application.getJobId(), (CharSequence)a.getId())).findFirst() : jobsOverview.getJobs().stream().findFirst()) : jobsOverview.getJobs().stream().filter(x -> x.getId().equals(application.getJobId())).findFirst();
        if (optional.isPresent() && !FlinkAppState.OTHER.equals(currentState = FlinkAppState.of((jobOverview = (JobsOverview.Job)optional.get()).getState()))) {
            try {
                this.handleJobOverview(application, jobOverview);
            }
            catch (Exception e) {
                log.error("get flink jobOverview error: {}", (Object)e.getMessage(), (Object)e);
            }
            try {
                this.handleCheckPoints(application);
            }
            catch (Exception e) {
                log.error("get flink jobOverview error: {}", (Object)e.getMessage(), (Object)e);
            }
            OptionState optionState = OPTIONING.get(application.getId());
            if (currentState.equals(FlinkAppState.RUNNING)) {
                this.handleRunningState(application, optionState, currentState);
            } else {
                this.handleNotRunState(application, optionState, currentState, stopFrom);
            }
        }
    }

    private void handleJobOverview(Application application, JobsOverview.Job jobOverview) throws IOException {
        long startTime = jobOverview.getStartTime();
        long endTime = jobOverview.getEndTime();
        if (application.getStartTime() == null || startTime != application.getStartTime().getTime()) {
            application.setStartTime(new Date(startTime));
        }
        if (endTime != -1L && (application.getEndTime() == null || endTime != application.getEndTime().getTime())) {
            application.setEndTime(new Date(endTime));
        }
        application.setJobId(jobOverview.getId());
        application.setDuration(jobOverview.getDuration());
        application.setTotalTask(jobOverview.getTasks().getTotal());
        application.setOverview(jobOverview.getTasks());
        if (STARTING_CACHE.getIfPresent((Object)application.getId()) != null) {
            FlinkCluster flinkCluster = this.getFlinkCluster(application);
            Overview override = this.httpOverview(application, flinkCluster);
            if (override != null && override.getSlotsTotal() > 0) {
                application.setTotalTM(override.getTaskmanagers());
                application.setTotalSlot(override.getSlotsTotal());
                application.setAvailableSlot(override.getSlotsAvailable());
            }
            STARTING_CACHE.invalidate((Object)application.getId());
        }
    }

    private void handleCheckPoints(Application application) throws Exception {
        FlinkCluster flinkCluster = this.getFlinkCluster(application);
        CheckPoints checkPoints = this.httpCheckpoints(application, flinkCluster);
        if (checkPoints != null) {
            this.checkpointProcessor.process(application.getId(), checkPoints);
        }
    }

    private void handleRunningState(Application application, OptionState optionState, FlinkAppState currentState) {
        if (OptionState.STARTING.equals(optionState)) {
            Application latestApp = WATCHING_APPS.get(application.getId());
            LaunchState launchState = latestApp.getLaunchState();
            switch (launchState) {
                case NEED_RESTART: 
                case NEED_ROLLBACK: {
                    LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(Application::getId, (Object)application.getId())).set(Application::getLaunch, (Object)LaunchState.DONE.get());
                    this.applicationService.update((Wrapper)updateWrapper);
                    break;
                }
            }
        }
        if (SAVEPOINT_CACHE.getIfPresent((Object)application.getId()) != null) {
            application.setOptionState(OptionState.SAVEPOINTING.getValue());
        } else {
            application.setOptionState(OptionState.NONE.getValue());
        }
        application.setState(currentState.getValue());
        this.doPersistMetrics(application, false);
        this.cleanOptioning(optionState, application.getId());
    }

    private void doPersistMetrics(Application application, boolean stopWatch) {
        if (FlinkAppState.isEndState(application.getState())) {
            application.setOverview(null);
            application.setTotalTM(null);
            application.setTotalSlot(null);
            application.setTotalTask(null);
            application.setAvailableSlot(null);
            application.setJmMemory(null);
            application.setTmMemory(null);
            FlinkRESTAPIWatcher.unWatching(application.getId());
        } else if (stopWatch) {
            FlinkRESTAPIWatcher.unWatching(application.getId());
        } else {
            WATCHING_APPS.put(application.getId(), application);
        }
        this.applicationService.persistMetrics(application);
    }

    private void handleNotRunState(Application application, OptionState optionState, FlinkAppState currentState, StopFrom stopFrom) throws Exception {
        switch (currentState) {
            case CANCELLING: {
                CANCELING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
                this.cleanSavepoint(application);
                application.setState(currentState.getValue());
                this.doPersistMetrics(application, false);
                break;
            }
            case CANCELED: {
                log.info("FlinkRESTAPIWatcher getFromFlinkRestApi, job state {}, stop tracking and delete stopFrom!", (Object)currentState.name());
                this.cleanSavepoint(application);
                application.setState(currentState.getValue());
                if (StopFrom.NONE.equals(stopFrom) || this.applicationService.checkAlter(application)) {
                    if (StopFrom.NONE.equals(stopFrom)) {
                        log.info("FlinkRESTAPIWatcher getFromFlinkRestApi, job cancel is not form StreamPark,savePoint expired!");
                        this.savePointService.expire(application.getId());
                    }
                    FlinkRESTAPIWatcher.stopCanceledJob(application.getId());
                    this.alertService.alert(application, FlinkAppState.CANCELED);
                }
                STOP_FROM_MAP.remove(application.getId());
                this.doPersistMetrics(application, true);
                this.cleanOptioning(optionState, application.getId());
                break;
            }
            case FAILED: {
                this.cleanSavepoint(application);
                STOP_FROM_MAP.remove(application.getId());
                application.setState(FlinkAppState.FAILED.getValue());
                this.doPersistMetrics(application, true);
                this.alertService.alert(application, FlinkAppState.FAILED);
                this.applicationService.start(application, true);
                break;
            }
            case RESTARTING: {
                log.info("FlinkRESTAPIWatcher getFromFlinkRestApi, job state {},add to starting", (Object)currentState.name());
                STARTING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
                break;
            }
            default: {
                application.setState(currentState.getValue());
                this.doPersistMetrics(application, false);
            }
        }
    }

    private void getFromYarnRestApi(Application application, StopFrom stopFrom) throws Exception {
        block14: {
            log.debug("FlinkRESTAPIWatcher getFromYarnRestApi starting...");
            OptionState optionState = OPTIONING.get(application.getId());
            Byte flag = (Byte)CANCELING_CACHE.getIfPresent((Object)application.getId());
            if (flag != null) {
                log.info("FlinkRESTAPIWatcher previous state: canceling.");
                if (StopFrom.NONE.equals(stopFrom)) {
                    log.error("FlinkRESTAPIWatcher query previous state was canceling and stopFrom NotFound,savePoint expired!");
                    this.savePointService.expire(application.getId());
                }
                application.setState(FlinkAppState.CANCELED.getValue());
                this.cleanSavepoint(application);
                this.cleanOptioning(optionState, application.getId());
                this.doPersistMetrics(application, true);
            } else {
                YarnAppInfo yarnAppInfo = this.httpYarnAppInfo(application);
                if (yarnAppInfo == null) {
                    if (!ExecutionMode.REMOTE.equals((Object)application.getExecutionModeEnum())) {
                        throw new RuntimeException("FlinkRESTAPIWatcher getFromYarnRestApi failed ");
                    }
                } else {
                    try {
                        String state = yarnAppInfo.getApp().getFinalStatus();
                        FlinkAppState flinkAppState = FlinkAppState.of(state);
                        if (FlinkAppState.OTHER.equals(flinkAppState)) {
                            return;
                        }
                        if (FlinkAppState.KILLED.equals(flinkAppState)) {
                            if (StopFrom.NONE.equals(stopFrom)) {
                                log.error("FlinkRESTAPIWatcher getFromYarnRestApi,job was killed and stopFrom NotFound,savePoint expired!");
                                this.savePointService.expire(application.getId());
                            }
                            flinkAppState = FlinkAppState.CANCELED;
                            this.cleanSavepoint(application);
                            application.setEndTime(new Date());
                        }
                        if (FlinkAppState.SUCCEEDED.equals(flinkAppState)) {
                            flinkAppState = FlinkAppState.FINISHED;
                        }
                        application.setState(flinkAppState.getValue());
                        this.cleanOptioning(optionState, application.getId());
                        this.doPersistMetrics(application, true);
                        if (flinkAppState.equals(FlinkAppState.FAILED) || flinkAppState.equals(FlinkAppState.LOST) || flinkAppState.equals(FlinkAppState.CANCELED) && StopFrom.NONE.equals(stopFrom) || this.applicationService.checkAlter(application)) {
                            this.alertService.alert(application, flinkAppState);
                            FlinkRESTAPIWatcher.stopCanceledJob(application.getId());
                            if (flinkAppState.equals(FlinkAppState.FAILED)) {
                                this.applicationService.start(application, true);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ExecutionMode.REMOTE.equals((Object)application.getExecutionModeEnum())) break block14;
                        throw new RuntimeException("FlinkRESTAPIWatcher getFromYarnRestApi error,", e);
                    }
                }
            }
        }
    }

    private void cleanOptioning(OptionState optionState, Long key) {
        if (optionState != null) {
            this.lastOptionTime = System.currentTimeMillis();
            OPTIONING.remove(key);
        }
    }

    private void cleanSavepoint(Application application) {
        SAVEPOINT_CACHE.invalidate((Object)application.getId());
        application.setOptionState(OptionState.NONE.getValue());
    }

    public static void setOptionState(Long appId, OptionState state) {
        if (FlinkRESTAPIWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("FlinkRESTAPIWatcher setOptioning");
        OPTIONING.put(appId, state);
        if (state.equals(OptionState.CANCELLING)) {
            STOP_FROM_MAP.put(appId, StopFrom.STREAMPARK);
        }
    }

    public static void doWatching(Application application) {
        if (FlinkRESTAPIWatcher.isKubernetesApp(application)) {
            return;
        }
        log.info("FlinkRESTAPIWatcher add app to tracking,appId:{}", (Object)application.getId());
        WATCHING_APPS.put(application.getId(), application);
        STARTING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
    }

    public static void addSavepoint(Long appId) {
        if (FlinkRESTAPIWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("FlinkRESTAPIWatcher add app to savepoint,appId:{}", (Object)appId);
        SAVEPOINT_CACHE.put((Object)appId, (Object)DEFAULT_FLAG_BYTE);
    }

    public static void removeFlinkCluster(FlinkCluster flinkCluster) {
        if (FLINK_CLUSTER_MAP.containsKey(flinkCluster.getId())) {
            log.info("remove flink cluster:{}", (Object)flinkCluster.getId());
            FLINK_CLUSTER_MAP.remove(flinkCluster.getId());
        }
    }

    public static void unWatching(Long appId) {
        if (FlinkRESTAPIWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("FlinkRESTAPIWatcher stop app,appId:{}", (Object)appId);
        WATCHING_APPS.remove(appId);
    }

    public static void stopCanceledJob(Long appId) {
        if (!CANCELLED_JOB_MAP.containsKey(appId)) {
            return;
        }
        log.info("flink job canceled app appId:{} by useId:{}", (Object)appId, (Object)CANCELLED_JOB_MAP.get(appId));
        CANCELLED_JOB_MAP.remove(appId);
    }

    public static void addCanceledApp(Long appId, Long userId) {
        log.info("flink job addCanceledApp app appId:{}, useId:{}", (Object)appId, (Object)userId);
        CANCELLED_JOB_MAP.put(appId, userId);
    }

    public static Long getCanceledJobUserId(Long appId) {
        return CANCELLED_JOB_MAP.get(appId) == null ? Long.valueOf(-1L) : CANCELLED_JOB_MAP.get(appId);
    }

    public static Collection<Application> getWatchingApps() {
        return WATCHING_APPS.values();
    }

    private static boolean isKubernetesApp(Application application) {
        return FlinkK8sWatcherWrapper.isKubernetesApp(application);
    }

    private static boolean isKubernetesApp(Long appId) {
        Application app = WATCHING_APPS.get(appId);
        return FlinkK8sWatcherWrapper.isKubernetesApp(app);
    }

    private FlinkCluster getFlinkCluster(Application application) {
        if (ExecutionMode.isRemoteMode((ExecutionMode)application.getExecutionModeEnum()) || ExecutionMode.isSessionMode((ExecutionMode)application.getExecutionModeEnum())) {
            FlinkCluster flinkCluster = FLINK_CLUSTER_MAP.get(application.getFlinkClusterId());
            if (flinkCluster == null) {
                flinkCluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
                FLINK_CLUSTER_MAP.put(application.getFlinkClusterId(), flinkCluster);
            }
            return flinkCluster;
        }
        return null;
    }

    private YarnAppInfo httpYarnAppInfo(Application application) throws Exception {
        String reqURL = "ws/v1/cluster/apps/".concat(application.getAppId());
        return this.yarnRestRequest(reqURL, YarnAppInfo.class);
    }

    private Overview httpOverview(Application application, FlinkCluster flinkCluster) throws IOException {
        String appId = application.getAppId();
        if (appId != null && (application.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_APPLICATION) || application.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_PER_JOB))) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/overview";
                reqURL = String.format(format, appId);
            } else {
                String format = "%s/overview";
                reqURL = String.format(format, application.getJobManagerUrl());
            }
            return this.yarnRestRequest(reqURL, Overview.class);
        }
        return null;
    }

    private JobsOverview httpJobsOverview(Application application, FlinkCluster flinkCluster) throws Exception {
        String flinkUrl = "jobs/overview";
        ExecutionMode execMode = application.getExecutionModeEnum();
        if (ExecutionMode.YARN_PER_JOB.equals((Object)execMode) || ExecutionMode.YARN_APPLICATION.equals((Object)execMode)) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/jobs/overview";
                reqURL = String.format(format, application.getAppId());
            } else {
                String format = "%s/jobs/overview";
                reqURL = String.format(format, application.getJobManagerUrl());
            }
            return this.yarnRestRequest(reqURL, JobsOverview.class);
        }
        if ((ExecutionMode.REMOTE.equals((Object)execMode) || ExecutionMode.YARN_SESSION.equals((Object)execMode)) && application.getJobId() != null) {
            String remoteUrl = flinkCluster.getAddress() + "/" + "jobs/overview";
            JobsOverview jobsOverview = this.httpRestRequest(remoteUrl, JobsOverview.class);
            if (jobsOverview != null) {
                List<JobsOverview.Job> jobs = jobsOverview.getJobs().stream().filter(x -> x.getId().equals(application.getJobId())).collect(Collectors.toList());
                jobsOverview.setJobs(jobs);
            }
            return jobsOverview;
        }
        return null;
    }

    private CheckPoints httpCheckpoints(Application application, FlinkCluster flinkCluster) throws IOException {
        String flinkUrl = "jobs/%s/checkpoints";
        ExecutionMode execMode = application.getExecutionModeEnum();
        if (ExecutionMode.YARN_PER_JOB.equals((Object)execMode) || ExecutionMode.YARN_APPLICATION.equals((Object)execMode)) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/jobs/%s/checkpoints";
                reqURL = String.format(format, application.getAppId(), application.getJobId());
            } else {
                String format = "%s/jobs/%s/checkpoints";
                reqURL = String.format(format, application.getJobManagerUrl(), application.getJobId());
            }
            return this.yarnRestRequest(reqURL, CheckPoints.class);
        }
        if ((ExecutionMode.REMOTE.equals((Object)execMode) || ExecutionMode.YARN_SESSION.equals((Object)execMode)) && application.getJobId() != null) {
            String remoteUrl = flinkCluster.getAddress() + "/" + String.format("jobs/%s/checkpoints", application.getJobId());
            return this.httpRestRequest(remoteUrl, CheckPoints.class);
        }
        return null;
    }

    private <T> T yarnRestRequest(String url, Class<T> clazz) throws IOException {
        String result = YarnUtils.restRequest((String)url);
        if (null == result) {
            return null;
        }
        return JacksonUtils.read(result, clazz);
    }

    private <T> T httpRestRequest(String url, Class<T> clazz) throws IOException {
        String result = HttpClientUtils.httpGetRequest((String)url, (RequestConfig)RequestConfig.custom().setConnectTimeout(5000).build());
        if (null == result) {
            return null;
        }
        return JacksonUtils.read(result, clazz);
    }

    public boolean isWatchingApp(Long id) {
        return WATCHING_APPS.containsKey(id);
    }
}

