/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client;

import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.ShutDownRequest;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.impl.KubernetesNativeApplicationSubmit$;
import org.apache.streampark.flink.client.impl.KubernetesNativeSessionSubmit$;
import org.apache.streampark.flink.client.impl.LocalSubmit$;
import org.apache.streampark.flink.client.impl.RemoteSubmit$;
import org.apache.streampark.flink.client.impl.YarnApplicationSubmit$;
import org.apache.streampark.flink.client.impl.YarnPerJobSubmit$;
import org.apache.streampark.flink.client.impl.YarnSessionSubmit$;

public final class FlinkClientHandler$ {
    public static FlinkClientHandler$ MODULE$;

    static {
        new FlinkClientHandler$();
    }

    public SubmitResponse submit(SubmitRequest submitInfo) {
        SubmitResponse submitResponse;
        ExecutionMode executionMode = submitInfo.executionMode();
        if (ExecutionMode.LOCAL.equals(executionMode)) {
            submitResponse = LocalSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.REMOTE.equals(executionMode)) {
            submitResponse = RemoteSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.YARN_APPLICATION.equals(executionMode)) {
            submitResponse = YarnApplicationSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            submitResponse = YarnSessionSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.YARN_PER_JOB.equals(executionMode)) {
            submitResponse = YarnPerJobSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
            submitResponse = KubernetesNativeSessionSubmit$.MODULE$.submit(submitInfo);
        } else if (ExecutionMode.KUBERNETES_NATIVE_APPLICATION.equals(executionMode)) {
            submitResponse = KubernetesNativeApplicationSubmit$.MODULE$.submit(submitInfo);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(20).append("Unsupported ").append(submitInfo.executionMode()).append(" submit ").toString());
        }
        return submitResponse;
    }

    public CancelResponse cancel(CancelRequest cancelRequest) {
        CancelResponse cancelResponse;
        ExecutionMode executionMode = cancelRequest.executionMode();
        if (ExecutionMode.LOCAL.equals(executionMode)) {
            cancelResponse = LocalSubmit$.MODULE$.cancel(cancelRequest);
        } else if (ExecutionMode.REMOTE.equals(executionMode)) {
            cancelResponse = RemoteSubmit$.MODULE$.cancel(cancelRequest);
        } else if (ExecutionMode.YARN_APPLICATION.equals(executionMode)) {
            cancelResponse = YarnApplicationSubmit$.MODULE$.cancel(cancelRequest);
        } else if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            cancelResponse = YarnSessionSubmit$.MODULE$.cancel(cancelRequest);
        } else {
            boolean bl = ExecutionMode.YARN_PER_JOB.equals(executionMode) ? true : ExecutionMode.YARN_SESSION.equals(executionMode);
            if (bl) {
                cancelResponse = YarnPerJobSubmit$.MODULE$.cancel(cancelRequest);
            } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
                cancelResponse = KubernetesNativeSessionSubmit$.MODULE$.cancel(cancelRequest);
            } else if (ExecutionMode.KUBERNETES_NATIVE_APPLICATION.equals(executionMode)) {
                cancelResponse = KubernetesNativeApplicationSubmit$.MODULE$.cancel(cancelRequest);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(20).append("Unsupported ").append(cancelRequest.executionMode()).append(" cancel ").toString());
            }
        }
        return cancelResponse;
    }

    public DeployResponse deploy(DeployRequest deployRequest) {
        DeployResponse deployResponse;
        ExecutionMode executionMode = deployRequest.executionMode();
        if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            deployResponse = YarnSessionSubmit$.MODULE$.deploy(deployRequest);
        } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
            deployResponse = KubernetesNativeSessionSubmit$.MODULE$.deploy(deployRequest);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Unsupported ").append(deployRequest.executionMode()).append(" deploy cluster ").toString());
        }
        return deployResponse;
    }

    public ShutDownResponse shutdown(ShutDownRequest shutDownRequest) {
        ShutDownResponse shutDownResponse;
        ExecutionMode executionMode = shutDownRequest.executionMode();
        if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            shutDownResponse = YarnSessionSubmit$.MODULE$.shutdown(shutDownRequest);
        } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
            shutDownResponse = KubernetesNativeSessionSubmit$.MODULE$.shutdown(shutDownRequest);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(30).append("Unsupported ").append(shutDownRequest.executionMode()).append(" shutdown cluster ").toString());
        }
        return shutDownResponse;
    }

    private FlinkClientHandler$() {
        MODULE$ = this;
    }
}

