/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.base;

import com.google.common.base.Nullable;
import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Supplier;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Suppliers {
    private Suppliers() {
    }

    public static <F, T> Supplier<T> compose(Function<? super F, ? extends T> function, Supplier<? extends F> first) {
        return new SupplierComposition<F, T>(function, first);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new MemoizingSupplier<T>(delegate);
    }

    public static <T> Supplier<T> ofInstance(@Nullable T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        private final T instance;
        private static final long serialVersionUID = 0L;

        public SupplierOfInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }

    public static class CyclicDependencyException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        CyclicDependencyException() {
            super("Cycle detected when invoking a memoizing supplier.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MemoizationState {
        NOT_YET,
        COMPUTING,
        DONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private final Supplier<T> delegate;
        private MemoizationState state = MemoizationState.NOT_YET;
        private T value;
        private static final long serialVersionUID = 0L;

        public MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            switch (this.state) {
                case NOT_YET: {
                    this.state = MemoizationState.COMPUTING;
                    try {
                        this.value = this.delegate.get();
                    }
                    finally {
                        this.state = MemoizationState.NOT_YET;
                    }
                    this.state = MemoizationState.DONE;
                    break;
                }
                case COMPUTING: {
                    throw new CyclicDependencyException();
                }
            }
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        private final Function<? super F, ? extends T> function;
        private final Supplier<? extends F> first;
        private static final long serialVersionUID = 0L;

        public SupplierComposition(Function<? super F, ? extends T> function, Supplier<? extends F> first) {
            this.function = function;
            this.first = first;
        }

        @Override
        public T get() {
            return this.function.apply(this.first.get());
        }
    }
}

