/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatementBlock;

public class IPAPassFlagLoopsRecompileOnce
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return true;
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        if (!ConfigurationManager.isDynamicRecompilation()) {
            return false;
        }
        boolean ret = false;
        for (StatementBlock sb : prog.getStatementBlocks()) {
            if (!this.rFlagFunctionForRecompileOnce(sb)) continue;
            ret = true;
        }
        return ret;
    }

    public boolean rFlagFunctionForRecompileOnce(StatementBlock sb) {
        boolean ret = false;
        if (sb instanceof WhileStatementBlock) {
            ret = IPAPassFlagLoopsRecompileOnce.markRecompile(sb);
        } else if (sb instanceof ForStatementBlock && !(sb instanceof ParForStatementBlock)) {
            ret = IPAPassFlagLoopsRecompileOnce.markRecompile(sb);
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock c : istmt.getIfBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c);
            }
            for (StatementBlock c : istmt.getElseBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c);
            }
        }
        return ret;
    }

    private static boolean markRecompile(StatementBlock sb) {
        sb.setRecompileOnce(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("IPA: loop (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ") flagged for recompile-once."));
        }
        return true;
    }
}

