/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FederatedCompilationTimer;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.utils.DMLCompressionStatistics;
import org.apache.sysds.utils.GPUStatistics;
import org.apache.sysds.utils.NativeHelper;
import org.apache.sysds.utils.stats.CodegenStatistics;
import org.apache.sysds.utils.stats.NGramBuilder;
import org.apache.sysds.utils.stats.NativeStatistics;
import org.apache.sysds.utils.stats.ParForStatistics;
import org.apache.sysds.utils.stats.ParamServStatistics;
import org.apache.sysds.utils.stats.RecompileStatistics;
import org.apache.sysds.utils.stats.SparkStatistics;
import org.apache.sysds.utils.stats.TransformStatistics;

public class Statistics {
    private static long compileStartTime = 0L;
    private static long compileEndTime = 0L;
    private static long execStartTime = 0L;
    private static long execEndTime = 0L;
    private static final ConcurrentHashMap<String, InstStats> _instStats = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, NGramBuilder<String, NGramStats>[]> _instStatsNGram = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Map.Entry<String, LineageItem>> _instStatsLineageTracker = new ConcurrentHashMap();
    private static final ConcurrentHashMap<LineageItem, LineageNGramExtension> _lineageExtensions = new ConcurrentHashMap();
    private static final LongAdder numExecutedSPInst = new LongAdder();
    private static final LongAdder numCompiledSPInst = new LongAdder();
    private static final DoubleAdder sizeofPinnedObjects = new DoubleAdder();
    private static long maxNumPinnedObjects = 0L;
    private static double maxSizeofPinnedObjects = 0.0;
    private static final ConcurrentHashMap<String, Double> _cpMemObjs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Double> _currCPMemObjs = new ConcurrentHashMap();
    private static long jitCompileTime = 0L;
    private static long jvmGCTime = 0L;
    private static long jvmGCCount = 0L;
    private static final LongAdder funRecompileTime = new LongAdder();
    private static final LongAdder funRecompiles = new LongAdder();
    private static final LongAdder lTotalUIPVar = new LongAdder();
    private static final LongAdder lTotalLix = new LongAdder();
    private static final LongAdder lTotalLixUIP = new LongAdder();
    public static long recomputeNNZTime = 0L;
    public static long examSparsityTime = 0L;
    public static long allocateDoubleArrTime = 0L;
    public static boolean allowWorkerStatistics = true;

    public static long getNoOfExecutedSPInst() {
        return numExecutedSPInst.longValue();
    }

    public static void incrementNoOfExecutedSPInst() {
        numExecutedSPInst.increment();
    }

    public static void decrementNoOfExecutedSPInst() {
        numExecutedSPInst.decrement();
    }

    public static long getNoOfCompiledSPInst() {
        return numCompiledSPInst.longValue();
    }

    public static void incrementNoOfCompiledSPInst() {
        numCompiledSPInst.increment();
    }

    public static long getTotalUIPVar() {
        return lTotalUIPVar.longValue();
    }

    public static void incrementTotalUIPVar() {
        lTotalUIPVar.increment();
    }

    public static long getTotalLixUIP() {
        return lTotalLixUIP.longValue();
    }

    public static void incrementTotalLixUIP() {
        lTotalLixUIP.increment();
    }

    public static long getTotalLix() {
        return lTotalLix.longValue();
    }

    public static void incrementTotalLix() {
        lTotalLix.increment();
    }

    public static void resetNoOfCompiledJobs(int count) {
        numCompiledSPInst.reset();
        if (OptimizerUtils.isSparkExecutionMode()) {
            numCompiledSPInst.add(count);
        }
    }

    public static void resetNoOfExecutedJobs() {
        numExecutedSPInst.reset();
        if (DMLScript.USE_ACCELERATOR) {
            GPUStatistics.setNoOfExecutedGPUInst(0);
        }
    }

    public static synchronized void incrementJITCompileTime(long time) {
        jitCompileTime += time;
    }

    public static synchronized void incrementJVMgcTime(long time) {
        jvmGCTime += time;
    }

    public static synchronized void incrementJVMgcCount(long delta) {
        jvmGCCount += delta;
    }

    public static void incrementFunRecompileTime(long delta) {
        funRecompileTime.add(delta);
    }

    public static void incrementFunRecompiles() {
        funRecompiles.increment();
    }

    public static void startCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileStartTime = System.nanoTime();
        }
    }

    public static void stopCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileEndTime = System.nanoTime();
        }
    }

    public static long getCompileTime() {
        return compileEndTime - compileStartTime;
    }

    public static void startRunTimer() {
        execStartTime = System.nanoTime();
    }

    public static void stopRunTimer() {
        execEndTime = System.nanoTime();
    }

    public static long getRunTime() {
        return execEndTime - execStartTime;
    }

    public static void reset() {
        RecompileStatistics.reset();
        funRecompiles.reset();
        funRecompileTime.reset();
        CodegenStatistics.reset();
        ParForStatistics.reset();
        ParamServStatistics.reset();
        SparkStatistics.reset();
        TransformStatistics.reset();
        lTotalLix.reset();
        lTotalLixUIP.reset();
        lTotalUIPVar.reset();
        CacheStatistics.reset();
        LineageCacheStatistics.reset();
        Statistics.resetJITCompileTime();
        Statistics.resetJVMgcTime();
        Statistics.resetJVMgcCount();
        Statistics.resetCPHeavyHitters();
        GPUStatistics.reset();
        NativeStatistics.reset();
        DMLCompressionStatistics.reset();
        FederatedStatistics.reset();
        _instStatsNGram.clear();
        _instStatsLineageTracker.clear();
        _instStats.clear();
    }

    public static void resetJITCompileTime() {
        jitCompileTime = -1L * Statistics.getJITCompileTime();
    }

    public static void resetJVMgcTime() {
        jvmGCTime = -1L * Statistics.getJVMgcTime();
    }

    public static void resetJVMgcCount() {
        jvmGCTime = -1L * Statistics.getJVMgcCount();
    }

    public static void resetCPHeavyHitters() {
        _instStats.clear();
    }

    public static String getCPHeavyHitterCode(Instruction inst) {
        Object opcode = null;
        if (inst instanceof SPInstruction) {
            opcode = "SP_" + InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        } else {
            opcode = InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        }
        return opcode;
    }

    public static void addCPMemObject(int hash, double sizeof) {
        double sizePrev = _currCPMemObjs.getOrDefault(hash, 0.0);
        _currCPMemObjs.put(hash, sizeof);
        sizeofPinnedObjects.add(sizeof - sizePrev);
        Statistics.maintainMemMaxStats();
    }

    private static void maintainMemMaxStats() {
        if (maxSizeofPinnedObjects < sizeofPinnedObjects.doubleValue()) {
            maxSizeofPinnedObjects = sizeofPinnedObjects.doubleValue();
        }
        if (maxNumPinnedObjects < (long)_currCPMemObjs.size()) {
            maxNumPinnedObjects = _currCPMemObjs.size();
        }
    }

    public static void removeCPMemObject(int hash) {
        if (_currCPMemObjs.containsKey(hash)) {
            double sizeof = _currCPMemObjs.remove(hash);
            sizeofPinnedObjects.add(-1.0 * sizeof);
        }
    }

    public static void maintainCPHeavyHittersMem(String name, double sizeof) {
        double prevSize = _cpMemObjs.getOrDefault(name, 0.0);
        if (prevSize < sizeof) {
            _cpMemObjs.put(name, sizeof);
        }
    }

    public static void maintainCPHeavyHitters(String instName, long timeNanos) {
        InstStats tmp = _instStats.get(instName);
        if (tmp == null) {
            InstStats tmp0 = new InstStats();
            InstStats tmp1 = _instStats.putIfAbsent(instName, tmp0);
            tmp = tmp1 != null ? tmp1 : tmp0;
        }
        tmp.time.add(timeNanos);
        tmp.count.increment();
    }

    public static void prepareNGramInst(Map.Entry<String, LineageItem> li) {
        if (li == null) {
            _instStatsLineageTracker.remove(Thread.currentThread().getId());
        } else {
            _instStatsLineageTracker.put(Thread.currentThread().getId(), li);
        }
    }

    public static Optional<Map.Entry<String, LineageItem>> getCurrentLineageItem() {
        Map.Entry<String, LineageItem> item = _instStatsLineageTracker.get(Thread.currentThread().getId());
        return item == null ? Optional.empty() : Optional.of(item);
    }

    public static synchronized void clearNGramRecording() {
        NGramBuilder<String, NGramStats>[] bl;
        for (NGramBuilder<String, NGramStats> b : bl = _instStatsNGram.get(Thread.currentThread().getName())) {
            b.clearCurrentRecording();
        }
    }

    public static synchronized void extendLineageItem(LineageItem li, LineageNGramExtension ext) {
        _lineageExtensions.put(li, ext);
    }

    public static synchronized LineageNGramExtension getExtendedLineage(LineageItem li) {
        return _lineageExtensions.get(li);
    }

    public static synchronized void maintainNGramsFromLineage(Instruction tmp, ExecutionContext ec, long t0) {
        long nanoTime = System.nanoTime() - t0;
        if (DMLScript.STATISTICS_NGRAMS_USE_LINEAGE) {
            Statistics.getCurrentLineageItem().ifPresent(li -> {
                Data data = ec.getVariable((String)li.getKey());
                LineageNGramExtension ext = new LineageNGramExtension();
                if (data != null) {
                    ext.setDataType(data.getDataType().toString());
                    ext.setValueType(data.getValueType().toString());
                    if (data instanceof CacheableData) {
                        DataCharacteristics dc = ((CacheableData)data).getDataCharacteristics();
                        ext.setMeta("NDims", Double.valueOf(dc.getNumDims()));
                        ext.setMeta("NumRows", Double.valueOf(dc.getRows()));
                        ext.setMeta("NumCols", Double.valueOf(dc.getCols()));
                        ext.setMeta("NonZeros", Double.valueOf(dc.getNonZeros()));
                    }
                }
                ext.setExecNanos(nanoTime);
                Statistics.extendLineageItem((LineageItem)li.getValue(), ext);
                Statistics.maintainNGramsFromLineage((LineageItem)li.getValue());
            });
        } else {
            Statistics.maintainNGrams(tmp.getExtendedOpcode(), nanoTime);
        }
    }

    public static synchronized void maintainNGramsFromLineage(LineageItem li) {
        NGramBuilder[] tmp = _instStatsNGram.computeIfAbsent(Thread.currentThread().getName(), k -> {
            NGramBuilder[] threadEntry = new NGramBuilder[DMLScript.STATISTICS_NGRAM_SIZES.length];
            for (int i = 0; i < threadEntry.length; ++i) {
                threadEntry[i] = new NGramBuilder<String, NGramStats>(String.class, NGramStats.class, DMLScript.STATISTICS_NGRAM_SIZES[i], s -> s, NGramStats::merge);
            }
            return threadEntry;
        });
        Statistics.addLineagePaths(li, new ArrayList<Map.Entry<LineageItem, LineageNGramExtension>>(), new ArrayList<Integer>(), tmp);
    }

    private static void addLineagePaths(LineageItem li, ArrayList<Map.Entry<LineageItem, LineageNGramExtension>> currentPath, ArrayList<Integer> indexes, NGramBuilder<String, NGramStats>[] builders) {
        if (li.getType() == LineageItem.LineageItemType.Literal) {
            return;
        }
        currentPath.add(new AbstractMap.SimpleEntry<LineageItem, LineageNGramExtension>(li, Statistics.getExtendedLineage(li)));
        int maxSize = 0;
        NGramBuilder<String, NGramStats> matchingBuilder = null;
        for (NGramBuilder<String, NGramStats> builder : builders) {
            if (builder.getSize() == currentPath.size()) {
                matchingBuilder = builder;
            }
            if (builder.getSize() <= maxSize) continue;
            maxSize = builder.getSize();
        }
        if (matchingBuilder != null) {
            Statistics.clearNGramRecording();
            Map.Entry<LineageItem, LineageNGramExtension> currentEntry = currentPath.get(currentPath.size() - 1);
            matchingBuilder.append(LineageItemUtils.explainLineageAsInstruction(currentEntry.getKey(), currentEntry.getValue()) + (String)(indexes.size() > 0 ? "[" + indexes.get(currentPath.size() - 2) + "]" : ""), new NGramStats(1L, currentEntry.getValue() != null ? currentEntry.getValue().getExecNanos() : 0L, 0.0, currentEntry.getValue() != null ? currentEntry.getValue()._meta : null));
            for (int i = currentPath.size() - 2; i >= 0; --i) {
                currentEntry = currentPath.get(i);
                matchingBuilder.append(LineageItemUtils.explainLineageAsInstruction(currentEntry.getKey(), currentEntry.getValue()) + (String)(i > 0 ? "[" + indexes.get(i - 1) + "]" : ""), new NGramStats(1L, currentEntry.getValue() != null ? currentEntry.getValue().getExecNanos() : 0L, 0.0, currentEntry.getValue() != null ? currentEntry.getValue()._meta : null));
            }
        }
        if (currentPath.size() < maxSize && li.getInputs() != null) {
            int idx = 0;
            for (LineageItem input : li.getInputs()) {
                indexes.add(idx++);
                Statistics.addLineagePaths(input, currentPath, indexes, builders);
                indexes.remove(indexes.size() - 1);
            }
        }
        currentPath.remove(currentPath.size() - 1);
    }

    public static void maintainNGrams(String instName, long timeNanos) {
        NGramBuilder[] tmp = _instStatsNGram.computeIfAbsent(Thread.currentThread().getName(), k -> {
            NGramBuilder[] threadEntry = new NGramBuilder[DMLScript.STATISTICS_NGRAM_SIZES.length];
            for (int i = 0; i < threadEntry.length; ++i) {
                threadEntry[i] = new NGramBuilder<String, NGramStats>(String.class, NGramStats.class, DMLScript.STATISTICS_NGRAM_SIZES[i], s -> s, NGramStats::merge);
            }
            return threadEntry;
        });
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].append(instName, new NGramStats(1L, timeNanos, 0.0, null));
        }
    }

    public static NGramBuilder<String, NGramStats>[] mergeNGrams() {
        int i;
        NGramBuilder[] builders = new NGramBuilder[DMLScript.STATISTICS_NGRAM_SIZES.length];
        for (i = 0; i < builders.length; ++i) {
            builders[i] = new NGramBuilder<String, NGramStats>(String.class, NGramStats.class, DMLScript.STATISTICS_NGRAM_SIZES[i], s -> s, NGramStats::merge);
        }
        for (i = 0; i < DMLScript.STATISTICS_NGRAM_SIZES.length; ++i) {
            for (Map.Entry<String, NGramBuilder<String, NGramStats>[]> entry : _instStatsNGram.entrySet()) {
                NGramBuilder<String, NGramStats> mbuilder = entry.getValue()[i];
                builders[i].merge(mbuilder);
            }
        }
        return builders;
    }

    public static String getNGramStdDevs(NGramStats[] stats, int offset, int prec, boolean displayZero) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean containsData = false;
        for (int i = 0; i < stats.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            int actualIndex = (offset + i) % stats.length;
            double var = 1.0E9 * (double)stats[actualIndex].n * Math.sqrt(stats[actualIndex].getTimeVariance()) / (double)stats[actualIndex].cumTimeNanos;
            if (!displayZero && !(var >= Math.pow(10.0, -prec))) continue;
            sb.append(String.format(Locale.US, "%." + prec + "f", var));
            containsData = true;
        }
        sb.append(")");
        return containsData ? sb.toString() : "-";
    }

    public static String getNGramAvgTimes(NGramStats[] stats, int offset, int prec) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < stats.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            int actualIndex = (offset + i) % stats.length;
            double var = (double)stats[actualIndex].cumTimeNanos / 1.0E9 / (double)stats[actualIndex].n;
            sb.append(String.format(Locale.US, "%." + prec + "f", var));
        }
        sb.append(")");
        return sb.toString();
    }

    public static void toCSVStream(NGramBuilder<String, NGramStats> mbuilder, Consumer<String> lineConsumer) {
        int j;
        ArrayList<Object> colList = new ArrayList<Object>();
        colList.add("N-Gram");
        colList.add("Time[s]");
        for (j = 0; j < mbuilder.getSize(); ++j) {
            colList.add("Col" + (j + 1));
        }
        for (j = 0; j < mbuilder.getSize(); ++j) {
            colList.add("Col" + (j + 1) + "::Mean(Time[s])");
        }
        for (j = 0; j < mbuilder.getSize(); ++j) {
            colList.add("Col" + (j + 1) + "::StdDev(Time[s])/Col" + (j + 1) + "::Mean(Time[s])");
        }
        for (j = 0; j < mbuilder.getSize(); ++j) {
            colList.add("Col" + (j + 1) + "_Meta");
        }
        colList.add("Count");
        NGramBuilder.toCSVStream(colList.toArray(new String[colList.size()]), mbuilder.getTopK(100000, NGramStats.getComparator(), true), e -> {
            StringBuilder builder = new StringBuilder();
            builder.append(e.getIdentifier().replace("(", "").replace(")", "").replace(", ", ","));
            builder.append(",");
            builder.append(Statistics.getNGramAvgTimes((NGramStats[])e.getStats(), e.getOffset(), 9).replace("-", "").replace("(", "").replace(")", ""));
            builder.append(",");
            String stdDevs = Statistics.getNGramStdDevs((NGramStats[])e.getStats(), e.getOffset(), 9, true).replace("-", "").replace("(", "").replace(")", "");
            if (stdDevs.isEmpty()) {
                for (int j = 0; j < mbuilder.getSize() - 1; ++j) {
                    builder.append(",");
                }
            } else {
                builder.append(stdDevs);
            }
            boolean first = true;
            NGramStats[] stats = (NGramStats[])e.getStats();
            for (int i = 0; i < stats.length; ++i) {
                builder.append(",");
                NGramStats stat = stats[i];
                if (stat.getMeta() == null) continue;
                for (Map.Entry<String, Double> metaData : stat.getMeta().entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append("&");
                    }
                    if (metaData.getValue() == null) continue;
                    builder.append(metaData.getKey()).append(":").append(metaData.getValue());
                }
            }
            return builder.toString();
        }, lineConsumer);
    }

    public static String nGramToCSV(NGramBuilder<String, NGramStats> mbuilder) {
        StringBuilder b = new StringBuilder();
        Statistics.toCSVStream(mbuilder, b::append);
        return b.toString();
    }

    public static String getCommonNGrams(NGramBuilder<String, NGramStats> builder, int num) {
        int i;
        if (num <= 0 || _instStatsNGram.size() <= 0) {
            return "-";
        }
        NGramBuilder.NGramEntry[] topNGrams = (NGramBuilder.NGramEntry[])builder.getTopK(num, NGramStats.getComparator(), true).toArray(NGramBuilder.NGramEntry[]::new);
        String numCol = "#";
        String instCol = "N-Gram";
        String timeSCol = "Time(s)";
        String timeSVar = "StdDev(t)/Mean(t)";
        String countCol = "Count";
        StringBuilder sb = new StringBuilder();
        int len = topNGrams.length;
        int numHittersToDisplay = Math.min(num, len);
        int maxNumLen = String.valueOf(numHittersToDisplay).length();
        int maxInstLen = "N-Gram".length();
        int maxTimeSLen = "Time(s)".length();
        int maxTimeSVarLen = "StdDev(t)/Mean(t)".length();
        int maxCountLen = "Count".length();
        DecimalFormat sFormat = new DecimalFormat("#,##0.000");
        for (i = 0; i < numHittersToDisplay; ++i) {
            long timeNs = ((NGramStats)topNGrams[i].getCumStats()).cumTimeNanos;
            String instruction = topNGrams[i].getIdentifier();
            double timeS = (double)timeNs / 1.0E9;
            maxInstLen = Math.max(maxInstLen, instruction.length() + 1);
            String timeSString = sFormat.format(timeS);
            String timeSVarString = Statistics.getNGramStdDevs((NGramStats[])topNGrams[i].getStats(), topNGrams[i].getOffset(), 3, false);
            maxTimeSLen = Math.max(maxTimeSLen, timeSString.length());
            maxTimeSVarLen = Math.max(maxTimeSVarLen, timeSVarString.length());
            maxCountLen = Math.max(maxCountLen, String.valueOf(topNGrams[i].getOccurrences()).length());
        }
        maxInstLen = Math.min(maxInstLen, DMLScript.STATISTICS_MAX_WRAP_LEN);
        sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxTimeSVarLen + "s  %" + maxCountLen + "s", "#", "N-Gram", "Time(s)", "StdDev(t)/Mean(t)", "Count"));
        sb.append("\n");
        for (i = 0; i < numHittersToDisplay; ++i) {
            String instruction = topNGrams[i].getIdentifier();
            String[] wrappedInstruction = Statistics.wrap(instruction, maxInstLen);
            double timeS = (double)((NGramStats)topNGrams[i].getCumStats()).cumTimeNanos / 1.0E9;
            String timeSString = sFormat.format(timeS);
            String timeVarString = Statistics.getNGramStdDevs((NGramStats[])topNGrams[i].getStats(), topNGrams[i].getOffset(), 3, false);
            long count = topNGrams[i].getOccurrences();
            int numLines = wrappedInstruction.length;
            for (int wrapIter = 0; wrapIter < numLines; ++wrapIter) {
                String instStr;
                String string = instStr = wrapIter < wrappedInstruction.length ? wrappedInstruction[wrapIter] : "";
                if (wrapIter == 0) {
                    sb.append(String.format(" %" + maxNumLen + "d  %-" + maxInstLen + "s  %" + maxTimeSLen + "s %" + maxTimeSVarLen + "s  %" + maxCountLen + "d", i + 1, instStr, timeSString, timeVarString, count));
                } else {
                    sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s %" + maxTimeSVarLen + "s  %" + maxCountLen + "s", "", instStr, "", "", ""));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static void maintainCPFuncCallStats(String instName) {
        InstStats tmp = _instStats.get(instName);
        if (tmp != null) {
            tmp.count.decrement();
        }
    }

    public static Set<String> getCPHeavyHitterOpCodes() {
        return _instStats.keySet();
    }

    public static long getCPHeavyHitterCount(String opcode) {
        InstStats tmp = _instStats.get(opcode);
        return tmp != null ? tmp.count.longValue() : 0L;
    }

    public static HashMap<String, Pair<Long, Double>> getHeavyHittersHashMap() {
        HashMap<String, Pair<Long, Double>> heavyHitters = new HashMap<String, Pair<Long, Double>>();
        for (String opcode : _instStats.keySet()) {
            InstStats val = _instStats.get(opcode);
            long count = val.count.longValue();
            double time = (double)val.time.longValue() / 1.0E9;
            heavyHitters.put(opcode, (Pair<Long, Double>)new ImmutablePair((Object)count, (Object)time));
        }
        return heavyHitters;
    }

    public static String getHeavyHitters(int num) {
        String timeSString;
        double timeS;
        long timeNs;
        int i;
        if (num <= 0 || _instStats.size() <= 0) {
            return "-";
        }
        Map.Entry[] tmp = (Map.Entry[])_instStats.entrySet().toArray(Map.Entry[]::new);
        Arrays.sort(tmp, new Comparator<Map.Entry<String, InstStats>>(){

            @Override
            public int compare(Map.Entry<String, InstStats> e1, Map.Entry<String, InstStats> e2) {
                return Long.compare(e1.getValue().time.longValue(), e2.getValue().time.longValue());
            }
        });
        String numCol = "#";
        String instCol = "Instruction";
        String timeSCol = "Time(s)";
        String countCol = "Count";
        StringBuilder sb = new StringBuilder();
        int len = tmp.length;
        int numHittersToDisplay = Math.min(num, len);
        int maxNumLen = String.valueOf(numHittersToDisplay).length();
        int maxInstLen = "Instruction".length();
        int maxTimeSLen = "Time(s)".length();
        int maxCountLen = "Count".length();
        DecimalFormat sFormat = new DecimalFormat("#,##0.000");
        for (i = 0; i < numHittersToDisplay; ++i) {
            Map.Entry hh = tmp[len - 1 - i];
            String instruction = (String)hh.getKey();
            timeNs = ((InstStats)hh.getValue()).time.longValue();
            timeS = (double)timeNs / 1.0E9;
            maxInstLen = Math.max(maxInstLen, instruction.length());
            timeSString = sFormat.format(timeS);
            maxTimeSLen = Math.max(maxTimeSLen, timeSString.length());
            maxCountLen = Math.max(maxCountLen, String.valueOf(((InstStats)hh.getValue()).count.longValue()).length());
        }
        maxInstLen = Math.min(maxInstLen, DMLScript.STATISTICS_MAX_WRAP_LEN);
        sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "#", "Instruction", "Time(s)", "Count"));
        sb.append("\n");
        for (i = 0; i < numHittersToDisplay; ++i) {
            String instruction = (String)tmp[len - 1 - i].getKey();
            String[] wrappedInstruction = Statistics.wrap(instruction, maxInstLen);
            timeNs = ((InstStats)tmp[len - 1 - i].getValue()).time.longValue();
            timeS = (double)timeNs / 1.0E9;
            timeSString = sFormat.format(timeS);
            long count = ((InstStats)tmp[len - 1 - i].getValue()).count.longValue();
            int numLines = wrappedInstruction.length;
            for (int wrapIter = 0; wrapIter < numLines; ++wrapIter) {
                String instStr;
                String string = instStr = wrapIter < wrappedInstruction.length ? wrappedInstruction[wrapIter] : "";
                if (wrapIter == 0) {
                    sb.append(String.format(" %" + maxNumLen + "d  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "d", i + 1, instStr, timeSString, count));
                } else {
                    sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "", instStr, "", ""));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String getCPHeavyHittersMem(int num) {
        if (_cpMemObjs.size() <= 0 || num <= 0) {
            return "-";
        }
        Map.Entry[] entries = (Map.Entry[])_cpMemObjs.entrySet().toArray(Map.Entry[]::new);
        Arrays.sort(entries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> a, Map.Entry<String, Double> b) {
                return b.getValue().compareTo(a.getValue());
            }
        });
        int n = entries.length;
        int numHittersToDisplay = Math.min(num, n);
        int numPadLen = String.format("%d", numHittersToDisplay).length();
        int maxNameLength = 0;
        for (String name : _cpMemObjs.keySet()) {
            maxNameLength = Math.max(name.length(), maxNameLength);
        }
        maxNameLength = Math.max(maxNameLength, "Object".length());
        StringBuilder res = new StringBuilder();
        res.append(String.format("  %-" + numPadLen + "s  %-" + maxNameLength + "s  %s\n", "#", "Object", "Memory"));
        for (int ix = 1; ix <= numHittersToDisplay; ++ix) {
            String objName = (String)entries[ix - 1].getKey();
            String objSize = Statistics.byteCountToDisplaySize((Double)entries[ix - 1].getValue());
            String numStr = String.format("  %-" + numPadLen + "s", ix);
            String objNameStr = String.format("  %-" + maxNameLength + "s ", objName);
            res.append(numStr + objNameStr + String.format("  %s", objSize) + "\n");
        }
        return res.toString();
    }

    private static String byteCountToDisplaySize(double numBytes) {
        if (numBytes < 1024.0) {
            return numBytes + " bytes";
        }
        int exp = (int)(Math.log(numBytes) / 6.931471805599453);
        return String.format("%.3f %sB", numBytes / Math.pow(1024.0, exp), Character.valueOf("KMGTP".charAt(exp - 1)));
    }

    public static long getJITCompileTime() {
        long ret = -1L;
        CompilationMXBean cmx = ManagementFactory.getCompilationMXBean();
        if (cmx.isCompilationTimeMonitoringSupported()) {
            ret = cmx.getTotalCompilationTime();
            ret += jitCompileTime;
        }
        return ret;
    }

    public static long getJVMgcTime() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionTime();
        }
        if (ret > 0L) {
            ret += jvmGCTime;
        }
        return ret;
    }

    public static long getJVMgcCount() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionCount();
        }
        if (ret > 0L) {
            ret += jvmGCCount;
        }
        return ret;
    }

    public static long getFunRecompileTime() {
        return funRecompileTime.longValue();
    }

    public static long getFunRecompiles() {
        return funRecompiles.longValue();
    }

    public static long getNumPinnedObjects() {
        return maxNumPinnedObjects;
    }

    public static double getSizeofPinnedObjects() {
        return maxSizeofPinnedObjects;
    }

    public static String display() {
        return Statistics.display(DMLScript.STATISTICS_COUNT);
    }

    public static String[] wrap(String str, int wrapLength) {
        int numLines = (int)Math.ceil((double)str.length() / (double)wrapLength);
        int len = str.length();
        String[] ret = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            ret[i] = str.substring(i * wrapLength, Math.min((i + 1) * wrapLength, len));
        }
        return ret;
    }

    public static String display(int maxHeavyHitters) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemDS Statistics:\n");
        if (DMLScript.STATISTICS) {
            sb.append("Total elapsed time:\t\t" + String.format("%.3f", (double)(Statistics.getCompileTime() + Statistics.getRunTime()) * 1.0E-9) + " sec.\n");
            sb.append("Total compilation time:\t\t" + String.format("%.3f", (double)Statistics.getCompileTime() * 1.0E-9) + " sec.\n");
            sb.append(FederatedCompilationTimer.getStringRepresentation());
        }
        sb.append("Total execution time:\t\t" + String.format("%.3f", (double)Statistics.getRunTime() * 1.0E-9) + " sec.\n");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (DMLScript.STATISTICS) {
                sb.append("Number of compiled Spark inst:\t" + Statistics.getNoOfCompiledSPInst() + ".\n");
            }
            sb.append("Number of executed Spark inst:\t" + Statistics.getNoOfExecutedSPInst() + ".\n");
        }
        if (DMLScript.USE_ACCELERATOR && DMLScript.STATISTICS) {
            sb.append(GPUStatistics.getStringForCudaTimers());
        }
        if (DMLScript.STATISTICS) {
            if (NativeHelper.CURRENT_NATIVE_BLAS_STATE == NativeHelper.NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE) {
                sb.append(NativeStatistics.displayStatistics());
            }
            if (recomputeNNZTime != 0L || examSparsityTime != 0L || allocateDoubleArrTime != 0L) {
                sb.append("MatrixBlock times (recomputeNNZ/examSparsity/allocateDoubleArr):\t" + String.format("%.3f", (double)recomputeNNZTime * 1.0E-9) + "/" + String.format("%.3f", (double)examSparsityTime * 1.0E-9) + "/" + String.format("%.3f", (double)allocateDoubleArrTime * 1.0E-9) + ".\n");
            }
            sb.append("Cache hits (Mem/Li/WB/FS/HDFS):\t" + CacheStatistics.displayHits() + ".\n");
            sb.append("Cache writes (Li/WB/FS/HDFS):\t" + CacheStatistics.displayWrites() + ".\n");
            sb.append("Cache times (ACQr/m, RLS, EXP):\t" + CacheStatistics.displayTime() + " sec.\n");
            if (DMLScript.JMLC_MEM_STATISTICS) {
                sb.append("Max size of live objects:\t" + Statistics.byteCountToDisplaySize(Statistics.getSizeofPinnedObjects()) + " (" + Statistics.getNumPinnedObjects() + " total objects)\n");
            }
            sb.append(RecompileStatistics.displayStatistics());
            if (Statistics.getFunRecompiles() > 0L) {
                sb.append("Functions recompiled:\t\t" + Statistics.getFunRecompiles() + ".\n");
                sb.append("Functions recompile time:\t" + String.format("%.3f", (double)Statistics.getFunRecompileTime() / 1.0E9) + " sec.\n");
            }
            if (DMLScript.LINEAGE && !LineageCacheConfig.ReuseCacheType.isNone()) {
                sb.append("LinCache hits (Mem/FS/Del): \t" + LineageCacheStatistics.displayHits() + ".\n");
                sb.append("LinCache MultiLevel (Ins/SB/Fn):" + LineageCacheStatistics.displayMultiLevelHits() + ".\n");
                if (LineageCacheStatistics.ifGpuStats()) {
                    sb.append("LinCache GPU (Hit/PF): \t" + LineageCacheStatistics.displayGpuStats() + ".\n");
                    sb.append("LinCache GPU (Recyc/Del/Miss): \t" + LineageCacheStatistics.displayGpuPointerStats() + ".\n");
                    sb.append("LinCache GPU evict time: \t" + LineageCacheStatistics.displayGpuEvictTime() + " sec.\n");
                }
                if (LineageCacheStatistics.ifSparkStats()) {
                    sb.append("LinCache Spark (Col/Loc/Dist): \t" + LineageCacheStatistics.displaySparkHits() + ".\n");
                    sb.append("LinCache Spark (Per/Unper/Del):\t" + LineageCacheStatistics.displaySparkPersist() + ".\n");
                }
                sb.append("LinCache writes (Mem/FS/Del): \t" + LineageCacheStatistics.displayWtrites() + ".\n");
                sb.append("LinCache FStimes (Rd/Wr): \t" + LineageCacheStatistics.displayFSTime() + " sec.\n");
                sb.append("LinCache Computetime (S/M/P): \t" + LineageCacheStatistics.displayComputeTime() + " sec.\n");
                sb.append("LinCache Rewrites:    \t\t" + LineageCacheStatistics.displayRewrites() + ".\n");
            }
            if (ConfigurationManager.isCodegenEnabled()) {
                sb.append(CodegenStatistics.displayStatistics());
            }
            if (OptimizerUtils.isSparkExecutionMode()) {
                sb.append(SparkStatistics.displayStatistics());
            }
            if (SparkStatistics.anyAsyncOp()) {
                sb.append(SparkStatistics.displayAsyncStats());
            }
            sb.append(ParamServStatistics.displayStatistics());
            sb.append(ParForStatistics.displayStatistics());
            sb.append(FederatedStatistics.displayFedIOExecStatistics());
            sb.append(FederatedStatistics.displayFedWorkerStats());
            sb.append(TransformStatistics.displayStatistics());
            if (ConfigurationManager.isCompressionEnabled() || DMLCompressionStatistics.getDecompressionCount() > 0) {
                DMLCompressionStatistics.display(sb);
            }
            sb.append("Total JIT compile time:\t\t" + (double)Statistics.getJITCompileTime() / 1000.0 + " sec.\n");
            sb.append("Total JVM GC count:\t\t" + Statistics.getJVMgcCount() + ".\n");
            sb.append("Total JVM GC time:\t\t" + (double)Statistics.getJVMgcTime() / 1000.0 + " sec.\n");
            sb.append("Heavy hitter instructions:\n" + Statistics.getHeavyHitters(maxHeavyHitters));
        }
        if (DMLScript.STATISTICS_NGRAMS) {
            NGramBuilder<String, NGramStats>[] mergedNGrams = Statistics.mergeNGrams();
            for (int i = 0; i < DMLScript.STATISTICS_NGRAM_SIZES.length; ++i) {
                sb.append("Most common " + DMLScript.STATISTICS_NGRAM_SIZES[i] + "-grams (sorted by absolute time):\n" + Statistics.getCommonNGrams(mergedNGrams[i], DMLScript.STATISTICS_TOP_K_NGRAMS));
            }
        }
        if (DMLScript.FED_STATISTICS) {
            sb.append("\n");
            sb.append(FederatedStatistics.displayStatistics(DMLScript.FED_STATISTICS_COUNT));
            sb.append("\n");
            sb.append(ParamServStatistics.displayFloStatistics());
        }
        return sb.toString();
    }

    public static class LineageNGramExtension {
        private String _datatype;
        private String _valuetype;
        private long _execNanos;
        private HashMap<String, Double> _meta;

        public void setDataType(String dataType) {
            this._datatype = dataType;
        }

        public String getDataType() {
            return this._datatype == null ? "" : this._datatype;
        }

        public void setValueType(String valueType) {
            this._valuetype = valueType;
        }

        public String getValueType() {
            return this._valuetype == null ? "" : this._valuetype;
        }

        public void setExecNanos(long nanos) {
            this._execNanos = nanos;
        }

        public long getExecNanos() {
            return this._execNanos;
        }

        public void setMeta(String key, Double value) {
            if (this._meta == null) {
                this._meta = new HashMap();
            }
            this._meta.put(key, value);
        }

        public Object getMeta(String key) {
            if (this._meta == null) {
                return null;
            }
            return this._meta.get(key);
        }
    }

    public static class NGramStats {
        public final long n;
        public final long cumTimeNanos;
        public final double m2;
        public final HashMap<String, Double> meta;

        public static <T> Comparator<NGramBuilder.NGramEntry<T, NGramStats>> getComparator() {
            return Comparator.comparingLong(entry -> ((NGramStats)entry.getCumStats()).cumTimeNanos);
        }

        public static NGramStats merge(NGramStats stats1, NGramStats stats2) {
            long newN = stats1.n + stats2.n;
            long cumTimeNanos = stats1.cumTimeNanos + stats2.cumTimeNanos;
            double mean1 = (double)stats1.cumTimeNanos / 1.0E9 / (double)stats1.n;
            double mean2 = (double)stats2.cumTimeNanos / 1.0E9 / (double)stats2.n;
            double delta = mean2 - mean1;
            double newM2 = stats1.m2 + stats2.m2 + delta * delta * (double)stats1.n * (double)stats2.n / (double)newN;
            HashMap<String, Double> cpy = null;
            if (stats1.meta != null) {
                HashMap<String, Double> mCpy = cpy = new HashMap<String, Double>(stats1.meta);
                if (stats2.meta != null) {
                    stats2.meta.forEach((key, value) -> mCpy.merge((String)key, (Double)value, Double::sum));
                }
            } else if (stats2.meta != null) {
                cpy = new HashMap<String, Double>(stats2.meta);
            }
            return new NGramStats(newN, cumTimeNanos, newM2, cpy);
        }

        public NGramStats(long n, long cumTimeNanos, double m2, HashMap<String, Double> meta) {
            this.n = n;
            this.cumTimeNanos = cumTimeNanos;
            this.m2 = m2;
            this.meta = meta;
        }

        public double getTimeVariance() {
            return this.m2 / (double)Math.max(this.n - 1L, 1L);
        }

        public String toString() {
            return String.format(Locale.US, "%.5f", (double)this.cumTimeNanos / 1.0E9);
        }

        public HashMap<String, Double> getMeta() {
            return this.meta;
        }
    }

    private static class InstStats {
        private final LongAdder time = new LongAdder();
        private final LongAdder count = new LongAdder();

        private InstStats() {
        }
    }
}

