/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.util.CombinedHostsFileReader;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Multimap;
import org.apache.hadoop.thirdparty.com.google.common.collect.UnmodifiableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedHostFileManager
extends HostConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedHostFileManager.class);
    private Configuration conf;
    private HostProperties hostProperties = new HostProperties();

    @Override
    public Iterable<InetSocketAddress> getIncludes() {
        return this.hostProperties.getIncludes();
    }

    @Override
    public Iterable<InetSocketAddress> getExcludes() {
        return this.hostProperties.getExcludes();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(this.conf.get("dfs.hosts", ""));
    }

    private void refresh(String hostsFile) throws IOException {
        DatanodeAdminProperties[] all;
        HostProperties hostProps = new HostProperties();
        for (DatanodeAdminProperties properties : all = CombinedHostsFileReader.readFile((String)hostsFile)) {
            InetSocketAddress addr = CombinedHostFileManager.parseEntry(hostsFile, properties.getHostName(), properties.getPort());
            if (addr == null) continue;
            hostProps.add(addr.getAddress(), properties);
        }
        this.refresh(hostProps);
    }

    @VisibleForTesting
    static InetSocketAddress parseEntry(String fn, String hostName, int port) {
        InetSocketAddress addr = new InetSocketAddress(hostName, port);
        if (addr.isUnresolved()) {
            LOG.warn("Failed to resolve {} in {}. ", (Object)hostName, (Object)fn);
            return null;
        }
        return addr;
    }

    @Override
    public synchronized boolean isIncluded(DatanodeID dn) {
        return this.hostProperties.isIncluded(dn.getResolvedAddress());
    }

    @Override
    public synchronized boolean isExcluded(DatanodeID dn) {
        return this.isExcluded(dn.getResolvedAddress());
    }

    private boolean isExcluded(InetSocketAddress address) {
        return this.hostProperties.isExcluded(address);
    }

    @Override
    public synchronized String getUpgradeDomain(DatanodeID dn) {
        return this.hostProperties.getUpgradeDomain(dn.getResolvedAddress());
    }

    @Override
    public long getMaintenanceExpirationTimeInMS(DatanodeID dn) {
        return this.hostProperties.getMaintenanceExpireTimeInMS(dn.getResolvedAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private void refresh(HostProperties hostProperties) {
        CombinedHostFileManager combinedHostFileManager = this;
        synchronized (combinedHostFileManager) {
            this.hostProperties = hostProperties;
        }
    }

    static class HostProperties {
        private Multimap<InetAddress, DatanodeAdminProperties> allDNs = HashMultimap.create();
        private boolean emptyInServiceNodeLists = true;

        HostProperties() {
        }

        synchronized void add(InetAddress addr, DatanodeAdminProperties properties) {
            this.allDNs.put((Object)addr, (Object)properties);
            if (properties.getAdminState().equals((Object)DatanodeInfo.AdminStates.NORMAL)) {
                this.emptyInServiceNodeLists = false;
            }
        }

        synchronized boolean isIncluded(InetSocketAddress address) {
            return this.emptyInServiceNodeLists || this.allDNs.get((Object)address.getAddress()).stream().anyMatch(input -> input.getPort() == 0 || input.getPort() == address.getPort());
        }

        synchronized boolean isExcluded(InetSocketAddress address) {
            return this.allDNs.get((Object)address.getAddress()).stream().anyMatch(input -> input.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED) && (input.getPort() == 0 || input.getPort() == address.getPort()));
        }

        synchronized String getUpgradeDomain(InetSocketAddress address) {
            Iterable datanode = this.allDNs.get((Object)address.getAddress()).stream().filter(input -> input.getPort() == 0 || input.getPort() == address.getPort()).collect(Collectors.toList());
            return datanode.iterator().hasNext() ? ((DatanodeAdminProperties)datanode.iterator().next()).getUpgradeDomain() : null;
        }

        Iterable<InetSocketAddress> getIncludes() {
            return new Iterable<InetSocketAddress>(){

                @Override
                public Iterator<InetSocketAddress> iterator() {
                    return new HostIterator(allDNs.entries());
                }
            };
        }

        Iterable<InetSocketAddress> getExcludes() {
            return () -> new HostIterator(this.allDNs.entries().stream().filter(entry -> ((DatanodeAdminProperties)entry.getValue()).getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED)).collect(Collectors.toList()));
        }

        synchronized long getMaintenanceExpireTimeInMS(InetSocketAddress address) {
            Iterable datanode = this.allDNs.get((Object)address.getAddress()).stream().filter(input -> input.getAdminState().equals((Object)DatanodeInfo.AdminStates.IN_MAINTENANCE) && (input.getPort() == 0 || input.getPort() == address.getPort())).collect(Collectors.toList());
            return datanode.iterator().hasNext() ? ((DatanodeAdminProperties)datanode.iterator().next()).getMaintenanceExpireTimeInMS() : 0L;
        }

        static class HostIterator
        extends UnmodifiableIterator<InetSocketAddress> {
            private final Iterator<Map.Entry<InetAddress, DatanodeAdminProperties>> it;

            public HostIterator(Collection<Map.Entry<InetAddress, DatanodeAdminProperties>> nodes) {
                this.it = nodes.iterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public InetSocketAddress next() {
                Map.Entry<InetAddress, DatanodeAdminProperties> e = this.it.next();
                return new InetSocketAddress(e.getKey(), e.getValue().getPort());
            }
        }
    }
}

