/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import org.apache.sysds.common.InstructionType;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateTernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AppendFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CentralMomentFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CovarianceFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.IndexingFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.InitFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantilePickFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantileSortFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TsmmFEDInstruction;

public class FEDInstructionParser
extends InstructionParser {
    public static FEDInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        InstructionType fedtype = InstructionUtils.getFEDType(str);
        if (fedtype == null) {
            throw new DMLRuntimeException("Unable derive fedtype for instruction: " + str);
        }
        FEDInstruction cpinst = FEDInstructionParser.parseSingleInstruction(fedtype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static FEDInstruction parseSingleInstruction(InstructionType fedtype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (fedtype) {
            case Init: {
                return InitFEDInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryFEDInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnaryFEDInstruction.parseInstruction(str);
            }
            case Tsmm: {
                return TsmmFEDInstruction.parseInstruction(str);
            }
            case Binary: {
                return BinaryFEDInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryFEDInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgFEDInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendFEDInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernaryFEDInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentFEDInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceFEDInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortFEDInstruction.parseInstruction(str, true);
            }
            case QPick: {
                return QuantilePickFEDInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                return IndexingFEDInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid FEDERATED Instruction Type: " + fedtype);
    }
}

