/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate.internal;

import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateEntityPackageManager;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.hibernate.cfg.Configuration;

public final class PackageNameHibernateConfigurer
implements HibernateConfigurer {
    private final HibernateEntityPackageManager packageManager;
    private final ClassNameLocator classNameLocator;

    public PackageNameHibernateConfigurer(HibernateEntityPackageManager packageManager, ClassNameLocator classNameLocator) {
        this.packageManager = packageManager;
        this.classNameLocator = classNameLocator;
    }

    @Override
    public void configure(Configuration configuration) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String packageName : this.packageManager.getPackageNames()) {
            configuration.addPackage(packageName);
            for (String className : this.classNameLocator.locateClassNames(packageName)) {
                try {
                    Class<?> entityClass = contextClassLoader.loadClass(className);
                    configuration.addAnnotatedClass(entityClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

