/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.internal.services.PersistentFieldManager;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.structure.PageResetListener;
import org.apache.tapestry5.internal.structure.StructureMessages;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.MetaDataLocator;
import org.apache.tapestry5.services.PersistentFieldBundle;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class PageImpl
implements Page {
    private final String name;
    private final ComponentResourceSelector selector;
    private final PersistentFieldManager persistentFieldManager;
    private ComponentPageElement rootElement;
    private List<Runnable> loadedCallbacks = CollectionFactory.newList();
    private final List<Runnable> attachCallbacks = CollectionFactory.newList();
    private final List<Runnable> detachCallbacks = CollectionFactory.newList();
    private final List<Runnable> resetCallbacks = CollectionFactory.newList();
    private boolean loadComplete;
    private final OneShotLock lifecycleListenersLock = new OneShotLock();
    private final OneShotLock verifyListenerLocks = new OneShotLock();
    private final Map<String, ComponentPageElement> idToComponent = CollectionFactory.newConcurrentMap();
    private Page.Stats stats;
    private final AtomicInteger attachCount = new AtomicInteger();
    private final boolean exactParameterCountMatch;
    private List<Runnable> pageVerifyCallbacks = CollectionFactory.newList();
    private final ObjectCreator<PersistentFieldBundle> fieldBundle;
    private static final Pattern SPLIT_ON_DOT = Pattern.compile("\\.");

    public PageImpl(String name, ComponentResourceSelector selector, PersistentFieldManager persistentFieldManager, PerthreadManager perThreadManager, MetaDataLocator metaDataLocator) {
        this.name = name;
        this.selector = selector;
        this.persistentFieldManager = persistentFieldManager;
        this.fieldBundle = perThreadManager.createValue((ObjectCreator)new ObjectCreator<PersistentFieldBundle>(){

            public PersistentFieldBundle createObject() {
                return PageImpl.this.persistentFieldManager.gatherChanges(PageImpl.this.name);
            }
        });
        this.exactParameterCountMatch = metaDataLocator.findMeta("tapestry.unknwon-activation-context-check", name, Boolean.class);
    }

    @Override
    public void setStats(Page.Stats stats) {
        this.stats = stats;
    }

    @Override
    public Page.Stats getStats() {
        return this.stats;
    }

    public String toString() {
        return String.format("Page[%s %s]", this.name, this.selector.toShortString());
    }

    @Override
    public ComponentPageElement getComponentElementByNestedId(String nestedId) {
        assert (nestedId != null);
        if (nestedId.equals("")) {
            return this.rootElement;
        }
        ComponentPageElement element = this.idToComponent.get(nestedId);
        if (element == null) {
            element = this.rootElement;
            for (String id : SPLIT_ON_DOT.split(nestedId)) {
                element = element.getEmbeddedElement(id);
            }
            this.idToComponent.put(nestedId, element);
        }
        return element;
    }

    @Override
    public ComponentResourceSelector getSelector() {
        return this.selector;
    }

    @Override
    public void setRootElement(ComponentPageElement component) {
        this.lifecycleListenersLock.check();
        this.rootElement = component;
    }

    @Override
    public ComponentPageElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public Component getRootComponent() {
        return this.rootElement.getComponent();
    }

    @Override
    public void addLifecycleListener(final PageLifecycleListener listener) {
        assert (listener != null);
        this.addPageLoadedCallback(new Runnable(){

            @Override
            public void run() {
                listener.containingPageDidLoad();
            }
        });
        this.addPageAttachedCallback(new Runnable(){

            @Override
            public void run() {
                listener.containingPageDidAttach();
            }
        });
        this.addPageDetachedCallback(new Runnable(){

            @Override
            public void run() {
                listener.containingPageDidDetach();
            }
        });
    }

    @Override
    public void removeLifecycleListener(PageLifecycleListener listener) {
        this.lifecycleListenersLock.check();
        throw new UnsupportedOperationException("It is not longer possible to remove a page lifecycle listener; please convert your code to use the addPageLoadedCallback() method instead.");
    }

    @Override
    public boolean detached() {
        boolean result = false;
        for (Runnable callback : this.detachCallbacks) {
            try {
                callback.run();
            }
            catch (RuntimeException ex) {
                result = true;
                this.getLogger().error(String.format("Callback %s failed during page detach: %s", callback, ExceptionUtils.toMessage((Throwable)ex)), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void loaded() {
        this.lifecycleListenersLock.lock();
        this.invokeCallbacks(this.loadedCallbacks);
        this.loadedCallbacks = null;
        this.verifyListenerLocks.lock();
        this.invokeCallbacks(this.pageVerifyCallbacks);
        this.pageVerifyCallbacks = null;
        this.loadComplete = true;
    }

    @Override
    public void attached() {
        this.attachCount.incrementAndGet();
        this.invokeCallbacks(this.attachCallbacks);
    }

    @Override
    public Logger getLogger() {
        return this.rootElement.getLogger();
    }

    @Override
    public void persistFieldChange(ComponentResources resources, String fieldName, Object newValue) {
        if (!this.loadComplete) {
            throw new RuntimeException(StructureMessages.persistChangeBeforeLoadComplete());
        }
        this.persistentFieldManager.postChange(this.name, resources, fieldName, newValue);
    }

    @Override
    public Object getFieldChange(String nestedId, String fieldName) {
        return ((PersistentFieldBundle)this.fieldBundle.createObject()).getValue(nestedId, fieldName);
    }

    @Override
    public void discardPersistentFieldChanges() {
        this.persistentFieldManager.discardChanges(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addResetCallback(Runnable callback) {
        assert (callback != null);
        this.lifecycleListenersLock.check();
        this.resetCallbacks.add(callback);
    }

    @Override
    public void addResetListener(final PageResetListener listener) {
        assert (listener != null);
        this.addResetCallback(new Runnable(){

            @Override
            public void run() {
                listener.containingPageDidReset();
            }
        });
    }

    @Override
    public void addVerifyCallback(Runnable callback) {
        this.verifyListenerLocks.check();
        assert (callback != null);
        this.pageVerifyCallbacks.add(callback);
    }

    @Override
    public void pageReset() {
        this.invokeCallbacks(this.resetCallbacks);
    }

    @Override
    public boolean hasResetListeners() {
        return !this.resetCallbacks.isEmpty();
    }

    @Override
    public int getAttachCount() {
        return this.attachCount.get();
    }

    @Override
    public boolean isExactParameterCountMatch() {
        return this.exactParameterCountMatch;
    }

    @Override
    public void addPageLoadedCallback(Runnable callback) {
        this.lifecycleListenersLock.check();
        assert (callback != null);
        this.loadedCallbacks.add(callback);
    }

    @Override
    public void addPageAttachedCallback(Runnable callback) {
        this.lifecycleListenersLock.check();
        assert (callback != null);
        this.attachCallbacks.add(callback);
    }

    @Override
    public void addPageDetachedCallback(Runnable callback) {
        this.lifecycleListenersLock.check();
        assert (callback != null);
        this.detachCallbacks.add(callback);
    }

    private void invokeCallbacks(List<Runnable> callbacks) {
        for (Runnable callback : callbacks) {
            callback.run();
        }
    }
}

