/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.util;

public enum StorageType {
    MEMORY(1),
    LOCALFILE(2),
    HDFS(4),
    LOCALFILE_HDFS(6),
    MEMORY_LOCALFILE(3),
    MEMORY_HDFS(5),
    MEMORY_LOCALFILE_HDFS(7);

    private int val;

    private StorageType(int val) {
        this.val = val;
    }

    private int getVal() {
        return this.val;
    }

    public static boolean withMemory(StorageType storageType) {
        return (storageType.getVal() & MEMORY.getVal()) != 0;
    }

    public static boolean withLocalfile(StorageType storageType) {
        return (storageType.getVal() & LOCALFILE.getVal()) != 0;
    }

    public static boolean withHadoop(StorageType storageType) {
        return (storageType.getVal() & HDFS.getVal()) != 0;
    }

    public static boolean withRemoteStorage(StorageType storageType) {
        return StorageType.withHadoop(storageType);
    }
}

