/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty;

import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.Transferable;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.channel.ChannelHandler;
import org.apache.uniffle.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.uniffle.io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Message message = (Message)msg;
        int encodeLength = message.encodedLength();
        ByteBuf byteBuf = ctx.alloc().buffer(5 + encodeLength);
        try {
            byteBuf.writeInt(encodeLength);
            byteBuf.writeByte(message.type().id());
            message.encode(byteBuf);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception during process encode!", (Throwable)e);
            byteBuf.release();
            throw e;
        }
        ctx.writeAndFlush(byteBuf);
        if (message instanceof Transferable) {
            ((Transferable)((Object)message)).transferTo(ctx.channel());
        }
    }
}

