/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.access;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Sets;

public class AccessInfo {
    private final String accessId;
    private final Set<String> tags;
    private final Map<String, String> extraProperties;
    private final String user;

    public AccessInfo(String accessId, Set<String> tags, Map<String, String> extraProperties, String user) {
        this.accessId = accessId;
        this.tags = tags;
        this.extraProperties = extraProperties == null ? Collections.emptyMap() : extraProperties;
        this.user = user;
    }

    @VisibleForTesting
    public AccessInfo(String accessId) {
        this(accessId, Sets.newHashSet(), Collections.emptyMap(), "");
    }

    public String getAccessId() {
        return this.accessId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "AccessInfo{accessId='" + this.accessId + '\'' + ", user= " + this.user + ", tags=" + this.tags + ", extraProperties=" + this.extraProperties + '}';
    }
}

