/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.rpc.MonitoringServerCall;
import org.apache.uniffle.common.rpc.MonitoringServerCallListener;

public class MonitoringServerInterceptor
implements ServerInterceptor {
    private final GRPCMetrics grpcMetrics;

    public MonitoringServerInterceptor(GRPCMetrics grpcMetrics) {
        this.grpcMetrics = grpcMetrics;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
        String methodName = methodDescriptor.getBareMethodName();
        this.grpcMetrics.incCounter(methodName);
        MonitoringServerCall<ReqT, RespT> monitoringServerCall = new MonitoringServerCall<ReqT, RespT>(serverCall, methodName, this.grpcMetrics);
        return new MonitoringServerCallListener(serverCallHandler.startCall(monitoringServerCall, metadata));
    }
}

