// python wrapper for vtkExtractsDeliveryHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExtractsDeliveryHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExtractsDeliveryHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExtractsDeliveryHelper_ClassNew(); }


static PyObject *
PyvtkExtractsDeliveryHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExtractsDeliveryHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExtractsDeliveryHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExtractsDeliveryHelper *tempr = vtkExtractsDeliveryHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExtractsDeliveryHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExtractsDeliveryHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExtractsDeliveryHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExtractsDeliveryHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SetProcessIsProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcessIsProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProcessIsProducer(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::SetProcessIsProducer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_GetProcessIsProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessIsProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProcessIsProducer() :
      op->vtkExtractsDeliveryHelper::GetProcessIsProducer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SetSimulation2VisualizationController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimulation2VisualizationController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  vtkSocketController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSocketController"))
  {
    if (ap.IsBound())
    {
      op->SetSimulation2VisualizationController(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::SetSimulation2VisualizationController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SetParallelController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetParallelController(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::SetParallelController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_ClearAllExtracts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearAllExtracts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearAllExtracts();
    }
    else
    {
      op->vtkExtractsDeliveryHelper::ClearAllExtracts();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_AddExtractConsumer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExtractConsumer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  const char *temp0 = nullptr;
  vtkTrivialProducer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkTrivialProducer"))
  {
    if (ap.IsBound())
    {
      op->AddExtractConsumer(temp0, temp1);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::AddExtractConsumer(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_RemoveExtractConsumer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveExtractConsumer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveExtractConsumer(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::RemoveExtractConsumer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_AddExtractProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExtractProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  const char *temp0 = nullptr;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddExtractProducer(temp0, temp1);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::AddExtractProducer(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Update() :
      op->vtkExtractsDeliveryHelper::Update());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SetNumberOfVisualizationProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfVisualizationProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfVisualizationProcesses(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::SetNumberOfVisualizationProcesses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_GetNumberOfVisualizationProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfVisualizationProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfVisualizationProcesses() :
      op->vtkExtractsDeliveryHelper::GetNumberOfVisualizationProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_SetNumberOfSimulationProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfSimulationProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfSimulationProcesses(temp0);
    }
    else
    {
      op->vtkExtractsDeliveryHelper::SetNumberOfSimulationProcesses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractsDeliveryHelper_GetNumberOfSimulationProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfSimulationProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractsDeliveryHelper *op = static_cast<vtkExtractsDeliveryHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfSimulationProcesses() :
      op->vtkExtractsDeliveryHelper::GetNumberOfSimulationProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkExtractsDeliveryHelper_Methods[] = {
  {"IsTypeOf", PyvtkExtractsDeliveryHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExtractsDeliveryHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExtractsDeliveryHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExtractsDeliveryHelper\nC++: static vtkExtractsDeliveryHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExtractsDeliveryHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExtractsDeliveryHelper\nC++: vtkExtractsDeliveryHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExtractsDeliveryHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExtractsDeliveryHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetProcessIsProducer", PyvtkExtractsDeliveryHelper_SetProcessIsProducer, METH_VARARGS,
   "SetProcessIsProducer(self, _arg:bool) -> None\nC++: virtual void SetProcessIsProducer(bool _arg)\n\n"},
  {"GetProcessIsProducer", PyvtkExtractsDeliveryHelper_GetProcessIsProducer, METH_VARARGS,
   "GetProcessIsProducer(self) -> bool\nC++: virtual bool GetProcessIsProducer()\n\n"},
  {"SetSimulation2VisualizationController", PyvtkExtractsDeliveryHelper_SetSimulation2VisualizationController, METH_VARARGS,
   "SetSimulation2VisualizationController(self,\n    __a:vtkSocketController) -> None\nC++: void SetSimulation2VisualizationController(\n    vtkSocketController *)\n\n"},
  {"SetParallelController", PyvtkExtractsDeliveryHelper_SetParallelController, METH_VARARGS,
   "SetParallelController(self, __a:vtkMultiProcessController) -> None\nC++: void SetParallelController(vtkMultiProcessController *)\n\n"},
  {"ClearAllExtracts", PyvtkExtractsDeliveryHelper_ClearAllExtracts, METH_VARARGS,
   "ClearAllExtracts(self) -> None\nC++: void ClearAllExtracts()\n\n"},
  {"AddExtractConsumer", PyvtkExtractsDeliveryHelper_AddExtractConsumer, METH_VARARGS,
   "AddExtractConsumer(self, key:str, consumer:vtkTrivialProducer)\n    -> None\nC++: void AddExtractConsumer(const char *key,\n    vtkTrivialProducer *consumer)\n\n"},
  {"RemoveExtractConsumer", PyvtkExtractsDeliveryHelper_RemoveExtractConsumer, METH_VARARGS,
   "RemoveExtractConsumer(self, key:str) -> None\nC++: void RemoveExtractConsumer(const char *key)\n\n"},
  {"AddExtractProducer", PyvtkExtractsDeliveryHelper_AddExtractProducer, METH_VARARGS,
   "AddExtractProducer(self, key:str, producerPort:vtkAlgorithmOutput)\n     -> None\nC++: void AddExtractProducer(const char *key,\n    vtkAlgorithmOutput *producerPort)\n\n"},
  {"Update", PyvtkExtractsDeliveryHelper_Update, METH_VARARGS,
   "Update(self) -> bool\nC++: bool Update()\n\nReturns true if the data has been made available.\n"},
  {"SetNumberOfVisualizationProcesses", PyvtkExtractsDeliveryHelper_SetNumberOfVisualizationProcesses, METH_VARARGS,
   "SetNumberOfVisualizationProcesses(self, _arg:int) -> None\nC++: virtual void SetNumberOfVisualizationProcesses(int _arg)\n\n"},
  {"GetNumberOfVisualizationProcesses", PyvtkExtractsDeliveryHelper_GetNumberOfVisualizationProcesses, METH_VARARGS,
   "GetNumberOfVisualizationProcesses(self) -> int\nC++: virtual int GetNumberOfVisualizationProcesses()\n\n"},
  {"SetNumberOfSimulationProcesses", PyvtkExtractsDeliveryHelper_SetNumberOfSimulationProcesses, METH_VARARGS,
   "SetNumberOfSimulationProcesses(self, _arg:int) -> None\nC++: virtual void SetNumberOfSimulationProcesses(int _arg)\n\n"},
  {"GetNumberOfSimulationProcesses", PyvtkExtractsDeliveryHelper_GetNumberOfSimulationProcesses, METH_VARARGS,
   "GetNumberOfSimulationProcesses(self) -> int\nC++: virtual int GetNumberOfSimulationProcesses()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExtractsDeliveryHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("process_is_producer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractsDeliveryHelper_GetProcessIsProducer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractsDeliveryHelper_SetProcessIsProducer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractsDeliveryHelper_SetProcessIsProducer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProcessIsProducer/SetProcessIsProducer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simulation2_visualization_controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractsDeliveryHelper_SetSimulation2VisualizationController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractsDeliveryHelper_SetSimulation2VisualizationController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSimulation2VisualizationController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractsDeliveryHelper_SetParallelController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractsDeliveryHelper_SetParallelController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetParallelController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_visualization_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractsDeliveryHelper_GetNumberOfVisualizationProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractsDeliveryHelper_SetNumberOfVisualizationProcesses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractsDeliveryHelper_SetNumberOfVisualizationProcesses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfVisualizationProcesses/SetNumberOfVisualizationProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_simulation_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractsDeliveryHelper_GetNumberOfSimulationProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractsDeliveryHelper_SetNumberOfSimulationProcesses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractsDeliveryHelper_SetNumberOfSimulationProcesses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfSimulationProcesses/SetNumberOfSimulationProcesses\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExtractsDeliveryHelper_Doc =
  "vtkExtractsDeliveryHelper - \n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExtractsDeliveryHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingLive.vtkExtractsDeliveryHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExtractsDeliveryHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExtractsDeliveryHelper_StaticNew()
{
  return vtkExtractsDeliveryHelper::New();
}

PyObject *PyvtkExtractsDeliveryHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExtractsDeliveryHelper_Type, PyvtkExtractsDeliveryHelper_Methods,
    "vtkExtractsDeliveryHelper",
 &PyvtkExtractsDeliveryHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExtractsDeliveryHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExtractsDeliveryHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExtractsDeliveryHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExtractsDeliveryHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

