// python wrapper for vtkPVIOSettings
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVIOSettings.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVIOSettings(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVIOSettings_ClassNew(); }


static PyObject *
PyvtkPVIOSettings_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVIOSettings::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVIOSettings::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVIOSettings *tempr = vtkPVIOSettings::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVIOSettings *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVIOSettings::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVIOSettings::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVIOSettings::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVIOSettings *tempr = vtkPVIOSettings::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_SetNumberOfExcludedNameFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfExcludedNameFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfExcludedNameFilters(temp0);
    }
    else
    {
      op->vtkPVIOSettings::SetNumberOfExcludedNameFilters(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetNumberOfExcludedNameFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfExcludedNameFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfExcludedNameFilters() :
      op->vtkPVIOSettings::GetNumberOfExcludedNameFilters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_SetExcludedNameFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludedNameFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetExcludedNameFilter(temp0, temp1);
    }
    else
    {
      op->vtkPVIOSettings::SetExcludedNameFilter(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetExcludedNameFilter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludedNameFilter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetExcludedNameFilter(temp0) :
      op->vtkPVIOSettings::GetExcludedNameFilter(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVIOSettings_GetAllNameFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllNameFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVIOSettings *op = static_cast<vtkPVIOSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetAllNameFilters() :
      op->vtkPVIOSettings::GetAllNameFilters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVIOSettings_Methods[] = {
  {"IsTypeOf", PyvtkPVIOSettings_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVIOSettings_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVIOSettings_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVIOSettings\nC++: static vtkPVIOSettings *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVIOSettings_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVIOSettings\nC++: vtkPVIOSettings *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVIOSettings_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVIOSettings_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkPVIOSettings_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkPVIOSettings\nC++: static vtkPVIOSettings *GetInstance()\n\nAccess the singleton.\n"},
  {"SetNumberOfExcludedNameFilters", PyvtkPVIOSettings_SetNumberOfExcludedNameFilters, METH_VARARGS,
   "SetNumberOfExcludedNameFilters(self, n:int) -> None\nC++: virtual void SetNumberOfExcludedNameFilters(int n)\n\nSet/get the number of excluded name filters.\n"},
  {"GetNumberOfExcludedNameFilters", PyvtkPVIOSettings_GetNumberOfExcludedNameFilters, METH_VARARGS,
   "GetNumberOfExcludedNameFilters(self) -> int\nC++: virtual int GetNumberOfExcludedNameFilters()\n\n"},
  {"SetExcludedNameFilter", PyvtkPVIOSettings_SetExcludedNameFilter, METH_VARARGS,
   "SetExcludedNameFilter(self, i:int, expression:str) -> None\nC++: virtual void SetExcludedNameFilter(int i,\n    const char *expression)\n\nSet/get the excluded name filter at index i. If the index is\noutside the valid range, this call is a noop.\n"},
  {"GetExcludedNameFilter", PyvtkPVIOSettings_GetExcludedNameFilter, METH_VARARGS,
   "GetExcludedNameFilter(self, i:int) -> str\nC++: virtual const char *GetExcludedNameFilter(int i)\n\n"},
  {"GetAllNameFilters", PyvtkPVIOSettings_GetAllNameFilters, METH_VARARGS,
   "GetAllNameFilters(self) -> vtkStringArray\nC++: vtkStringArray *GetAllNameFilters()\n\nGet all reader names, used by the Reader selection logic XXX:\nThis method and property names should be improved\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVIOSettings_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVIOSettings_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("all_name_filters"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVIOSettings_GetAllNameFilters(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAllNameFilters\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVIOSettings_Doc =
  "vtkPVIOSettings - singleton used to control how ParaView open and\nsave files\n\n"
  "Superclass: vtkObject\n\n"
  "Represents the \"IO\" section of ParaView settings.\n\n"
  "vtkPVIOSettings is a singleton used to keep track of readers/writers\n"
  "settings in ParaView, as well as UI for the `Open File Dialog`.\n\n"
  "All calls to vtkPVIOSettings::New() returns a reference to the\n"
  "singleton instance.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVIOSettings_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVIOSettings", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVIOSettings_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVIOSettings_StaticNew()
{
  return vtkPVIOSettings::New();
}

PyObject *PyvtkPVIOSettings_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVIOSettings_Type, PyvtkPVIOSettings_Methods,
    "vtkPVIOSettings",
 &PyvtkPVIOSettings_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVIOSettings_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVIOSettings(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVIOSettings_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVIOSettings", o) != 0)
  {
    Py_DECREF(o);
  }

}

