package common

// folderCreationTracker is used to ensure than in an overwrite=false situation we
// only set folder properties on folders which were created by the current job. (To be consistent
// with the fact that when overwrite == false, we only set file properties on files created
// by the current job)
type FolderCreationTracker interface {
	CreateFolder(folder string, doCreation func() error) error
	ShouldSetProperties(folder string, overwrite OverwriteOption, prompter Prompter) bool
	StopTracking(folder string)
}

type Prompter interface {
	ShouldOverwrite(objectPath string, objectType EntityType) bool
}

// FolderCreationErrorAlreadyExists is a signalling error that should be
// returned by doCreation when the folder already exists, allowing the tracker to mark it as
// FolderExisted rather than FolderCreated.
type FolderCreationErrorAlreadyExists struct{}

func (f FolderCreationErrorAlreadyExists) Error() string {
	return "not a real error"
}
