// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-pluginrpc-go. DO NOT EDIT.
//
// Source: buf/plugin/info/v1/plugin_info_service.proto

package v1pluginrpc

import (
	v1 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/info/v1"
	context "context"
	fmt "fmt"
	pluginrpc "pluginrpc.com/pluginrpc"
)

// This is a compile-time assertion to ensure that this generated file and the pluginrpc package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of pluginrpc newer than the one compiled into your binary. You can fix
// the problem by either regenerating this code with an older version of pluginrpc or updating the
// pluginrpc version compiled into your binary.
const _ = pluginrpc.IsAtLeastVersion0_1_0

const (
	// PluginInfoServiceGetPluginInfoPath is the path of the PluginInfoService's GetPluginInfo RPC.
	PluginInfoServiceGetPluginInfoPath = "/buf.plugin.info.v1.PluginInfoService/GetPluginInfo"
)

// PluginInfoServiceSpecBuilder builds a Spec for the buf.plugin.info.v1.PluginInfoService service.
type PluginInfoServiceSpecBuilder struct {
	GetPluginInfo []pluginrpc.ProcedureOption
}

// Build builds a Spec for the buf.plugin.info.v1.PluginInfoService service.
func (s PluginInfoServiceSpecBuilder) Build() (pluginrpc.Spec, error) {
	procedures := make([]pluginrpc.Procedure, 0, 1)
	procedure, err := pluginrpc.NewProcedure(PluginInfoServiceGetPluginInfoPath, s.GetPluginInfo...)
	if err != nil {
		return nil, err
	}
	procedures = append(procedures, procedure)
	return pluginrpc.NewSpec(procedures...)
}

// PluginInfoServiceClient is a client for the buf.plugin.info.v1.PluginInfoService service.
type PluginInfoServiceClient interface {
	// GetPluginInfo gets information about the plugin.
	GetPluginInfo(context.Context, *v1.GetPluginInfoRequest, ...pluginrpc.CallOption) (*v1.GetPluginInfoResponse, error)
}

// NewPluginInfoServiceClient constructs a client for the buf.plugin.info.v1.PluginInfoService
// service.
func NewPluginInfoServiceClient(client pluginrpc.Client) (PluginInfoServiceClient, error) {
	return &pluginInfoServiceClient{
		client: client,
	}, nil
}

// PluginInfoServiceHandler is an implementation of the buf.plugin.info.v1.PluginInfoService
// service.
type PluginInfoServiceHandler interface {
	// GetPluginInfo gets information about the plugin.
	GetPluginInfo(context.Context, *v1.GetPluginInfoRequest) (*v1.GetPluginInfoResponse, error)
}

// PluginInfoServiceServer serves the buf.plugin.info.v1.PluginInfoService service.
type PluginInfoServiceServer interface {
	// GetPluginInfo gets information about the plugin.
	GetPluginInfo(context.Context, pluginrpc.HandleEnv, ...pluginrpc.HandleOption) error
}

// NewPluginInfoServiceServer constructs a server for the buf.plugin.info.v1.PluginInfoService
// service.
func NewPluginInfoServiceServer(handler pluginrpc.Handler, pluginInfoServiceHandler PluginInfoServiceHandler) PluginInfoServiceServer {
	return &pluginInfoServiceServer{
		handler:                  handler,
		pluginInfoServiceHandler: pluginInfoServiceHandler,
	}
}

// RegisterPluginInfoServiceServer registers the server for the buf.plugin.info.v1.PluginInfoService
// service.
func RegisterPluginInfoServiceServer(serverRegistrar pluginrpc.ServerRegistrar, pluginInfoServiceServer PluginInfoServiceServer) {
	serverRegistrar.Register(PluginInfoServiceGetPluginInfoPath, pluginInfoServiceServer.GetPluginInfo)
}

// *** PRIVATE ***

// pluginInfoServiceClient implements PluginInfoServiceClient.
type pluginInfoServiceClient struct {
	client pluginrpc.Client
}

// GetPluginInfo calls buf.plugin.info.v1.PluginInfoService.GetPluginInfo.
func (c *pluginInfoServiceClient) GetPluginInfo(ctx context.Context, req *v1.GetPluginInfoRequest, opts ...pluginrpc.CallOption) (*v1.GetPluginInfoResponse, error) {
	res := &v1.GetPluginInfoResponse{}
	if err := c.client.Call(ctx, PluginInfoServiceGetPluginInfoPath, req, res, opts...); err != nil {
		return nil, err
	}
	return res, nil
}

// pluginInfoServiceServer implements PluginInfoServiceServer.
type pluginInfoServiceServer struct {
	handler                  pluginrpc.Handler
	pluginInfoServiceHandler PluginInfoServiceHandler
}

// GetPluginInfo calls buf.plugin.info.v1.PluginInfoService.GetPluginInfo.
func (c *pluginInfoServiceServer) GetPluginInfo(ctx context.Context, handleEnv pluginrpc.HandleEnv, options ...pluginrpc.HandleOption) error {
	return c.handler.Handle(
		ctx,
		handleEnv,
		&v1.GetPluginInfoRequest{},
		func(ctx context.Context, anyReq any) (any, error) {
			req, ok := anyReq.(*v1.GetPluginInfoRequest)
			if !ok {
				return nil, fmt.Errorf("could not cast %T to a *v1.GetPluginInfoRequest", anyReq)
			}
			return c.pluginInfoServiceHandler.GetPluginInfo(ctx, req)
		},
		options...,
	)
}
