// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Creates an interruptible Capacity Reservation by specifying the number of
//
// unused instances you want to allocate from your source reservation. This helps
// you make unused capacity available for other workloads within your account while
// maintaining control to reclaim it.
func (c *Client) CreateInterruptibleCapacityReservationAllocation(ctx context.Context, params *CreateInterruptibleCapacityReservationAllocationInput, optFns ...func(*Options)) (*CreateInterruptibleCapacityReservationAllocationOutput, error) {
	if params == nil {
		params = &CreateInterruptibleCapacityReservationAllocationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateInterruptibleCapacityReservationAllocation", params, optFns, c.addOperationCreateInterruptibleCapacityReservationAllocationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateInterruptibleCapacityReservationAllocationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateInterruptibleCapacityReservationAllocationInput struct {

	//  The ID of the source Capacity Reservation from which to create the
	// interruptible Capacity Reservation. Your Capacity Reservation must be in active
	// state with no end date set and have available capacity for allocation.
	//
	// This member is required.
	CapacityReservationId *string

	//  The number of instances to allocate from your source reservation. You can only
	// allocate available instances (also called unused capacity).
	//
	// This member is required.
	InstanceCount *int32

	//  Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response.
	DryRun *bool

	//  The tags to apply to the interruptible Capacity Reservation during creation.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateInterruptibleCapacityReservationAllocationOutput struct {

	//  The type of interruption applied to the interruptible reservation.
	InterruptionType types.InterruptionType

	//  The ID of the source Capacity Reservation from which the interruptible
	// Capacity Reservation was created.
	SourceCapacityReservationId *string

	//  The current status of the allocation request (creating, active, updating).
	Status types.InterruptibleCapacityReservationAllocationStatus

	//  The number of instances allocated to the interruptible reservation.
	TargetInstanceCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateInterruptibleCapacityReservationAllocationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateInterruptibleCapacityReservationAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateInterruptibleCapacityReservationAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateInterruptibleCapacityReservationAllocation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateInterruptibleCapacityReservationAllocationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateInterruptibleCapacityReservationAllocationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateInterruptibleCapacityReservationAllocation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateInterruptibleCapacityReservationAllocation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateInterruptibleCapacityReservationAllocation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateInterruptibleCapacityReservationAllocation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateInterruptibleCapacityReservationAllocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateInterruptibleCapacityReservationAllocationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateInterruptibleCapacityReservationAllocationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateInterruptibleCapacityReservationAllocation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateInterruptibleCapacityReservationAllocation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateInterruptibleCapacityReservationAllocation",
	}
}
