/* collection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from collection.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include <gio/gio.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;
typedef struct _BoxesCollectionItemPrivate BoxesCollectionItemPrivate;
enum  {
	BOXES_COLLECTION_ITEM_0_PROPERTY,
	BOXES_COLLECTION_ITEM_NAME_PROPERTY,
	BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY,
	BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY,
	BOXES_COLLECTION_ITEM_NUM_PROPERTIES
};
static GParamSpec* boxes_collection_item_properties[BOXES_COLLECTION_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;
typedef struct _BoxesCollectionPrivate BoxesCollectionPrivate;

#define BOXES_TYPE_COLLECTION_FILTER (boxes_collection_filter_get_type ())
#define BOXES_COLLECTION_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilter))
#define BOXES_COLLECTION_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilterClass))
#define BOXES_IS_COLLECTION_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_FILTER))
#define BOXES_IS_COLLECTION_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_FILTER))
#define BOXES_COLLECTION_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilterClass))

typedef struct _BoxesCollectionFilter BoxesCollectionFilter;
typedef struct _BoxesCollectionFilterClass BoxesCollectionFilterClass;
enum  {
	BOXES_COLLECTION_0_PROPERTY,
	BOXES_COLLECTION_LENGTH_PROPERTY,
	BOXES_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* boxes_collection_properties[BOXES_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef void (*BoxesCollectionCollectionForeachFunc) (BoxesCollectionItem* item, gpointer user_data);
enum  {
	BOXES_COLLECTION_ITEM_ADDED_SIGNAL,
	BOXES_COLLECTION_ITEM_REMOVED_SIGNAL,
	BOXES_COLLECTION_NUM_SIGNALS
};
static guint boxes_collection_signals[BOXES_COLLECTION_NUM_SIGNALS] = {0};
typedef struct _BoxesCollectionFilterPrivate BoxesCollectionFilterPrivate;
enum  {
	BOXES_COLLECTION_FILTER_0_PROPERTY,
	BOXES_COLLECTION_FILTER_TEXT_PROPERTY,
	BOXES_COLLECTION_FILTER_NUM_PROPERTIES
};
static GParamSpec* boxes_collection_filter_properties[BOXES_COLLECTION_FILTER_NUM_PROPERTIES];

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _BoxesCollectionItem {
	GObject parent_instance;
	BoxesCollectionItemPrivate * priv;
};

struct _BoxesCollectionItemClass {
	GObjectClass parent_class;
	gint (*compare) (BoxesCollectionItem* self, BoxesCollectionItem* other);
};

struct _BoxesCollectionItemPrivate {
	gchar* _name;
	BoxesUIState _previous_ui_state;
	BoxesUIState _ui_state;
};

struct _BoxesCollection {
	GObject parent_instance;
	BoxesCollectionPrivate * priv;
	GListStore* filtered_items;
};

struct _BoxesCollectionClass {
	GObjectClass parent_class;
};

struct _BoxesCollectionPrivate {
	GListStore* items;
	BoxesCollectionFilter* collection_filter;
	GCompareDataFunc sort_func;
	gpointer sort_func_target;
	GDestroyNotify sort_func_target_destroy_notify;
	GList* hidden_items;
};

struct _Block22Data {
	int _ref_count_;
	BoxesCollection* self;
	BoxesAppWindow* window;
	BoxesCollectionItem* item;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	gulong ui_state_id;
};

struct _BoxesCollectionFilter {
	GObject parent_instance;
	BoxesCollectionFilterPrivate * priv;
};

struct _BoxesCollectionFilterClass {
	GObjectClass parent_class;
};

struct _BoxesCollectionFilterPrivate {
	gchar** terms;
	gint terms_length1;
	gint _terms_size_;
	gchar* _text;
};

static gint BoxesCollectionItem_private_offset;
static gpointer boxes_collection_item_parent_class = NULL;
static BoxesUIIface * boxes_collection_item_boxes_ui_parent_iface = NULL;
static gint BoxesCollection_private_offset;
static gpointer boxes_collection_parent_class = NULL;
static gint BoxesCollectionFilter_private_offset;
static gpointer boxes_collection_filter_parent_class = NULL;

VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN gint boxes_collection_item_compare (BoxesCollectionItem* self,
                                    BoxesCollectionItem* other);
static gint boxes_collection_item_real_compare (BoxesCollectionItem* self,
                                         BoxesCollectionItem* other);
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN const gchar* boxes_collection_item_get_name (BoxesCollectionItem* self);
VALA_EXTERN BoxesCollectionItem* boxes_collection_item_construct (GType object_type);
VALA_EXTERN void boxes_collection_item_set_name (BoxesCollectionItem* self,
                                     const gchar* value);
VALA_EXTERN BoxesUIState boxes_ui_get_previous_ui_state (BoxesUI* self);
VALA_EXTERN void boxes_ui_set_previous_ui_state (BoxesUI* self,
                                     BoxesUIState value);
VALA_EXTERN BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
VALA_EXTERN void boxes_ui_set_ui_state (BoxesUI* self,
                            BoxesUIState value);
static void boxes_collection_item_finalize (GObject * obj);
static GType boxes_collection_item_get_type_once (void);
static void _vala_boxes_collection_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_boxes_collection_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN GType boxes_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollection, g_object_unref)
VALA_EXTERN GType boxes_collection_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionFilter, g_object_unref)
VALA_EXTERN BoxesCollectionFilter* boxes_collection_filter_new (void);
VALA_EXTERN BoxesCollectionFilter* boxes_collection_filter_construct (GType object_type);
static gint _boxes_collection_sort_func_lambda9_ (BoxesCollectionItem* item1,
                                           BoxesCollectionItem* item2);
static gint __boxes_collection_sort_func_lambda9__gcompare_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN BoxesCollection* boxes_collection_new (void);
VALA_EXTERN BoxesCollection* boxes_collection_construct (GType object_type);
VALA_EXTERN BoxesCollectionItem* boxes_collection_get_item (BoxesCollection* self,
                                                gint position);
VALA_EXTERN void boxes_collection_add_item (BoxesCollection* self,
                                BoxesCollectionItem* item);
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
VALA_EXTERN BoxesAppWindow* boxes_machine_get_window (BoxesMachine* self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ___lambda10_ (Block23Data* _data23_);
static void ____lambda10__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void boxes_ui_set_state (BoxesUI* self,
                         BoxesUIState new_state);
VALA_EXTERN void boxes_collection_remove_item (BoxesCollection* self,
                                   BoxesCollectionItem* item);
VALA_EXTERN guint boxes_collection_get_length (BoxesCollection* self);
VALA_EXTERN void boxes_collection_foreach_item (BoxesCollection* self,
                                    BoxesCollectionCollectionForeachFunc foreach_func,
                                    gpointer foreach_func_target);
VALA_EXTERN void boxes_collection_filter (BoxesCollection* self,
                              const gchar* search_term);
VALA_EXTERN void boxes_collection_filter_set_text (BoxesCollectionFilter* self,
                                       const gchar* value);
static void __lambda11_ (BoxesCollection* self,
                  BoxesCollectionItem* item);
VALA_EXTERN gboolean boxes_collection_filter_filter (BoxesCollectionFilter* self,
                                         BoxesCollectionItem* item);
static void ___lambda11__boxes_collection_collection_foreach_func (BoxesCollectionItem* item,
                                                            gpointer self);
static GObject * boxes_collection_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void boxes_collection_finalize (GObject * obj);
static GType boxes_collection_get_type_once (void);
static void _vala_boxes_collection_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
VALA_EXTERN const gchar* boxes_collection_filter_get_text (BoxesCollectionFilter* self);
static void boxes_collection_filter_finalize (GObject * obj);
static GType boxes_collection_filter_get_type_once (void);
static void _vala_boxes_collection_filter_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_boxes_collection_filter_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
boxes_collection_item_get_instance_private (BoxesCollectionItem* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesCollectionItem_private_offset);
}

static gint
boxes_collection_item_real_compare (BoxesCollectionItem* self,
                                    BoxesCollectionItem* other)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint result;
	g_return_val_if_fail (other != NULL, 0);
	if (BOXES_IS_MACHINE (other)) {
		result = 1;
		return result;
	}
	_tmp1_ = self->priv->_name;
	if (boxes_is_set (_tmp1_)) {
		const gchar* _tmp2_;
		_tmp2_ = other->priv->_name;
		_tmp0_ = boxes_is_set (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = other->priv->_name;
		result = g_utf8_collate (_tmp3_, _tmp4_);
		return result;
	}
	_tmp5_ = self->priv->_name;
	if (boxes_is_set (_tmp5_)) {
		result = -1;
		return result;
	}
	_tmp6_ = other->priv->_name;
	if (boxes_is_set (_tmp6_)) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

gint
boxes_collection_item_compare (BoxesCollectionItem* self,
                               BoxesCollectionItem* other)
{
	BoxesCollectionItemClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = BOXES_COLLECTION_ITEM_GET_CLASS (self);
	if (_klass_->compare) {
		return _klass_->compare (self, other);
	}
	return -1;
}

BoxesCollectionItem*
boxes_collection_item_construct (GType object_type)
{
	BoxesCollectionItem * self = NULL;
	self = (BoxesCollectionItem*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
boxes_collection_item_get_name (BoxesCollectionItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
boxes_collection_item_set_name (BoxesCollectionItem* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_collection_item_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_NAME_PROPERTY]);
	}
}

static BoxesUIState
boxes_collection_item_real_get_previous_ui_state (BoxesUI* base)
{
	BoxesUIState result;
	BoxesCollectionItem* self;
	self = (BoxesCollectionItem*) base;
	result = self->priv->_previous_ui_state;
	return result;
}

static void
boxes_collection_item_real_set_previous_ui_state (BoxesUI* base,
                                                  BoxesUIState value)
{
	BoxesCollectionItem* self;
	BoxesUIState old_value;
	self = (BoxesCollectionItem*) base;
	old_value = boxes_collection_item_real_get_previous_ui_state (base);
	if (old_value != value) {
		self->priv->_previous_ui_state = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY]);
	}
}

static BoxesUIState
boxes_collection_item_real_get_ui_state (BoxesUI* base)
{
	BoxesUIState result;
	BoxesCollectionItem* self;
	self = (BoxesCollectionItem*) base;
	result = self->priv->_ui_state;
	return result;
}

static void
boxes_collection_item_real_set_ui_state (BoxesUI* base,
                                         BoxesUIState value)
{
	BoxesCollectionItem* self;
	BoxesUIState old_value;
	self = (BoxesCollectionItem*) base;
	old_value = boxes_collection_item_real_get_ui_state (base);
	if (old_value != value) {
		self->priv->_ui_state = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY]);
	}
}

static void
boxes_collection_item_class_init (BoxesCollectionItemClass * klass,
                                  gpointer klass_data)
{
	boxes_collection_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesCollectionItem_private_offset);
	((BoxesCollectionItemClass *) klass)->compare = (gint (*) (BoxesCollectionItem*, BoxesCollectionItem*)) boxes_collection_item_real_compare;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_collection_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_collection_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_collection_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_ITEM_NAME_PROPERTY, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY] = g_param_spec_enum ("previous-ui-state", "previous-ui-state", "previous-ui-state", BOXES_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY, boxes_collection_item_properties[BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY] = g_param_spec_enum ("ui-state", "ui-state", "ui-state", BOXES_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_collection_item_boxes_ui_interface_init (BoxesUIIface * iface,
                                               gpointer iface_data)
{
	boxes_collection_item_boxes_ui_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_previous_ui_state = boxes_collection_item_real_get_previous_ui_state;
	iface->set_previous_ui_state = boxes_collection_item_real_set_previous_ui_state;
	iface->get_ui_state = boxes_collection_item_real_get_ui_state;
	iface->set_ui_state = boxes_collection_item_real_set_ui_state;
}

static void
boxes_collection_item_instance_init (BoxesCollectionItem * self,
                                     gpointer klass)
{
	self->priv = boxes_collection_item_get_instance_private (self);
}

static void
boxes_collection_item_finalize (GObject * obj)
{
	BoxesCollectionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (boxes_collection_item_parent_class)->finalize (obj);
}

static GType
boxes_collection_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesCollectionItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_collection_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesCollectionItem), 0, (GInstanceInitFunc) boxes_collection_item_instance_init, NULL };
	static const GInterfaceInfo boxes_ui_info = { (GInterfaceInitFunc) boxes_collection_item_boxes_ui_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType boxes_collection_item_type_id;
	boxes_collection_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesCollectionItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (boxes_collection_item_type_id, BOXES_TYPE_UI, &boxes_ui_info);
	BoxesCollectionItem_private_offset = g_type_add_instance_private (boxes_collection_item_type_id, sizeof (BoxesCollectionItemPrivate));
	return boxes_collection_item_type_id;
}

GType
boxes_collection_item_get_type (void)
{
	static volatile gsize boxes_collection_item_type_id__once = 0;
	if (g_once_init_enter (&boxes_collection_item_type_id__once)) {
		GType boxes_collection_item_type_id;
		boxes_collection_item_type_id = boxes_collection_item_get_type_once ();
		g_once_init_leave (&boxes_collection_item_type_id__once, boxes_collection_item_type_id);
	}
	return boxes_collection_item_type_id__once;
}

static void
_vala_boxes_collection_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BoxesCollectionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	switch (property_id) {
		case BOXES_COLLECTION_ITEM_NAME_PROPERTY:
		g_value_set_string (value, boxes_collection_item_get_name (self));
		break;
		case BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY:
		g_value_set_enum (value, boxes_ui_get_previous_ui_state ((BoxesUI*) self));
		break;
		case BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY:
		g_value_set_enum (value, boxes_ui_get_ui_state ((BoxesUI*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_collection_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BoxesCollectionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem);
	switch (property_id) {
		case BOXES_COLLECTION_ITEM_NAME_PROPERTY:
		boxes_collection_item_set_name (self, g_value_get_string (value));
		break;
		case BOXES_COLLECTION_ITEM_PREVIOUS_UI_STATE_PROPERTY:
		boxes_ui_set_previous_ui_state ((BoxesUI*) self, g_value_get_enum (value));
		break;
		case BOXES_COLLECTION_ITEM_UI_STATE_PROPERTY:
		boxes_ui_set_ui_state ((BoxesUI*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boxes_collection_get_instance_private (BoxesCollection* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesCollection_private_offset);
}

static gint
_boxes_collection_sort_func_lambda9_ (BoxesCollectionItem* item1,
                                      BoxesCollectionItem* item2)
{
	gint result;
	g_return_val_if_fail (item1 != NULL, 0);
	g_return_val_if_fail (item2 != NULL, 0);
	result = boxes_collection_item_compare (item1, item2);
	return result;
}

static gint
__boxes_collection_sort_func_lambda9__gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self)
{
	gint result;
	result = _boxes_collection_sort_func_lambda9_ ((BoxesCollectionItem*) a, (BoxesCollectionItem*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

BoxesCollection*
boxes_collection_construct (GType object_type)
{
	BoxesCollection * self = NULL;
	self = (BoxesCollection*) g_object_new (object_type, NULL);
	return self;
}

BoxesCollection*
boxes_collection_new (void)
{
	return boxes_collection_construct (BOXES_TYPE_COLLECTION);
}

BoxesCollectionItem*
boxes_collection_get_item (BoxesCollection* self,
                           gint position)
{
	GListStore* _tmp0_;
	GObject* _tmp1_;
	BoxesCollectionItem* _tmp2_;
	BoxesCollectionItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) position);
	_tmp2_ = BOXES_IS_COLLECTION_ITEM (_tmp1_) ? ((BoxesCollectionItem*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		BoxesCollection* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->window);
		_g_object_unref0 (_data22_->item);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		BoxesCollection* self;
		self = _data23_->_data22_->self;
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
___lambda10_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	BoxesCollection* self;
	BoxesAppWindow* _tmp0_;
	BoxesUIState _tmp1_;
	BoxesUIState _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	BoxesAppWindow* _tmp5_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->window;
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == BOXES_UI_STATE_WIZARD) {
		return;
	}
	_tmp3_ = self->priv->hidden_items;
	_tmp4_ = g_list_find (_tmp3_, _data22_->item);
	if (_tmp4_ != NULL) {
		boxes_collection_add_item (self, _data22_->item);
		self->priv->hidden_items = vala_g_list_remove_full (self->priv->hidden_items, _data22_->item, _g_object_unref0_);
	}
	_tmp5_ = _data22_->window;
	g_signal_handler_disconnect ((GObject*) _tmp5_, _data23_->ui_state_id);
}

static void
____lambda10__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda10_ (self);
}

void
boxes_collection_add_item (BoxesCollection* self,
                           BoxesCollectionItem* item)
{
	Block22Data* _data22_;
	BoxesCollectionItem* _tmp0_;
	BoxesMachine* machine = NULL;
	BoxesMachine* _tmp1_;
	BoxesMachine* _tmp2_;
	BoxesMachine* _tmp5_;
	BoxesAppWindow* _tmp6_;
	BoxesAppWindow* _tmp7_;
	BoxesAppWindow* _tmp8_;
	BoxesAppWindow* _tmp9_;
	BoxesUIState _tmp10_;
	BoxesUIState _tmp11_;
	BoxesAppWindow* _tmp15_;
	BoxesUIState _tmp16_;
	BoxesUIState _tmp17_;
	GListStore* _tmp18_;
	GCompareDataFunc _tmp19_;
	gpointer _tmp19__target;
	GListStore* _tmp20_;
	GCompareDataFunc _tmp21_;
	gpointer _tmp21__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data22_->item);
	_data22_->item = _tmp0_;
	_tmp1_ = _g_object_ref0 (BOXES_IS_MACHINE (_data22_->item) ? ((BoxesMachine*) _data22_->item) : NULL);
	machine = _tmp1_;
	_tmp2_ = machine;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup_printf ("Cannot add item %p", &_data22_->item);
		_tmp4_ = _tmp3_;
		g_warning ("collection.vala:65: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (machine);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	_tmp5_ = machine;
	_tmp6_ = boxes_machine_get_window (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data22_->window = _tmp8_;
	_tmp9_ = _data22_->window;
	_tmp10_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == BOXES_UI_STATE_WIZARD) {
		Block23Data* _data23_;
		BoxesCollectionItem* _tmp12_;
		BoxesAppWindow* _tmp13_;
		gulong _tmp14_;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data22_ = block22_data_ref (_data22_);
		_tmp12_ = _g_object_ref0 (_data22_->item);
		self->priv->hidden_items = g_list_append (self->priv->hidden_items, _tmp12_);
		_data23_->ui_state_id = (gulong) 0;
		_tmp13_ = _data22_->window;
		_tmp14_ = g_signal_connect_data ((GObject*) _tmp13_, "notify::ui-state", (GCallback) ____lambda10__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->ui_state_id = _tmp14_;
		block23_data_unref (_data23_);
		_data23_ = NULL;
		_g_object_unref0 (machine);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	_tmp15_ = _data22_->window;
	_tmp16_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp15_);
	_tmp17_ = _tmp16_;
	boxes_ui_set_state ((BoxesUI*) _data22_->item, _tmp17_);
	_tmp18_ = self->priv->items;
	_tmp19_ = self->priv->sort_func;
	_tmp19__target = self->priv->sort_func_target;
	g_list_store_insert_sorted (_tmp18_, (GObject*) _data22_->item, _tmp19_, _tmp19__target);
	_tmp20_ = self->filtered_items;
	_tmp21_ = self->priv->sort_func;
	_tmp21__target = self->priv->sort_func_target;
	g_list_store_insert_sorted (_tmp20_, (GObject*) _data22_->item, _tmp21_, _tmp21__target);
	g_signal_emit (self, boxes_collection_signals[BOXES_COLLECTION_ITEM_ADDED_SIGNAL], 0, _data22_->item);
	_g_object_unref0 (machine);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

void
boxes_collection_remove_item (BoxesCollection* self,
                              BoxesCollectionItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	self->priv->hidden_items = vala_g_list_remove_full (self->priv->hidden_items, item, _g_object_unref0_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				BoxesCollectionItem* _tmp4_;
				BoxesCollectionItem* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = boxes_collection_get_length (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				_tmp4_ = boxes_collection_get_item (self, i);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_ == item;
				_g_object_unref0 (_tmp5_);
				if (_tmp6_) {
					GListStore* _tmp7_;
					GListStore* _tmp8_;
					_tmp7_ = self->priv->items;
					g_list_store_remove (_tmp7_, (guint) i);
					_tmp8_ = self->filtered_items;
					g_list_store_remove (_tmp8_, (guint) i);
					g_signal_emit (self, boxes_collection_signals[BOXES_COLLECTION_ITEM_REMOVED_SIGNAL], 0, item);
					break;
				}
			}
		}
	}
}

void
boxes_collection_foreach_item (BoxesCollection* self,
                               BoxesCollectionCollectionForeachFunc foreach_func,
                               gpointer foreach_func_target)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				BoxesCollectionItem* _tmp4_;
				BoxesCollectionItem* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = boxes_collection_get_length (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				_tmp4_ = boxes_collection_get_item (self, i);
				_tmp5_ = _tmp4_;
				foreach_func (_tmp5_, foreach_func_target);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
}

static void
__lambda11_ (BoxesCollection* self,
             BoxesCollectionItem* item)
{
	BoxesCollectionFilter* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->collection_filter;
	if (boxes_collection_filter_filter (_tmp0_, item)) {
		GListStore* _tmp1_;
		GCompareDataFunc _tmp2_;
		gpointer _tmp2__target;
		_tmp1_ = self->filtered_items;
		_tmp2_ = self->priv->sort_func;
		_tmp2__target = self->priv->sort_func_target;
		g_list_store_insert_sorted (_tmp1_, (GObject*) item, _tmp2_, _tmp2__target);
	}
}

static void
___lambda11__boxes_collection_collection_foreach_func (BoxesCollectionItem* item,
                                                       gpointer self)
{
	__lambda11_ ((BoxesCollection*) self, item);
}

void
boxes_collection_filter (BoxesCollection* self,
                         const gchar* search_term)
{
	GListStore* _tmp0_;
	BoxesCollectionFilter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_term != NULL);
	_tmp0_ = self->filtered_items;
	g_list_store_remove_all (_tmp0_);
	_tmp1_ = self->priv->collection_filter;
	boxes_collection_filter_set_text (_tmp1_, search_term);
	boxes_collection_foreach_item (self, ___lambda11__boxes_collection_collection_foreach_func, self);
}

guint
boxes_collection_get_length (BoxesCollection* self)
{
	guint result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->items;
	result = g_list_model_get_n_items ((GListModel*) _tmp0_);
	return result;
}

static GObject *
boxes_collection_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesCollection * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	parent_class = G_OBJECT_CLASS (boxes_collection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION, BoxesCollection);
	_tmp0_ = g_list_store_new (BOXES_TYPE_COLLECTION_ITEM);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	_tmp1_ = g_list_store_new (BOXES_TYPE_COLLECTION_ITEM);
	_g_object_unref0 (self->filtered_items);
	self->filtered_items = _tmp1_;
	(self->priv->hidden_items == NULL) ? NULL : (self->priv->hidden_items = (_g_list_free__g_object_unref0_ (self->priv->hidden_items), NULL));
	self->priv->hidden_items = NULL;
	return obj;
}

static void
boxes_collection_class_init (BoxesCollectionClass * klass,
                             gpointer klass_data)
{
	boxes_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_collection_get_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_collection_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_LENGTH_PROPERTY, boxes_collection_properties[BOXES_COLLECTION_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	boxes_collection_signals[BOXES_COLLECTION_ITEM_ADDED_SIGNAL] = g_signal_new ("item-added", BOXES_TYPE_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BOXES_TYPE_COLLECTION_ITEM);
	boxes_collection_signals[BOXES_COLLECTION_ITEM_REMOVED_SIGNAL] = g_signal_new ("item-removed", BOXES_TYPE_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BOXES_TYPE_COLLECTION_ITEM);
}

static void
boxes_collection_instance_init (BoxesCollection * self,
                                gpointer klass)
{
	BoxesCollectionFilter* _tmp0_;
	self->priv = boxes_collection_get_instance_private (self);
	_tmp0_ = boxes_collection_filter_new ();
	self->priv->collection_filter = _tmp0_;
	self->priv->sort_func = __boxes_collection_sort_func_lambda9__gcompare_data_func;
	self->priv->sort_func_target = NULL;
	self->priv->sort_func_target_destroy_notify = NULL;
}

static void
boxes_collection_finalize (GObject * obj)
{
	BoxesCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION, BoxesCollection);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->filtered_items);
	_g_object_unref0 (self->priv->collection_filter);
	(self->priv->sort_func_target_destroy_notify == NULL) ? NULL : (self->priv->sort_func_target_destroy_notify (self->priv->sort_func_target), NULL);
	self->priv->sort_func = NULL;
	self->priv->sort_func_target = NULL;
	self->priv->sort_func_target_destroy_notify = NULL;
	(self->priv->hidden_items == NULL) ? NULL : (self->priv->hidden_items = (_g_list_free__g_object_unref0_ (self->priv->hidden_items), NULL));
	G_OBJECT_CLASS (boxes_collection_parent_class)->finalize (obj);
}

static GType
boxes_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesCollection), 0, (GInstanceInitFunc) boxes_collection_instance_init, NULL };
	GType boxes_collection_type_id;
	boxes_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesCollection", &g_define_type_info, 0);
	BoxesCollection_private_offset = g_type_add_instance_private (boxes_collection_type_id, sizeof (BoxesCollectionPrivate));
	return boxes_collection_type_id;
}

GType
boxes_collection_get_type (void)
{
	static volatile gsize boxes_collection_type_id__once = 0;
	if (g_once_init_enter (&boxes_collection_type_id__once)) {
		GType boxes_collection_type_id;
		boxes_collection_type_id = boxes_collection_get_type_once ();
		g_once_init_leave (&boxes_collection_type_id__once, boxes_collection_type_id);
	}
	return boxes_collection_type_id__once;
}

static void
_vala_boxes_collection_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BoxesCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION, BoxesCollection);
	switch (property_id) {
		case BOXES_COLLECTION_LENGTH_PROPERTY:
		g_value_set_uint (value, boxes_collection_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boxes_collection_filter_get_instance_private (BoxesCollectionFilter* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesCollectionFilter_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
boxes_collection_filter_filter (BoxesCollectionFilter* self,
                                BoxesCollectionItem* item)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = boxes_collection_item_get_name (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_canonicalize_for_search (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->terms;
	_tmp3__length1 = self->priv->terms_length1;
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = _tmp3_;
		term_collection_length1 = _tmp3__length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp4_;
			gchar* term = NULL;
			_tmp4_ = g_strdup (term_collection[term_it]);
			term = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = name;
				_tmp6_ = term;
				if (!string_contains (_tmp5_, _tmp6_)) {
					result = FALSE;
					_g_free0 (term);
					_g_free0 (name);
					return result;
				}
				_g_free0 (term);
			}
		}
	}
	result = TRUE;
	_g_free0 (name);
	return result;
}

BoxesCollectionFilter*
boxes_collection_filter_construct (GType object_type)
{
	BoxesCollectionFilter * self = NULL;
	self = (BoxesCollectionFilter*) g_object_new (object_type, NULL);
	return self;
}

BoxesCollectionFilter*
boxes_collection_filter_new (void)
{
	return boxes_collection_filter_construct (BOXES_TYPE_COLLECTION_FILTER);
}

const gchar*
boxes_collection_filter_get_text (BoxesCollectionFilter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
boxes_collection_filter_set_text (BoxesCollectionFilter* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (value, " ", 0);
	self->priv->terms = (_vala_array_free (self->priv->terms, self->priv->terms_length1, (GDestroyNotify) g_free), NULL);
	self->priv->terms = _tmp2_;
	self->priv->terms_length1 = _vala_array_length (_tmp1_);
	self->priv->_terms_size_ = self->priv->terms_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->terms;
				_tmp5__length1 = self->priv->terms_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = self->priv->terms;
				_tmp6__length1 = self->priv->terms_length1;
				_tmp7_ = self->priv->terms;
				_tmp7__length1 = self->priv->terms_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = boxes_canonicalize_for_search (_tmp8_);
				_g_free0 (_tmp6_[i]);
				_tmp6_[i] = _tmp9_;
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, boxes_collection_filter_properties[BOXES_COLLECTION_FILTER_TEXT_PROPERTY]);
}

static void
boxes_collection_filter_class_init (BoxesCollectionFilterClass * klass,
                                    gpointer klass_data)
{
	boxes_collection_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesCollectionFilter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_collection_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_collection_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_collection_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_FILTER_TEXT_PROPERTY, boxes_collection_filter_properties[BOXES_COLLECTION_FILTER_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_collection_filter_instance_init (BoxesCollectionFilter * self,
                                       gpointer klass)
{
	self->priv = boxes_collection_filter_get_instance_private (self);
}

static void
boxes_collection_filter_finalize (GObject * obj)
{
	BoxesCollectionFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilter);
	self->priv->terms = (_vala_array_free (self->priv->terms, self->priv->terms_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (boxes_collection_filter_parent_class)->finalize (obj);
}

static GType
boxes_collection_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesCollectionFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_collection_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesCollectionFilter), 0, (GInstanceInitFunc) boxes_collection_filter_instance_init, NULL };
	GType boxes_collection_filter_type_id;
	boxes_collection_filter_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesCollectionFilter", &g_define_type_info, 0);
	BoxesCollectionFilter_private_offset = g_type_add_instance_private (boxes_collection_filter_type_id, sizeof (BoxesCollectionFilterPrivate));
	return boxes_collection_filter_type_id;
}

GType
boxes_collection_filter_get_type (void)
{
	static volatile gsize boxes_collection_filter_type_id__once = 0;
	if (g_once_init_enter (&boxes_collection_filter_type_id__once)) {
		GType boxes_collection_filter_type_id;
		boxes_collection_filter_type_id = boxes_collection_filter_get_type_once ();
		g_once_init_leave (&boxes_collection_filter_type_id__once, boxes_collection_filter_type_id);
	}
	return boxes_collection_filter_type_id__once;
}

static void
_vala_boxes_collection_filter_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	BoxesCollectionFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilter);
	switch (property_id) {
		case BOXES_COLLECTION_FILTER_TEXT_PROPERTY:
		g_value_set_string (value, boxes_collection_filter_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_collection_filter_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	BoxesCollectionFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_FILTER, BoxesCollectionFilter);
	switch (property_id) {
		case BOXES_COLLECTION_FILTER_TEXT_PROPERTY:
		boxes_collection_filter_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

