
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kkeysequencerecorder_wrapper.h"

// Wrappers providing overrides
#include "ksystemclipboard_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qkeysequence.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwindow.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KKeySequenceRecorder_Type = nullptr;
static PyTypeObject *Sbk_KKeySequenceRecorder_TypeF(void)
{
    return _Sbk_KKeySequenceRecorder_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KKeySequenceRecorderWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KKeySequenceRecorderWrapper::KKeySequenceRecorderWrapper(::QWindow * window, ::QObject * parent) : KKeySequenceRecorder(window, parent)
{
}

void KKeySequenceRecorderWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_childEvent("KKeySequenceRecorder", funcName, gil, pyOverride, event);
}

void KKeySequenceRecorderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KKeySequenceRecorder", funcName, gil, pyOverride, signal);
}

void KKeySequenceRecorderWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_customEvent("KKeySequenceRecorder", funcName, gil, pyOverride, event);
}

void KKeySequenceRecorderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KKeySequenceRecorder", funcName, gil, pyOverride, signal);
}

bool KKeySequenceRecorderWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSystemClipboardWrapper::sbk_o_event("KKeySequenceRecorder", funcName, gil, pyOverride, event);
}

bool KKeySequenceRecorderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSystemClipboardWrapper::sbk_o_eventFilter("KKeySequenceRecorder", funcName, gil, pyOverride, watched, event);
}

void KKeySequenceRecorderWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceRecorder_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_timerEvent("KKeySequenceRecorder", funcName, gil, pyOverride, event);
}

const QMetaObject *KKeySequenceRecorderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KKeySequenceRecorder::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KKeySequenceRecorderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KKeySequenceRecorder::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KKeySequenceRecorderWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KKeySequenceRecorderWrapper *>(this));
    }
    return KKeySequenceRecorder::qt_metacast(_clname);
}

KKeySequenceRecorderWrapper::~KKeySequenceRecorderWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KKeySequenceRecorder_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KKeySequenceRecorder_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KKeySequenceRecorder >()))
        return -1;

    KKeySequenceRecorderWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KKeySequenceRecorder", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KKeySequenceRecorder::KKeySequenceRecorder(QWindow*,QObject*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KKeySequenceRecorder(QWindow*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KKeySequenceRecorder(QWindow*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KKeySequenceRecorder(QWindow*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KKeySequenceRecorderWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KKeySequenceRecorderWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KKeySequenceRecorder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KKeySequenceRecorderFunc_cancelRecording(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cancelRecording()
        cppSelf->cancelRecording();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_currentKeySequence(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentKeySequence()const
        QKeySequence cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->currentKeySequence();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_isRecording(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRecording()const
        bool cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->isRecording();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_modifierOnlyAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceRecorder", "modifierOnlyAllowed() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // modifierOnlyAllowed()const
        bool cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->modifierOnlyAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_modifierlessAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceRecorder", "modifierlessAllowed() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // modifierlessAllowed()const
        bool cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->modifierlessAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_multiKeyShortcutsAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // multiKeyShortcutsAllowed()const
        bool cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->multiKeyShortcutsAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_patterns(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // patterns()const
        QFlags<KKeySequenceRecorder::Pattern> cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->patterns();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KKeySequenceRecorder_Pattern_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setCurrentKeySequence(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setCurrentKeySequence(QKeySequence)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentKeySequence(QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentKeySequence", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentKeySequence(QKeySequence)
            cppSelf->setCurrentKeySequence(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setModifierOnlyAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setModifierOnlyAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setModifierOnlyAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModifierOnlyAllowed", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceRecorder", "setModifierOnlyAllowed(bool allowed)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModifierOnlyAllowed(bool)
            cppSelf->setModifierOnlyAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setModifierlessAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setModifierlessAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setModifierlessAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModifierlessAllowed", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceRecorder", "setModifierlessAllowed(bool allowed)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModifierlessAllowed(bool)
            cppSelf->setModifierlessAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setMultiKeyShortcutsAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setMultiKeyShortcutsAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMultiKeyShortcutsAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMultiKeyShortcutsAllowed", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMultiKeyShortcutsAllowed(bool)
            cppSelf->setMultiKeyShortcutsAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setPatterns(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setPatterns(QFlags<KKeySequenceRecorder::Pattern>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KKeySequenceRecorder_Pattern_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setPatterns(QFlags<KKeySequenceRecorder::Pattern>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPatterns", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        ::QFlags<KKeySequenceRecorder::Pattern> cppArg0 = QFlags<KKeySequenceRecorder::Pattern>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPatterns(QFlags<KKeySequenceRecorder::Pattern>)
            cppSelf->setPatterns(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_setWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceRecorder::setWindow(QWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setWindow(QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWindow", errInfo, SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QWindow*)
            cppSelf->setWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_startRecording(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startRecording()
        cppSelf->startRecording();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceRecorderFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // window()const
        QWindow * cppResult = const_cast<const ::KKeySequenceRecorder *>(cppSelf)->window();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KKeySequenceRecorder_PropertyStrings[] = {
    "currentKeySequence::",
    "isRecording:",
    "modifierOnlyAllowed::",
    "modifierlessAllowed::",
    "multiKeyShortcutsAllowed::",
    "window::",
    nullptr // Sentinel
};

static const char *Sbk_KKeySequenceRecorder_EnumFlagInfo[] = {
    "Pattern:IntFlag:yes",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KKeySequenceRecorder_methods[] = {
    {"cancelRecording", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_cancelRecording), METH_NOARGS, nullptr},
    {"currentKeySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_currentKeySequence), METH_NOARGS, nullptr},
    {"isRecording", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_isRecording), METH_NOARGS, nullptr},
    {"modifierOnlyAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_modifierOnlyAllowed), METH_NOARGS, nullptr},
    {"modifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_modifierlessAllowed), METH_NOARGS, nullptr},
    {"multiKeyShortcutsAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_multiKeyShortcutsAllowed), METH_NOARGS, nullptr},
    {"patterns", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_patterns), METH_NOARGS, nullptr},
    {"setCurrentKeySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setCurrentKeySequence), METH_O, nullptr},
    {"setModifierOnlyAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setModifierOnlyAllowed), METH_O, nullptr},
    {"setModifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setModifierlessAllowed), METH_O, nullptr},
    {"setMultiKeyShortcutsAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setMultiKeyShortcutsAllowed), METH_O, nullptr},
    {"setPatterns", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setPatterns), METH_O, nullptr},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_setWindow), METH_O, nullptr},
    {"startRecording", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_startRecording), METH_NOARGS, nullptr},
    {"window", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceRecorderFunc_window), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KKeySequenceRecorder_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KKeySequenceRecorder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KKeySequenceRecorderWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KKeySequenceRecorder_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KKeySequenceRecorder_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KKeySequenceRecorder_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KKeySequenceRecorder_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KKeySequenceRecorder_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KKeySequenceRecorder_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KKeySequenceRecorder_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KKeySequenceRecorder_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KKeySequenceRecorder_spec = {
    "1:KGuiAddons.KKeySequenceRecorder",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KKeySequenceRecorder_slots
};

} //extern "C"

static void *Sbk_KKeySequenceRecorder_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KKeySequenceRecorder *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KKeySequenceRecorder_Pattern(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KKeySequenceRecorder::Pattern>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KKeySequenceRecorder::Pattern *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KKeySequenceRecorder_Pattern_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_Pattern_IDX])))
        return Enum_PythonToCpp_KKeySequenceRecorder_Pattern;
    return {};
}

static PyObject *KKeySequenceRecorder_Pattern_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KKeySequenceRecorder::Pattern>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KKeySequenceRecorder::Pattern *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KKeySequenceRecorder_Pattern(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KKeySequenceRecorder::Pattern>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KKeySequenceRecorder::Pattern> *>(cppOut) = value;

}

static PyObject *KKeySequenceRecorder_Pattern_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KKeySequenceRecorder::Pattern> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_Pattern_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KKeySequenceRecorder_PythonToCpp_KKeySequenceRecorder_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KKeySequenceRecorder_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KKeySequenceRecorder_PythonToCpp_KKeySequenceRecorder_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KKeySequenceRecorder_TypeF()))
        return KKeySequenceRecorder_PythonToCpp_KKeySequenceRecorder_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KKeySequenceRecorder_PTR_CppToPython_KKeySequenceRecorder(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KKeySequenceRecorder *>(const_cast<void *>(cppIn)), Sbk_KKeySequenceRecorder_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KKeySequenceRecorder_SignatureStrings[] = {
    "KGuiAddons.KKeySequenceRecorder(self,window:PySide6.QtGui.QWindow,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,isRecording:bool=None,currentKeySequence:QKeySequence=None,window:QWindow=None,modifierlessAllowed:bool=None,multiKeyShortcutsAllowed:bool=None,modifierOnlyAllowed:bool=None)",
    "KGuiAddons.KKeySequenceRecorder.cancelRecording(self)",
    "KGuiAddons.KKeySequenceRecorder.currentKeySequence(self)->PySide6.QtGui.QKeySequence",
    "KGuiAddons.KKeySequenceRecorder.isRecording(self)->bool",
    "KGuiAddons.KKeySequenceRecorder.modifierOnlyAllowed(self)->bool",
    "KGuiAddons.KKeySequenceRecorder.modifierlessAllowed(self)->bool",
    "KGuiAddons.KKeySequenceRecorder.multiKeyShortcutsAllowed(self)->bool",
    "KGuiAddons.KKeySequenceRecorder.patterns(self)->KGuiAddons.KKeySequenceRecorder.Pattern",
    "KGuiAddons.KKeySequenceRecorder.setCurrentKeySequence(self,sequence:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int])",
    "KGuiAddons.KKeySequenceRecorder.setModifierOnlyAllowed(self,allowed:bool)",
    "KGuiAddons.KKeySequenceRecorder.setModifierlessAllowed(self,allowed:bool)",
    "KGuiAddons.KKeySequenceRecorder.setMultiKeyShortcutsAllowed(self,allowed:bool)",
    "KGuiAddons.KKeySequenceRecorder.setPatterns(self,patterns:KGuiAddons.KKeySequenceRecorder.Pattern)",
    "KGuiAddons.KKeySequenceRecorder.setWindow(self,window:PySide6.QtGui.QWindow)",
    "KGuiAddons.KKeySequenceRecorder.startRecording(self)",
    "KGuiAddons.KKeySequenceRecorder.window(self)->PySide6.QtGui.QWindow",
    nullptr}; // Sentinel
#else
static constexpr size_t KKeySequenceRecorder_SignatureByteSize = 361;
static constexpr uint8_t KKeySequenceRecorder_SignatureBytes[361] = {
    0x78, 0xda, 0x9d, 0x54, 0x3d, 0x4f, 0xc3, 0x30, 0x10, 0xdd, 0xfb, 0x2b, 0x3a, 0x52, 0x64, 0x32,
    0x32, 0x44, 0x2a, 0x52, 0xd5, 0x81, 0x21, 0x82, 0x36, 0x44, 0x88, 0x01, 0x31, 0xb8, 0xf1, 0x15,
    0x8c, 0xdc, 0x73, 0xb0, 0x2f, 0x8a, 0xf2, 0xef, 0x71, 0xea, 0x06, 0xac, 0xf4, 0x23, 0x49, 0x47,
    0xdf, 0xdd, 0x7b, 0xf7, 0xf1, 0xce, 0x97, 0x3c, 0x96, 0x72, 0x21, 0x84, 0x46, 0x1b, 0x25, 0x09,
    0xd4, 0x19, 0xfc, 0x94, 0x80, 0x39, 0xbc, 0x40, 0xae, 0x8d, 0x00, 0x73, 0x63, 0x41, 0x6d, 0x59,
    0x25, 0x51, 0xe8, 0x2a, 0x5e, 0xd7, 0x99, 0x14, 0x70, 0x1f, 0xa5, 0xe4, 0x40, 0x51, 0xfa, 0xb6,
    0xb7, 0xb2, 0x82, 0x1b, 0x40, 0x0a, 0x9c, 0x4b, 0x6d, 0x20, 0x4a, 0x57, 0x9b, 0x6f, 0xc8, 0x69,
    0x8e, 0xa5, 0x52, 0x05, 0x19, 0x76, 0x1b, 0x3b, 0xf6, 0xca, 0x71, 0xae, 0x50, 0xd5, 0xf3, 0x67,
    0x8d, 0xc0, 0xa4, 0xf5, 0x59, 0x24, 0x7e, 0xc6, 0x1b, 0xad, 0x95, 0xb7, 0xe6, 0xa5, 0x69, 0xf8,
    0x82, 0x5a, 0xe2, 0x34, 0x78, 0xf8, 0xa0, 0x43, 0x41, 0x87, 0x12, 0xbc, 0x6d, 0xa7, 0x85, 0xdc,
    0x4a, 0x30, 0x0a, 0xac, 0x5d, 0x28, 0xa5, 0x2b, 0x10, 0x01, 0xed, 0xae, 0x54, 0x24, 0x1b, 0x9e,
    0x2f, 0x6d, 0x28, 0x2f, 0xe9, 0x54, 0xc8, 0x81, 0xa0, 0xa9, 0xf0, 0xc8, 0x3b, 0x9b, 0x24, 0x97,
    0x27, 0x15, 0xe5, 0xdc, 0xbd, 0xd4, 0x5f, 0x4b, 0xfb, 0xc9, 0x0d, 0x40, 0x1d, 0xb5, 0xeb, 0x81,
    0x77, 0x0f, 0x9d, 0x69, 0x07, 0x11, 0xbd, 0xa4, 0xc1, 0x64, 0x5b, 0xb6, 0xa6, 0x91, 0x5e, 0xdc,
    0x89, 0x09, 0x5c, 0x85, 0x0f, 0x24, 0x18, 0x87, 0x3f, 0x23, 0xd2, 0x28, 0x92, 0x82, 0x13, 0x81,
    0x41, 0xdb, 0x82, 0xfa, 0xe2, 0xd7, 0x3e, 0xbe, 0x97, 0xd7, 0x02, 0x2d, 0x4f, 0x8b, 0xc5, 0x6c,
    0xbb, 0xa9, 0x54, 0x17, 0x6e, 0xe6, 0xd1, 0x2b, 0x4a, 0x8d, 0xef, 0xe7, 0x05, 0x64, 0xd3, 0xee,
    0x6f, 0x71, 0xce, 0xa5, 0xde, 0x6d, 0x24, 0x72, 0x72, 0xd0, 0xd0, 0xdf, 0xc5, 0x46, 0x19, 0x71,
    0x14, 0xdc, 0x08, 0x67, 0x63, 0xd3, 0x34, 0x23, 0xe3, 0x32, 0xb2, 0xa9, 0x44, 0xfa, 0x98, 0x0d,
    0xe9, 0xe1, 0xe9, 0x8c, 0xc6, 0x8c, 0x07, 0x2b, 0x3f, 0x8a, 0xa9, 0xab, 0xf6, 0x15, 0x4c, 0x97,
    0x74, 0x1f, 0x4f, 0xb7, 0x0e, 0x37, 0x80, 0xb5, 0xfb, 0x10, 0x0f, 0x5c, 0x84, 0x41, 0x29, 0xfc,
    0xe1, 0xe9, 0xbf, 0x8e, 0x03, 0xc8, 0x88, 0x1b, 0x1a, 0x7b, 0x35, 0xaa, 0xff, 0xf4, 0xc7, 0x97,
    0xc2, 0x67, 0x9e, 0xfc, 0x02, 0x84, 0x0b, 0x2f, 0x97
};
#endif

PyTypeObject *init_KKeySequenceRecorder(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX].type;

    Shiboken::AutoDecRef Sbk_KKeySequenceRecorder_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KKeySequenceRecorder_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KKeySequenceRecorder",
        "KKeySequenceRecorder*",
        &Sbk_KKeySequenceRecorder_spec,
        &Shiboken::callCppDestructor< KKeySequenceRecorder >,
        Sbk_KKeySequenceRecorder_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KKeySequenceRecorder_Type; // references _Sbk_KKeySequenceRecorder_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KKeySequenceRecorder_SignatureStrings);
#else
    InitSignatureBytes(pyType, KKeySequenceRecorder_SignatureBytes, KKeySequenceRecorder_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KKeySequenceRecorder_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KKeySequenceRecorder_PythonToCpp_KKeySequenceRecorder_PTR,
        is_KKeySequenceRecorder_PythonToCpp_KKeySequenceRecorder_PTR_Convertible,
        KKeySequenceRecorder_PTR_CppToPython_KKeySequenceRecorder);

    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceRecorder");
    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceRecorder*");
    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceRecorder&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KKeySequenceRecorder).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KKeySequenceRecorderWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KKeySequenceRecorder_TypeF(), &Sbk_KKeySequenceRecorder_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KKeySequenceRecorder_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Pattern'.
    const char *Pattern_Initializer[] = {
        "Modifier",
        "Key",
        "ModifierAndKey",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Pattern_InitializerValues[] = {
        uint8_t(KKeySequenceRecorder::Pattern::Modifier),      //  0x01  1
        uint8_t(KKeySequenceRecorder::Pattern::Key),           //  0x02  2
        uint8_t(KKeySequenceRecorder::Pattern::ModifierAndKey) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KKeySequenceRecorder_TypeF(),
        "1:KGuiAddons.KKeySequenceRecorder.Pattern",
        Pattern_Initializer, Pattern_InitializerValues);
    SbkKGuiAddonsTypeStructs[SBK_KKeySequenceRecorder_Pattern_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKGuiAddonsTypeStructs[SBK_QFlags_KKeySequenceRecorder_Pattern_IDX].type =
        EType;
    // Register converter for enum 'KKeySequenceRecorder::Pattern'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KKeySequenceRecorder_Pattern_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KKeySequenceRecorder_Pattern,
            is_Enum_PythonToCpp_KKeySequenceRecorder_Pattern_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KKeySequenceRecorder::Pattern");
        Shiboken::Conversions::registerConverterAlias(converter, "Pattern");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KKeySequenceRecorder_Pattern_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KKeySequenceRecorder_Pattern,
            is_Enum_PythonToCpp_KKeySequenceRecorder_Pattern_Convertible);
        // Register converter for flag 'QFlags<KKeySequenceRecorder::Pattern>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KKeySequenceRecorder::Pattern>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KKeySequenceRecorder::yes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Pattern' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KKeySequenceRecorder::staticMetaObject);
    qRegisterMetaType< ::KKeySequenceRecorder::Pattern >("KKeySequenceRecorder::Pattern");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KKeySequenceRecorder::staticMetaObject, sizeof(KKeySequenceRecorderWrapper));

    return pyType;
}
