/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * Sparc Disassembler                                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTableSparc32[] = {
/* 0 */       MCD::OPC_ExtractField, 30, 2,  // Inst{31-30} ...
/* 3 */       MCD::OPC_FilterValue, 0, 157, 1, // Skip to: 420
/* 7 */       MCD::OPC_ExtractField, 22, 3,  // Inst{24-22} ...
/* 10 */      MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 22
/* 14 */      MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 18 */      MCD::OPC_Decode, 204, 6, 0, // Opcode: UNIMP, DecodeIdx: 0
/* 22 */      MCD::OPC_FilterValue, 1, 101, 0, // Skip to: 127
/* 26 */      MCD::OPC_ExtractField, 19, 3,  // Inst{21-19} ...
/* 29 */      MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 54
/* 33 */      MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 36 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 46
/* 40 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 42 */      MCD::OPC_Decode, 252, 2, 1, // Opcode: BPICCNT, DecodeIdx: 1
/* 46 */      MCD::OPC_FilterValueOrFail, 1, 
/* 48 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 50 */      MCD::OPC_Decode, 251, 2, 1, // Opcode: BPICCANT, DecodeIdx: 1
/* 54 */      MCD::OPC_FilterValue, 1, 21, 0, // Skip to: 79
/* 58 */      MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 61 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 71
/* 65 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 67 */      MCD::OPC_Decode, 249, 2, 1, // Opcode: BPICC, DecodeIdx: 1
/* 71 */      MCD::OPC_FilterValueOrFail, 1, 
/* 73 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 75 */      MCD::OPC_Decode, 250, 2, 1, // Opcode: BPICCA, DecodeIdx: 1
/* 79 */      MCD::OPC_FilterValue, 4, 21, 0, // Skip to: 104
/* 83 */      MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 86 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 96
/* 90 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 92 */      MCD::OPC_Decode, 132, 3, 1, // Opcode: BPXCCNT, DecodeIdx: 1
/* 96 */      MCD::OPC_FilterValueOrFail, 1, 
/* 98 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 100 */     MCD::OPC_Decode, 131, 3, 1, // Opcode: BPXCCANT, DecodeIdx: 1
/* 104 */     MCD::OPC_FilterValueOrFail, 5, 
/* 106 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 109 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 119
/* 113 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 115 */     MCD::OPC_Decode, 129, 3, 1, // Opcode: BPXCC, DecodeIdx: 1
/* 119 */     MCD::OPC_FilterValueOrFail, 1, 
/* 121 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 123 */     MCD::OPC_Decode, 130, 3, 1, // Opcode: BPXCCA, DecodeIdx: 1
/* 127 */     MCD::OPC_FilterValue, 2, 27, 0, // Skip to: 158
/* 131 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 134 */     MCD::OPC_FilterValue, 0, 14, 0, // Skip to: 152
/* 138 */     MCD::OPC_CheckField, 25, 4, 8, 4, 0, // Skip to: 148
/* 144 */     MCD::OPC_Decode, 239, 2, 2, // Opcode: BA, DecodeIdx: 2
/* 148 */     MCD::OPC_Decode, 240, 2, 3, // Opcode: BCOND, DecodeIdx: 3
/* 152 */     MCD::OPC_FilterValueOrFail, 1, 
/* 154 */     MCD::OPC_Decode, 241, 2, 3, // Opcode: BCONDA, DecodeIdx: 3
/* 158 */     MCD::OPC_FilterValue, 3, 111, 0, // Skip to: 273
/* 162 */     MCD::OPC_ExtractField, 28, 1,  // Inst{28} ...
/* 165 */     MCD::OPC_FilterValue, 0, 51, 0, // Skip to: 220
/* 169 */     MCD::OPC_ExtractField, 19, 1,  // Inst{19} ...
/* 172 */     MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 197
/* 176 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 179 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 189
/* 183 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 185 */     MCD::OPC_Decode, 128, 3, 4, // Opcode: BPRNT, DecodeIdx: 4
/* 189 */     MCD::OPC_FilterValueOrFail, 1, 
/* 191 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 193 */     MCD::OPC_Decode, 255, 2, 4, // Opcode: BPRANT, DecodeIdx: 4
/* 197 */     MCD::OPC_FilterValueOrFail, 1, 
/* 199 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 202 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 212
/* 206 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 208 */     MCD::OPC_Decode, 253, 2, 4, // Opcode: BPR, DecodeIdx: 4
/* 212 */     MCD::OPC_FilterValueOrFail, 1, 
/* 214 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 216 */     MCD::OPC_Decode, 254, 2, 4, // Opcode: BPRA, DecodeIdx: 4
/* 220 */     MCD::OPC_FilterValueOrFail, 1, 
/* 222 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 225 */     MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 250
/* 229 */     MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 232 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 242
/* 236 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 238 */     MCD::OPC_Decode, 154, 3, 5, // Opcode: CWBCONDrr, DecodeIdx: 5
/* 242 */     MCD::OPC_FilterValueOrFail, 1, 
/* 244 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 246 */     MCD::OPC_Decode, 156, 3, 5, // Opcode: CXBCONDrr, DecodeIdx: 5
/* 250 */     MCD::OPC_FilterValueOrFail, 1, 
/* 252 */     MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 255 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 265
/* 259 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 261 */     MCD::OPC_Decode, 153, 3, 6, // Opcode: CWBCONDri, DecodeIdx: 6
/* 265 */     MCD::OPC_FilterValueOrFail, 1, 
/* 267 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 269 */     MCD::OPC_Decode, 155, 3, 6, // Opcode: CXBCONDri, DecodeIdx: 6
/* 273 */     MCD::OPC_FilterValue, 4, 20, 0, // Skip to: 297
/* 277 */     MCD::OPC_CheckField, 25, 5, 0, 10, 0, // Skip to: 293
/* 283 */     MCD::OPC_CheckField, 0, 22, 0, 4, 0, // Skip to: 293
/* 289 */     MCD::OPC_Decode, 169, 5, 7, // Opcode: NOP, DecodeIdx: 7
/* 293 */     MCD::OPC_Decode, 212, 5, 8, // Opcode: SETHIi, DecodeIdx: 8
/* 297 */     MCD::OPC_FilterValue, 5, 79, 0, // Skip to: 380
/* 301 */     MCD::OPC_ExtractField, 19, 1,  // Inst{19} ...
/* 304 */     MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 329
/* 308 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 311 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 321
/* 315 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 317 */     MCD::OPC_Decode, 248, 2, 9, // Opcode: BPFCCNT, DecodeIdx: 9
/* 321 */     MCD::OPC_FilterValueOrFail, 1, 
/* 323 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 325 */     MCD::OPC_Decode, 247, 2, 9, // Opcode: BPFCCANT, DecodeIdx: 9
/* 329 */     MCD::OPC_FilterValueOrFail, 1, 
/* 331 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 334 */     MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 358
/* 338 */     MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 352
/* 342 */     MCD::OPC_CheckField, 20, 2, 0, 4, 0, // Skip to: 352
/* 348 */     MCD::OPC_Decode, 190, 3, 1, // Opcode: FBCOND_V9, DecodeIdx: 1
/* 352 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 354 */     MCD::OPC_Decode, 245, 2, 9, // Opcode: BPFCC, DecodeIdx: 9
/* 358 */     MCD::OPC_FilterValueOrFail, 1, 
/* 360 */     MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 374
/* 364 */     MCD::OPC_CheckField, 20, 2, 0, 4, 0, // Skip to: 374
/* 370 */     MCD::OPC_Decode, 189, 3, 1, // Opcode: FBCONDA_V9, DecodeIdx: 1
/* 374 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 376 */     MCD::OPC_Decode, 246, 2, 9, // Opcode: BPFCCA, DecodeIdx: 9
/* 380 */     MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 401
/* 384 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 387 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 395
/* 391 */     MCD::OPC_Decode, 187, 3, 3, // Opcode: FBCOND, DecodeIdx: 3
/* 395 */     MCD::OPC_FilterValueOrFail, 1, 
/* 397 */     MCD::OPC_Decode, 188, 3, 3, // Opcode: FBCONDA, DecodeIdx: 3
/* 401 */     MCD::OPC_FilterValueOrFail, 7, 
/* 403 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 406 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 414
/* 410 */     MCD::OPC_Decode, 150, 3, 3, // Opcode: CPBCOND, DecodeIdx: 3
/* 414 */     MCD::OPC_FilterValueOrFail, 1, 
/* 416 */     MCD::OPC_Decode, 151, 3, 3, // Opcode: CPBCONDA, DecodeIdx: 3
/* 420 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 428
/* 424 */     MCD::OPC_Decode, 134, 3, 10, // Opcode: CALL, DecodeIdx: 10
/* 428 */     MCD::OPC_FilterValue, 2, 50, 18, // Skip to: 5090
/* 432 */     MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 435 */     MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 460
/* 439 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 442 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 454
/* 446 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 450 */     MCD::OPC_Decode, 213, 2, 11, // Opcode: ADDrr, DecodeIdx: 11
/* 454 */     MCD::OPC_FilterValueOrFail, 1, 
/* 456 */     MCD::OPC_Decode, 212, 2, 12, // Opcode: ADDri, DecodeIdx: 12
/* 460 */     MCD::OPC_FilterValue, 1, 21, 0, // Skip to: 485
/* 464 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 467 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 479
/* 471 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 475 */     MCD::OPC_Decode, 235, 2, 11, // Opcode: ANDrr, DecodeIdx: 11
/* 479 */     MCD::OPC_FilterValueOrFail, 1, 
/* 481 */     MCD::OPC_Decode, 234, 2, 12, // Opcode: ANDri, DecodeIdx: 12
/* 485 */     MCD::OPC_FilterValue, 2, 21, 0, // Skip to: 510
/* 489 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 492 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 504
/* 496 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 500 */     MCD::OPC_Decode, 178, 5, 11, // Opcode: ORrr, DecodeIdx: 11
/* 504 */     MCD::OPC_FilterValueOrFail, 1, 
/* 506 */     MCD::OPC_Decode, 177, 5, 12, // Opcode: ORri, DecodeIdx: 12
/* 510 */     MCD::OPC_FilterValue, 3, 21, 0, // Skip to: 535
/* 514 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 517 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 529
/* 521 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 525 */     MCD::OPC_Decode, 235, 6, 11, // Opcode: XORrr, DecodeIdx: 11
/* 529 */     MCD::OPC_FilterValueOrFail, 1, 
/* 531 */     MCD::OPC_Decode, 234, 6, 12, // Opcode: XORri, DecodeIdx: 12
/* 535 */     MCD::OPC_FilterValue, 4, 21, 0, // Skip to: 560
/* 539 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 542 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 554
/* 546 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 550 */     MCD::OPC_Decode, 163, 6, 11, // Opcode: SUBrr, DecodeIdx: 11
/* 554 */     MCD::OPC_FilterValueOrFail, 1, 
/* 556 */     MCD::OPC_Decode, 162, 6, 12, // Opcode: SUBri, DecodeIdx: 12
/* 560 */     MCD::OPC_FilterValue, 5, 21, 0, // Skip to: 585
/* 564 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 567 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 579
/* 571 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 575 */     MCD::OPC_Decode, 233, 2, 11, // Opcode: ANDNrr, DecodeIdx: 11
/* 579 */     MCD::OPC_FilterValueOrFail, 1, 
/* 581 */     MCD::OPC_Decode, 232, 2, 12, // Opcode: ANDNri, DecodeIdx: 12
/* 585 */     MCD::OPC_FilterValue, 6, 21, 0, // Skip to: 610
/* 589 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 592 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 604
/* 596 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 600 */     MCD::OPC_Decode, 176, 5, 11, // Opcode: ORNrr, DecodeIdx: 11
/* 604 */     MCD::OPC_FilterValueOrFail, 1, 
/* 606 */     MCD::OPC_Decode, 175, 5, 12, // Opcode: ORNri, DecodeIdx: 12
/* 610 */     MCD::OPC_FilterValue, 7, 21, 0, // Skip to: 635
/* 614 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 617 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 629
/* 621 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 625 */     MCD::OPC_Decode, 231, 6, 11, // Opcode: XNORrr, DecodeIdx: 11
/* 629 */     MCD::OPC_FilterValueOrFail, 1, 
/* 631 */     MCD::OPC_Decode, 230, 6, 12, // Opcode: XNORri, DecodeIdx: 12
/* 635 */     MCD::OPC_FilterValue, 8, 21, 0, // Skip to: 660
/* 639 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 642 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 654
/* 646 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 650 */     MCD::OPC_Decode, 207, 2, 11, // Opcode: ADDCrr, DecodeIdx: 11
/* 654 */     MCD::OPC_FilterValueOrFail, 1, 
/* 656 */     MCD::OPC_Decode, 206, 2, 12, // Opcode: ADDCri, DecodeIdx: 12
/* 660 */     MCD::OPC_FilterValue, 9, 25, 0, // Skip to: 689
/* 664 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 667 */     MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 681
/* 671 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 673 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 677 */     MCD::OPC_Decode, 168, 5, 13, // Opcode: MULXrr, DecodeIdx: 13
/* 681 */     MCD::OPC_FilterValueOrFail, 1, 
/* 683 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 685 */     MCD::OPC_Decode, 167, 5, 14, // Opcode: MULXri, DecodeIdx: 14
/* 689 */     MCD::OPC_FilterValue, 10, 21, 0, // Skip to: 714
/* 693 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 696 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 708
/* 700 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 704 */     MCD::OPC_Decode, 203, 6, 11, // Opcode: UMULrr, DecodeIdx: 11
/* 708 */     MCD::OPC_FilterValueOrFail, 1, 
/* 710 */     MCD::OPC_Decode, 202, 6, 12, // Opcode: UMULri, DecodeIdx: 12
/* 714 */     MCD::OPC_FilterValue, 11, 21, 0, // Skip to: 739
/* 718 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 721 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 733
/* 725 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 729 */     MCD::OPC_Decode, 228, 5, 11, // Opcode: SMULrr, DecodeIdx: 11
/* 733 */     MCD::OPC_FilterValueOrFail, 1, 
/* 735 */     MCD::OPC_Decode, 227, 5, 12, // Opcode: SMULri, DecodeIdx: 12
/* 739 */     MCD::OPC_FilterValue, 12, 21, 0, // Skip to: 764
/* 743 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 746 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 758
/* 750 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 754 */     MCD::OPC_Decode, 159, 6, 11, // Opcode: SUBCrr, DecodeIdx: 11
/* 758 */     MCD::OPC_FilterValueOrFail, 1, 
/* 760 */     MCD::OPC_Decode, 158, 6, 12, // Opcode: SUBCri, DecodeIdx: 12
/* 764 */     MCD::OPC_FilterValue, 13, 25, 0, // Skip to: 793
/* 768 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 771 */     MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 785
/* 775 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 777 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 781 */     MCD::OPC_Decode, 194, 6, 13, // Opcode: UDIVXrr, DecodeIdx: 13
/* 785 */     MCD::OPC_FilterValueOrFail, 1, 
/* 787 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 789 */     MCD::OPC_Decode, 193, 6, 14, // Opcode: UDIVXri, DecodeIdx: 14
/* 793 */     MCD::OPC_FilterValue, 14, 21, 0, // Skip to: 818
/* 797 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 800 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 812
/* 804 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 808 */     MCD::OPC_Decode, 196, 6, 11, // Opcode: UDIVrr, DecodeIdx: 11
/* 812 */     MCD::OPC_FilterValueOrFail, 1, 
/* 814 */     MCD::OPC_Decode, 195, 6, 12, // Opcode: UDIVri, DecodeIdx: 12
/* 818 */     MCD::OPC_FilterValue, 15, 21, 0, // Skip to: 843
/* 822 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 825 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 837
/* 829 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 833 */     MCD::OPC_Decode, 211, 5, 11, // Opcode: SDIVrr, DecodeIdx: 11
/* 837 */     MCD::OPC_FilterValueOrFail, 1, 
/* 839 */     MCD::OPC_Decode, 210, 5, 12, // Opcode: SDIVri, DecodeIdx: 12
/* 843 */     MCD::OPC_FilterValue, 16, 21, 0, // Skip to: 868
/* 847 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 850 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 862
/* 854 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 858 */     MCD::OPC_Decode, 205, 2, 11, // Opcode: ADDCCrr, DecodeIdx: 11
/* 862 */     MCD::OPC_FilterValueOrFail, 1, 
/* 864 */     MCD::OPC_Decode, 204, 2, 12, // Opcode: ADDCCri, DecodeIdx: 12
/* 868 */     MCD::OPC_FilterValue, 17, 21, 0, // Skip to: 893
/* 872 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 875 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 887
/* 879 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 883 */     MCD::OPC_Decode, 229, 2, 11, // Opcode: ANDCCrr, DecodeIdx: 11
/* 887 */     MCD::OPC_FilterValueOrFail, 1, 
/* 889 */     MCD::OPC_Decode, 228, 2, 12, // Opcode: ANDCCri, DecodeIdx: 12
/* 893 */     MCD::OPC_FilterValue, 18, 21, 0, // Skip to: 918
/* 897 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 900 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 912
/* 904 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 908 */     MCD::OPC_Decode, 172, 5, 11, // Opcode: ORCCrr, DecodeIdx: 11
/* 912 */     MCD::OPC_FilterValueOrFail, 1, 
/* 914 */     MCD::OPC_Decode, 171, 5, 12, // Opcode: ORCCri, DecodeIdx: 12
/* 918 */     MCD::OPC_FilterValue, 19, 21, 0, // Skip to: 943
/* 922 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 925 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 937
/* 929 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 933 */     MCD::OPC_Decode, 233, 6, 11, // Opcode: XORCCrr, DecodeIdx: 11
/* 937 */     MCD::OPC_FilterValueOrFail, 1, 
/* 939 */     MCD::OPC_Decode, 232, 6, 12, // Opcode: XORCCri, DecodeIdx: 12
/* 943 */     MCD::OPC_FilterValue, 20, 21, 0, // Skip to: 968
/* 947 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 950 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 962
/* 954 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 958 */     MCD::OPC_Decode, 157, 6, 11, // Opcode: SUBCCrr, DecodeIdx: 11
/* 962 */     MCD::OPC_FilterValueOrFail, 1, 
/* 964 */     MCD::OPC_Decode, 156, 6, 12, // Opcode: SUBCCri, DecodeIdx: 12
/* 968 */     MCD::OPC_FilterValue, 21, 21, 0, // Skip to: 993
/* 972 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 975 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 987
/* 979 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 983 */     MCD::OPC_Decode, 231, 2, 11, // Opcode: ANDNCCrr, DecodeIdx: 11
/* 987 */     MCD::OPC_FilterValueOrFail, 1, 
/* 989 */     MCD::OPC_Decode, 230, 2, 12, // Opcode: ANDNCCri, DecodeIdx: 12
/* 993 */     MCD::OPC_FilterValue, 22, 21, 0, // Skip to: 1018
/* 997 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1000 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1012
/* 1004 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1008 */    MCD::OPC_Decode, 174, 5, 11, // Opcode: ORNCCrr, DecodeIdx: 11
/* 1012 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1014 */    MCD::OPC_Decode, 173, 5, 12, // Opcode: ORNCCri, DecodeIdx: 12
/* 1018 */    MCD::OPC_FilterValue, 23, 21, 0, // Skip to: 1043
/* 1022 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1025 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1037
/* 1029 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1033 */    MCD::OPC_Decode, 229, 6, 11, // Opcode: XNORCCrr, DecodeIdx: 11
/* 1037 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1039 */    MCD::OPC_Decode, 228, 6, 12, // Opcode: XNORCCri, DecodeIdx: 12
/* 1043 */    MCD::OPC_FilterValue, 24, 21, 0, // Skip to: 1068
/* 1047 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1050 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1062
/* 1054 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1058 */    MCD::OPC_Decode, 209, 2, 11, // Opcode: ADDErr, DecodeIdx: 11
/* 1062 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1064 */    MCD::OPC_Decode, 208, 2, 12, // Opcode: ADDEri, DecodeIdx: 12
/* 1068 */    MCD::OPC_FilterValue, 25, 111, 0, // Skip to: 1183
/* 1072 */    MCD::OPC_ExtractField, 5, 4,  // Inst{8-5} ...
/* 1075 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1085
/* 1079 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1081 */    MCD::OPC_Decode, 218, 2, 15, // Opcode: AES_EROUND01, DecodeIdx: 15
/* 1085 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1095
/* 1089 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1091 */    MCD::OPC_Decode, 220, 2, 15, // Opcode: AES_EROUND23, DecodeIdx: 15
/* 1095 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1105
/* 1099 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1101 */    MCD::OPC_Decode, 214, 2, 15, // Opcode: AES_DROUND01, DecodeIdx: 15
/* 1105 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1115
/* 1109 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1111 */    MCD::OPC_Decode, 216, 2, 15, // Opcode: AES_DROUND23, DecodeIdx: 15
/* 1115 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1125
/* 1119 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1121 */    MCD::OPC_Decode, 219, 2, 15, // Opcode: AES_EROUND01_LAST, DecodeIdx: 15
/* 1125 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1135
/* 1129 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1131 */    MCD::OPC_Decode, 221, 2, 15, // Opcode: AES_EROUND23_LAST, DecodeIdx: 15
/* 1135 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1145
/* 1139 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1141 */    MCD::OPC_Decode, 215, 2, 15, // Opcode: AES_DROUND01_LAST, DecodeIdx: 15
/* 1145 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1155
/* 1149 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1151 */    MCD::OPC_Decode, 217, 2, 15, // Opcode: AES_DROUND23_LAST, DecodeIdx: 15
/* 1155 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 1165
/* 1159 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1161 */    MCD::OPC_Decode, 223, 2, 16, // Opcode: AES_KEXPAND1, DecodeIdx: 16
/* 1165 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 1175
/* 1169 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1171 */    MCD::OPC_Decode, 160, 3, 15, // Opcode: DES_ROUND, DecodeIdx: 15
/* 1175 */    MCD::OPC_FilterValueOrFail, 12, 
/* 1177 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 1179 */    MCD::OPC_Decode, 140, 3, 15, // Opcode: CAMELLIA_F, DecodeIdx: 15
/* 1183 */    MCD::OPC_FilterValue, 26, 21, 0, // Skip to: 1208
/* 1187 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1190 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1202
/* 1194 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1198 */    MCD::OPC_Decode, 200, 6, 11, // Opcode: UMULCCrr, DecodeIdx: 11
/* 1202 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1204 */    MCD::OPC_Decode, 199, 6, 12, // Opcode: UMULCCri, DecodeIdx: 12
/* 1208 */    MCD::OPC_FilterValue, 27, 21, 0, // Skip to: 1233
/* 1212 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1215 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1227
/* 1219 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1223 */    MCD::OPC_Decode, 226, 5, 11, // Opcode: SMULCCrr, DecodeIdx: 11
/* 1227 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1229 */    MCD::OPC_Decode, 225, 5, 12, // Opcode: SMULCCri, DecodeIdx: 12
/* 1233 */    MCD::OPC_FilterValue, 28, 21, 0, // Skip to: 1258
/* 1237 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1240 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1252
/* 1244 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1248 */    MCD::OPC_Decode, 161, 6, 11, // Opcode: SUBErr, DecodeIdx: 11
/* 1252 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1254 */    MCD::OPC_Decode, 160, 6, 12, // Opcode: SUBEri, DecodeIdx: 12
/* 1258 */    MCD::OPC_FilterValue, 30, 21, 0, // Skip to: 1283
/* 1262 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1265 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1277
/* 1269 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1273 */    MCD::OPC_Decode, 192, 6, 11, // Opcode: UDIVCCrr, DecodeIdx: 11
/* 1277 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1279 */    MCD::OPC_Decode, 191, 6, 12, // Opcode: UDIVCCri, DecodeIdx: 12
/* 1283 */    MCD::OPC_FilterValue, 31, 21, 0, // Skip to: 1308
/* 1287 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1290 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1302
/* 1294 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1298 */    MCD::OPC_Decode, 207, 5, 11, // Opcode: SDIVCCrr, DecodeIdx: 11
/* 1302 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1304 */    MCD::OPC_Decode, 206, 5, 12, // Opcode: SDIVCCri, DecodeIdx: 12
/* 1308 */    MCD::OPC_FilterValue, 32, 21, 0, // Skip to: 1333
/* 1312 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1315 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1327
/* 1319 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1323 */    MCD::OPC_Decode, 174, 6, 11, // Opcode: TADDCCrr, DecodeIdx: 11
/* 1327 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1329 */    MCD::OPC_Decode, 173, 6, 12, // Opcode: TADDCCri, DecodeIdx: 12
/* 1333 */    MCD::OPC_FilterValue, 33, 21, 0, // Skip to: 1358
/* 1337 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1340 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1352
/* 1344 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1348 */    MCD::OPC_Decode, 188, 6, 11, // Opcode: TSUBCCrr, DecodeIdx: 11
/* 1352 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1354 */    MCD::OPC_Decode, 187, 6, 12, // Opcode: TSUBCCri, DecodeIdx: 12
/* 1358 */    MCD::OPC_FilterValue, 34, 21, 0, // Skip to: 1383
/* 1362 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1365 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1377
/* 1369 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1373 */    MCD::OPC_Decode, 172, 6, 11, // Opcode: TADDCCTVrr, DecodeIdx: 11
/* 1377 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1379 */    MCD::OPC_Decode, 171, 6, 12, // Opcode: TADDCCTVri, DecodeIdx: 12
/* 1383 */    MCD::OPC_FilterValue, 35, 21, 0, // Skip to: 1408
/* 1387 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1390 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1402
/* 1394 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1398 */    MCD::OPC_Decode, 186, 6, 11, // Opcode: TSUBCCTVrr, DecodeIdx: 11
/* 1402 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1404 */    MCD::OPC_Decode, 185, 6, 12, // Opcode: TSUBCCTVri, DecodeIdx: 12
/* 1408 */    MCD::OPC_FilterValue, 36, 21, 0, // Skip to: 1433
/* 1412 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1415 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1427
/* 1419 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1423 */    MCD::OPC_Decode, 166, 5, 11, // Opcode: MULSCCrr, DecodeIdx: 11
/* 1427 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1429 */    MCD::OPC_Decode, 165, 5, 12, // Opcode: MULSCCri, DecodeIdx: 12
/* 1433 */    MCD::OPC_FilterValue, 37, 37, 0, // Skip to: 1474
/* 1437 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1440 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1448
/* 1444 */    MCD::OPC_Decode, 222, 5, 11, // Opcode: SLLrr, DecodeIdx: 11
/* 1448 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1458
/* 1452 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1454 */    MCD::OPC_Decode, 220, 5, 17, // Opcode: SLLXrr, DecodeIdx: 17
/* 1458 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1466
/* 1462 */    MCD::OPC_Decode, 221, 5, 18, // Opcode: SLLri, DecodeIdx: 18
/* 1466 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1468 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1470 */    MCD::OPC_Decode, 219, 5, 19, // Opcode: SLLXri, DecodeIdx: 19
/* 1474 */    MCD::OPC_FilterValue, 38, 37, 0, // Skip to: 1515
/* 1478 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1481 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1489
/* 1485 */    MCD::OPC_Decode, 236, 5, 11, // Opcode: SRLrr, DecodeIdx: 11
/* 1489 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1499
/* 1493 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1495 */    MCD::OPC_Decode, 234, 5, 17, // Opcode: SRLXrr, DecodeIdx: 17
/* 1499 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1507
/* 1503 */    MCD::OPC_Decode, 235, 5, 18, // Opcode: SRLri, DecodeIdx: 18
/* 1507 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1509 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1511 */    MCD::OPC_Decode, 233, 5, 19, // Opcode: SRLXri, DecodeIdx: 19
/* 1515 */    MCD::OPC_FilterValue, 39, 37, 0, // Skip to: 1556
/* 1519 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1522 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1530
/* 1526 */    MCD::OPC_Decode, 232, 5, 11, // Opcode: SRArr, DecodeIdx: 11
/* 1530 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1540
/* 1534 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1536 */    MCD::OPC_Decode, 230, 5, 17, // Opcode: SRAXrr, DecodeIdx: 17
/* 1540 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1548
/* 1544 */    MCD::OPC_Decode, 231, 5, 18, // Opcode: SRAri, DecodeIdx: 18
/* 1548 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1550 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1552 */    MCD::OPC_Decode, 229, 5, 19, // Opcode: SRAXri, DecodeIdx: 19
/* 1556 */    MCD::OPC_FilterValue, 40, 48, 0, // Skip to: 1608
/* 1560 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1563 */    MCD::OPC_FilterValue, 0, 25, 0, // Skip to: 1592
/* 1567 */    MCD::OPC_ExtractField, 0, 13,  // Inst{12-0} ...
/* 1570 */    MCD::OPC_FilterValueOrFail, 0, 
/* 1572 */    MCD::OPC_CheckField, 25, 5, 0, 10, 0, // Skip to: 1588
/* 1578 */    MCD::OPC_CheckField, 14, 5, 15, 4, 0, // Skip to: 1588
/* 1584 */    MCD::OPC_Decode, 239, 5, 7, // Opcode: STBAR, DecodeIdx: 7
/* 1588 */    MCD::OPC_Decode, 189, 5, 20, // Opcode: RDASR, DecodeIdx: 20
/* 1592 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1594 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1596 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 1600 */    MCD::OPC_CheckFieldOrFail, 14, 5, 15, 
/* 1604 */    MCD::OPC_Decode, 148, 5, 21, // Opcode: MEMBARi, DecodeIdx: 21
/* 1608 */    MCD::OPC_FilterValue, 41, 8, 0, // Skip to: 1620
/* 1612 */    MCD::OPC_CheckFieldOrFail, 0, 19, 0, 
/* 1616 */    MCD::OPC_Decode, 192, 5, 22, // Opcode: RDPSR, DecodeIdx: 22
/* 1620 */    MCD::OPC_FilterValue, 42, 34, 0, // Skip to: 1658
/* 1624 */    MCD::OPC_ExtractField, 0, 14,  // Inst{13-0} ...
/* 1627 */    MCD::OPC_FilterValueOrFail, 0, 
/* 1629 */    MCD::OPC_ExtractField, 14, 5,  // Inst{18-14} ...
/* 1632 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1640
/* 1636 */    MCD::OPC_Decode, 194, 5, 22, // Opcode: RDWIM, DecodeIdx: 22
/* 1640 */    MCD::OPC_FilterValue, 15, 8, 0, // Skip to: 1652
/* 1644 */    MCD::OPC_CheckPredicate, 0, 4, 0, // Skip to: 1652
/* 1648 */    MCD::OPC_Decode, 190, 5, 22, // Opcode: RDFQ, DecodeIdx: 22
/* 1652 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1654 */    MCD::OPC_Decode, 191, 5, 23, // Opcode: RDPR, DecodeIdx: 23
/* 1658 */    MCD::OPC_FilterValue, 43, 23, 0, // Skip to: 1685
/* 1662 */    MCD::OPC_ExtractField, 0, 19,  // Inst{18-0} ...
/* 1665 */    MCD::OPC_FilterValueOrFail, 0, 
/* 1667 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 1681
/* 1671 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, // Skip to: 1681
/* 1677 */    MCD::OPC_Decode, 225, 3, 7, // Opcode: FLUSHW, DecodeIdx: 7
/* 1681 */    MCD::OPC_Decode, 193, 5, 22, // Opcode: RDTBR, DecodeIdx: 22
/* 1685 */    MCD::OPC_FilterValue, 44, 109, 0, // Skip to: 1798
/* 1689 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1692 */    MCD::OPC_FilterValue, 0, 50, 0, // Skip to: 1746
/* 1696 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 1699 */    MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 1723
/* 1703 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 1717
/* 1707 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 1717
/* 1713 */    MCD::OPC_Decode, 153, 5, 24, // Opcode: MOVFCCrr, DecodeIdx: 24
/* 1717 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1719 */    MCD::OPC_Decode, 215, 6, 25, // Opcode: V9MOVFCCrr, DecodeIdx: 25
/* 1723 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1725 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 1728 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1738
/* 1732 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1734 */    MCD::OPC_Decode, 155, 5, 24, // Opcode: MOVICCrr, DecodeIdx: 24
/* 1738 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1740 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1742 */    MCD::OPC_Decode, 162, 5, 24, // Opcode: MOVXCCrr, DecodeIdx: 24
/* 1746 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1748 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 1751 */    MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 1775
/* 1755 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 1769
/* 1759 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 1769
/* 1765 */    MCD::OPC_Decode, 152, 5, 26, // Opcode: MOVFCCri, DecodeIdx: 26
/* 1769 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1771 */    MCD::OPC_Decode, 214, 6, 27, // Opcode: V9MOVFCCri, DecodeIdx: 27
/* 1775 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1777 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 1780 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1790
/* 1784 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1786 */    MCD::OPC_Decode, 154, 5, 26, // Opcode: MOVICCri, DecodeIdx: 26
/* 1790 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1792 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1794 */    MCD::OPC_Decode, 161, 5, 26, // Opcode: MOVXCCri, DecodeIdx: 26
/* 1798 */    MCD::OPC_FilterValue, 45, 25, 0, // Skip to: 1827
/* 1802 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1805 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1819
/* 1809 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1811 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1815 */    MCD::OPC_Decode, 209, 5, 13, // Opcode: SDIVXrr, DecodeIdx: 13
/* 1819 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1821 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1823 */    MCD::OPC_Decode, 208, 5, 14, // Opcode: SDIVXri, DecodeIdx: 14
/* 1827 */    MCD::OPC_FilterValue, 46, 10, 0, // Skip to: 1841
/* 1831 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1833 */    MCD::OPC_CheckFieldOrFail, 5, 14, 0, 
/* 1837 */    MCD::OPC_Decode, 182, 5, 28, // Opcode: POPCrr, DecodeIdx: 28
/* 1841 */    MCD::OPC_FilterValue, 47, 25, 0, // Skip to: 1870
/* 1845 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1848 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1862
/* 1852 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1854 */    MCD::OPC_CheckFieldOrFail, 5, 5, 0, 
/* 1858 */    MCD::OPC_Decode, 157, 5, 29, // Opcode: MOVRrr, DecodeIdx: 29
/* 1862 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1864 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1866 */    MCD::OPC_Decode, 156, 5, 30, // Opcode: MOVRri, DecodeIdx: 30
/* 1870 */    MCD::OPC_FilterValue, 48, 41, 0, // Skip to: 1915
/* 1874 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1877 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1889
/* 1881 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 1885 */    MCD::OPC_Decode, 217, 6, 31, // Opcode: WRASRrr, DecodeIdx: 31
/* 1889 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1891 */    MCD::OPC_CheckPredicate, 0, 16, 0, // Skip to: 1911
/* 1895 */    MCD::OPC_CheckField, 25, 5, 15, 10, 0, // Skip to: 1911
/* 1901 */    MCD::OPC_CheckField, 14, 5, 0, 4, 0, // Skip to: 1911
/* 1907 */    MCD::OPC_Decode, 218, 5, 32, // Opcode: SIR, DecodeIdx: 32
/* 1911 */    MCD::OPC_Decode, 216, 6, 33, // Opcode: WRASRri, DecodeIdx: 33
/* 1915 */    MCD::OPC_FilterValue, 49, 153, 0, // Skip to: 2072
/* 1919 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 1922 */    MCD::OPC_FilterValue, 0, 42, 0, // Skip to: 1968
/* 1926 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1929 */    MCD::OPC_FilterValue, 0, 29, 0, // Skip to: 1962
/* 1933 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 1936 */    MCD::OPC_FilterValueOrFail, 0, 
/* 1938 */    MCD::OPC_CheckPredicate, 0, 16, 0, // Skip to: 1958
/* 1942 */    MCD::OPC_CheckField, 14, 5, 0, 10, 0, // Skip to: 1958
/* 1948 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, // Skip to: 1958
/* 1954 */    MCD::OPC_Decode, 203, 5, 7, // Opcode: SAVED, DecodeIdx: 7
/* 1958 */    MCD::OPC_Decode, 221, 6, 34, // Opcode: WRPSRrr, DecodeIdx: 34
/* 1962 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1964 */    MCD::OPC_Decode, 220, 6, 35, // Opcode: WRPSRri, DecodeIdx: 35
/* 1968 */    MCD::OPC_FilterValue, 1, 46, 0, // Skip to: 2018
/* 1972 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1975 */    MCD::OPC_FilterValue, 0, 31, 0, // Skip to: 2010
/* 1979 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 1982 */    MCD::OPC_FilterValueOrFail, 0, 
/* 1984 */    MCD::OPC_CheckPredicate, 0, 16, 0, // Skip to: 2004
/* 1988 */    MCD::OPC_CheckField, 14, 5, 0, 10, 0, // Skip to: 2004
/* 1994 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, // Skip to: 2004
/* 2000 */    MCD::OPC_Decode, 195, 5, 7, // Opcode: RESTORED, DecodeIdx: 7
/* 2004 */    MCD::OPC_CheckPredicateOrFail, 3, 
/* 2006 */    MCD::OPC_Decode, 188, 5, 34, // Opcode: PWRPSRrr, DecodeIdx: 34
/* 2010 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2012 */    MCD::OPC_CheckPredicateOrFail, 3, 
/* 2014 */    MCD::OPC_Decode, 187, 5, 35, // Opcode: PWRPSRri, DecodeIdx: 35
/* 2018 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 2032
/* 2022 */    MCD::OPC_CheckPredicateOrFail, 4, 
/* 2024 */    MCD::OPC_CheckFieldOrFail, 0, 19, 0, 
/* 2028 */    MCD::OPC_Decode, 227, 2, 7, // Opcode: ALLCLEAN, DecodeIdx: 7
/* 2032 */    MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 2046
/* 2036 */    MCD::OPC_CheckPredicateOrFail, 4, 
/* 2038 */    MCD::OPC_CheckFieldOrFail, 0, 19, 0, 
/* 2042 */    MCD::OPC_Decode, 179, 5, 7, // Opcode: OTHERW, DecodeIdx: 7
/* 2046 */    MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 2060
/* 2050 */    MCD::OPC_CheckPredicateOrFail, 4, 
/* 2052 */    MCD::OPC_CheckFieldOrFail, 0, 19, 0, 
/* 2056 */    MCD::OPC_Decode, 170, 5, 7, // Opcode: NORMALW, DecodeIdx: 7
/* 2060 */    MCD::OPC_FilterValueOrFail, 5, 
/* 2062 */    MCD::OPC_CheckPredicateOrFail, 4, 
/* 2064 */    MCD::OPC_CheckFieldOrFail, 0, 19, 0, 
/* 2068 */    MCD::OPC_Decode, 213, 4, 7, // Opcode: INVALW, DecodeIdx: 7
/* 2072 */    MCD::OPC_FilterValue, 50, 46, 0, // Skip to: 2122
/* 2076 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2079 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 2104
/* 2083 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 2086 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2088 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, // Skip to: 2098
/* 2094 */    MCD::OPC_Decode, 225, 6, 34, // Opcode: WRWIMrr, DecodeIdx: 34
/* 2098 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2100 */    MCD::OPC_Decode, 219, 6, 36, // Opcode: WRPRrr, DecodeIdx: 36
/* 2104 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2106 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, // Skip to: 2116
/* 2112 */    MCD::OPC_Decode, 224, 6, 35, // Opcode: WRWIMri, DecodeIdx: 35
/* 2116 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2118 */    MCD::OPC_Decode, 218, 6, 37, // Opcode: WRPRri, DecodeIdx: 37
/* 2122 */    MCD::OPC_FilterValue, 51, 29, 0, // Skip to: 2155
/* 2126 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2129 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 2145
/* 2133 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 2137 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 2141 */    MCD::OPC_Decode, 223, 6, 34, // Opcode: WRTBRrr, DecodeIdx: 34
/* 2145 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2147 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 2151 */    MCD::OPC_Decode, 222, 6, 35, // Opcode: WRTBRri, DecodeIdx: 35
/* 2155 */    MCD::OPC_FilterValue, 52, 113, 2, // Skip to: 2784
/* 2159 */    MCD::OPC_ExtractField, 5, 9,  // Inst{13-5} ...
/* 2162 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 2174
/* 2166 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2170 */    MCD::OPC_Decode, 242, 3, 38, // Opcode: FMOVS, DecodeIdx: 38
/* 2174 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 2188
/* 2178 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2180 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2184 */    MCD::OPC_Decode, 231, 3, 39, // Opcode: FMOVD, DecodeIdx: 39
/* 2188 */    MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 2202
/* 2192 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2194 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2198 */    MCD::OPC_Decode, 235, 3, 40, // Opcode: FMOVQ, DecodeIdx: 40
/* 2202 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 2214
/* 2206 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2210 */    MCD::OPC_Decode, 136, 4, 38, // Opcode: FNEGS, DecodeIdx: 38
/* 2214 */    MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 2228
/* 2218 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2220 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2224 */    MCD::OPC_Decode, 134, 4, 39, // Opcode: FNEGD, DecodeIdx: 39
/* 2228 */    MCD::OPC_FilterValue, 7, 10, 0, // Skip to: 2242
/* 2232 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2234 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2238 */    MCD::OPC_Decode, 135, 4, 40, // Opcode: FNEGQ, DecodeIdx: 40
/* 2242 */    MCD::OPC_FilterValue, 9, 8, 0, // Skip to: 2254
/* 2246 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2250 */    MCD::OPC_Decode, 176, 3, 38, // Opcode: FABSS, DecodeIdx: 38
/* 2254 */    MCD::OPC_FilterValue, 10, 10, 0, // Skip to: 2268
/* 2258 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2260 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2264 */    MCD::OPC_Decode, 174, 3, 39, // Opcode: FABSD, DecodeIdx: 39
/* 2268 */    MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 2282
/* 2272 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2274 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2278 */    MCD::OPC_Decode, 175, 3, 40, // Opcode: FABSQ, DecodeIdx: 40
/* 2282 */    MCD::OPC_FilterValue, 41, 8, 0, // Skip to: 2294
/* 2286 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2290 */    MCD::OPC_Decode, 186, 4, 38, // Opcode: FSQRTS, DecodeIdx: 38
/* 2294 */    MCD::OPC_FilterValue, 42, 8, 0, // Skip to: 2306
/* 2298 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2302 */    MCD::OPC_Decode, 184, 4, 39, // Opcode: FSQRTD, DecodeIdx: 39
/* 2306 */    MCD::OPC_FilterValue, 43, 8, 0, // Skip to: 2318
/* 2310 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2314 */    MCD::OPC_Decode, 185, 4, 40, // Opcode: FSQRTQ, DecodeIdx: 40
/* 2318 */    MCD::OPC_FilterValue, 65, 4, 0, // Skip to: 2326
/* 2322 */    MCD::OPC_Decode, 179, 3, 41, // Opcode: FADDS, DecodeIdx: 41
/* 2326 */    MCD::OPC_FilterValue, 66, 4, 0, // Skip to: 2334
/* 2330 */    MCD::OPC_Decode, 177, 3, 42, // Opcode: FADDD, DecodeIdx: 42
/* 2334 */    MCD::OPC_FilterValue, 67, 4, 0, // Skip to: 2342
/* 2338 */    MCD::OPC_Decode, 178, 3, 43, // Opcode: FADDQ, DecodeIdx: 43
/* 2342 */    MCD::OPC_FilterValue, 69, 4, 0, // Skip to: 2350
/* 2346 */    MCD::OPC_Decode, 201, 4, 41, // Opcode: FSUBS, DecodeIdx: 41
/* 2350 */    MCD::OPC_FilterValue, 70, 4, 0, // Skip to: 2358
/* 2354 */    MCD::OPC_Decode, 199, 4, 42, // Opcode: FSUBD, DecodeIdx: 42
/* 2358 */    MCD::OPC_FilterValue, 71, 4, 0, // Skip to: 2366
/* 2362 */    MCD::OPC_Decode, 200, 4, 43, // Opcode: FSUBQ, DecodeIdx: 43
/* 2366 */    MCD::OPC_FilterValue, 73, 4, 0, // Skip to: 2374
/* 2370 */    MCD::OPC_Decode, 129, 4, 41, // Opcode: FMULS, DecodeIdx: 41
/* 2374 */    MCD::OPC_FilterValue, 74, 4, 0, // Skip to: 2382
/* 2378 */    MCD::OPC_Decode, 253, 3, 42, // Opcode: FMULD, DecodeIdx: 42
/* 2382 */    MCD::OPC_FilterValue, 75, 4, 0, // Skip to: 2390
/* 2386 */    MCD::OPC_Decode, 128, 4, 43, // Opcode: FMULQ, DecodeIdx: 43
/* 2390 */    MCD::OPC_FilterValue, 77, 4, 0, // Skip to: 2398
/* 2394 */    MCD::OPC_Decode, 208, 3, 41, // Opcode: FDIVS, DecodeIdx: 41
/* 2398 */    MCD::OPC_FilterValue, 78, 4, 0, // Skip to: 2406
/* 2402 */    MCD::OPC_Decode, 206, 3, 42, // Opcode: FDIVD, DecodeIdx: 42
/* 2406 */    MCD::OPC_FilterValue, 79, 4, 0, // Skip to: 2414
/* 2410 */    MCD::OPC_Decode, 207, 3, 43, // Opcode: FDIVQ, DecodeIdx: 43
/* 2414 */    MCD::OPC_FilterValue, 81, 6, 0, // Skip to: 2424
/* 2418 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2420 */    MCD::OPC_Decode, 131, 4, 41, // Opcode: FNADDS, DecodeIdx: 41
/* 2424 */    MCD::OPC_FilterValue, 82, 6, 0, // Skip to: 2434
/* 2428 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2430 */    MCD::OPC_Decode, 130, 4, 42, // Opcode: FNADDD, DecodeIdx: 42
/* 2434 */    MCD::OPC_FilterValue, 89, 6, 0, // Skip to: 2444
/* 2438 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2440 */    MCD::OPC_Decode, 144, 4, 41, // Opcode: FNMULS, DecodeIdx: 41
/* 2444 */    MCD::OPC_FilterValue, 90, 6, 0, // Skip to: 2454
/* 2448 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2450 */    MCD::OPC_Decode, 143, 4, 42, // Opcode: FNMULD, DecodeIdx: 42
/* 2454 */    MCD::OPC_FilterValue, 97, 6, 0, // Skip to: 2464
/* 2458 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2460 */    MCD::OPC_Decode, 216, 3, 41, // Opcode: FHADDS, DecodeIdx: 41
/* 2464 */    MCD::OPC_FilterValue, 98, 6, 0, // Skip to: 2474
/* 2468 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2470 */    MCD::OPC_Decode, 215, 3, 42, // Opcode: FHADDD, DecodeIdx: 42
/* 2474 */    MCD::OPC_FilterValue, 101, 6, 0, // Skip to: 2484
/* 2478 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2480 */    MCD::OPC_Decode, 218, 3, 41, // Opcode: FHSUBS, DecodeIdx: 41
/* 2484 */    MCD::OPC_FilterValue, 102, 6, 0, // Skip to: 2494
/* 2488 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2490 */    MCD::OPC_Decode, 217, 3, 42, // Opcode: FHSUBD, DecodeIdx: 42
/* 2494 */    MCD::OPC_FilterValue, 105, 4, 0, // Skip to: 2502
/* 2498 */    MCD::OPC_Decode, 183, 4, 44, // Opcode: FSMULD, DecodeIdx: 44
/* 2502 */    MCD::OPC_FilterValue, 110, 4, 0, // Skip to: 2510
/* 2506 */    MCD::OPC_Decode, 209, 3, 45, // Opcode: FDMULQ, DecodeIdx: 45
/* 2510 */    MCD::OPC_FilterValue, 113, 6, 0, // Skip to: 2520
/* 2514 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2516 */    MCD::OPC_Decode, 138, 4, 41, // Opcode: FNHADDS, DecodeIdx: 41
/* 2520 */    MCD::OPC_FilterValue, 114, 6, 0, // Skip to: 2530
/* 2524 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2526 */    MCD::OPC_Decode, 137, 4, 42, // Opcode: FNHADDD, DecodeIdx: 42
/* 2530 */    MCD::OPC_FilterValue, 121, 6, 0, // Skip to: 2540
/* 2534 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 2536 */    MCD::OPC_Decode, 151, 4, 44, // Opcode: FNSMULD, DecodeIdx: 44
/* 2540 */    MCD::OPC_FilterValue, 129, 1, 10, 0, // Skip to: 2555
/* 2545 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2547 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2551 */    MCD::OPC_Decode, 198, 4, 46, // Opcode: FSTOX, DecodeIdx: 46
/* 2555 */    MCD::OPC_FilterValue, 130, 1, 10, 0, // Skip to: 2570
/* 2560 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2562 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2566 */    MCD::OPC_Decode, 213, 3, 39, // Opcode: FDTOX, DecodeIdx: 39
/* 2570 */    MCD::OPC_FilterValue, 131, 1, 10, 0, // Skip to: 2585
/* 2575 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2577 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2581 */    MCD::OPC_Decode, 178, 4, 47, // Opcode: FQTOX, DecodeIdx: 47
/* 2585 */    MCD::OPC_FilterValue, 132, 1, 10, 0, // Skip to: 2600
/* 2590 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2592 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2596 */    MCD::OPC_Decode, 208, 4, 48, // Opcode: FXTOS, DecodeIdx: 48
/* 2600 */    MCD::OPC_FilterValue, 136, 1, 10, 0, // Skip to: 2615
/* 2605 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2607 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2611 */    MCD::OPC_Decode, 206, 4, 39, // Opcode: FXTOD, DecodeIdx: 39
/* 2615 */    MCD::OPC_FilterValue, 140, 1, 10, 0, // Skip to: 2630
/* 2620 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2622 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2626 */    MCD::OPC_Decode, 207, 4, 49, // Opcode: FXTOQ, DecodeIdx: 49
/* 2630 */    MCD::OPC_FilterValue, 196, 1, 8, 0, // Skip to: 2643
/* 2635 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2639 */    MCD::OPC_Decode, 221, 3, 38, // Opcode: FITOS, DecodeIdx: 38
/* 2643 */    MCD::OPC_FilterValue, 198, 1, 8, 0, // Skip to: 2656
/* 2648 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2652 */    MCD::OPC_Decode, 212, 3, 48, // Opcode: FDTOS, DecodeIdx: 48
/* 2656 */    MCD::OPC_FilterValue, 199, 1, 8, 0, // Skip to: 2669
/* 2661 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2665 */    MCD::OPC_Decode, 177, 4, 50, // Opcode: FQTOS, DecodeIdx: 50
/* 2669 */    MCD::OPC_FilterValue, 200, 1, 8, 0, // Skip to: 2682
/* 2674 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2678 */    MCD::OPC_Decode, 219, 3, 46, // Opcode: FITOD, DecodeIdx: 46
/* 2682 */    MCD::OPC_FilterValue, 201, 1, 8, 0, // Skip to: 2695
/* 2687 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2691 */    MCD::OPC_Decode, 195, 4, 46, // Opcode: FSTOD, DecodeIdx: 46
/* 2695 */    MCD::OPC_FilterValue, 203, 1, 8, 0, // Skip to: 2708
/* 2700 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2704 */    MCD::OPC_Decode, 175, 4, 47, // Opcode: FQTOD, DecodeIdx: 47
/* 2708 */    MCD::OPC_FilterValue, 204, 1, 8, 0, // Skip to: 2721
/* 2713 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2717 */    MCD::OPC_Decode, 220, 3, 51, // Opcode: FITOQ, DecodeIdx: 51
/* 2721 */    MCD::OPC_FilterValue, 205, 1, 8, 0, // Skip to: 2734
/* 2726 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2730 */    MCD::OPC_Decode, 197, 4, 51, // Opcode: FSTOQ, DecodeIdx: 51
/* 2734 */    MCD::OPC_FilterValue, 206, 1, 8, 0, // Skip to: 2747
/* 2739 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2743 */    MCD::OPC_Decode, 211, 3, 49, // Opcode: FDTOQ, DecodeIdx: 49
/* 2747 */    MCD::OPC_FilterValue, 209, 1, 8, 0, // Skip to: 2760
/* 2752 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2756 */    MCD::OPC_Decode, 196, 4, 38, // Opcode: FSTOI, DecodeIdx: 38
/* 2760 */    MCD::OPC_FilterValue, 210, 1, 8, 0, // Skip to: 2773
/* 2765 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2769 */    MCD::OPC_Decode, 210, 3, 48, // Opcode: FDTOI, DecodeIdx: 48
/* 2773 */    MCD::OPC_FilterValueOrFail, 211, 1, 
/* 2776 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 2780 */    MCD::OPC_Decode, 176, 4, 50, // Opcode: FQTOI, DecodeIdx: 50
/* 2784 */    MCD::OPC_FilterValue, 53, 73, 1, // Skip to: 3117
/* 2788 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 2791 */    MCD::OPC_FilterValue, 1, 68, 0, // Skip to: 2863
/* 2795 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2798 */    MCD::OPC_FilterValue, 0, 30, 0, // Skip to: 2832
/* 2802 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 2805 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2807 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 2810 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2812 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 2826
/* 2816 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 2826
/* 2822 */    MCD::OPC_Decode, 243, 3, 52, // Opcode: FMOVS_FCC, DecodeIdx: 52
/* 2826 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2828 */    MCD::OPC_Decode, 213, 6, 53, // Opcode: V9FMOVS_FCC, DecodeIdx: 53
/* 2832 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2834 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 2837 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 2851
/* 2841 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2843 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 2847 */    MCD::OPC_Decode, 244, 3, 52, // Opcode: FMOVS_ICC, DecodeIdx: 52
/* 2851 */    MCD::OPC_FilterValueOrFail, 4, 
/* 2853 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2855 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 2859 */    MCD::OPC_Decode, 245, 3, 52, // Opcode: FMOVS_XCC, DecodeIdx: 52
/* 2863 */    MCD::OPC_FilterValue, 2, 68, 0, // Skip to: 2935
/* 2867 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2870 */    MCD::OPC_FilterValue, 0, 30, 0, // Skip to: 2904
/* 2874 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 2877 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2879 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 2882 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2884 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 2898
/* 2888 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 2898
/* 2894 */    MCD::OPC_Decode, 232, 3, 54, // Opcode: FMOVD_FCC, DecodeIdx: 54
/* 2898 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2900 */    MCD::OPC_Decode, 211, 6, 55, // Opcode: V9FMOVD_FCC, DecodeIdx: 55
/* 2904 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2906 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 2909 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 2923
/* 2913 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2915 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 2919 */    MCD::OPC_Decode, 233, 3, 54, // Opcode: FMOVD_ICC, DecodeIdx: 54
/* 2923 */    MCD::OPC_FilterValueOrFail, 4, 
/* 2925 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2927 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 2931 */    MCD::OPC_Decode, 234, 3, 54, // Opcode: FMOVD_XCC, DecodeIdx: 54
/* 2935 */    MCD::OPC_FilterValue, 3, 68, 0, // Skip to: 3007
/* 2939 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2942 */    MCD::OPC_FilterValue, 0, 30, 0, // Skip to: 2976
/* 2946 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 2949 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2951 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 2954 */    MCD::OPC_FilterValueOrFail, 0, 
/* 2956 */    MCD::OPC_CheckPredicate, 0, 10, 0, // Skip to: 2970
/* 2960 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 2970
/* 2966 */    MCD::OPC_Decode, 236, 3, 56, // Opcode: FMOVQ_FCC, DecodeIdx: 56
/* 2970 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2972 */    MCD::OPC_Decode, 212, 6, 57, // Opcode: V9FMOVQ_FCC, DecodeIdx: 57
/* 2976 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2978 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 2981 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 2995
/* 2985 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2987 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 2991 */    MCD::OPC_Decode, 237, 3, 56, // Opcode: FMOVQ_ICC, DecodeIdx: 56
/* 2995 */    MCD::OPC_FilterValueOrFail, 4, 
/* 2997 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2999 */    MCD::OPC_CheckFieldOrFail, 18, 1, 0, 
/* 3003 */    MCD::OPC_Decode, 238, 3, 56, // Opcode: FMOVQ_XCC, DecodeIdx: 56
/* 3007 */    MCD::OPC_FilterValue, 5, 10, 0, // Skip to: 3021
/* 3011 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3013 */    MCD::OPC_CheckFieldOrFail, 13, 1, 0, 
/* 3017 */    MCD::OPC_Decode, 241, 3, 58, // Opcode: FMOVRS, DecodeIdx: 58
/* 3021 */    MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 3035
/* 3025 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3027 */    MCD::OPC_CheckFieldOrFail, 13, 1, 0, 
/* 3031 */    MCD::OPC_Decode, 239, 3, 59, // Opcode: FMOVRD, DecodeIdx: 59
/* 3035 */    MCD::OPC_FilterValue, 7, 8, 0, // Skip to: 3047
/* 3039 */    MCD::OPC_CheckFieldOrFail, 13, 1, 0, 
/* 3043 */    MCD::OPC_Decode, 240, 3, 60, // Opcode: FMOVRQ, DecodeIdx: 60
/* 3047 */    MCD::OPC_FilterValue, 17, 8, 0, // Skip to: 3059
/* 3051 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3055 */    MCD::OPC_Decode, 210, 6, 61, // Opcode: V9FCMPS, DecodeIdx: 61
/* 3059 */    MCD::OPC_FilterValue, 18, 8, 0, // Skip to: 3071
/* 3063 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3067 */    MCD::OPC_Decode, 205, 6, 62, // Opcode: V9FCMPD, DecodeIdx: 62
/* 3071 */    MCD::OPC_FilterValue, 19, 8, 0, // Skip to: 3083
/* 3075 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3079 */    MCD::OPC_Decode, 209, 6, 63, // Opcode: V9FCMPQ, DecodeIdx: 63
/* 3083 */    MCD::OPC_FilterValue, 21, 8, 0, // Skip to: 3095
/* 3087 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3091 */    MCD::OPC_Decode, 208, 6, 61, // Opcode: V9FCMPES, DecodeIdx: 61
/* 3095 */    MCD::OPC_FilterValue, 22, 8, 0, // Skip to: 3107
/* 3099 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3103 */    MCD::OPC_Decode, 206, 6, 62, // Opcode: V9FCMPED, DecodeIdx: 62
/* 3107 */    MCD::OPC_FilterValueOrFail, 23, 
/* 3109 */    MCD::OPC_CheckFieldOrFail, 10, 4, 2, 
/* 3113 */    MCD::OPC_Decode, 207, 6, 63, // Opcode: V9FCMPEQ, DecodeIdx: 63
/* 3117 */    MCD::OPC_FilterValue, 54, 235, 5, // Skip to: 4636
/* 3121 */    MCD::OPC_ExtractField, 5, 9,  // Inst{13-5} ...
/* 3124 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3134
/* 3128 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3130 */    MCD::OPC_Decode, 170, 3, 13, // Opcode: EDGE8, DecodeIdx: 13
/* 3134 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3144
/* 3138 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3140 */    MCD::OPC_Decode, 173, 3, 13, // Opcode: EDGE8N, DecodeIdx: 13
/* 3144 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 3154
/* 3148 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3150 */    MCD::OPC_Decode, 171, 3, 13, // Opcode: EDGE8L, DecodeIdx: 13
/* 3154 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 3164
/* 3158 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3160 */    MCD::OPC_Decode, 172, 3, 13, // Opcode: EDGE8LN, DecodeIdx: 13
/* 3164 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 3174
/* 3168 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3170 */    MCD::OPC_Decode, 162, 3, 13, // Opcode: EDGE16, DecodeIdx: 13
/* 3174 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 3184
/* 3178 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3180 */    MCD::OPC_Decode, 165, 3, 13, // Opcode: EDGE16N, DecodeIdx: 13
/* 3184 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 3194
/* 3188 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3190 */    MCD::OPC_Decode, 163, 3, 13, // Opcode: EDGE16L, DecodeIdx: 13
/* 3194 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 3204
/* 3198 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3200 */    MCD::OPC_Decode, 164, 3, 13, // Opcode: EDGE16LN, DecodeIdx: 13
/* 3204 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 3214
/* 3208 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3210 */    MCD::OPC_Decode, 166, 3, 13, // Opcode: EDGE32, DecodeIdx: 13
/* 3214 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 3224
/* 3218 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3220 */    MCD::OPC_Decode, 169, 3, 13, // Opcode: EDGE32N, DecodeIdx: 13
/* 3224 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 3234
/* 3228 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3230 */    MCD::OPC_Decode, 167, 3, 13, // Opcode: EDGE32L, DecodeIdx: 13
/* 3234 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 3244
/* 3238 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3240 */    MCD::OPC_Decode, 168, 3, 13, // Opcode: EDGE32LN, DecodeIdx: 13
/* 3244 */    MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 3254
/* 3248 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3250 */    MCD::OPC_Decode, 238, 2, 13, // Opcode: ARRAY8, DecodeIdx: 13
/* 3254 */    MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 3264
/* 3258 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3260 */    MCD::OPC_Decode, 210, 2, 13, // Opcode: ADDXC, DecodeIdx: 13
/* 3264 */    MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 3274
/* 3268 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3270 */    MCD::OPC_Decode, 236, 2, 13, // Opcode: ARRAY16, DecodeIdx: 13
/* 3274 */    MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 3284
/* 3278 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3280 */    MCD::OPC_Decode, 211, 2, 13, // Opcode: ADDXCCC, DecodeIdx: 13
/* 3284 */    MCD::OPC_FilterValue, 20, 6, 0, // Skip to: 3294
/* 3288 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3290 */    MCD::OPC_Decode, 237, 2, 13, // Opcode: ARRAY32, DecodeIdx: 13
/* 3294 */    MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 3304
/* 3298 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3300 */    MCD::OPC_Decode, 201, 6, 13, // Opcode: UMULXHI, DecodeIdx: 13
/* 3304 */    MCD::OPC_FilterValue, 23, 10, 0, // Skip to: 3318
/* 3308 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3310 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3314 */    MCD::OPC_Decode, 146, 5, 64, // Opcode: LZCNT, DecodeIdx: 64
/* 3318 */    MCD::OPC_FilterValue, 24, 6, 0, // Skip to: 3328
/* 3322 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3324 */    MCD::OPC_Decode, 225, 2, 13, // Opcode: ALIGNADDR, DecodeIdx: 13
/* 3328 */    MCD::OPC_FilterValue, 25, 6, 0, // Skip to: 3338
/* 3332 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3334 */    MCD::OPC_Decode, 244, 2, 13, // Opcode: BMASK, DecodeIdx: 13
/* 3338 */    MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 3348
/* 3342 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3344 */    MCD::OPC_Decode, 226, 2, 13, // Opcode: ALIGNADDRL, DecodeIdx: 13
/* 3348 */    MCD::OPC_FilterValue, 27, 14, 0, // Skip to: 3366
/* 3352 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3354 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 3358 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3362 */    MCD::OPC_Decode, 149, 3, 65, // Opcode: CMASK8, DecodeIdx: 65
/* 3366 */    MCD::OPC_FilterValue, 29, 14, 0, // Skip to: 3384
/* 3370 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3372 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 3376 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3380 */    MCD::OPC_Decode, 147, 3, 65, // Opcode: CMASK16, DecodeIdx: 65
/* 3384 */    MCD::OPC_FilterValue, 31, 14, 0, // Skip to: 3402
/* 3388 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3390 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 3394 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3398 */    MCD::OPC_Decode, 148, 3, 65, // Opcode: CMASK32, DecodeIdx: 65
/* 3402 */    MCD::OPC_FilterValue, 32, 6, 0, // Skip to: 3412
/* 3406 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3408 */    MCD::OPC_Decode, 198, 3, 66, // Opcode: FCMPLE16, DecodeIdx: 66
/* 3412 */    MCD::OPC_FilterValue, 33, 6, 0, // Skip to: 3422
/* 3416 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3418 */    MCD::OPC_Decode, 181, 4, 42, // Opcode: FSLL16, DecodeIdx: 42
/* 3422 */    MCD::OPC_FilterValue, 34, 6, 0, // Skip to: 3432
/* 3426 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3428 */    MCD::OPC_Decode, 200, 3, 66, // Opcode: FCMPNE16, DecodeIdx: 66
/* 3432 */    MCD::OPC_FilterValue, 35, 6, 0, // Skip to: 3442
/* 3436 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3438 */    MCD::OPC_Decode, 193, 4, 42, // Opcode: FSRL16, DecodeIdx: 42
/* 3442 */    MCD::OPC_FilterValue, 36, 6, 0, // Skip to: 3452
/* 3446 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3448 */    MCD::OPC_Decode, 199, 3, 66, // Opcode: FCMPLE32, DecodeIdx: 66
/* 3452 */    MCD::OPC_FilterValue, 37, 6, 0, // Skip to: 3462
/* 3456 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3458 */    MCD::OPC_Decode, 182, 4, 42, // Opcode: FSLL32, DecodeIdx: 42
/* 3462 */    MCD::OPC_FilterValue, 38, 6, 0, // Skip to: 3472
/* 3466 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3468 */    MCD::OPC_Decode, 201, 3, 66, // Opcode: FCMPNE32, DecodeIdx: 66
/* 3472 */    MCD::OPC_FilterValue, 39, 6, 0, // Skip to: 3482
/* 3476 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3478 */    MCD::OPC_Decode, 194, 4, 42, // Opcode: FSRL32, DecodeIdx: 42
/* 3482 */    MCD::OPC_FilterValue, 40, 6, 0, // Skip to: 3492
/* 3486 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3488 */    MCD::OPC_Decode, 196, 3, 66, // Opcode: FCMPGT16, DecodeIdx: 66
/* 3492 */    MCD::OPC_FilterValue, 41, 6, 0, // Skip to: 3502
/* 3496 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3498 */    MCD::OPC_Decode, 179, 4, 42, // Opcode: FSLAS16, DecodeIdx: 42
/* 3502 */    MCD::OPC_FilterValue, 42, 6, 0, // Skip to: 3512
/* 3506 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3508 */    MCD::OPC_Decode, 194, 3, 66, // Opcode: FCMPEQ16, DecodeIdx: 66
/* 3512 */    MCD::OPC_FilterValue, 43, 6, 0, // Skip to: 3522
/* 3516 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3518 */    MCD::OPC_Decode, 187, 4, 42, // Opcode: FSRA16, DecodeIdx: 42
/* 3522 */    MCD::OPC_FilterValue, 44, 6, 0, // Skip to: 3532
/* 3526 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3528 */    MCD::OPC_Decode, 197, 3, 66, // Opcode: FCMPGT32, DecodeIdx: 66
/* 3532 */    MCD::OPC_FilterValue, 45, 6, 0, // Skip to: 3542
/* 3536 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3538 */    MCD::OPC_Decode, 180, 4, 42, // Opcode: FSLAS32, DecodeIdx: 42
/* 3542 */    MCD::OPC_FilterValue, 46, 6, 0, // Skip to: 3552
/* 3546 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3548 */    MCD::OPC_Decode, 195, 3, 66, // Opcode: FCMPEQ32, DecodeIdx: 66
/* 3552 */    MCD::OPC_FilterValue, 47, 6, 0, // Skip to: 3562
/* 3556 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3558 */    MCD::OPC_Decode, 188, 4, 42, // Opcode: FSRA32, DecodeIdx: 42
/* 3562 */    MCD::OPC_FilterValue, 49, 6, 0, // Skip to: 3572
/* 3566 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3568 */    MCD::OPC_Decode, 250, 3, 67, // Opcode: FMUL8X16, DecodeIdx: 67
/* 3572 */    MCD::OPC_FilterValue, 51, 6, 0, // Skip to: 3582
/* 3576 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3578 */    MCD::OPC_Decode, 252, 3, 44, // Opcode: FMUL8X16AU, DecodeIdx: 44
/* 3582 */    MCD::OPC_FilterValue, 53, 6, 0, // Skip to: 3592
/* 3586 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3588 */    MCD::OPC_Decode, 251, 3, 44, // Opcode: FMUL8X16AL, DecodeIdx: 44
/* 3592 */    MCD::OPC_FilterValue, 54, 6, 0, // Skip to: 3602
/* 3596 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3598 */    MCD::OPC_Decode, 248, 3, 42, // Opcode: FMUL8SUX16, DecodeIdx: 42
/* 3602 */    MCD::OPC_FilterValue, 55, 6, 0, // Skip to: 3612
/* 3606 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3608 */    MCD::OPC_Decode, 249, 3, 42, // Opcode: FMUL8ULX16, DecodeIdx: 42
/* 3612 */    MCD::OPC_FilterValue, 56, 6, 0, // Skip to: 3622
/* 3616 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3618 */    MCD::OPC_Decode, 254, 3, 44, // Opcode: FMULD8SUX16, DecodeIdx: 44
/* 3622 */    MCD::OPC_FilterValue, 57, 6, 0, // Skip to: 3632
/* 3626 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3628 */    MCD::OPC_Decode, 255, 3, 44, // Opcode: FMULD8ULX16, DecodeIdx: 44
/* 3632 */    MCD::OPC_FilterValue, 58, 6, 0, // Skip to: 3642
/* 3636 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3638 */    MCD::OPC_Decode, 161, 4, 42, // Opcode: FPACK32, DecodeIdx: 42
/* 3642 */    MCD::OPC_FilterValue, 59, 10, 0, // Skip to: 3656
/* 3646 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3648 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3652 */    MCD::OPC_Decode, 160, 4, 39, // Opcode: FPACK16, DecodeIdx: 39
/* 3656 */    MCD::OPC_FilterValue, 61, 10, 0, // Skip to: 3670
/* 3660 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3662 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3666 */    MCD::OPC_Decode, 162, 4, 48, // Opcode: FPACKFIX, DecodeIdx: 48
/* 3670 */    MCD::OPC_FilterValue, 62, 6, 0, // Skip to: 3680
/* 3674 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3676 */    MCD::OPC_Decode, 180, 5, 42, // Opcode: PDIST, DecodeIdx: 42
/* 3680 */    MCD::OPC_FilterValue, 63, 6, 0, // Skip to: 3690
/* 3684 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3686 */    MCD::OPC_Decode, 181, 5, 66, // Opcode: PDISTN, DecodeIdx: 66
/* 3690 */    MCD::OPC_FilterValue, 64, 6, 0, // Skip to: 3700
/* 3694 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3696 */    MCD::OPC_Decode, 230, 3, 42, // Opcode: FMEAN16, DecodeIdx: 42
/* 3700 */    MCD::OPC_FilterValue, 66, 6, 0, // Skip to: 3710
/* 3704 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3706 */    MCD::OPC_Decode, 167, 4, 42, // Opcode: FPADD64, DecodeIdx: 42
/* 3710 */    MCD::OPC_FilterValue, 68, 6, 0, // Skip to: 3720
/* 3714 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 3716 */    MCD::OPC_Decode, 191, 3, 42, // Opcode: FCHKSM16, DecodeIdx: 42
/* 3720 */    MCD::OPC_FilterValue, 72, 6, 0, // Skip to: 3730
/* 3724 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3726 */    MCD::OPC_Decode, 180, 3, 42, // Opcode: FALIGNADATA, DecodeIdx: 42
/* 3730 */    MCD::OPC_FilterValue, 75, 6, 0, // Skip to: 3740
/* 3734 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3736 */    MCD::OPC_Decode, 170, 4, 44, // Opcode: FPMERGE, DecodeIdx: 44
/* 3740 */    MCD::OPC_FilterValue, 76, 6, 0, // Skip to: 3750
/* 3744 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 3746 */    MCD::OPC_Decode, 133, 3, 42, // Opcode: BSHUFFLE, DecodeIdx: 42
/* 3750 */    MCD::OPC_FilterValue, 77, 10, 0, // Skip to: 3764
/* 3754 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3756 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3760 */    MCD::OPC_Decode, 214, 3, 46, // Opcode: FEXPAND, DecodeIdx: 46
/* 3764 */    MCD::OPC_FilterValue, 80, 6, 0, // Skip to: 3774
/* 3768 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3770 */    MCD::OPC_Decode, 163, 4, 42, // Opcode: FPADD16, DecodeIdx: 42
/* 3774 */    MCD::OPC_FilterValue, 81, 6, 0, // Skip to: 3784
/* 3778 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3780 */    MCD::OPC_Decode, 164, 4, 41, // Opcode: FPADD16S, DecodeIdx: 41
/* 3784 */    MCD::OPC_FilterValue, 82, 6, 0, // Skip to: 3794
/* 3788 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3790 */    MCD::OPC_Decode, 165, 4, 42, // Opcode: FPADD32, DecodeIdx: 42
/* 3794 */    MCD::OPC_FilterValue, 83, 6, 0, // Skip to: 3804
/* 3798 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3800 */    MCD::OPC_Decode, 166, 4, 41, // Opcode: FPADD32S, DecodeIdx: 41
/* 3804 */    MCD::OPC_FilterValue, 84, 6, 0, // Skip to: 3814
/* 3808 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3810 */    MCD::OPC_Decode, 171, 4, 42, // Opcode: FPSUB16, DecodeIdx: 42
/* 3814 */    MCD::OPC_FilterValue, 85, 6, 0, // Skip to: 3824
/* 3818 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3820 */    MCD::OPC_Decode, 172, 4, 41, // Opcode: FPSUB16S, DecodeIdx: 41
/* 3824 */    MCD::OPC_FilterValue, 86, 6, 0, // Skip to: 3834
/* 3828 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3830 */    MCD::OPC_Decode, 173, 4, 42, // Opcode: FPSUB32, DecodeIdx: 42
/* 3834 */    MCD::OPC_FilterValue, 87, 6, 0, // Skip to: 3844
/* 3838 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3840 */    MCD::OPC_Decode, 174, 4, 41, // Opcode: FPSUB32S, DecodeIdx: 41
/* 3844 */    MCD::OPC_FilterValue, 96, 14, 0, // Skip to: 3862
/* 3848 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3850 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3854 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 3858 */    MCD::OPC_Decode, 209, 4, 68, // Opcode: FZERO, DecodeIdx: 68
/* 3862 */    MCD::OPC_FilterValue, 97, 14, 0, // Skip to: 3880
/* 3866 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3868 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3872 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 3876 */    MCD::OPC_Decode, 210, 4, 69, // Opcode: FZEROS, DecodeIdx: 69
/* 3880 */    MCD::OPC_FilterValue, 98, 6, 0, // Skip to: 3890
/* 3884 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3886 */    MCD::OPC_Decode, 145, 4, 42, // Opcode: FNOR, DecodeIdx: 42
/* 3890 */    MCD::OPC_FilterValue, 99, 6, 0, // Skip to: 3900
/* 3894 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3896 */    MCD::OPC_Decode, 146, 4, 41, // Opcode: FNORS, DecodeIdx: 41
/* 3900 */    MCD::OPC_FilterValue, 100, 6, 0, // Skip to: 3910
/* 3904 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3906 */    MCD::OPC_Decode, 184, 3, 42, // Opcode: FANDNOT2, DecodeIdx: 42
/* 3910 */    MCD::OPC_FilterValue, 101, 6, 0, // Skip to: 3920
/* 3914 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3916 */    MCD::OPC_Decode, 185, 3, 41, // Opcode: FANDNOT2S, DecodeIdx: 41
/* 3920 */    MCD::OPC_FilterValue, 102, 10, 0, // Skip to: 3934
/* 3924 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3926 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3930 */    MCD::OPC_Decode, 149, 4, 39, // Opcode: FNOT2, DecodeIdx: 39
/* 3934 */    MCD::OPC_FilterValue, 103, 10, 0, // Skip to: 3948
/* 3938 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3940 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 3944 */    MCD::OPC_Decode, 150, 4, 38, // Opcode: FNOT2S, DecodeIdx: 38
/* 3948 */    MCD::OPC_FilterValue, 104, 6, 0, // Skip to: 3958
/* 3952 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3954 */    MCD::OPC_Decode, 182, 3, 42, // Opcode: FANDNOT1, DecodeIdx: 42
/* 3958 */    MCD::OPC_FilterValue, 105, 6, 0, // Skip to: 3968
/* 3962 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3964 */    MCD::OPC_Decode, 183, 3, 41, // Opcode: FANDNOT1S, DecodeIdx: 41
/* 3968 */    MCD::OPC_FilterValue, 106, 10, 0, // Skip to: 3982
/* 3972 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3974 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 3978 */    MCD::OPC_Decode, 147, 4, 70, // Opcode: FNOT1, DecodeIdx: 70
/* 3982 */    MCD::OPC_FilterValue, 107, 10, 0, // Skip to: 3996
/* 3986 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3988 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 3992 */    MCD::OPC_Decode, 148, 4, 71, // Opcode: FNOT1S, DecodeIdx: 71
/* 3996 */    MCD::OPC_FilterValue, 108, 6, 0, // Skip to: 4006
/* 4000 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4002 */    MCD::OPC_Decode, 204, 4, 42, // Opcode: FXOR, DecodeIdx: 42
/* 4006 */    MCD::OPC_FilterValue, 109, 6, 0, // Skip to: 4016
/* 4010 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4012 */    MCD::OPC_Decode, 205, 4, 41, // Opcode: FXORS, DecodeIdx: 41
/* 4016 */    MCD::OPC_FilterValue, 110, 6, 0, // Skip to: 4026
/* 4020 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4022 */    MCD::OPC_Decode, 132, 4, 42, // Opcode: FNAND, DecodeIdx: 42
/* 4026 */    MCD::OPC_FilterValue, 111, 6, 0, // Skip to: 4036
/* 4030 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4032 */    MCD::OPC_Decode, 133, 4, 41, // Opcode: FNANDS, DecodeIdx: 41
/* 4036 */    MCD::OPC_FilterValue, 112, 6, 0, // Skip to: 4046
/* 4040 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4042 */    MCD::OPC_Decode, 181, 3, 42, // Opcode: FAND, DecodeIdx: 42
/* 4046 */    MCD::OPC_FilterValue, 113, 6, 0, // Skip to: 4056
/* 4050 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4052 */    MCD::OPC_Decode, 186, 3, 41, // Opcode: FANDS, DecodeIdx: 41
/* 4056 */    MCD::OPC_FilterValue, 114, 6, 0, // Skip to: 4066
/* 4060 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4062 */    MCD::OPC_Decode, 202, 4, 42, // Opcode: FXNOR, DecodeIdx: 42
/* 4066 */    MCD::OPC_FilterValue, 115, 6, 0, // Skip to: 4076
/* 4070 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4072 */    MCD::OPC_Decode, 203, 4, 41, // Opcode: FXNORS, DecodeIdx: 41
/* 4076 */    MCD::OPC_FilterValue, 116, 10, 0, // Skip to: 4090
/* 4080 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4082 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4086 */    MCD::OPC_Decode, 189, 4, 70, // Opcode: FSRC1, DecodeIdx: 70
/* 4090 */    MCD::OPC_FilterValue, 117, 10, 0, // Skip to: 4104
/* 4094 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4096 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4100 */    MCD::OPC_Decode, 190, 4, 71, // Opcode: FSRC1S, DecodeIdx: 71
/* 4104 */    MCD::OPC_FilterValue, 118, 6, 0, // Skip to: 4114
/* 4108 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4110 */    MCD::OPC_Decode, 157, 4, 42, // Opcode: FORNOT2, DecodeIdx: 42
/* 4114 */    MCD::OPC_FilterValue, 119, 6, 0, // Skip to: 4124
/* 4118 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4120 */    MCD::OPC_Decode, 158, 4, 41, // Opcode: FORNOT2S, DecodeIdx: 41
/* 4124 */    MCD::OPC_FilterValue, 120, 10, 0, // Skip to: 4138
/* 4128 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4130 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4134 */    MCD::OPC_Decode, 191, 4, 39, // Opcode: FSRC2, DecodeIdx: 39
/* 4138 */    MCD::OPC_FilterValue, 121, 10, 0, // Skip to: 4152
/* 4142 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4144 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4148 */    MCD::OPC_Decode, 192, 4, 38, // Opcode: FSRC2S, DecodeIdx: 38
/* 4152 */    MCD::OPC_FilterValue, 122, 6, 0, // Skip to: 4162
/* 4156 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4158 */    MCD::OPC_Decode, 155, 4, 42, // Opcode: FORNOT1, DecodeIdx: 42
/* 4162 */    MCD::OPC_FilterValue, 123, 6, 0, // Skip to: 4172
/* 4166 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4168 */    MCD::OPC_Decode, 156, 4, 41, // Opcode: FORNOT1S, DecodeIdx: 41
/* 4172 */    MCD::OPC_FilterValue, 124, 6, 0, // Skip to: 4182
/* 4176 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4178 */    MCD::OPC_Decode, 154, 4, 42, // Opcode: FOR, DecodeIdx: 42
/* 4182 */    MCD::OPC_FilterValue, 125, 6, 0, // Skip to: 4192
/* 4186 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4188 */    MCD::OPC_Decode, 159, 4, 41, // Opcode: FORS, DecodeIdx: 41
/* 4192 */    MCD::OPC_FilterValue, 126, 14, 0, // Skip to: 4210
/* 4196 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4198 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4202 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4206 */    MCD::OPC_Decode, 152, 4, 68, // Opcode: FONE, DecodeIdx: 68
/* 4210 */    MCD::OPC_FilterValue, 127, 14, 0, // Skip to: 4228
/* 4214 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4216 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4220 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4224 */    MCD::OPC_Decode, 153, 4, 69, // Opcode: FONES, DecodeIdx: 69
/* 4228 */    MCD::OPC_FilterValue, 128, 1, 18, 0, // Skip to: 4251
/* 4233 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4235 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4239 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4243 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4247 */    MCD::OPC_Decode, 216, 5, 7, // Opcode: SHUTDOWN, DecodeIdx: 7
/* 4251 */    MCD::OPC_FilterValue, 129, 1, 18, 0, // Skip to: 4274
/* 4256 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 4258 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4262 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4266 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4270 */    MCD::OPC_Decode, 217, 5, 72, // Opcode: SIAM, DecodeIdx: 72
/* 4274 */    MCD::OPC_FilterValue, 144, 2, 10, 0, // Skip to: 4289
/* 4279 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4281 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4285 */    MCD::OPC_Decode, 151, 5, 73, // Opcode: MOVDTOX, DecodeIdx: 73
/* 4289 */    MCD::OPC_FilterValue, 145, 2, 10, 0, // Skip to: 4304
/* 4294 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4296 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4300 */    MCD::OPC_Decode, 159, 5, 74, // Opcode: MOVSTOUW, DecodeIdx: 74
/* 4304 */    MCD::OPC_FilterValue, 147, 2, 10, 0, // Skip to: 4319
/* 4309 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4311 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4315 */    MCD::OPC_Decode, 158, 5, 74, // Opcode: MOVSTOSW, DecodeIdx: 74
/* 4319 */    MCD::OPC_FilterValue, 149, 2, 6, 0, // Skip to: 4330
/* 4324 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4326 */    MCD::OPC_Decode, 226, 6, 13, // Opcode: XMULX, DecodeIdx: 13
/* 4330 */    MCD::OPC_FilterValue, 150, 2, 6, 0, // Skip to: 4341
/* 4335 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4337 */    MCD::OPC_Decode, 227, 6, 13, // Opcode: XMULXHI, DecodeIdx: 13
/* 4341 */    MCD::OPC_FilterValue, 152, 2, 10, 0, // Skip to: 4356
/* 4346 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4348 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4352 */    MCD::OPC_Decode, 163, 5, 75, // Opcode: MOVXTOD, DecodeIdx: 75
/* 4356 */    MCD::OPC_FilterValue, 153, 2, 10, 0, // Skip to: 4371
/* 4361 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4363 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4367 */    MCD::OPC_Decode, 160, 5, 76, // Opcode: MOVWTOS, DecodeIdx: 76
/* 4371 */    MCD::OPC_FilterValue, 176, 2, 6, 0, // Skip to: 4382
/* 4376 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4378 */    MCD::OPC_Decode, 222, 2, 42, // Opcode: AES_KEXPAND0, DecodeIdx: 42
/* 4382 */    MCD::OPC_FilterValue, 177, 2, 6, 0, // Skip to: 4393
/* 4387 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4389 */    MCD::OPC_Decode, 224, 2, 42, // Opcode: AES_KEXPAND2, DecodeIdx: 42
/* 4393 */    MCD::OPC_FilterValue, 180, 2, 10, 0, // Skip to: 4408
/* 4398 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4400 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4404 */    MCD::OPC_Decode, 158, 3, 70, // Opcode: DES_IP, DecodeIdx: 70
/* 4408 */    MCD::OPC_FilterValue, 181, 2, 10, 0, // Skip to: 4423
/* 4413 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4415 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4419 */    MCD::OPC_Decode, 157, 3, 70, // Opcode: DES_IIP, DecodeIdx: 70
/* 4423 */    MCD::OPC_FilterValue, 182, 2, 6, 0, // Skip to: 4434
/* 4428 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4430 */    MCD::OPC_Decode, 159, 3, 77, // Opcode: DES_KEXPAND, DecodeIdx: 77
/* 4434 */    MCD::OPC_FilterValue, 188, 2, 6, 0, // Skip to: 4445
/* 4439 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4441 */    MCD::OPC_Decode, 141, 3, 42, // Opcode: CAMELLIA_FL, DecodeIdx: 42
/* 4445 */    MCD::OPC_FilterValue, 189, 2, 6, 0, // Skip to: 4456
/* 4450 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4452 */    MCD::OPC_Decode, 142, 3, 42, // Opcode: CAMELLIA_FLI, DecodeIdx: 42
/* 4456 */    MCD::OPC_FilterValue, 192, 2, 18, 0, // Skip to: 4479
/* 4461 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4463 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4467 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4471 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4475 */    MCD::OPC_Decode, 147, 5, 7, // Opcode: MD5, DecodeIdx: 7
/* 4479 */    MCD::OPC_FilterValue, 193, 2, 18, 0, // Skip to: 4502
/* 4484 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4486 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4490 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4494 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4498 */    MCD::OPC_Decode, 213, 5, 7, // Opcode: SHA1, DecodeIdx: 7
/* 4502 */    MCD::OPC_FilterValue, 194, 2, 18, 0, // Skip to: 4525
/* 4507 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4509 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4513 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4517 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4521 */    MCD::OPC_Decode, 214, 5, 7, // Opcode: SHA256, DecodeIdx: 7
/* 4525 */    MCD::OPC_FilterValue, 195, 2, 18, 0, // Skip to: 4548
/* 4530 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4532 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4536 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4540 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 4544 */    MCD::OPC_Decode, 215, 5, 7, // Opcode: SHA512, DecodeIdx: 7
/* 4548 */    MCD::OPC_FilterValue, 199, 2, 6, 0, // Skip to: 4559
/* 4553 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4555 */    MCD::OPC_Decode, 152, 3, 42, // Opcode: CRC32C, DecodeIdx: 42
/* 4559 */    MCD::OPC_FilterValue, 200, 2, 14, 0, // Skip to: 4578
/* 4564 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4566 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4570 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4574 */    MCD::OPC_Decode, 164, 5, 78, // Opcode: MPMUL, DecodeIdx: 78
/* 4578 */    MCD::OPC_FilterValue, 201, 2, 14, 0, // Skip to: 4597
/* 4583 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4585 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4589 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4593 */    MCD::OPC_Decode, 149, 5, 78, // Opcode: MONTMUL, DecodeIdx: 78
/* 4597 */    MCD::OPC_FilterValue, 202, 2, 14, 0, // Skip to: 4616
/* 4602 */    MCD::OPC_CheckPredicateOrFail, 2, 
/* 4604 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4608 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4612 */    MCD::OPC_Decode, 150, 5, 78, // Opcode: MONTSQR, DecodeIdx: 78
/* 4616 */    MCD::OPC_FilterValue, 209, 2, 6, 0, // Skip to: 4627
/* 4621 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4623 */    MCD::OPC_Decode, 223, 3, 61, // Opcode: FLCMPS, DecodeIdx: 61
/* 4627 */    MCD::OPC_FilterValueOrFail, 210, 2, 
/* 4630 */    MCD::OPC_CheckPredicateOrFail, 5, 
/* 4632 */    MCD::OPC_Decode, 222, 3, 62, // Opcode: FLCMPD, DecodeIdx: 62
/* 4636 */    MCD::OPC_FilterValue, 55, 101, 0, // Skip to: 4741
/* 4640 */    MCD::OPC_ExtractField, 5, 4,  // Inst{8-5} ...
/* 4643 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 4653
/* 4647 */    MCD::OPC_CheckPredicateOrFail, 1, 
/* 4649 */    MCD::OPC_Decode, 168, 4, 15, // Opcode: FPMADDX, DecodeIdx: 15
/* 4653 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 4663
/* 4657 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4659 */    MCD::OPC_Decode, 229, 3, 79, // Opcode: FMADDS, DecodeIdx: 79
/* 4663 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 4673
/* 4667 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4669 */    MCD::OPC_Decode, 228, 3, 15, // Opcode: FMADDD, DecodeIdx: 15
/* 4673 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 4683
/* 4677 */    MCD::OPC_CheckPredicateOrFail, 1, 
/* 4679 */    MCD::OPC_Decode, 169, 4, 15, // Opcode: FPMADDXHI, DecodeIdx: 15
/* 4683 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 4693
/* 4687 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4689 */    MCD::OPC_Decode, 247, 3, 79, // Opcode: FMSUBS, DecodeIdx: 79
/* 4693 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 4703
/* 4697 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4699 */    MCD::OPC_Decode, 246, 3, 15, // Opcode: FMSUBD, DecodeIdx: 15
/* 4703 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 4713
/* 4707 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4709 */    MCD::OPC_Decode, 142, 4, 79, // Opcode: FNMSUBS, DecodeIdx: 79
/* 4713 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 4723
/* 4717 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4719 */    MCD::OPC_Decode, 141, 4, 15, // Opcode: FNMSUBD, DecodeIdx: 15
/* 4723 */    MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 4733
/* 4727 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4729 */    MCD::OPC_Decode, 140, 4, 79, // Opcode: FNMADDS, DecodeIdx: 79
/* 4733 */    MCD::OPC_FilterValueOrFail, 14, 
/* 4735 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4737 */    MCD::OPC_Decode, 139, 4, 15, // Opcode: FNMADDD, DecodeIdx: 15
/* 4741 */    MCD::OPC_FilterValue, 56, 21, 0, // Skip to: 4766
/* 4745 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4748 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 4760
/* 4752 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 4756 */    MCD::OPC_Decode, 215, 4, 80, // Opcode: JMPLrr, DecodeIdx: 80
/* 4760 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4762 */    MCD::OPC_Decode, 214, 4, 81, // Opcode: JMPLri, DecodeIdx: 81
/* 4766 */    MCD::OPC_FilterValue, 57, 29, 0, // Skip to: 4799
/* 4770 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4773 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 4789
/* 4777 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4781 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 4785 */    MCD::OPC_Decode, 202, 5, 82, // Opcode: RETTrr, DecodeIdx: 82
/* 4789 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4791 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4795 */    MCD::OPC_Decode, 201, 5, 83, // Opcode: RETTri, DecodeIdx: 83
/* 4799 */    MCD::OPC_FilterValue, 58, 86, 0, // Skip to: 4889
/* 4803 */    MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 4806 */    MCD::OPC_FilterValue, 16, 14, 0, // Skip to: 4824
/* 4810 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 4812 */    MCD::OPC_CheckFieldOrFail, 29, 1, 0, 
/* 4816 */    MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 4820 */    MCD::OPC_Decode, 190, 6, 84, // Opcode: TXCCrr, DecodeIdx: 84
/* 4824 */    MCD::OPC_FilterValue, 32, 49, 0, // Skip to: 4877
/* 4828 */    MCD::OPC_ExtractField, 0, 8,  // Inst{7-0} ...
/* 4831 */    MCD::OPC_FilterValue, 1, 12, 0, // Skip to: 4847
/* 4835 */    MCD::OPC_CheckFieldOrFail, 25, 5, 8, 
/* 4839 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4843 */    MCD::OPC_Decode, 168, 6, 7, // Opcode: TA1, DecodeIdx: 7
/* 4847 */    MCD::OPC_FilterValue, 3, 12, 0, // Skip to: 4863
/* 4851 */    MCD::OPC_CheckFieldOrFail, 25, 5, 8, 
/* 4855 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4859 */    MCD::OPC_Decode, 169, 6, 7, // Opcode: TA3, DecodeIdx: 7
/* 4863 */    MCD::OPC_FilterValueOrFail, 5, 
/* 4865 */    MCD::OPC_CheckFieldOrFail, 25, 5, 8, 
/* 4869 */    MCD::OPC_CheckFieldOrFail, 14, 5, 0, 
/* 4873 */    MCD::OPC_Decode, 170, 6, 7, // Opcode: TA5, DecodeIdx: 7
/* 4877 */    MCD::OPC_FilterValueOrFail, 48, 
/* 4879 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 4881 */    MCD::OPC_CheckFieldOrFail, 29, 1, 0, 
/* 4885 */    MCD::OPC_Decode, 189, 6, 85, // Opcode: TXCCri, DecodeIdx: 85
/* 4889 */    MCD::OPC_FilterValue, 59, 47, 0, // Skip to: 4940
/* 4893 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4896 */    MCD::OPC_FilterValue, 0, 30, 0, // Skip to: 4930
/* 4900 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 4903 */    MCD::OPC_FilterValueOrFail, 0, 
/* 4905 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 4908 */    MCD::OPC_FilterValueOrFail, 0, 
/* 4910 */    MCD::OPC_CheckField, 14, 5, 0, 10, 0, // Skip to: 4926
/* 4916 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, // Skip to: 4926
/* 4922 */    MCD::OPC_Decode, 224, 3, 7, // Opcode: FLUSH, DecodeIdx: 7
/* 4926 */    MCD::OPC_Decode, 227, 3, 82, // Opcode: FLUSHrr, DecodeIdx: 82
/* 4930 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4932 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 4936 */    MCD::OPC_Decode, 226, 3, 83, // Opcode: FLUSHri, DecodeIdx: 83
/* 4940 */    MCD::OPC_FilterValue, 60, 21, 0, // Skip to: 4965
/* 4944 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4947 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 4959
/* 4951 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 4955 */    MCD::OPC_Decode, 205, 5, 11, // Opcode: SAVErr, DecodeIdx: 11
/* 4959 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4961 */    MCD::OPC_Decode, 204, 5, 12, // Opcode: SAVEri, DecodeIdx: 12
/* 4965 */    MCD::OPC_FilterValue, 61, 21, 0, // Skip to: 4990
/* 4969 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4972 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 4984
/* 4976 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 4980 */    MCD::OPC_Decode, 197, 5, 11, // Opcode: RESTORErr, DecodeIdx: 11
/* 4984 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4986 */    MCD::OPC_Decode, 196, 5, 12, // Opcode: RESTOREri, DecodeIdx: 12
/* 4990 */    MCD::OPC_FilterValue, 62, 73, 0, // Skip to: 5067
/* 4994 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 4997 */    MCD::OPC_FilterValue, 0, 60, 0, // Skip to: 5061
/* 5001 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 5004 */    MCD::OPC_FilterValueOrFail, 0, 
/* 5006 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5009 */    MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 5033
/* 5013 */    MCD::OPC_CheckPredicate, 0, 40, 0, // Skip to: 5057
/* 5017 */    MCD::OPC_CheckField, 14, 5, 0, 34, 0, // Skip to: 5057
/* 5023 */    MCD::OPC_CheckField, 0, 5, 0, 28, 0, // Skip to: 5057
/* 5029 */    MCD::OPC_Decode, 161, 3, 7, // Opcode: DONE, DecodeIdx: 7
/* 5033 */    MCD::OPC_FilterValue, 1, 20, 0, // Skip to: 5057
/* 5037 */    MCD::OPC_CheckPredicate, 0, 16, 0, // Skip to: 5057
/* 5041 */    MCD::OPC_CheckField, 14, 5, 0, 10, 0, // Skip to: 5057
/* 5047 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, // Skip to: 5057
/* 5053 */    MCD::OPC_Decode, 200, 5, 7, // Opcode: RETRY, DecodeIdx: 7
/* 5057 */    MCD::OPC_Decode, 198, 6, 11, // Opcode: UMACrr, DecodeIdx: 11
/* 5061 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5063 */    MCD::OPC_Decode, 197, 6, 12, // Opcode: UMACri, DecodeIdx: 12
/* 5067 */    MCD::OPC_FilterValueOrFail, 63, 
/* 5069 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5072 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5084
/* 5076 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5080 */    MCD::OPC_Decode, 224, 5, 11, // Opcode: SMACrr, DecodeIdx: 11
/* 5084 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5086 */    MCD::OPC_Decode, 223, 5, 12, // Opcode: SMACri, DecodeIdx: 12
/* 5090 */    MCD::OPC_FilterValueOrFail, 3, 
/* 5092 */    MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 5095 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 5120
/* 5099 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5102 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5114
/* 5106 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5110 */    MCD::OPC_Decode, 145, 5, 80, // Opcode: LDrr, DecodeIdx: 80
/* 5114 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5116 */    MCD::OPC_Decode, 144, 5, 81, // Opcode: LDri, DecodeIdx: 81
/* 5120 */    MCD::OPC_FilterValue, 1, 21, 0, // Skip to: 5145
/* 5124 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5127 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5139
/* 5131 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5135 */    MCD::OPC_Decode, 133, 5, 80, // Opcode: LDUBrr, DecodeIdx: 80
/* 5139 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5141 */    MCD::OPC_Decode, 132, 5, 81, // Opcode: LDUBri, DecodeIdx: 81
/* 5145 */    MCD::OPC_FilterValue, 2, 21, 0, // Skip to: 5170
/* 5149 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5152 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5164
/* 5156 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5160 */    MCD::OPC_Decode, 137, 5, 80, // Opcode: LDUHrr, DecodeIdx: 80
/* 5164 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5166 */    MCD::OPC_Decode, 136, 5, 81, // Opcode: LDUHri, DecodeIdx: 81
/* 5170 */    MCD::OPC_FilterValue, 3, 21, 0, // Skip to: 5195
/* 5174 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5177 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5189
/* 5181 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5185 */    MCD::OPC_Decode, 231, 4, 86, // Opcode: LDDrr, DecodeIdx: 86
/* 5189 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5191 */    MCD::OPC_Decode, 230, 4, 87, // Opcode: LDDri, DecodeIdx: 87
/* 5195 */    MCD::OPC_FilterValue, 4, 21, 0, // Skip to: 5220
/* 5199 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5202 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5214
/* 5206 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5210 */    MCD::OPC_Decode, 155, 6, 88, // Opcode: STrr, DecodeIdx: 88
/* 5214 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5216 */    MCD::OPC_Decode, 154, 6, 89, // Opcode: STri, DecodeIdx: 89
/* 5220 */    MCD::OPC_FilterValue, 5, 21, 0, // Skip to: 5245
/* 5224 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5227 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5239
/* 5231 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5235 */    MCD::OPC_Decode, 243, 5, 88, // Opcode: STBrr, DecodeIdx: 88
/* 5239 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5241 */    MCD::OPC_Decode, 242, 5, 89, // Opcode: STBri, DecodeIdx: 89
/* 5245 */    MCD::OPC_FilterValue, 6, 21, 0, // Skip to: 5270
/* 5249 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5252 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5264
/* 5256 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5260 */    MCD::OPC_Decode, 143, 6, 88, // Opcode: STHrr, DecodeIdx: 88
/* 5264 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5266 */    MCD::OPC_Decode, 142, 6, 89, // Opcode: STHri, DecodeIdx: 89
/* 5270 */    MCD::OPC_FilterValue, 7, 21, 0, // Skip to: 5295
/* 5274 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5277 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5289
/* 5281 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5285 */    MCD::OPC_Decode, 133, 6, 90, // Opcode: STDrr, DecodeIdx: 90
/* 5289 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5291 */    MCD::OPC_Decode, 132, 6, 91, // Opcode: STDri, DecodeIdx: 91
/* 5295 */    MCD::OPC_FilterValue, 8, 25, 0, // Skip to: 5324
/* 5299 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5302 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 5316
/* 5306 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5308 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5312 */    MCD::OPC_Decode, 129, 5, 92, // Opcode: LDSWrr, DecodeIdx: 92
/* 5316 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5318 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5320 */    MCD::OPC_Decode, 128, 5, 93, // Opcode: LDSWri, DecodeIdx: 93
/* 5324 */    MCD::OPC_FilterValue, 9, 21, 0, // Skip to: 5349
/* 5328 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5331 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5343
/* 5335 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5339 */    MCD::OPC_Decode, 245, 4, 80, // Opcode: LDSBrr, DecodeIdx: 80
/* 5343 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5345 */    MCD::OPC_Decode, 244, 4, 81, // Opcode: LDSBri, DecodeIdx: 81
/* 5349 */    MCD::OPC_FilterValue, 10, 21, 0, // Skip to: 5374
/* 5353 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5356 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5368
/* 5360 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5364 */    MCD::OPC_Decode, 249, 4, 80, // Opcode: LDSHrr, DecodeIdx: 80
/* 5368 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5370 */    MCD::OPC_Decode, 248, 4, 81, // Opcode: LDSHri, DecodeIdx: 81
/* 5374 */    MCD::OPC_FilterValue, 11, 25, 0, // Skip to: 5403
/* 5378 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5381 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 5395
/* 5385 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5387 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5391 */    MCD::OPC_Decode, 143, 5, 92, // Opcode: LDXrr, DecodeIdx: 92
/* 5395 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5397 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5399 */    MCD::OPC_Decode, 142, 5, 93, // Opcode: LDXri, DecodeIdx: 93
/* 5403 */    MCD::OPC_FilterValue, 13, 21, 0, // Skip to: 5428
/* 5407 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5410 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5422
/* 5414 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5418 */    MCD::OPC_Decode, 253, 4, 80, // Opcode: LDSTUBrr, DecodeIdx: 80
/* 5422 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5424 */    MCD::OPC_Decode, 252, 4, 81, // Opcode: LDSTUBri, DecodeIdx: 81
/* 5428 */    MCD::OPC_FilterValue, 14, 25, 0, // Skip to: 5457
/* 5432 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5435 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 5449
/* 5439 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5441 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5445 */    MCD::OPC_Decode, 153, 6, 94, // Opcode: STXrr, DecodeIdx: 94
/* 5449 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5451 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5453 */    MCD::OPC_Decode, 152, 6, 95, // Opcode: STXri, DecodeIdx: 95
/* 5457 */    MCD::OPC_FilterValue, 15, 21, 0, // Skip to: 5482
/* 5461 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5464 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5476
/* 5468 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5472 */    MCD::OPC_Decode, 167, 6, 96, // Opcode: SWAPrr, DecodeIdx: 96
/* 5476 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5478 */    MCD::OPC_Decode, 166, 6, 97, // Opcode: SWAPri, DecodeIdx: 97
/* 5482 */    MCD::OPC_FilterValue, 16, 19, 0, // Skip to: 5505
/* 5486 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5489 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5497
/* 5493 */    MCD::OPC_Decode, 217, 4, 98, // Opcode: LDArr, DecodeIdx: 98
/* 5497 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5499 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5501 */    MCD::OPC_Decode, 216, 4, 81, // Opcode: LDAri, DecodeIdx: 81
/* 5505 */    MCD::OPC_FilterValue, 17, 19, 0, // Skip to: 5528
/* 5509 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5512 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5520
/* 5516 */    MCD::OPC_Decode, 131, 5, 98, // Opcode: LDUBArr, DecodeIdx: 98
/* 5520 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5522 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5524 */    MCD::OPC_Decode, 130, 5, 81, // Opcode: LDUBAri, DecodeIdx: 81
/* 5528 */    MCD::OPC_FilterValue, 18, 19, 0, // Skip to: 5551
/* 5532 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5535 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5543
/* 5539 */    MCD::OPC_Decode, 135, 5, 98, // Opcode: LDUHArr, DecodeIdx: 98
/* 5543 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5545 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5547 */    MCD::OPC_Decode, 134, 5, 81, // Opcode: LDUHAri, DecodeIdx: 81
/* 5551 */    MCD::OPC_FilterValue, 19, 19, 0, // Skip to: 5574
/* 5555 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5558 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5566
/* 5562 */    MCD::OPC_Decode, 223, 4, 99, // Opcode: LDDArr, DecodeIdx: 99
/* 5566 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5568 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5570 */    MCD::OPC_Decode, 222, 4, 87, // Opcode: LDDAri, DecodeIdx: 87
/* 5574 */    MCD::OPC_FilterValue, 20, 19, 0, // Skip to: 5597
/* 5578 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5581 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5589
/* 5585 */    MCD::OPC_Decode, 238, 5, 100, // Opcode: STArr, DecodeIdx: 100
/* 5589 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5591 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5593 */    MCD::OPC_Decode, 237, 5, 89, // Opcode: STAri, DecodeIdx: 89
/* 5597 */    MCD::OPC_FilterValue, 21, 19, 0, // Skip to: 5620
/* 5601 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5604 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5612
/* 5608 */    MCD::OPC_Decode, 241, 5, 100, // Opcode: STBArr, DecodeIdx: 100
/* 5612 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5614 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5616 */    MCD::OPC_Decode, 240, 5, 89, // Opcode: STBAri, DecodeIdx: 89
/* 5620 */    MCD::OPC_FilterValue, 22, 19, 0, // Skip to: 5643
/* 5624 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5627 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5635
/* 5631 */    MCD::OPC_Decode, 141, 6, 100, // Opcode: STHArr, DecodeIdx: 100
/* 5635 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5637 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5639 */    MCD::OPC_Decode, 140, 6, 89, // Opcode: STHAri, DecodeIdx: 89
/* 5643 */    MCD::OPC_FilterValue, 23, 19, 0, // Skip to: 5666
/* 5647 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5650 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5658
/* 5654 */    MCD::OPC_Decode, 249, 5, 101, // Opcode: STDArr, DecodeIdx: 101
/* 5658 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5660 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5662 */    MCD::OPC_Decode, 248, 5, 91, // Opcode: STDAri, DecodeIdx: 91
/* 5666 */    MCD::OPC_FilterValue, 24, 21, 0, // Skip to: 5691
/* 5670 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5673 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 5683
/* 5677 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5679 */    MCD::OPC_Decode, 255, 4, 102, // Opcode: LDSWArr, DecodeIdx: 102
/* 5683 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5685 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5687 */    MCD::OPC_Decode, 254, 4, 93, // Opcode: LDSWAri, DecodeIdx: 93
/* 5691 */    MCD::OPC_FilterValue, 25, 19, 0, // Skip to: 5714
/* 5695 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5698 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5706
/* 5702 */    MCD::OPC_Decode, 243, 4, 98, // Opcode: LDSBArr, DecodeIdx: 98
/* 5706 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5708 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5710 */    MCD::OPC_Decode, 242, 4, 81, // Opcode: LDSBAri, DecodeIdx: 81
/* 5714 */    MCD::OPC_FilterValue, 26, 19, 0, // Skip to: 5737
/* 5718 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5721 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5729
/* 5725 */    MCD::OPC_Decode, 247, 4, 98, // Opcode: LDSHArr, DecodeIdx: 98
/* 5729 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5731 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5733 */    MCD::OPC_Decode, 246, 4, 81, // Opcode: LDSHAri, DecodeIdx: 81
/* 5737 */    MCD::OPC_FilterValue, 27, 21, 0, // Skip to: 5762
/* 5741 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5744 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 5754
/* 5748 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5750 */    MCD::OPC_Decode, 139, 5, 102, // Opcode: LDXArr, DecodeIdx: 102
/* 5754 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5756 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5758 */    MCD::OPC_Decode, 138, 5, 93, // Opcode: LDXAri, DecodeIdx: 93
/* 5762 */    MCD::OPC_FilterValue, 29, 19, 0, // Skip to: 5785
/* 5766 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5769 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5777
/* 5773 */    MCD::OPC_Decode, 251, 4, 98, // Opcode: LDSTUBArr, DecodeIdx: 98
/* 5777 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5779 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5781 */    MCD::OPC_Decode, 250, 4, 81, // Opcode: LDSTUBAri, DecodeIdx: 81
/* 5785 */    MCD::OPC_FilterValue, 30, 21, 0, // Skip to: 5810
/* 5789 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5792 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 5802
/* 5796 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5798 */    MCD::OPC_Decode, 149, 6, 103, // Opcode: STXArr, DecodeIdx: 103
/* 5802 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5804 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5806 */    MCD::OPC_Decode, 148, 6, 95, // Opcode: STXAri, DecodeIdx: 95
/* 5810 */    MCD::OPC_FilterValue, 31, 19, 0, // Skip to: 5833
/* 5814 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5817 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5825
/* 5821 */    MCD::OPC_Decode, 165, 6, 104, // Opcode: SWAPArr, DecodeIdx: 104
/* 5825 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5827 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5829 */    MCD::OPC_Decode, 164, 6, 97, // Opcode: SWAPAri, DecodeIdx: 97
/* 5833 */    MCD::OPC_FilterValue, 32, 21, 0, // Skip to: 5858
/* 5837 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5840 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5852
/* 5844 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5848 */    MCD::OPC_Decode, 237, 4, 105, // Opcode: LDFrr, DecodeIdx: 105
/* 5852 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5854 */    MCD::OPC_Decode, 236, 4, 106, // Opcode: LDFri, DecodeIdx: 106
/* 5858 */    MCD::OPC_FilterValue, 33, 55, 0, // Skip to: 5917
/* 5862 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5865 */    MCD::OPC_FilterValue, 0, 27, 0, // Skip to: 5896
/* 5869 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5872 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5884
/* 5876 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5880 */    MCD::OPC_Decode, 235, 4, 82, // Opcode: LDFSRrr, DecodeIdx: 82
/* 5884 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5886 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5888 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5892 */    MCD::OPC_Decode, 141, 5, 82, // Opcode: LDXFSRrr, DecodeIdx: 82
/* 5896 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5898 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5901 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5909
/* 5905 */    MCD::OPC_Decode, 234, 4, 83, // Opcode: LDFSRri, DecodeIdx: 83
/* 5909 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5911 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5913 */    MCD::OPC_Decode, 140, 5, 83, // Opcode: LDXFSRri, DecodeIdx: 83
/* 5917 */    MCD::OPC_FilterValue, 35, 21, 0, // Skip to: 5942
/* 5921 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5924 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5936
/* 5928 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5932 */    MCD::OPC_Decode, 229, 4, 107, // Opcode: LDDFrr, DecodeIdx: 107
/* 5936 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5938 */    MCD::OPC_Decode, 228, 4, 108, // Opcode: LDDFri, DecodeIdx: 108
/* 5942 */    MCD::OPC_FilterValue, 36, 21, 0, // Skip to: 5967
/* 5946 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5949 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5961
/* 5953 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5957 */    MCD::OPC_Decode, 139, 6, 109, // Opcode: STFrr, DecodeIdx: 109
/* 5961 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5963 */    MCD::OPC_Decode, 138, 6, 110, // Opcode: STFri, DecodeIdx: 110
/* 5967 */    MCD::OPC_FilterValue, 37, 55, 0, // Skip to: 6026
/* 5971 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5974 */    MCD::OPC_FilterValue, 0, 27, 0, // Skip to: 6005
/* 5978 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5981 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5993
/* 5985 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 5989 */    MCD::OPC_Decode, 137, 6, 82, // Opcode: STFSRrr, DecodeIdx: 82
/* 5993 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5995 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5997 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6001 */    MCD::OPC_Decode, 151, 6, 82, // Opcode: STXFSRrr, DecodeIdx: 82
/* 6005 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6007 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 6010 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 6018
/* 6014 */    MCD::OPC_Decode, 136, 6, 83, // Opcode: STFSRri, DecodeIdx: 83
/* 6018 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6020 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6022 */    MCD::OPC_Decode, 150, 6, 83, // Opcode: STXFSRri, DecodeIdx: 83
/* 6026 */    MCD::OPC_FilterValue, 38, 29, 0, // Skip to: 6059
/* 6030 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6033 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 6049
/* 6037 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6041 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6045 */    MCD::OPC_Decode, 129, 6, 82, // Opcode: STDFQrr, DecodeIdx: 82
/* 6049 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6051 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6055 */    MCD::OPC_Decode, 128, 6, 83, // Opcode: STDFQri, DecodeIdx: 83
/* 6059 */    MCD::OPC_FilterValue, 39, 21, 0, // Skip to: 6084
/* 6063 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6066 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 6078
/* 6070 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6074 */    MCD::OPC_Decode, 131, 6, 111, // Opcode: STDFrr, DecodeIdx: 111
/* 6078 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6080 */    MCD::OPC_Decode, 130, 6, 112, // Opcode: STDFri, DecodeIdx: 112
/* 6084 */    MCD::OPC_FilterValue, 45, 25, 0, // Skip to: 6113
/* 6088 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6091 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 6105
/* 6095 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6097 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6101 */    MCD::OPC_Decode, 186, 5, 113, // Opcode: PREFETCHr, DecodeIdx: 113
/* 6105 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6107 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6109 */    MCD::OPC_Decode, 185, 5, 114, // Opcode: PREFETCHi, DecodeIdx: 114
/* 6113 */    MCD::OPC_FilterValue, 49, 29, 0, // Skip to: 6146
/* 6117 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6120 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 6136
/* 6124 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6128 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6132 */    MCD::OPC_Decode, 219, 4, 82, // Opcode: LDCSRrr, DecodeIdx: 82
/* 6136 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6138 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6142 */    MCD::OPC_Decode, 218, 4, 83, // Opcode: LDCSRri, DecodeIdx: 83
/* 6146 */    MCD::OPC_FilterValue, 53, 29, 0, // Skip to: 6179
/* 6150 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6153 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 6169
/* 6157 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6161 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6165 */    MCD::OPC_Decode, 245, 5, 82, // Opcode: STCSRrr, DecodeIdx: 82
/* 6169 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6171 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6175 */    MCD::OPC_Decode, 244, 5, 83, // Opcode: STCSRri, DecodeIdx: 83
/* 6179 */    MCD::OPC_FilterValue, 54, 29, 0, // Skip to: 6212
/* 6183 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6186 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 6202
/* 6190 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6194 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6198 */    MCD::OPC_Decode, 251, 5, 82, // Opcode: STDCQrr, DecodeIdx: 82
/* 6202 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6204 */    MCD::OPC_CheckFieldOrFail, 25, 5, 0, 
/* 6208 */    MCD::OPC_Decode, 250, 5, 83, // Opcode: STDCQri, DecodeIdx: 83
/* 6212 */    MCD::OPC_FilterValue, 60, 25, 0, // Skip to: 6241
/* 6216 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6219 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 6229
/* 6223 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 6225 */    MCD::OPC_Decode, 144, 3, 115, // Opcode: CASArr, DecodeIdx: 115
/* 6229 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6231 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6233 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6237 */    MCD::OPC_Decode, 143, 3, 116, // Opcode: CASAri, DecodeIdx: 116
/* 6241 */    MCD::OPC_FilterValue, 61, 21, 0, // Skip to: 6266
/* 6245 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6248 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 6258
/* 6252 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6254 */    MCD::OPC_Decode, 184, 5, 117, // Opcode: PREFETCHAr, DecodeIdx: 117
/* 6258 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6260 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6262 */    MCD::OPC_Decode, 183, 5, 114, // Opcode: PREFETCHAi, DecodeIdx: 114
/* 6266 */    MCD::OPC_FilterValueOrFail, 62, 
/* 6268 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6271 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 6281
/* 6275 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 6277 */    MCD::OPC_Decode, 146, 3, 118, // Opcode: CASXArr, DecodeIdx: 118
/* 6281 */    MCD::OPC_FilterValueOrFail, 1, 
/* 6283 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 6285 */    MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 6289 */    MCD::OPC_Decode, 145, 3, 119, // Opcode: CASXAri, DecodeIdx: 119
/* 6293 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableSparcV832[] = {
/* 0 */       MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 3 */       MCD::OPC_FilterValue, 48, 29, 0, // Skip to: 36
/* 7 */       MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 10 */      MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 26
/* 14 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 18 */      MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 22 */      MCD::OPC_Decode, 221, 4, 120, // Opcode: LDCrr, DecodeIdx: 120
/* 26 */      MCD::OPC_FilterValueOrFail, 1, 
/* 28 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 32 */      MCD::OPC_Decode, 220, 4, 121, // Opcode: LDCri, DecodeIdx: 121
/* 36 */      MCD::OPC_FilterValue, 51, 29, 0, // Skip to: 69
/* 40 */      MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 43 */      MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 59
/* 47 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 51 */      MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 55 */      MCD::OPC_Decode, 225, 4, 122, // Opcode: LDDCrr, DecodeIdx: 122
/* 59 */      MCD::OPC_FilterValueOrFail, 1, 
/* 61 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 65 */      MCD::OPC_Decode, 224, 4, 123, // Opcode: LDDCri, DecodeIdx: 123
/* 69 */      MCD::OPC_FilterValue, 52, 29, 0, // Skip to: 102
/* 73 */      MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 76 */      MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 92
/* 80 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 84 */      MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 88 */      MCD::OPC_Decode, 247, 5, 124, // Opcode: STCrr, DecodeIdx: 124
/* 92 */      MCD::OPC_FilterValueOrFail, 1, 
/* 94 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 98 */      MCD::OPC_Decode, 246, 5, 125, // Opcode: STCri, DecodeIdx: 125
/* 102 */     MCD::OPC_FilterValue, 55, 29, 0, // Skip to: 135
/* 106 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 109 */     MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 125
/* 113 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 117 */     MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 121 */     MCD::OPC_Decode, 253, 5, 126, // Opcode: STDCrr, DecodeIdx: 126
/* 125 */     MCD::OPC_FilterValueOrFail, 1, 
/* 127 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 131 */     MCD::OPC_Decode, 252, 5, 127, // Opcode: STDCri, DecodeIdx: 127
/* 135 */     MCD::OPC_FilterValueOrFail, 58, 
/* 137 */     MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 140 */     MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 156
/* 144 */     MCD::OPC_CheckFieldOrFail, 29, 3, 4, 
/* 148 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 152 */     MCD::OPC_Decode, 184, 6, 84, // Opcode: TRAPrr, DecodeIdx: 84
/* 156 */     MCD::OPC_FilterValueOrFail, 32, 
/* 158 */     MCD::OPC_CheckFieldOrFail, 29, 3, 4, 
/* 162 */     MCD::OPC_Decode, 183, 6, 85, // Opcode: TRAPri, DecodeIdx: 85
/* 166 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableSparcV932[] = {
/* 0 */       MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 3 */       MCD::OPC_FilterValue, 34, 35, 0, // Skip to: 42
/* 7 */       MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 10 */      MCD::OPC_FilterValue, 0, 15, 0, // Skip to: 29
/* 14 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 16 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 20 */      MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 24 */      MCD::OPC_Decode, 241, 4, 128, 1, // Opcode: LDQFrr, DecodeIdx: 128
/* 29 */      MCD::OPC_FilterValueOrFail, 1, 
/* 31 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 33 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 37 */      MCD::OPC_Decode, 240, 4, 129, 1, // Opcode: LDQFri, DecodeIdx: 129
/* 42 */      MCD::OPC_FilterValue, 38, 35, 0, // Skip to: 81
/* 46 */      MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 49 */      MCD::OPC_FilterValue, 0, 15, 0, // Skip to: 68
/* 53 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 55 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 59 */      MCD::OPC_CheckFieldOrFail, 5, 8, 0, 
/* 63 */      MCD::OPC_Decode, 147, 6, 130, 1, // Opcode: STQFrr, DecodeIdx: 130
/* 68 */      MCD::OPC_FilterValueOrFail, 1, 
/* 70 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 72 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 76 */      MCD::OPC_Decode, 146, 6, 131, 1, // Opcode: STQFri, DecodeIdx: 131
/* 81 */      MCD::OPC_FilterValue, 48, 30, 0, // Skip to: 115
/* 85 */      MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 88 */      MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 103
/* 92 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 94 */      MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 98 */      MCD::OPC_Decode, 233, 4, 132, 1, // Opcode: LDFArr, DecodeIdx: 132
/* 103 */     MCD::OPC_FilterValueOrFail, 1, 
/* 105 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 107 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 111 */     MCD::OPC_Decode, 232, 4, 106, // Opcode: LDFAri, DecodeIdx: 106
/* 115 */     MCD::OPC_FilterValue, 50, 31, 0, // Skip to: 150
/* 119 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 122 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 137
/* 126 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 128 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 132 */     MCD::OPC_Decode, 239, 4, 133, 1, // Opcode: LDQFArr, DecodeIdx: 133
/* 137 */     MCD::OPC_FilterValueOrFail, 1, 
/* 139 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 141 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 145 */     MCD::OPC_Decode, 238, 4, 129, 1, // Opcode: LDQFAri, DecodeIdx: 129
/* 150 */     MCD::OPC_FilterValue, 51, 30, 0, // Skip to: 184
/* 154 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 157 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 172
/* 161 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 163 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 167 */     MCD::OPC_Decode, 227, 4, 134, 1, // Opcode: LDDFArr, DecodeIdx: 134
/* 172 */     MCD::OPC_FilterValueOrFail, 1, 
/* 174 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 176 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 180 */     MCD::OPC_Decode, 226, 4, 108, // Opcode: LDDFAri, DecodeIdx: 108
/* 184 */     MCD::OPC_FilterValue, 52, 30, 0, // Skip to: 218
/* 188 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 191 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 206
/* 195 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 197 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 201 */     MCD::OPC_Decode, 135, 6, 135, 1, // Opcode: STFArr, DecodeIdx: 135
/* 206 */     MCD::OPC_FilterValueOrFail, 1, 
/* 208 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 210 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 214 */     MCD::OPC_Decode, 134, 6, 110, // Opcode: STFAri, DecodeIdx: 110
/* 218 */     MCD::OPC_FilterValue, 54, 31, 0, // Skip to: 253
/* 222 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 225 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 240
/* 229 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 231 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 235 */     MCD::OPC_Decode, 145, 6, 136, 1, // Opcode: STQFArr, DecodeIdx: 136
/* 240 */     MCD::OPC_FilterValueOrFail, 1, 
/* 242 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 244 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 248 */     MCD::OPC_Decode, 144, 6, 131, 1, // Opcode: STQFAri, DecodeIdx: 131
/* 253 */     MCD::OPC_FilterValue, 55, 30, 0, // Skip to: 287
/* 257 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 260 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 275
/* 264 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 266 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 270 */     MCD::OPC_Decode, 255, 5, 137, 1, // Opcode: STDFArr, DecodeIdx: 137
/* 275 */     MCD::OPC_FilterValueOrFail, 1, 
/* 277 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 279 */     MCD::OPC_CheckFieldOrFail, 30, 2, 3, 
/* 283 */     MCD::OPC_Decode, 254, 5, 112, // Opcode: STDFAri, DecodeIdx: 112
/* 287 */     MCD::OPC_FilterValueOrFail, 58, 
/* 289 */     MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 292 */     MCD::OPC_FilterValue, 0, 14, 0, // Skip to: 310
/* 296 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 298 */     MCD::OPC_CheckFieldOrFail, 29, 3, 4, 
/* 302 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 306 */     MCD::OPC_Decode, 178, 6, 84, // Opcode: TICCrr, DecodeIdx: 84
/* 310 */     MCD::OPC_FilterValueOrFail, 32, 
/* 312 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 314 */     MCD::OPC_CheckFieldOrFail, 29, 3, 4, 
/* 318 */     MCD::OPC_Decode, 177, 6, 85, // Opcode: TICCri, DecodeIdx: 85
/* 322 */     MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[Sparc::FeatureV9]);
  case 1:
    return (Bits[Sparc::FeatureOSA2011]);
  case 2:
    return (Bits[Sparc::FeatureCrypto]);
  case 3:
    return (Bits[Sparc::FeaturePWRPSR]);
  case 4:
    return (Bits[Sparc::FeatureUA2005]);
  case 5:
    return (Bits[Sparc::FeatureVIS3]);
  case 6:
    return (Bits[Sparc::FeatureVIS]);
  case 7:
    return (Bits[Sparc::FeatureVIS2]);
  case 8:
    return (Bits[Sparc::FeatureUA2007]);
  case 9:
    return (Bits[Sparc::LeonCASA] || Bits[Sparc::FeatureV9]);
  case 10:
    return (Bits[Sparc::FeatureV9] && Bits[Sparc::FeatureV9]);
  }
}

// Handling 138 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 22);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 19);
    if (!Check(S, DecodeDisp<19>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 22);
    if (!Check(S, DecodeDisp<22>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 0, 22);
    if (!Check(S, DecodeDisp<22>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 4:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 14), 0, 14);
    insertBits(tmp, fieldFromInstruction(insn, 20, 2), 14, 2);
    if (!Check(S, DecodeDisp<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 5, 8), 0, 8);
    insertBits(tmp, fieldFromInstruction(insn, 19, 2), 8, 2);
    if (!Check(S, DecodeDisp<10>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 25, 3), 0, 3);
    insertBits(tmp, fieldFromInstruction(insn, 29, 1), 3, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 5, 8), 0, 8);
    insertBits(tmp, fieldFromInstruction(insn, 19, 2), 8, 2);
    if (!Check(S, DecodeDisp<10>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 25, 3), 0, 3);
    insertBits(tmp, fieldFromInstruction(insn, 29, 1), 3, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeSIMM5(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 7:
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 22);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 0, 19);
    if (!Check(S, DecodeDisp<19>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 20, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 0, 30);
    if (!Check(S, DecodeCall(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 5);
    if (!Check(S, DecodeSIMM5(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 11);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 11);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 37:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 39:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 40:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 41:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 42:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 43:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 44:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 45:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 46:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 47:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 48:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 49:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 50:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 51:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 52:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 53:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 54:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 55:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 56:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 57:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 58:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 59:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 60:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 61:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 62:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 63:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 64:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 65:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 66:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 67:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 68:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 69:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 70:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 71:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 72:
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 73:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 74:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 75:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 76:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 77:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeSIMM5(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 78:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeSIMM5(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 79:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 80:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 81:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 82:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 83:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 84:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 85:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 86:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 87:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 88:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 89:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 90:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 91:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 92:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 93:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 94:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 95:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 96:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 97:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 98:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 99:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 100:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 101:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 102:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 103:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 104:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 105:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 106:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 107:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 108:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 109:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 110:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 111:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 112:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 113:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 114:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 115:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 116:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 117:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 118:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 119:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 120:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 121:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 122:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 123:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 124:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 125:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 126:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 127:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 128:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 129:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 130:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 131:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 132:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 133:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 134:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 135:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 136:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 137:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckPredicate:
    case MCD::OPC_CheckPredicateOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckPredicateOrFail;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128AndIncUnsafe(Ptr);
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);
      // Check the predicate.
      bool Failed = !checkDecoderPredicate(PIdx, Bits);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckPredicateOrFail" : "OPC_CheckPredicate";
        dbgs() << Loc << ": " << OpName << '(' << PIdx << ", " << NumToSkip
               << "): " << (Failed ? "FAIL\n" : "PASS\n");
      });

      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
