// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/TextProperty.h>

#include "AlignmentPropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype TextPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of TextProperty to QML.
 */
class TextPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit TextPropertyGroup(QuickStyle *style);

    void update(Union::Properties::TextProperty *newState);
    Q_SIGNAL void updated();

    void refreshColors();

    /*!
     * \qmlproperty AlignmentPropertyGroup TextPropertyGroup::alignment
     *
     * Exposes TextProperty::AlignmentProperty to QML.
     */
    Q_PROPERTY(AlignmentPropertyGroup *alignment READ alignment CONSTANT)
    AlignmentPropertyGroup *alignment() const;

    /*!
     * \qmlproperty QFont TextPropertyGroup::font
     *
     * Exposes TextProperty::font to QML.
     */
    Q_PROPERTY(QJSValue font READ font NOTIFY fontChanged)
    QJSValue font() const;
    Q_SIGNAL void fontChanged();

    /*!
     * \qmlproperty Union::Color TextPropertyGroup::color
     *
     * Exposes TextProperty::color to QML.
     */
    Q_PROPERTY(QJSValue color READ color NOTIFY colorChanged)
    QJSValue color() const;
    Q_SIGNAL void colorChanged();

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<AlignmentPropertyGroup> m_alignment;

    Union::Properties::TextProperty *m_state = nullptr;
};