/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(MEDIA_SOURCE)

#include "JSDOMWrapper.h"
#include "JSSourceBuffer.h"
#include "ManagedSourceBuffer.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSManagedSourceBuffer : public JSSourceBuffer {
public:
    using Base = JSSourceBuffer;
    using DOMWrapped = ManagedSourceBuffer;
    static JSManagedSourceBuffer* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<ManagedSourceBuffer>&& impl)
    {
        SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject->vm();
        JSManagedSourceBuffer* ptr = new (NotNull, JSC::allocateCell<JSManagedSourceBuffer>(vm)) JSManagedSourceBuffer(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static size_t estimatedSize(JSCell*, JSC::VM&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    ManagedSourceBuffer& wrapped() const
    {
        return static_cast<ManagedSourceBuffer&>(Base::wrapped());
    }

    Ref<ManagedSourceBuffer> protectedWrapped() const;

protected:
    JSManagedSourceBuffer(JSC::Structure*, JSDOMGlobalObject&, Ref<ManagedSourceBuffer>&&);

    void finishCreation(JSC::VM&);
};

class WEBCORE_EXPORT JSManagedSourceBufferOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, ASCIILiteral*) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, ManagedSourceBuffer*)
{
    static NeverDestroyed<JSManagedSourceBufferOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(ManagedSourceBuffer* wrappableObject)
{
    return wrappableObject;
}


template<> struct JSDOMWrapperConverterTraits<ManagedSourceBuffer> {
    using WrapperClass = JSManagedSourceBuffer;
    using ToWrappedReturnType = ManagedSourceBuffer*;
};

} // namespace WebCore

#endif // ENABLE(MEDIA_SOURCE)
