/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSubscriber.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortSignal.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSVoidCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSubscriberPrototypeFunction_next);
static JSC_DECLARE_HOST_FUNCTION(jsSubscriberPrototypeFunction_error);
static JSC_DECLARE_HOST_FUNCTION(jsSubscriberPrototypeFunction_complete);
static JSC_DECLARE_HOST_FUNCTION(jsSubscriberPrototypeFunction_addTeardown);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSubscriberConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSubscriber_active);
static JSC_DECLARE_CUSTOM_GETTER(jsSubscriber_signal);

class JSSubscriberPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSubscriberPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSubscriberPrototype* ptr = new (NotNull, JSC::allocateCell<JSSubscriberPrototype>(vm)) JSSubscriberPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSubscriberPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSubscriberPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSubscriberPrototype, JSSubscriberPrototype::Base);

using JSSubscriberDOMConstructor = JSDOMConstructorNotConstructable<JSSubscriber>;

template<> const ClassInfo JSSubscriberDOMConstructor::s_info = { "Subscriber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSubscriberDOMConstructor) };

template<> JSValue JSSubscriberDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSubscriberDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Subscriber"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSubscriber::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSSubscriberPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSubscriberConstructor, 0 } },
    HashTableValue { "active"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSubscriber_active, 0 } },
    HashTableValue { "signal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSubscriber_signal, 0 } },
    HashTableValue { "next"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSubscriberPrototypeFunction_next, 1 } },
    HashTableValue { "error"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSubscriberPrototypeFunction_error, 1 } },
    HashTableValue { "complete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSubscriberPrototypeFunction_complete, 0 } },
    HashTableValue { "addTeardown"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSubscriberPrototypeFunction_addTeardown, 1 } },
};

const ClassInfo JSSubscriberPrototype::s_info = { "Subscriber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSubscriberPrototype) };

void JSSubscriberPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSubscriber::info(), JSSubscriberPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSubscriber::s_info = { "Subscriber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSubscriber) };

JSSubscriber::JSSubscriber(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Subscriber>&& impl)
    : JSDOMWrapper<Subscriber>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, Subscriber>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSSubscriber::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSubscriberPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSubscriberPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSubscriber::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSubscriber>(vm, globalObject);
}

JSValue JSSubscriber::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSubscriberDOMConstructor, DOMConstructorID::Subscriber>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSubscriber::destroy(JSC::JSCell* cell)
{
    JSSubscriber* thisObject = static_cast<JSSubscriber*>(cell);
    thisObject->JSSubscriber::~JSSubscriber();
}

JSC_DEFINE_CUSTOM_GETTER(jsSubscriberConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSubscriberPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSubscriber::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSubscriber_activeGetter(JSGlobalObject& lexicalGlobalObject, JSSubscriber& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.active())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSubscriber_active, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSubscriber>::get<jsSubscriber_activeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSubscriber_signalGetter(JSGlobalObject& lexicalGlobalObject, JSSubscriber& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AbortSignal>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSubscriber_signal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSubscriber>::get<jsSubscriber_signalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSubscriberPrototypeFunction_nextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSubscriber>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.next(valueConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSubscriberPrototypeFunction_next, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSubscriber>::call<jsSubscriberPrototypeFunction_nextBody>(*lexicalGlobalObject, *callFrame, "next");
}

static inline JSC::EncodedJSValue jsSubscriberPrototypeFunction_errorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSubscriber>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto errorConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (errorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.error(errorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSubscriberPrototypeFunction_error, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSubscriber>::call<jsSubscriberPrototypeFunction_errorBody>(*lexicalGlobalObject, *callFrame, "error");
}

static inline JSC::EncodedJSValue jsSubscriberPrototypeFunction_completeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSubscriber>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.complete(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSubscriberPrototypeFunction_complete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSubscriber>::call<jsSubscriberPrototypeFunction_completeBody>(*lexicalGlobalObject, *callFrame, "complete");
}

static inline JSC::EncodedJSValue jsSubscriberPrototypeFunction_addTeardownBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSubscriber>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto teardownConversionResult = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "teardown"_s, "Subscriber"_s, "addTeardown"_s); });
    if (teardownConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addTeardown(teardownConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSubscriberPrototypeFunction_addTeardown, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSubscriber>::call<jsSubscriberPrototypeFunction_addTeardownBody>(*lexicalGlobalObject, *callFrame, "addTeardown");
}

JSC::GCClient::IsoSubspace* JSSubscriber::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSubscriber, UseCustomHeapCellType::No>(vm, "JSSubscriber"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSubscriber.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSubscriber = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSubscriber.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSubscriber = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSSubscriber::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSSubscriber*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSSubscriber);

template<typename Visitor>
void JSSubscriber::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSSubscriber*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSSubscriber::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSSubscriber::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSSubscriber::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSubscriber*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSubscriberOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsSubscriber = jsCast<JSSubscriber*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsSubscriber->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSubscriberOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSubscriber = static_cast<JSSubscriber*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSubscriber->protectedWrapped().ptr(), jsSubscriber);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Subscriber@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10SubscriberE[]; }
#endif
template<std::same_as<Subscriber> T>
static inline void verifyVTable(Subscriber* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Subscriber@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10SubscriberE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Subscriber has subclasses. If Subscriber has subclasses that get passed
        // to toJS() we currently require Subscriber you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Subscriber>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Subscriber>(impl.ptr());
#endif
    return createWrapper<Subscriber>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Subscriber& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Subscriber* JSSubscriber::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSubscriber*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
