/*
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "TextDecoderStreamBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_textDecoderStreamInitializeTextDecoderStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamInitializeTextDecoderStreamCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamInitializeTextDecoderStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamInitializeTextDecoderStreamCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamInitializeTextDecoderStreamCodeLength = 2162;
static constinit const JSC::Intrinsic s_textDecoderStreamInitializeTextDecoderStreamCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamInitializeTextDecoderStreamCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const label = arguments.length >= 1 ? arguments[0] : \"utf-8\";\n" \
    "    const options = arguments.length >= 2 ? arguments[1] : { };\n" \
    "\n" \
    "    const startAlgorithm = () => {\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const transformAlgorithm = (chunk) => {\n" \
    "        const decoder = @getByIdDirectPrivate(this, \"textDecoderStreamDecoder\");\n" \
    "        let buffer;\n" \
    "        try {\n" \
    "            buffer = decoder.@decode(chunk);\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "        if (buffer) {\n" \
    "            const transformStream = @getByIdDirectPrivate(this, \"textDecoderStreamTransform\");\n" \
    "            const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "            @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "        }\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const flushAlgorithm = () => {\n" \
    "        const decoder = @getByIdDirectPrivate(this, \"textDecoderStreamDecoder\");\n" \
    "        let buffer;\n" \
    "        try {\n" \
    "            buffer = decoder.@flush();\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "        if (buffer) {\n" \
    "            const transformStream = @getByIdDirectPrivate(this, \"textDecoderStreamTransform\");\n" \
    "            const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "            @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "        }\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "\n" \
    "    const [transform, readable, writable] = @createTransformStream(startAlgorithm, transformAlgorithm, flushAlgorithm);\n" \
    "    @putByIdDirectPrivate(this, \"textDecoderStreamTransform\", transform);\n" \
    "    @putByIdDirectPrivate(this, \"readable\", readable);\n" \
    "    @putByIdDirectPrivate(this, \"writable\", writable);\n" \
    "\n" \
    "    const fatal = !!options.fatal;\n" \
    "    const ignoreBOM = !!options.ignoreBOM;\n" \
    "    const decoder = new @TextDecoderStreamDecoder(label, fatal, ignoreBOM);\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"fatal\", fatal);\n" \
    "    @putByIdDirectPrivate(this, \"ignoreBOM\", ignoreBOM);\n" \
    "    @putByIdDirectPrivate(this, \"encoding\", decoder.@encoding());\n" \
    "    @putByIdDirectPrivate(this, \"textDecoderStreamDecoder\", decoder);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_textDecoderStreamEncodingCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamEncodingCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamEncodingCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamEncodingCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamEncodingCodeLength = 225;
static constinit const JSC::Intrinsic s_textDecoderStreamEncodingCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamEncodingCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"textDecoderStreamTransform\"))\n" \
    "        throw @makeThisTypeError(\"TextDecoderStream\", \"encoding\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"encoding\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_textDecoderStreamFatalCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamFatalCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamFatalCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamFatalCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamFatalCodeLength = 219;
static constinit const JSC::Intrinsic s_textDecoderStreamFatalCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamFatalCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"textDecoderStreamTransform\"))\n" \
    "        throw @makeThisTypeError(\"TextDecoderStream\", \"fatal\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"fatal\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_textDecoderStreamIgnoreBOMCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamIgnoreBOMCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamIgnoreBOMCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamIgnoreBOMCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamIgnoreBOMCodeLength = 227;
static constinit const JSC::Intrinsic s_textDecoderStreamIgnoreBOMCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamIgnoreBOMCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"textDecoderStreamTransform\"))\n" \
    "        throw @makeThisTypeError(\"TextDecoderStream\", \"ignoreBOM\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"ignoreBOM\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_textDecoderStreamReadableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamReadableCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamReadableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamReadableCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamReadableCodeLength = 258;
static constinit const JSC::Intrinsic s_textDecoderStreamReadableCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamReadableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"textDecoderStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"TextDecoderStream\", \"readable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"readable\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_textDecoderStreamWritableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_textDecoderStreamWritableCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_textDecoderStreamWritableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_textDecoderStreamWritableCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_textDecoderStreamWritableCodeLength = 258;
static constinit const JSC::Intrinsic s_textDecoderStreamWritableCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_textDecoderStreamWritableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"textDecoderStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"TextDecoderStream\", \"writable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"writable\");\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().textDecoderStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().textDecoderStreamBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_TEXTDECODERSTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
