# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "aks safeguards create",
)
class Create(AAZCommand):
    """Enable Deployment Safeguards for a Managed Cluster

    :example: Create a DeploymentSafeguards resource at Warn level with a managed cluster resource id
        az aks safeguards create --resource /subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1 --level Warn

    :example: Create a DeploymentSafeguards resource at Warn level using subscription, resourcegroup, and name tags
        az aks safeguards create --subscription subid1 -g rg1 -n cluster1 --level Warn

    :example: Create a DeploymentSafeguards resource at Warn level with ignored namespaces
        az aks safeguards create -g rg1 -n mc1 --excluded-ns ns1 ns2 --level Warn

    :example: Create a DeploymentSafeguards resource at Warn level with Pod Security Standards level set to Baseline
        az aks safeguards create --managed-cluster /subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1 --level Warn --pss-level Baseline

    :example: Create a DeploymentSafeguards resource with PSS level set to Restricted using -g/-n pattern
        az aks safeguards create -g rg1 -n cluster1 --level Enforce --pss-level Restricted
    """

    _aaz_info = {
        "version": "2025-07-01",
        "resources": [
            ["mgmt-plane", "/{resourceuri}/providers/microsoft.containerservice/deploymentsafeguards/default", "2025-07-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.managed_cluster = AAZStrArg(
            options=["-c", "--cluster", "--managed-cluster"],
            help="The fully qualified Azure Resource manager identifier of the Managed Cluster.",
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.excluded_namespaces = AAZListArg(
            options=["--excluded-ns", "--excluded-namespaces"],
            arg_group="Properties",
            help="User defined list of namespaces to exclude from Deployment Safeguards. Deployments in these namespaces will not be checked against any safeguards",
        )
        _args_schema.level = AAZStrArg(
            options=["--level"],
            arg_group="Properties",
            help="The deployment safeguards level. Possible values are Warn and Enforce",
            enum={"Enforce": "Enforce", "Warn": "Warn"},
        )
        _args_schema.pss_level = AAZStrArg(
            options=["--pss-level"],
            arg_group="Properties",
            help="The pod security standards level",
            enum={"Baseline": "Baseline", "Privileged": "Privileged", "Restricted": "Restricted"},
        )

        excluded_namespaces = cls._args_schema.excluded_namespaces
        excluded_namespaces.Element = AAZStrArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.DeploymentSafeguardsCreate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DeploymentSafeguardsCreate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/{resourceUri}/providers/Microsoft.ContainerService/deploymentSafeguards/default",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceUri", self.ctx.args.managed_cluster,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType)

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("excludedNamespaces", AAZListType, ".excluded_namespaces")
                properties.set_prop("level", AAZStrType, ".level", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("podSecurityStandardsLevel", AAZStrType, ".pss_level")

            excluded_namespaces = _builder.get(".properties.excludedNamespaces")
            if excluded_namespaces is not None:
                excluded_namespaces.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.e_tag = AAZStrType(
                serialized_name="eTag",
                flags={"read_only": True},
            )
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType()
            _schema_on_200_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.excluded_namespaces = AAZListType(
                serialized_name="excludedNamespaces",
            )
            properties.level = AAZStrType(
                flags={"required": True},
            )
            properties.pod_security_standards_level = AAZStrType(
                serialized_name="podSecurityStandardsLevel",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.system_excluded_namespaces = AAZListType(
                serialized_name="systemExcludedNamespaces",
                flags={"read_only": True},
            )

            excluded_namespaces = cls._schema_on_200_201.properties.excluded_namespaces
            excluded_namespaces.Element = AAZStrType()

            system_excluded_namespaces = cls._schema_on_200_201.properties.system_excluded_namespaces
            system_excluded_namespaces.Element = AAZStrType()

            system_data = cls._schema_on_200_201.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
