/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agui.BaseEvent;

public class ToolCallResultEvent
extends BaseEvent {
    public static final String TYPE = "TOOL_CALL_RESULT";
    private String messageId;
    private String toolCallId;
    private String content;
    private String role;

    public ToolCallResultEvent(String messageId, String toolCallId, String content) {
        super(TYPE, System.currentTimeMillis(), null);
        this.messageId = messageId;
        this.toolCallId = toolCallId;
        this.content = content;
        this.role = "tool";
    }

    public ToolCallResultEvent(StreamInput input) throws IOException {
        super(input);
        this.messageId = input.readString();
        this.toolCallId = input.readString();
        this.content = input.readString();
        this.role = input.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.messageId);
        out.writeString(this.toolCallId);
        out.writeString(this.content);
        out.writeOptionalString(this.role);
    }

    @Override
    protected void addEventSpecificFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("messageId", this.messageId);
        builder.field("toolCallId", this.toolCallId);
        builder.field("content", this.content);
        if (this.role != null) {
            builder.field("role", this.role);
        }
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getToolCallId() {
        return this.toolCallId;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    @Generated
    public String toString() {
        return "ToolCallResultEvent(messageId=" + this.getMessageId() + ", toolCallId=" + this.getToolCallId() + ", content=" + this.getContent() + ", role=" + this.getRole() + ")";
    }

    @Generated
    public ToolCallResultEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolCallResultEvent)) {
            return false;
        }
        ToolCallResultEvent other = (ToolCallResultEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$toolCallId = this.getToolCallId();
        String other$toolCallId = other.getToolCallId();
        if (this$toolCallId == null ? other$toolCallId != null : !this$toolCallId.equals(other$toolCallId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ToolCallResultEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $toolCallId = this.getToolCallId();
        result = result * 59 + ($toolCallId == null ? 43 : $toolCallId.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }
}

