// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef BIBENTRYLISTVIEW_H
#define BIBENTRYLISTVIEW_H

#include <qlistview.h>
#include <qvaluelist.h>

class QWidget;
class QBoxLayout;
class QDomNode;
class QDomElement;

class EntryManipulator;
class KBiblioShell;
class BibEntryListView;


class BibEntryListViewItem : public QListViewItem
{
public:
    BibEntryListViewItem( QListView * parent, QDomElement entry );
    virtual ~BibEntryListViewItem();
    
    QDomElement entry() const;
    
    virtual QString key ( int column, bool ascending ) const;

private:
    QDomElement mEntry;
    EntryManipulator *mManip;
};


class BibEntryListView : public QListView
{
    friend class BibEntryListViewItem;
    
    Q_OBJECT
public:
    BibEntryListView( KBiblioShell *shell, QDomNode baseNode, QWidget *parent, const char *name = 0 );
    BibEntryListView( KBiblioShell *shell, QValueList<QDomElement> *elementList, QWidget *parent, const char *name = 0 );
    ~BibEntryListView();
    void newDocument( QDomNode baseNode );
    void newDocument( QValueList<QDomElement> *elementList );
    void add( QDomElement entry );
    void remove( BibEntryListViewItem *item );
    void remove( QDomElement entry );
    void update( QDomElement entry );
    BibEntryListViewItem* findItem( QDomElement entry );
    
    
public slots:
    void rebuildList();
    
private:
    void setup();
    
    KBiblioShell *mShell;
    QDomNode mBaseNode;
    QValueList<QDomElement> *mElementList;
    bool mUseElementList;
};

#endif

