/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qdom.h>
#include <klocale.h>

#include <kbiblioshell.h>
#include <kbibliomainview.h>
#include <bibentrylistview.h>
#include <kbibliodoc.h>
#include <entrymanipulator.h>
#include <finddialog.h>

//============================================================
//
//       class FindWidget

FindWidget::FindWidget( KBiblioShell *shell, QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    mShell = shell;
    mFoundList = new QValueList<QDomElement>;

    QStringList boolList = QStringList::split( "|", "OR|AND|XOR|OR NOT|AND NOT" );
    mFieldNames = mShell->document()->allFieldTypesNames();
    QStringList descrList = mShell->fieldDescriptionList( mFieldNames );

    QVBoxLayout *topLayout = new QVBoxLayout( this, mShell->marginHint(), mShell->spacingHint() );

    QLabel *label =  new QLabel( i18n( "Find any entry that contains" ), this );
    topLayout->addWidget( label );

    QHBoxLayout *hbox1 = new QHBoxLayout( topLayout, mShell->spacingHint() );
    mLineEdit1 = new QLineEdit( this );
    mLineEdit1->setMinimumWidth( 40*fontMetrics().width( "x" ) );
    hbox1->addWidget( mLineEdit1, 4 );
    hbox1->addWidget( new QLabel( i18n( "in" ), this ) );
    mFieldCombo1 = new QComboBox( this );
    mFieldCombo1->insertStringList( descrList );
    hbox1->addWidget( mFieldCombo1, 1 );

    topLayout->addSpacing( mShell->spacingHint() );

    QHBoxLayout *hbox2 = new QHBoxLayout( topLayout, mShell->spacingHint() );
    mBoolCombo1 = new QComboBox( this );
    mBoolCombo1->insertStringList( boolList );
    mBoolCombo1->setMaximumSize( mBoolCombo1->sizeHint() );
    hbox2->addWidget( mBoolCombo1 );
    mLineEdit2 = new QLineEdit( this );
    mLineEdit2->setMinimumWidth( 40*fontMetrics().width( "x" ) );
    hbox2->addWidget( mLineEdit2, 4 );
    hbox2->addWidget( new QLabel( i18n( "in" ), this ) );
    mFieldCombo2 = new QComboBox( this );
    mFieldCombo2->insertStringList( descrList );
    hbox2->addWidget( mFieldCombo2, 1 );

    topLayout->addSpacing( mShell->spacingHint() );

    QHBoxLayout *hbox3 = new QHBoxLayout( topLayout, mShell->spacingHint() );
    mBoolCombo2 = new QComboBox( this );
    mBoolCombo2->insertStringList( boolList );
    mBoolCombo2->setMaximumSize( mBoolCombo2->sizeHint() );
    hbox3->addWidget( mBoolCombo2 );
    mLineEdit3 = new QLineEdit( this );
    mLineEdit3->setMinimumWidth( 40*fontMetrics().width( "x" ) );
    hbox3->addWidget( mLineEdit3, 4 );
    hbox3->addWidget( new QLabel( i18n( "in" ), this ) );
    mFieldCombo3 = new QComboBox( this );
    mFieldCombo3->insertStringList( descrList );
    hbox3->addWidget( mFieldCombo3, 1 );

    topLayout->addSpacing( mShell->spacingHint() );

    QHBoxLayout *hbox4 = new QHBoxLayout( topLayout, mShell->spacingHint() );
    hbox4->addStretch( 3 );
    mCSBox = new QCheckBox( i18n( "Case sensitive" ), this );
    mCSBox->setChecked( false );
    hbox4->addWidget( mCSBox, 1 );
    hbox4->addStretch( 1 );
    mWCBox = new QCheckBox( i18n( "Wildcard mode" ), this );
    mWCBox->setChecked( false );
    hbox4->addWidget( mWCBox, 1 );

    topLayout->addSpacing( mShell->spacingHint() );
    mListView = new BibEntryListView( mShell, mFoundList, this );
    topLayout->addWidget( mListView, 4 );

    connect( mListView, SIGNAL( selectionChanged( QListViewItem* ) ), SLOT( displaySelected( QListViewItem* ) ) );
    connect( mShell, SIGNAL( newDocument() ), SLOT( newDocument() ) );

    topLayout->activate();
}


FindWidget::~FindWidget()
{
    delete mFoundList;
}


bool
FindWidget::boolOp( int no, bool b1, bool b2 )
{
    switch( no ){
    case 0:
	return b1 | b2;
    case 1:
	return b1 & b2;
    case 2:
	return b1 ^ b2;
    case 3:
	return b1 | !b2;
    case 4:
	return b1 & !b2;
    default:
	return false;
    }
}


void
FindWidget::find()
{
    bool cs, wildcards;
    QRegExp regExp1, regExp2, regExp3;
    QString fieldName1, fieldName2, fieldName3;
    int opNo1, opNo2;

    cs = mCSBox->isChecked();
    wildcards = mWCBox->isChecked();

    regExp1 = QRegExp( mLineEdit1->text(), cs, wildcards );
    regExp2 = QRegExp( mLineEdit2->text(), cs, wildcards );
    regExp3 = QRegExp( mLineEdit3->text(), cs, wildcards );

    fieldName1 = *( mFieldNames.at( mFieldCombo1->currentItem() ) );
    fieldName2 = *( mFieldNames.at( mFieldCombo2->currentItem() ) );
    fieldName3 = *( mFieldNames.at( mFieldCombo3->currentItem() ) );


    opNo1 = mBoolCombo1->currentItem();
    opNo2 = mBoolCombo2->currentItem();

    KBiblioDoc *doc = mShell->document();
    QDomNodeList entryList = doc->entryListNode().childNodes();
    QDomElement entry, tmpEntry;
    mFoundList->clear();

    bool b1, b2;
    uint i, length = entryList.length();
    EntryManipulator manip;
	
    for ( i=0; i<length; i++ ){
	entry = entryList.item(i).toElement();
	manip = EntryManipulator( entry, mShell );
	b1 = manip.find( regExp1, fieldName1 );
	b2 = boolOp( opNo1, b1, manip.find( regExp2, fieldName2 ) );
	if ( boolOp( opNo2, b2, manip.find( regExp3, fieldName3 ) ) ){
	    mFoundList->append( entry );
	}

	
    }


    mListView->newDocument( mFoundList );
}


void
FindWidget::newDocument()
{
    mFoundList->clear();
    mListView->newDocument( mFoundList );
}

void
FindWidget::displaySelected( QListViewItem *item )
{
    if ( item != 0 ){
	BibEntryListViewItem *castedItem = ( BibEntryListViewItem* ) item;
	QDomElement entry = castedItem->entry();
	
	mShell->mainView()->setSelected( entry );
    }
}




//============================================================
//
//       class FindDialog


FindDialog::FindDialog( KBiblioShell *shell, QWidget *parent, const char *name )
    :  KDialogBase( parent, name, false, i18n( "Find" ), KDialogBase::User1 | KDialogBase::Close, KDialogBase::User1, true, i18n( "&Find" ) )
{
    FindWidget *fw = new FindWidget( shell, this );
    setMainWidget( fw );
    connect( this, SIGNAL( user1Clicked() ), fw, SLOT( find() ) );
}


FindDialog::~FindDialog()
{
}


#include "finddialog.moc"




