/***************************************************************************
                          kplitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Aug 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include "kplitem.h"
#include "kplgraph.h"

KplItem::KplItem() : active(true), x0(0.0), y0(0.0), relsiz(1.0)
{
}

KplItem::KplItem(KSimpleConfig* plo)
{
  active = plo->readBoolEntry("active", true);
  x0 = plo->readDoubleNumEntry("x");
  y0 = plo->readDoubleNumEntry("y");
  relsiz = plo->readDoubleNumEntry("relsiz", 1.0);
}

KplItem::KplItem(bool act, double x, double y, double relSize) :
 active(act), x0(x), y0(y), relsiz(relSize)
{
}

KplItem::~KplItem()
{
}

void KplItem::writePlo(KSimpleConfig* plo, const KURL&, bool, KplDoc*) const
{
  if (!active)
    plo->writeEntry("active", active);
  plo->writeEntry("relsiz", relsiz);
}

void KplItem::normalize(double, double)
{
}

void KplItem::expoItem(int*, int*, double*, double*) const
{
}

void KplItem::minMax(double*, double*, double*, double*) const
{
}

void KplItem::setPar(int, double, bool)
{
}

void KplItem::exportTable(QTextStream&, KplDoc*) const
{
}

QRect KplItem::boundingRect() const
{
  return bRect;
}

double KplItem::xPos() const
{
  return x0;
}
double KplItem::yPos() const
{
  return y0;
}

void KplItem::setPos(double x, double y)
{
  x0 = x;
  y0 = y;
}

void KplItem::setActive(bool act)
{
  active = act;
}

ScaledItem::ScaledItem() : symb(0), color(0), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(Kpl::AutoStruct* aut) :
 symb(aut->autoSymb), color(aut->colData), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) : KplItem(plo)
{
  readPlo(plo, aut);
}

ScaledItem::ScaledItem(bool act, int sym, const QString& col,
                       double fxa, double fya, double relSize) :
 KplItem(act, 0.0, 0.0, relSize), symb(sym), fx(fxa), fy(fya)
{
  unsigned u;
  sscanf(col.latin1(), "%x", &u);
  color = KplGraph::rgbQt(u);
}

ScaledItem::~ScaledItem()
{
}

void ScaledItem::readPlo(KSimpleConfig* plo, Kpl::AutoStruct* aut)
{
  symb = plo->readNumEntry("symb", aut->autoSymb);
  QString s = plo->readEntry("color", "");
  if (!s.isEmpty()) {
    unsigned u;
    sscanf(s.latin1(), "%x", &u);
    color = KplGraph::rgbQt(u);
  } else
    color = aut->colData;
  fx = plo->readDoubleNumEntry("fx", 1.0);
  fy = plo->readDoubleNumEntry("fy", 1.0);
}

void ScaledItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                          KplDoc* m) const
{
  KplItem::writePlo(plo, url, abs, m);
  plo->writeEntry("symb", symb);
  QString s;
  plo->writeEntry("color", s.sprintf("%x", KplGraph::rgbQt1(color)));
  plo->writeEntry("fx", fx);
  plo->writeEntry("fy", fy);
}

void ScaledItem::normalize(double fx0, double fy0)
{
  fx = fx0;
  fy = fy0;
}

void ScaledItem::setProperties(KplGraph* g) const
{
  g->setColData(color);
  g->setSymbol(symb);
  g->fxn = fx;
  g->fyn = fy;
}

DecoItem::DecoItem() : color(0)
{
}

DecoItem::DecoItem(Kpl::AutoStruct* aut) :
 color(aut->colFrame)
{
}

DecoItem::DecoItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) : KplItem(plo)
{
  QString s = plo->readEntry("colsymb", "");
  if (!s.isEmpty()) {
    unsigned u;
    sscanf(s.latin1(), "%x", &u);
    color = KplGraph::rgbQt(u);
  } else
    color = aut->colFrame;
}

DecoItem::DecoItem(bool act, const QString& col, double x, double y,
                   double relSize) : KplItem(act, x, y, relSize)
{
  unsigned u;
  sscanf(col.latin1(), "%x", &u);
  color = KplGraph::rgbQt(u);
}

DecoItem::~DecoItem()
{
}

void DecoItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const
{
  KplItem::writePlo(plo, url, abs, m);
  QString s;
  plo->writeEntry("colsymb", s.sprintf("%x", KplGraph::rgbQt1(color)));
  plo->writeEntry("x", x0);
  plo->writeEntry("y", y0);
}
